/*
 * This file contains the external declarations for the configuration and
 * syntax highlighting strings.
 */


#ifndef F_OK                    /* for access - not defined with BC3.1 */
# define F_OK 0
#endif


/*
 * Display an error message with line number.
 * errmsg is the message to display;
 * line_str is the buffer to store the line number.
 * Expects line_out, line_no and prompt_line to be defined externally.
 */
#define ERRORLINE(errmsg, line_str) \
combine_strings( line_out, errmsg, config0, my_ltoa( line_no, line_str, 10 ) );\
error( WARNING, prompt_line, line_out );


/*
 * The minimum length of a key string - largest key is 11 characters, which can
 * occur twice (two-keys are so-called for a reason) plus the space between
 * them and the terminating null.
 */
#define KEY_STR_MIN     24


#define NUM_MODES       26
#define NUM_MACRO_MODES 17

/*
 * mode indexes
 */
#define Ins              0
#define Ind              1
#define PTAB             2
#define LTAB             3
#define Smart            4
#define InflateTabs      5
#define Write_Z          6
#define Crlf             7
#define Trim             8
#define Eol              9
#define WW              10
#define Left            11
#define Para            12
#define Right           13
#define Size            14
#define Backup          15
#define Ruler           16
#define Stamp           17
#define Initcase        18
#define Match           19
#define Ignore          20
#define JustRM          21
#define CursorCross     22
#define DirSort         23
#define CaseConvert     24
#define CharDef         25


extern CONFIG_DEFS valid_syntax[SHL_NUM_FEATURES];
extern CONFIG_DEFS valid_string[2];
extern CONFIG_DEFS case_modes[2];       /* Also an editor mode */

extern CONFIG_DEFS valid_keys[AVAIL_KEYS];
extern CONFIG_DEFS valid_func[NUM_FUNCS+2];
extern CONFIG_DEFS valid_macro_modes[NUM_MACRO_MODES];
extern CONFIG_DEFS valid_colors[NUM_COLORS*2];
extern CONFIG_DEFS valid_modes[NUM_MODES];
extern CONFIG_DEFS off_on[2];
extern CONFIG_DEFS valid_z[2];
extern CONFIG_DEFS valid_cursor[2];
extern CONFIG_DEFS valid_crlf[2];
extern CONFIG_DEFS valid_wraps[3];
extern CONFIG_DEFS valid_tabs[3];
extern CONFIG_DEFS valid_eol[3];
extern CONFIG_DEFS valid_dir_sort[2];
extern CONFIG_DEFS valid_pairs[8];

#if defined( __UNIX__ )
extern CONFIG_DEFS valid_curse[8];
#endif
