/*
 * This file contains all the strings required to parse the configuration and
 * syntax highlighting files.
 */

#include "tdestr.h"
#include "config.h"
#include "syntax.h"
#include "define.h"

/*
 * List of valid syntax highlighting features, sorted alphabetically.
 */
CONFIG_DEFS valid_syntax[SHL_NUM_FEATURES] = {
   { "bad",          SHL_BAD       },
   { "binary",       SHL_BINARY    },
   { "case",         SHL_CASE      },
   { "character",    SHL_CHARACTER },
   { "comment",      SHL_COMMENT   },
   { "escape",       SHL_ESCAPE    },
   { "function",     SHL_FUNCTION  },
   { "hex",          SHL_HEX       },
   { "innumber",     SHL_INNUMBER  },
   { "integer",      SHL_INTEGER   },
   { "inword",       SHL_INWORD    },
   { "keyword",      SHL_KEYWORD   },
   { "language",     SHL_LANGUAGE  },
   { "normal",       SHL_NORMAL    },
   { "octal",        SHL_OCTAL     },
   { "pattern",      SHL_PATTERN   },
   { "preprocessor", SHL_PREPRO    },
   { "pseudomacro",  SHL_MACRO     },
   { "real",         SHL_REAL      },
   { "startword",    SHL_STARTWORD },
   { "string",       SHL_STRING    },
   { "symbol",       SHL_SYMBOL    }
};


/*
 * List of additional features for string, character and preprocessor.
 */
CONFIG_DEFS valid_string[2] = {
   { "newline",  SHL_NEWLINE  },
   { "spanline", SHL_SPANLINE }
};


CONFIG_DEFS case_modes[2] = {
   { "ignore", IGNORE },
   { "match",  MATCH  }
};


/*
 * Group the list of available keys alphabetically.
 */
CONFIG_DEFS valid_keys[AVAIL_KEYS] = {
/*  available key      index into file   */
   { "a+\'",                     40 },
   { "a+-",                     130 },
   { "a+0",                     129 },
   { "a+1",                     120 },
   { "a+2",                     121 },
   { "a+3",                     122 },
   { "a+4",                     123 },
   { "a+5",                     124 },
   { "a+6",                     125 },
   { "a+7",                     126 },
   { "a+8",                     127 },
   { "a+9",                     128 },
   { "a+;",                      39 },
   { "a+<",                      51 },
   { "a+=",                     131 },
   { "a+>",                      52 },
   { "a+?",                      53 },
#ifndef __TURBOC__                         /* It seems Borland (BC3.1)       */
   { "a+[",                      26 },     /* converts to uppercase in       */
   { "a+]",                      27 },     /* stricmp, meaning these have    */
#endif                                     /* to go after the letters (jmh)  */
   { "a+a",                      30 },
   { "a+b",                      48 },
   { "a+backspace",              14 },
   { "a+c",                      46 },
   { "a+d",                      32 },
   { "a+e",                      18 },
   { "a+enter",                  28 },
   { "a+esc",                     1 },
   { "a+f",                      33 },
   { "a+f1",                    104 },
   { "a+f10",                   113 },
   { "a+f11",                   139 },
   { "a+f12",                   140 },
   { "a+f2",                    105 },
   { "a+f3",                    106 },
   { "a+f4",                    107 },
   { "a+f5",                    108 },
   { "a+f6",                    109 },
   { "a+f7",                    110 },
   { "a+f8",                    111 },
   { "a+f9",                    112 },
   { "a+g",                      34 },
   { "a+grey/",                 164 },
   { "a+greydel",               163 },
   { "a+greydown",              160 },
   { "a+greyend",               159 },
   { "a+greyenter",             166 },
   { "a+greyhome",              151 },
   { "a+greyins",               162 },
   { "a+greyleft",              155 },
   { "a+greypgdn",              161 },
   { "a+greypgup",              153 },
   { "a+greyright",             157 },
   { "a+greyup",                152 },
   { "a+h",                      35 },
   { "a+i",                      23 },
   { "a+j",                      36 },
   { "a+k",                      37 },
   { "a+l",                      38 },
   { "a+m",                      50 },
   { "a+n",                      49 },
   { "a+o",                      24 },
   { "a+p",                      25 },
   { "a+q",                      16 },
   { "a+r",                      19 },
   { "a+s",                      31 },
   { "a+t",                      20 },
   { "a+tab",                   165 },
   { "a+u",                      22 },
   { "a+v",                      47 },
   { "a+w",                      17 },
   { "a+x",                      45 },
   { "a+y",                      21 },
   { "a+z",                      44 },
#ifdef __TURBOC__                          /* added by jmh */
   { "a+[",                      26 },
   { "a+]",                      27 },
#endif
   { "a+~",                      41 },
   { "backspace",                 9 },
   { "c+@",                     174 },
#ifndef __TURBOC__                         /* added by jmh */
   { "c+[",                     201 },
   { "c+\\",                    202 },
   { "c+]",                     203 },
   { "c+^",                     204 },
   { "c+_",                     205 },
#endif
   { "c+a",                     175 },
   { "c+b",                     176 },
   { "c+backspace",              11 },
   { "c+c",                     177 },
   { "c+center",                143 },
   { "c+d",                     178 },
   { "c+del",                   147 },
   { "c+down",                  145 },
   { "c+e",                     179 },
   { "c+end",                   117 },
   { "c+enter",                   8 },
   { "c+esc",                     4 },
   { "c+f",                     180 },
   { "c+f1",                     94 },
   { "c+f10",                   103 },
   { "c+f11",                   137 },
   { "c+f12",                   138 },
   { "c+f2",                     95 },
   { "c+f3",                     96 },
   { "c+f4",                     97 },
   { "c+f5",                     98 },
   { "c+f6",                     99 },
   { "c+f7",                    100 },
   { "c+f8",                    101 },
   { "c+f9",                    102 },
   { "c+g",                     181 },
   { "c+grey*",                 150 },
   { "c+grey+",                 144 },
   { "c+grey-",                 142 },
   { "c+grey/",                 149 },
   { "c+greyenter",              43 },
   { "c+h",                     182 },
   { "c+home",                  119 },
   { "c+i",                     183 },
   { "c+ins",                   146 },
   { "c+j",                     184 },
   { "c+k",                     185 },
   { "c+l",                     186 },
   { "c+left",                  115 },
   { "c+m",                     187 },
   { "c+n",                     188 },
   { "c+o",                     189 },
   { "c+p",                     190 },
   { "c+pgdn",                  118 },
   { "c+pgup",                  132 },
   { "c+q",                     191 },
   { "c+r",                     192 },
   { "c+right",                 116 },
   { "c+s",                     193 },
   { "c+t",                     194 },
   { "c+tab",                   148 },
   { "c+u",                     195 },
   { "c+up",                    141 },
   { "c+v",                     196 },
   { "c+w",                     197 },
   { "c+x",                     198 },
   { "c+y",                     199 },
   { "c+z",                     200 },
#ifdef __TURBOC__                          /* added by jmh */
   { "c+[",                     201 },
   { "c+\\",                    202 },
   { "c+]",                     203 },
   { "c+^",                     204 },
   { "c+_",                     205 },
#endif
   { "center",                   76 },
   { "del",                      83 },
   { "down",                     80 },
   { "end",                      79 },
   { "enter",                     6 },
   { "esc",                       2 },
   { "f1",                       59 },
   { "f10",                      68 },
   { "f11",                     133 },
   { "f12",                     134 },
   { "f2",                       60 },
   { "f3",                       61 },
   { "f4",                       62 },
   { "f5",                       63 },
   { "f6",                       64 },
   { "f7",                       65 },
   { "f8",                       66 },
   { "f9",                       67 },
   { "grey+",                   168 },
   { "grey-",                   167 },
   { "greyenter",                29 },
   { "home",                     71 },
   { "ins",                      82 },
   { "left",                     75 },
   { "pgdn",                     81 },
   { "pgup",                     73 },
   { "right",                    77 },
   { "s+a+\'",                  242 },
   { "s+a+-",                   216 },
   { "s+a+0",                   215 },
   { "s+a+1",                   206 },
   { "s+a+2",                   207 },
   { "s+a+3",                   208 },
   { "s+a+4",                   209 },
   { "s+a+5",                   210 },
   { "s+a+6",                   211 },
   { "s+a+7",                   212 },
   { "s+a+8",                   213 },
   { "s+a+9",                   214 },
   { "s+a+;",                   241 },
   { "s+a+<",                   253 },
   { "s+a+=",                   217 },
   { "s+a+>",                   254 },
   { "s+a+?",                   255 },
#ifndef __TURBOC__                         /* added by jmh */
   { "s+a+[",                   228 },
   { "s+a+]",                   229 },
#endif
   { "s+a+a",                   232 },
   { "s+a+b",                   250 },
   { "s+a+c",                   248 },
   { "s+a+d",                   234 },
   { "s+a+e",                   220 },
   { "s+a+f",                   235 },
   { "s+a+g",                   236 },
   { "s+a+h",                   237 },
   { "s+a+i",                   225 },
   { "s+a+j",                   238 },
   { "s+a+k",                   239 },
   { "s+a+l",                   240 },
   { "s+a+m",                   252 },
   { "s+a+n",                   251 },
   { "s+a+o",                   226 },
   { "s+a+p",                   227 },
   { "s+a+q",                   218 },
   { "s+a+r",                   221 },
   { "s+a+s",                   233 },
   { "s+a+t",                   222 },
   { "s+a+u",                   224 },
   { "s+a+v",                   249 },
   { "s+a+w",                   219 },
   { "s+a+x",                   247 },
   { "s+a+y",                   223 },
   { "s+a+z",                   246 },
#ifdef __TURBOC__                          /* added by jmh */
   { "s+a+[",                   228 },
   { "s+a+]",                   229 },
#endif
   { "s+a+~",                   243 },
   { "s+backspace",              10 },
   { "s+c+down",                173 },     /* added by jmh 980807 */
   { "s+c+left",                170 },
   { "s+c+right",               171 },
   { "s+c+up",                  172 },     /* added by jmh 980807 */
   { "s+down",                   55 },     /* added by jmh 980807 */
   { "s+enter",                   7 },
   { "s+esc",                     3 },
   { "s+f1",                     84 },
   { "s+f10",                    93 },
   { "s+f11",                   135 },
   { "s+f12",                   136 },
   { "s+f2",                     85 },
   { "s+f3",                     86 },
   { "s+f4",                     87 },
   { "s+f5",                     88 },
   { "s+f6",                     89 },
   { "s+f7",                     90 },
   { "s+f8",                     91 },
   { "s+f9",                     92 },
   { "s+greyenter",              42 },
   { "s+left",                   56 },     /* added by jmh 980807 */
   { "s+right",                  57 },     /* added by jmh 980807 */
   { "s+tab",                    15 },
   { "s+up",                     54 },     /* added by jmh 980807 */
   { "tab",                      12 },
   { "up",                       72 }
};


/*
 * sorted alphabetic list of functions that keys may be assigned to.
 *  add 1 to NUM_FUNCS so users may use either Macro or Playback to
 *  define macros.  Macro and Playback are both assigned to 126.
 *
 * jmh 980723: replaced the numbers with the defines.
 * jmh 980726: add another one to NUM_FUNCS due to my two-key reorganizing.
 */

CONFIG_DEFS valid_func[NUM_FUNCS+2] = {
   { "AbortCommand",            AbortCommand           },
   { "AddLine",                 AddLine                },
   { "BackSpace",               BackSpace              },
   { "BackTab",                 BackTab                },
   { "BegNextLine",             BegNextLine            },
   { "BegOfLine",               BegOfLine              },
   { "BlockBegin",              BlockBegin             },
   { "BlockCenterJustify",      BlockCenterJustify     },
   { "BlockCompressTabs",       BlockCompressTabs      },
   { "BlockEmailReply",         BlockEmailReply        },
   { "BlockEnd",                BlockEnd               },
   { "BlockExpandTabs",         BlockExpandTabs        },
   { "BlockFixUUE",             BlockFixUUE            },
   { "BlockIndent",             BlockIndent            },
   { "BlockIndentN",            BlockIndentN           },
   { "BlockIndentTabs",         BlockIndentTabs        },
   { "BlockLeftJustify",        BlockLeftJustify       },
   { "BlockLowerCase",          BlockLowerCase         },
   { "BlockRightJustify",       BlockRightJustify      },
   { "BlockRot13",              BlockRot13             },
   { "BlockStripHiBit",         BlockStripHiBit        },
   { "BlockToFile",             BlockToFile            },
   { "BlockTrimTrailing",       BlockTrimTrailing      },
   { "BlockUndent",             BlockUndent            },
   { "BlockUndentN",            BlockUndentN           },
   { "BlockUpperCase",          BlockUpperCase         },
   { "BorderBlock",             BorderBlock            },
   { "BotOfScreen",             BotOfScreen            },
   { "CenterJustify",           CenterJustify          },
   { "CenterLine",              CenterLine             },
   { "CenterWindow",            CenterWindow           },
   { "ChangeCurDir",            ChangeCurDir           },
   { "CharLeft",                CharLeft               },
   { "CharRight",               CharRight              },
   { "ClearAllMacros",          ClearAllMacros         },
   { "CopyBlock",               CopyBlock              },
   { "DateTimeStamp",           DateTimeStamp          },
   { "DefineDiff",              DefineDiff             },
   { "DefineGrep",              DefineGrep             },
   { "DefineRegXGrep",          DefineRegXGrep         },
   { "DelEndOfLine",            DelEndOfLine           },
   { "DeleteBlock",             DeleteBlock            },
   { "DeleteChar",              DeleteChar             },
   { "DeleteLine",              DeleteLine             },
   { "DirList",                 DirList                },
   { "DosScreen",               DosScreen              },
   { "DosShell",                DosShell               },
   { "DuplicateLine",           DuplicateLine          },
   { "EditFile",                EditFile               },
   { "EditNextFile",            EditNextFile           },
   { "EndOfFile",               EndOfFile              },
   { "EndOfLine",               EndOfLine              },
   { "File",                    File                   },
   { "FileAll",                 FileAll                },
   { "FillBlock",               FillBlock              },
   { "FindBackward",            FindBackward           },
   { "FindForward",             FindForward            },
   { "FindRegX",                FindRegX               },
   { "FormatParagraph",         FormatParagraph        },
   { "FormatText",              FormatText             },
   { "FullWordEndLeft",         FullWordEndLeft        },
   { "FullWordEndRight",        FullWordEndRight       },
   { "FullWordLeft",            FullWordLeft           },
   { "FullWordRight",           FullWordRight          },
   { "GotoMark1",               GotoMark1              },
   { "GotoMark2",               GotoMark2              },
   { "GotoMark3",               GotoMark3              },
   { "Help",                    Help                   },
   { "HorizontalScreenLeft",    HorizontalScreenLeft   },
   { "HorizontalScreenRight",   HorizontalScreenRight  },
   { "InsertFile",              InsertFile             },
   { "JoinLine",                JoinLine               },
   { "JumpToLine",              JumpToLine             },
   { "KopyBlock",               KopyBlock              },
   { "LeftJustify",             LeftJustify            },
   { "LineDown",                LineDown               },
   { "LineUp",                  LineUp                 },
   { "LoadMacro",               LoadMacro              },
   { "Macro",                   PlayBack               },
   { "MacroMark",               MacroMark              },
   { "MarkBegin",               MarkBegin              },
   { "MarkBox",                 MarkBox                },
   { "MarkEnd",                 MarkEnd                },
   { "MarkLine",                MarkLine               },
   { "MarkStream",              MarkStream             },
   { "MoveBlock",               MoveBlock              },
   { "NextDirtyLine",           NextDirtyLine          },
   { "NextHiddenWindow",        NextHiddenWindow       },
   { "NextLine",                NextLine               },
   { "NextWindow",              NextWindow             },
   { "Null",                    0                      },
   { "NumberBlock",             NumberBlock            },
   { "OverlayBlock",            OverlayBlock           },
   { "PanDn",                   PanDn                  },
   { "PanLeft",                 PanLeft                },
   { "PanRight",                PanRight               },
   { "PanUp",                   PanUp                  },
   { "ParenBalance",            ParenBalance           },
   { "Pause",                   Pause                  },
   { "PlayBack",                PlayBack               },
   { "PrevDirtyLine",           PrevDirtyLine          },
   { "PrevHiddenWindow",        PrevHiddenWindow       },
   { "PreviousPosition",        PreviousPosition       },
   { "PreviousWindow",          PreviousWindow         },
   { "PrintBlock",              PrintBlock             },
   { "PseudoMacro",             PseudoMacro            },
   { "PullDown",                PullDown               },
   { "Quit",                    Quit                   },
   { "QuitAll",                 QuitAll                },
   { "ReadConfig",              ReadConfig             },
   { "RecordMacro",             RecordMacro            },
   { "RedrawScreen",            RedrawScreen           },
   { "Repeat",                  Repeat                 },
   { "RepeatDiff",              RepeatDiff             },
   { "RepeatFindBackward",      RepeatFindBackward     },
   { "RepeatFindForward",       RepeatFindForward      },
   { "RepeatFindRegX",          RepeatFindRegX         },
   { "RepeatFindRegXBackward",  RepeatFindRegXBackward },
   { "RepeatGrep",              RepeatGrep             },
   { "ReplaceString",           ReplaceString          },
   { "RightJustify",            RightJustify           },
   { "Rturn",                   Rturn                  },
   { "Save",                    Save                   },
   { "SaveAs",                  SaveAs                 },
   { "SaveMacro",               SaveMacro              },
   { "ScreenDown",              ScreenDown             },
   { "ScreenUp",                ScreenUp               },
   { "ScrollDnLine",            ScrollDnLine           },
   { "ScrollUpLine",            ScrollUpLine           },
   { "SetBreakPoint",           SetBreakPoint          },
   { "SetFileAttributes",       SetFileAttributes      },
   { "SetLeftMargin",           SetLeftMargin          },
   { "SetMark1",                SetMark1               },
   { "SetMark2",                SetMark2               },
   { "SetMark3",                SetMark3               },
   { "SetParagraphMargin",      SetParagraphMargin     },
   { "SetRightMargin",          SetRightMargin         },
   { "SetTabs",                 SetTabs                },
   { "SizeWindow",              SizeWindow             },
   { "SortBoxBlock",            SortBoxBlock           },
   { "SplitHorizontal",         SplitHorizontal        },
   { "SplitLine",               SplitLine              },
   { "SplitVertical",           SplitVertical          },
   { "StampFormat",             StampFormat            },
   { "StreamDeleteChar",        StreamDeleteChar       },
   { "SwapBlock",               SwapBlock              },
   { "SyntaxSelect",            SyntaxSelect           },
   { "Tab",                     Tab                    },
   { "ToggleCRLF",              ToggleCRLF             },
   { "ToggleCursorCross",       ToggleCursorCross      },
   { "ToggleEol",               ToggleEol              },
   { "ToggleGraphicChars",      ToggleGraphicChars     },
   { "ToggleIndent",            ToggleIndent           },
   { "ToggleOverWrite",         ToggleOverWrite        },
   { "ToggleRuler",             ToggleRuler            },
   { "ToggleSearchCase",        ToggleSearchCase       },
   { "ToggleSmartTabs",         ToggleSmartTabs        },
   { "ToggleSync",              ToggleSync             },
   { "ToggleSyntax",            ToggleSyntax           },
   { "ToggleTabInflate",        ToggleTabInflate       },
   { "ToggleTrailing",          ToggleTrailing         },
   { "ToggleWordWrap",          ToggleWordWrap         },
   { "ToggleZ",                 ToggleZ                },
   { "TopOfFile",               TopOfFile              },
   { "TopOfScreen",             TopOfScreen            },
   { "Transpose",               Transpose              },
   { "TwoCharKey",              TwoCharKey             },
   { "UndoDelete",              UndoDelete             },
   { "UndoLine",                UndoLine               },
   { "UnMarkBlock",             UnMarkBlock            },
   { "WordDelete",              WordDelete             },
   { "WordDeleteBack",          WordDeleteBack         },
   { "WordEndLeft",             WordEndLeft            },
   { "WordEndRight",            WordEndRight           },
   { "WordLeft",                WordLeft               },
   { "WordRight",               WordRight              },
   { "ZoomWindow",              ZoomWindow             }
};


/*
 * list of modes (with aliases) for the macros.
 * key / 2 is the index; key % 2 is the value.
 */

CONFIG_DEFS valid_macro_modes[NUM_MACRO_MODES] = {
  { "F",         2 },
  { "Fixed",     2 },
  { "FixedTabs", 2 },
  { "I",         1 },
  { "Ind",       5 },
  { "Indent",    5 },
  { "Ins",       1 },
  { "Insert",    1 },
  { "NoI",       4 },
  { "NoInd",     4 },
  { "NoIndent",  4 },
  { "O",         0 },
  { "Ovr",       0 },
  { "Overwrite", 0 },
  { "S",         3 },
  { "Smart",     3 },
  { "SmartTabs", 3 }
};


/*
 * list of color fields sorted alphabetically
 */

CONFIG_DEFS valid_colors[NUM_COLORS*2] = {
   { "co80_Blocks",                   4 },
   { "co80_Cross",                   10 },
   { "co80_CurLine",                  9 },
   { "co80_DirtyLine",                2 },
   { "co80_EndOfFile",                8 },
   { "co80_FileHeader",               0 },
   { "co80_HelpScreen",               6 },
   { "co80_HilitedFile",             13 },
   { "co80_MessageLine",              5 },
   { "co80_ModeLine",                 3 },
   { "co80_Overscan",                14 },
   { "co80_Ruler",                   11 },
   { "co80_RulerPointer",            12 },
   { "co80_Text",                     1 },
   { "co80_Wrapped",                  7 },
   { "mono_Blocks",                   4 },
   { "mono_Cross",                   10 },
   { "mono_CurLine",                  9 },
   { "mono_DirtyLine",                2 },
   { "mono_EndOfFile",                8 },
   { "mono_FileHeader",               0 },
   { "mono_HelpScreen",               6 },
   { "mono_HilitedFile",             13 },
   { "mono_MessageLine",              5 },
   { "mono_ModeLine",                 3 },
   { "mono_Overscan",                14 },
   { "mono_Ruler",                   11 },
   { "mono_RulerPointer",            12 },
   { "mono_Text",                     1 },
   { "mono_Wrapped",                  7 }
};


/*
 * list of editor modes sorted alphabetically
 */

CONFIG_DEFS valid_modes[NUM_MODES] = {
   { "Backups",             Backup      },
   { "CaseConvert",         CaseConvert },
   { "CaseIgnore",          Ignore      },
   { "CaseMatch",           Match       },
   { "CharDef",             CharDef     },
   { "ControlZ",            Write_Z     },
   { "CursorCross",         CursorCross },
   { "CursorStyle",         Size        },
   { "DirSort",             DirSort     },
   { "DisplayEndOfLine",    Eol         },
   { "EndOfLineStyle",      Crlf        },
   { "IndentMode",          Ind         },
   { "InflateTabs",         InflateTabs },
   { "InitialCaseMode",     Initcase    },
   { "InsertMode",          Ins         },
   { "JustifyRightMargin",  JustRM      },
   { "LeftMargin",          Left        },
   { "LTabSize",            LTAB        },
   { "ParagraphMargin",     Para        },
   { "PTabSize",            PTAB        },
   { "RightMargin",         Right       },
   { "Ruler",               Ruler       },
   { "SmartTabMode",        Smart       },
   { "TimeStamp",           Stamp       },
   { "TrimTrailingBlanks",  Trim        },
   { "WordWrapMode",        WW          }
};



CONFIG_DEFS off_on[2] = {
   { "Off",   0 },
   { "On",    1 }
};


CONFIG_DEFS valid_z[2] = {
   { "No_Z",     0 },
   { "Write_Z",  1 }
};


CONFIG_DEFS valid_cursor[2] = {
   { "Large",   1 },
   { "Small",   0 }
};


CONFIG_DEFS valid_crlf[2] = {
   { "CRLF",   1 },
   { "LF",     2 }
};


CONFIG_DEFS valid_wraps[3] = {
   { "DynamicWrap",   2 },
   { "FixedWrap",     1 },
   { "Off",           0 }
};


CONFIG_DEFS valid_tabs[3] = {
   { "Off",   0 },
   { "On",    1 },
   { "Real",  2 }
};


CONFIG_DEFS valid_eol[3] = {
   { "Extend", 2 },
   { "Off",    0 },
   { "On",     1 }
};


CONFIG_DEFS valid_dir_sort[2] = {
   { "Extension", SORT_EXT  },
   { "Filename",  SORT_NAME }
};


CONFIG_DEFS valid_pairs[8] = {
   { "Pair1",  0 },
   { "Pair2",  1 },
   { "Pair3",  2 },
   { "Pair4",  3 },
   { "Pair5",  4 },
   { "Pair6",  5 },
   { "Pair7",  6 },
   { "Pair8",  7 }
};

#if defined( __UNIX__ )
CONFIG_DEFS valid_curse[8] = {
   { "COLOR_BLACK",    0 },
   { "COLOR_BLUE",     4 },
   { "COLOR_CYAN",     6 },
   { "COLOR_GREEN",    2 },
   { "COLOR_MAGENTA",  5 },
   { "COLOR_RED",      1 },
   { "COLOR_WHITE",    7 },
   { "COLOR_YELLOW",   3 }
};
#endif
