// clean the root directory
void clean_root(void)
	{
	uint	i,j,k,m;  // indexes for 'for' loops
	uchar	flag;   // flag to tell if the rest of the dir is empty
	char	temp[256]; // temp string for new directory
	char	temp1[9];
	uchar	ch;     // for holding temperary char values
	ulong	first_sector;	// first sector of the root directory
	ulong	numsecs;		// number of sectors in the root directory
	uchar	far *small_buf;		// pointer to the sector buffer


	first_sector = (ulong)hdb.reserved_sectors +
				   (ulong)hdb.sectors_fat * (ulong)hdb.number_fats;
	numsecs = (((ulong)hdb.number_entries_root_dir * 32L)/
			  (ulong)hdb.bytes_sector);
	small_buf = (uchar far*)farcalloc((ulong)(hdb.bytes_sector)*numsecs,sizeof(uchar));
	if( small_buf == NULL )
		{
		cprintf("\n\rFailed to allocate small_buf in clean_root");
		getch();
        exit(0);
		}

	// use the 'small_buf' to store the data while we edit it
	// first get the root sector data into the small_buf
	rd_multi((uchar far *)(small_buf), first_sector, 1, (int)numsecs);

	clrscr();
	dircount = 1;
	cprintf("\n\rCleaning %u \/", dircount);
	flag = 1;
	for( i = 0 ; i < (uint)numsecs ; i++ )
		{
		for( j = 0 ; j < hdb.bytes_sector/32 ; j++ )
			{
			if( flag == 1 )
				{
				if( *(small_buf+i*hdb.bytes_sector + j*32) == 0xe5 )
					{
					for( k = 1 ; k < 32 ; k++ )
						*(small_buf+i*hdb.bytes_sector+j*32+k) = 0x00;
					}
				if ( *(small_buf+i*hdb.bytes_sector+j*32) == 0 )
					{
					for( k = 0 ; k < 32 ; k++ )
						*(small_buf+i*hdb.bytes_sector+j*32+k) = 0x00;
					flag = 0;
					}
				}
			else
				{
				for( k = 0 ; k < 32 ; k++ )
					*(small_buf+i*hdb.bytes_sector+j*32+k) = 0x00;
				}
			}
		}

	wt_multi((uchar far *)(small_buf), first_sector, 1, (int)numsecs );

	for( i = 0 ; i < (uint)numsecs ; i++ )
		{
		for( j = 0 ; j < hdb.bytes_sector/32 ; j++ )
			{
			if( *(small_buf+i*hdb.bytes_sector+j*32+11) & 0x10 ) // check if directory
				{
				ch = *(small_buf+i*hdb.bytes_sector+j*32);
				if( (ch != 0x2e) && (ch != 0x00) && (ch != 0xe5) ) // check for first two entries
					{
					dircount += 1;
					cprintf("\n\rCleaning %u \/", dircount);
					for( m = 0 ; m < 8 ; m++ )
						cprintf("%c",*(small_buf+i*hdb.bytes_sector+j*32+m));
					for( m = 0 ; m < 256 ; m++ )
						temp[m] = 0x00;
					for( m = 0 ; m < 9 ; m++ )
						temp1[m] = 0x00;
					strcat(temp, "\/");
					for (m = 0 ; m < 8 ; m++)
						{
						if( *(small_buf+i*hdb.bytes_sector+j*32+m) != 0x20 )
							temp1[m] = *(small_buf+i*hdb.bytes_sector+j*32+m);
						}
					strcat(temp, temp1);
					clean_dir(*(uint*)(small_buf+i*hdb.bytes_sector+j*32+26), temp);
					}
				}
			}
		}
	farfree(small_buf);
    getch();
	}

