/*
 *  DRSP - DriveSpeed, version 3.10 (GPL FREEWARE)
 *  Copyleft (l) Stanislav Sokolov, May 1998 and onwards.
 *
 *  This program is subject to GNU General Public License ver. 2 of June 1991
 *  and any later version.
 *
 *  You may use this source with your programs, provided
 *  due credits are given.
 *
 *  Contact the author by e-mail: stanislavs@hotmail.com
 *
 *  Internet:  http://members.tripod.com/~stanislavs/prog/prog.htm
 */

#include "D:\TC\MY\DRSP\DRSP.H"


//DoTest for a RW process
void DoTest(TestData TD, float *ReadSpd, float *WriteSpd){
	int Handle = 0, ax_, i, Length;
	unsigned long j;
	register int k;
	struct time WOn, WOff, ROn, ROff;
	FindLong f;
	char *buffer;
	char FName[] = FILE_NAME;

	if((buffer = (char *)malloc(10000)) == NULL)
		Abort(0, NULL, "Out of memory in DoTest().", EX_NO_MEM);

	strcpy(buffer, "DRSP (version 3.10) - DriveSpeed test file\x1A\r");

	FName[0] = TD.Drive;

	f.Whole = (long)buffer;

	//Set blinking ". . ."
	printf("\n\n");
	gotoxy(9, wherey());
	textcolor(128 + 7);
	cprintf(". . .");
	textcolor(7);
	gotoxy(1, wherey());
	_setcursortype(_NOCURSOR);

	//Main loop
	for(i = 1; i <= TD.Turns; i++){
		printf("Writing");

		//Generate random test string
		srand((unsigned) time(NULL));
		for(k = 45; k <= 9999; k++) buffer[k] = char(random(254) + 1);

		//Open
		unlink(FName);

		if((Handle = open(FName, O_CREAT | O_TRUNC | O_BINARY, S_IREAD | S_IWRITE)) == -1)
			Abort(0, NULL, "Error opening test-file.", EX_OPEN_ERR);

		Length = 10000;
		j = 0;

		ClearCache();

		//Test writing speed
		gettime(&WOn);
		do{
			//Adjust write length
			//(last write operation will generally be shorter than 10000)
			j += 10000;
			if(j > TD.Size) Length = int(TD.Size - (j - 10000));
						//Perform write operation
			asm{
				mov AH, 0x40
				mov BX, Handle
				push DS
				mov DS, word ptr [f.Part.High]
				mov DX, word ptr [f.Part.Low]
				mov CX, Length
				int 0x21
				mov ax_, AX
				pop DS
			}

			//Check for errors
			if(ax_ != Length) Abort(Handle, FName, "Error writing to file.", EX_WRITE_ERR);

		}while(j < TD.Size);

		//Commit cached data to file (only available from DOS 3.3)
		asm{
			mov AH, 0x68
			mov BX, Handle
			int 0x21
		}
		gettime(&WOff);

		*WriteSpd += finddiff(WOn, WOff);

		if(kbhit() && getch() == 27)
			Abort(Handle, FName, "\nAborted by user.", EX_ABORT);

		lseek(Handle, 0, SEEK_SET);

		Length = 10000;
		j = 0;

		ClearCache();

		//Test reading speed
		gotoxy(1, wherey());
		printf("Reading\n\n");

		gettime(&ROn);
		do{
			//Adjust read length
			//(last read operation will generally be shorter than 10000)
			j += 10000;
			if(j > TD.Size) Length = int(TD.Size - (j - 10000));

			//Perform read operation
			asm{
				mov AH, 0x3F
				mov BX, Handle
				push DS
				mov DS, word ptr [f.Part.High]
				mov DX, word ptr [f.Part.Low]
				mov CX, Length
				int 0x21
				mov ax_, AX
				pop DS
			}

			//Check for errors (this is a do-nothing condition, preserved
			//only to give comparable results with write operation)
			if(ax_ != Length) ax_ = 0;

		}while(j < TD.Size);
		gettime(&ROff);

		*ReadSpd += finddiff(ROn, ROff);

		if(kbhit() && getch() == 27)
			Abort(Handle, FName, "\n\nAborted by user.", EX_ABORT);

		close(Handle);

		printf("Turn %i out of %i complete.", i, TD.Turns);
		gotoxy(1, wherey() - 2);

	}

	cprintf("Done.        \n\n\n\n");
	_setcursortype(_NORMALCURSOR);
	unlink(FName);

	nfree(buffer);

	//Return values
	*WriteSpd /= TD.Turns;
	*ReadSpd /= TD.Turns;
}



//DoTest for a RO multi-pass process
float DoTest(char *RetPath, TestData TD){
	int Handle = 0, ax_, i, Length;
	unsigned long j;
	float ReadSpd = 0.0;
	struct time ROn, ROff;
	FindLong f;
	char *FName = RetPath, *buffer;

	if((buffer = (char *)malloc(10000)) == NULL)
		Abort(0, NULL, "Out of memory in DoTest().", EX_NO_MEM);

	f.Whole = (long)buffer;

	//Set blinking ". . ."
	printf("\n\n");
	gotoxy(9, wherey());
	textcolor(128 + 7);
	cprintf(". . .");
	textcolor(7);
	gotoxy(1, wherey());
	_setcursortype(_NOCURSOR);

	//Main loop
	for(i = 1; i <= TD.Turns; i++){

		//Open
		if((Handle = open(FName, O_BINARY, S_IREAD)) == -1)
			Abort(0, NULL, "Error opening test-file.", EX_OPEN_ERR);

		Length = 10000;
		j = 0;

		if(kbhit() && getch() == 27)
			Abort(Handle, NULL, "\nAborted by user.", EX_ABORT);

		lseek(Handle, 0, SEEK_SET);

		Length = 10000;
		j = 0;

		//Test reading speed
		gotoxy(1, wherey());
		printf("Reading\n\n");

		ClearCache();

		gettime(&ROn);
		do{
			//Adjust read length
			//(last read operation will generally be shorter than 10000)
			j += 10000;
			if(j > TD.Size) Length = int(TD.Size - (j - 10000));

			//Perform read operation
			asm{
				mov AH, 0x3F
				mov BX, Handle
				push DS
				mov DS, word ptr [f.Part.High]
				mov DX, word ptr [f.Part.Low]
				mov CX, Length
				int 0x21
				mov ax_, AX
				pop DS
			}

			//Check for errors (this is a do-nothing condition, preserved
			//only to give comparable results with write operation)
			if(ax_ != Length) ax_ = 0;

		}while(j < TD.Size);
		gettime(&ROff);

		ReadSpd += finddiff(ROn, ROff);

		if(kbhit() && getch() == 27)
			Abort(Handle, NULL, "\n\nAborted by user.", EX_ABORT);

		close(Handle);

		printf("Turn %i out of %i complete.", i, TD.Turns);
		gotoxy(1, wherey() - 2);

	}

	cprintf("Done.        \n\n\n\n");
	_setcursortype(_NORMALCURSOR);

	nfree(buffer);

	//Return value
	return ReadSpd /= TD.Turns;
}


//DoTest for a RO single-pass process
float DoTest(TestFile TF[], unsigned long Size){
	int Handle = 0, ax_, i, Length;
	unsigned long j;
	float ReadSpd = 0.0;
	struct time ROn, ROff;
	FindLong f;
	char *FName, *buffer;

	if((buffer = (char *)malloc(10000)) == NULL)
		Abort(0, NULL, "Out of memory in DoTest().", EX_NO_MEM);

	f.Whole = (long)buffer;

	//Set blinking ". . ."
	printf("\n\n");
	gotoxy(9, wherey());
	textcolor(128 + 7);
	cprintf(". . .");
	textcolor(7);
	gotoxy(1, wherey());
	_setcursortype(_NOCURSOR);

	printf("Reading\n\n");

	//Main loop
	for(i = 0; i < MAX_FBUF; i++){
		if(TF[i].Size == 0) break;

		//Open
		FName = TF[i].Path;
		printf("Testing file #%d.\n%s", i + 1, FName);
		for(int k = 1; k < MAX_PATH - strlen(TF[i].Path); k++) printf(" ");

		if((Handle = open(FName, O_BINARY, S_IREAD)) == -1)
			Abort(0, NULL, "Error opening test-file.", EX_OPEN_ERR);

		if(kbhit() && getch() == 27)
			Abort(Handle, NULL, "\nAborted by user.", EX_ABORT);

		lseek(Handle, 0, SEEK_SET);

		Length = 10000;
		j = 0;

		//Test reading speed
		gettime(&ROn);
		do{
			//Adjust read length
			//(last read operation will generally be shorter than 10000)
			j += 10000;
			if(j > Size) Length = int(Size - (j - 10000));

			//Perform read operation
			asm{
				mov AH, 0x3F
				mov BX, Handle
				push DS
				mov DS, word ptr [f.Part.High]
				mov DX, word ptr [f.Part.Low]
				mov CX, Length
				int 0x21
				mov ax_, AX
				pop DS
			}

			//Check for errors (this is a do-nothing condition, preserved
			//only to give comparable results with write operation)
			if(ax_ != Length) ax_ = 0;

		}while(j < Size);
		gettime(&ROff);

		ReadSpd += finddiff(ROn, ROff);

		if(kbhit() && getch() == 27)
			Abort(Handle, NULL, "\n\nAborted by user.", EX_ABORT);

		close(Handle);

		gotoxy(1, wherey() - 2);

	}

	gotoxy(1, wherey() - 2);
	cprintf("Done.        \n\n\n\n");
	_setcursortype(_NORMALCURSOR);

	nfree(buffer);

	return ReadSpd;

}



float TestFAS(char Drive){
	char *FName, CF;
	FName = FILE_NAME;
	FName[0] = Drive;

	unsigned long RetVal = 0;
	int Handle, flags_;
	time_t TestOff;
	FindLong f;

	f.Whole = (long)FName;

	//Set blinking ". . ."
	gotoxy(56, wherey());
	textcolor(128 + 7);
	cprintf(". . .");
	textcolor(7);
	gotoxy(1, wherey());
	_setcursortype(_NOCURSOR);

	cprintf("Performing File Access Speed (FAS) test - takes 15 sec");

	TestOff = time(NULL) + 15;
	do{
		//Create and open a file (Fn 6cH is only available from DOS 4.0)
		asm{
			mov AX, 0x6C00
			mov BX, 0x40C2
			mov CX, 0x20
			mov DX, 0x12
			push DS
			push SI
			mov DS, word ptr [f.Part.High]
			mov SI, word ptr [f.Part.Low]
			int 0x21
			pop SI
			pop DS
			mov Handle, AX
			pushf           //push Flags on stack
			pop flags_      //read Flags
		}
		CF = flags_ & 0x01;

		if(CF)
			Abort((CF ? 0 : Handle), FName, "\nCritical error while creating/opening a file.", EX_OPEN_ERR);

		//Commit cached data to file (only available from DOS 3.3)
		asm{
			mov AH, 0x68
			mov BX, Handle
			int 0x21
		}

		//Close the file
		asm{
			mov AH, 0x3E
			mov BX, Handle
			int 0x21
			pushf           //push Flags on stack
			pop flags_      //read Flags
		}
		CF = flags_ & 0x01;

		if(CF)
			Abort(Handle, FName, "\nCritical error while closing a file.", EX_CLOSE_ERR);

		//Delete the file
		asm{
			mov AH, 0x41
			push DS
			mov DS, word ptr [f.Part.High]
			mov DX, word ptr [f.Part.Low]
			int 0x21
			pop DS
			pushf           //push Flags on stack
			pop flags_      //read Flags
		}
		CF = flags_ & 0x01;

		if(CF)
			Abort(0, FName, "\nCritical error while deleting a file.", EX_DEL_ERR);

		RetVal++;
	}while(TestOff >= time(NULL));

	unlink(FName);

	cprintf(" . . . done.\n\n");
	_setcursortype(_NORMALCURSOR);

	//Compensate for the 4 operations that are performed
	return (RetVal * 4.0) / 15.0;
}


float finddiff(struct time on, struct time off){
	unsigned long start = (long)on.ti_hund +
						  (long)on.ti_sec * 100 +
						  (long)on.ti_min * 6000 +
						  (long)on.ti_hour * 360000;
	unsigned long stop =  (long)off.ti_hund +
						  (long)off.ti_sec * 100 +
						  (long)off.ti_min * 6000 +
						  (long)off.ti_hour * 360000;

	return (stop - start) / 100.0;

}