#include "ntui.h"
#include <commctrl.h>
#include <time.h>
#include <process.h>
#include <assert.h>
#include "progress.h"

static HWND statDlgWnd     = 0;
static HWND srcAddFiles    = 0;
static HWND srcAddBytes    = 0;
static HWND srcCopyFiles   = 0;
static HWND srcCopyBytes   = 0;
static HWND srcDeleteFiles = 0;
static HWND srcDeleteBytes = 0;
static HWND dstAddFiles    = 0;
static HWND dstAddBytes    = 0;
static HWND dstCopyFiles   = 0;
static HWND dstCopyBytes   = 0;
static HWND dstDeleteFiles = 0;
static HWND dstDeleteBytes = 0;
static HWND remAddFiles    = 0;
static HWND remAddBytes    = 0;
static HWND remCopyFiles   = 0;
static HWND remCopyBytes   = 0;
static HWND remDeleteFiles = 0;
static HWND remDeleteBytes = 0;
static HWND messages       = 0;
static HWND fileProgress   = 0;
static HWND totalProgress  = 0;
static HWND timeElapsed    = 0;
static HWND timeRemaining  = 0;
static HWND BPSWnd         = 0;

static BOOL   waitingWindow = FALSE; // set when button --> ``OK''
static BOOL   cancel        = FALSE; // set when cancel pressed
static HANDLE fnComplete; // event used to signify create or destroy is complete

BOOL statDlgCancelTest()
{
  return cancel;
}

void statDlgCancelSet(void)
{
  cancel = TRUE;
  EnableWindow(GetDlgItem(statDlgWnd, IDOK), FALSE);
}

void statDlgCancelReset(void)
{
  cancel = FALSE;
  EnableWindow(GetDlgItem(statDlgWnd, IDOK), TRUE);
}

static BOOL CALLBACK statDlgProc(HWND hWnd, UINT uMsg, WPARAM wp, LPARAM lp)
{
  BOOL ret = FALSE;
  UNUSED(lp);
  switch (uMsg)
  {
    case WM_COMMAND:
      if ((HIWORD(wp) == BN_CLICKED) && (LOWORD(wp) == IDOK))
      {
        if (waitingWindow)
          DestroyWindow(statDlgWnd);
        else
          statDlgCancelSet();
        ret = TRUE;
      }
      break;
    case WM_DESTROY:
      PostQuitMessage(0);
      break;
    case WM_INITDIALOG:
      srcAddFiles    = GetDlgItem(hWnd, IDC_SRC_ADD_FILES);
      srcAddBytes    = GetDlgItem(hWnd, IDC_SRC_ADD_BYTES);
      srcCopyFiles   = GetDlgItem(hWnd, IDC_SRC_COPY_FILES);
      srcCopyBytes   = GetDlgItem(hWnd, IDC_SRC_COPY_BYTES);
      srcDeleteFiles = GetDlgItem(hWnd, IDC_SRC_DELETE_FILES);
      srcDeleteBytes = GetDlgItem(hWnd, IDC_SRC_DELETE_BYTES);

      dstAddFiles    = GetDlgItem(hWnd, IDC_DST_ADD_FILES);
      dstAddBytes    = GetDlgItem(hWnd, IDC_DST_ADD_BYTES);
      dstCopyFiles   = GetDlgItem(hWnd, IDC_DST_COPY_FILES);
      dstCopyBytes   = GetDlgItem(hWnd, IDC_DST_COPY_BYTES);
      dstDeleteFiles = GetDlgItem(hWnd, IDC_DST_DELETE_FILES);
      dstDeleteBytes = GetDlgItem(hWnd, IDC_DST_DELETE_BYTES);
  
      remAddFiles    = GetDlgItem(hWnd, IDC_REMAINING_ADD_FILES);
      remAddBytes    = GetDlgItem(hWnd, IDC_REMAINING_ADD_BYTES);
      remCopyFiles   = GetDlgItem(hWnd, IDC_REMAINING_COPY_FILES);
      remCopyBytes   = GetDlgItem(hWnd, IDC_REMAINING_COPY_BYTES);
      remDeleteFiles = GetDlgItem(hWnd, IDC_REMAINING_DELETE_FILES);
      remDeleteBytes = GetDlgItem(hWnd, IDC_REMAINING_DELETE_BYTES);

      timeElapsed    = GetDlgItem(hWnd, IDC_ELAPSED);
      timeRemaining  = GetDlgItem(hWnd, IDC_REMAINING);
      BPSWnd         = GetDlgItem(hWnd, IDC_BPS);


      {
        RECT cr;
        POINT tl;
        GetClientRect(hWnd, &cr);
        tl.y = cr.top;
        tl.x = cr.left;
        ClientToScreen(hWnd, &tl);
        {
          HWND placeHolder = GetDlgItem(hWnd, IDC_FILE);
          RECT rc;
          GetWindowRect(placeHolder, &rc);
          rc.left   -= tl.x;
          rc.right  -= tl.x;
          rc.top    -= tl.y;
          rc.bottom -= tl.y;

          fileProgress = CreateWindow(
            PROGRESS_NAME, 
            "", 
            WS_BORDER | WS_CHILD | WS_VISIBLE,
            rc.left,
            rc.top,
            rc.right - rc.left + 1,
            rc.bottom - rc.top + 1,
            hWnd,
            0,
            0,
            0);
          DestroyWindow(placeHolder);
        }
        {
          HWND placeHolder = GetDlgItem(hWnd, IDC_TOTAL);
          RECT rc;
          GetWindowRect(placeHolder, &rc);
          rc.left   -= tl.x;
          rc.right  -= tl.x;
          rc.top    -= tl.y;
          rc.bottom -= tl.y;

          totalProgress = CreateWindow(
            PROGRESS_NAME, 
            "", 
            WS_BORDER | WS_CHILD | WS_VISIBLE,
            rc.left,
            rc.top,
            rc.right - rc.left + 1,
            rc.bottom - rc.top + 1,
            hWnd,
            0,
            0,
            0
          );
          DestroyWindow(placeHolder);
        }
      }


      messages       = GetDlgItem(hWnd, IDC_MESSAGES);
  
#if 0
      PostMessage(fileProgress, PBM_SETPOS,   0, 0);
      PostMessage(fileProgress, PBM_SETRANGE, 0, MAKELPARAM(0,1000));
      PostMessage(totalProgress, PBM_SETRANGE, 0, MAKELPARAM(0,1000));
      PostMessage(totalProgress, PBM_SETPOS, 0, 0);
#endif
      {
        HWND child;
        for (child = GetWindow(hWnd, GW_CHILD); child; child = GetWindow(child, GW_HWNDNEXT))
        {
          long style = GetWindowLong(child, GWL_STYLE);
          style |= WS_CLIPSIBLINGS;
          SetWindowLong(child, GWL_STYLE, style);
        }
      }
      ret = FALSE;
      //
      // complete. set the event
      //
      {
        BOOL OK = SetEvent(fnComplete);
        assert(OK);
      }
      break;
  }
  return ret;
}

static UINT statDlgThread(void *p)
{
  MSG msg;
  MSG lastMsg;
  UNUSED(p);
  statDlgWnd = CreateDialog(0, MAKEINTRESOURCE(IDD_STAT), 0, statDlgProc);
  while (GetMessage(&msg, 0, 0, 0))
  {
    if (!IsDialogMessage(statDlgWnd, &msg))
    {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
    memcpy(&lastMsg, &msg, sizeof(msg));
  }
  SetEvent(fnComplete);
  return 0;
}

void statDlgCreate(void)
{
  SECURITY_ATTRIBUTES sa;
  sa.nLength = sizeof(sa);
  sa.lpSecurityDescriptor = 0;
  sa.bInheritHandle = TRUE;

  fnComplete = CreateEvent(&sa, FALSE, FALSE, 0);
  statDlgWnd = 0;
  assert(fnComplete != 0);
  _beginthread(statDlgThread, 0, 0);
  WaitForMultipleObjects(1, &fnComplete, FALSE, INFINITE); // don't go anywhere until init is complete!
  while (!statDlgWnd)
    Sleep(0);
}

void statDlgUpdate(const char *txt, BOOL exec, BOOL force)
{
  if (statDlgWnd && (force || txt))
  {
    char text[16];

    SetWindowText(srcAddFiles,    fixNumber(text, source->stAdd.tCt));
    SetWindowText(srcAddBytes,    fixNumber(text, source->stAdd.tSz));
    SetWindowText(srcCopyFiles,   fixNumber(text, source->stCopy.tCt));
    SetWindowText(srcCopyBytes,   fixNumber(text, source->stCopy.tSz));
    SetWindowText(srcDeleteFiles, fixNumber(text, source->stDelete.tCt));
    SetWindowText(srcDeleteBytes, fixNumber(text, source->stDelete.tSz));

    SetWindowText(dstAddFiles,    fixNumber(text, dest->stAdd.tCt));
    SetWindowText(dstAddBytes,    fixNumber(text, dest->stAdd.tSz));
    SetWindowText(dstCopyFiles,   fixNumber(text, dest->stCopy.tCt));
    SetWindowText(dstCopyBytes,   fixNumber(text, dest->stCopy.tSz));
    SetWindowText(dstDeleteFiles, fixNumber(text, dest->stDelete.tCt));
    SetWindowText(dstDeleteBytes, fixNumber(text, dest->stDelete.tSz));

    SetWindowText(remAddFiles,    fixNumber(text, (source->stAdd.tCt + dest->stAdd.tCt) - (source->stAdd.cCt + dest->stAdd.cCt)));
    SetWindowText(remAddBytes,    fixNumber(text, (source->stAdd.tSz + dest->stAdd.tSz) - (source->stAdd.cSz + dest->stAdd.cSz)));
    SetWindowText(remCopyFiles,   fixNumber(text, (source->stCopy.tCt + dest->stCopy.tCt) - (source->stCopy.cCt + dest->stCopy.cCt)));
    SetWindowText(remCopyBytes,   fixNumber(text, (source->stCopy.tSz + dest->stCopy.tSz) - (source->stCopy.cSz + dest->stCopy.cSz)));
    SetWindowText(remDeleteFiles, fixNumber(text, (source->stDelete.tCt + dest->stDelete.tCt) - (source->stDelete.cCt + dest->stDelete.cCt)));
    SetWindowText(remDeleteBytes, fixNumber(text, (source->stDelete.tSz + dest->stDelete.tSz) - (source->stDelete.cSz + dest->stDelete.cSz)));
    if (txt && exec)
    {
      char *dup = strdup(txt);
      char *ptr = dup;
      HTREEITEM      hItem = 0;
      while (ptr && *ptr)
      {
        TV_INSERTSTRUCT item;
        char *eol = strchr(ptr, '\n');
        if (eol)
          *eol = 0;
        memset(&item, 0, sizeof(item));
        item.hParent = 0;
        item.hInsertAfter = TVI_LAST;
        item.item.mask = TVIF_TEXT;
        item.item.pszText = ptr;
        item.item.cchTextMax = strlen(text);
        hItem = (HTREEITEM) SendMessage(messages, TVM_INSERTITEM, 0, (LPARAM) &item);
        ptr = (eol) ? eol+1 : 0;
      }
      free(dup);
      if (hItem)
      {
        SendMessage(messages, TVM_ENSUREVISIBLE, 0, (LPARAM) hItem);
        InvalidateRect(messages, 0, TRUE);
      }
    }
  }
}

void statDlgUpdateTotalProgress(UINT32 amt, UINT32 complete)
{
  if (complete > amt)
    complete = amt;
  PostMessage(totalProgress, KYPM_SETPOS, (WPARAM) (100.0 * complete / amt), 0);
}

void statDlgUpdateFileProgress(UINT32 amt, UINT32 complete)
{
  if (complete > amt)
    complete = amt;
  PostMessage(fileProgress, KYPM_SETPOS, (WPARAM) (100.0 * complete / amt), 0);
  {
    time_t x   = elapsed(); // how long have i been going?
    DWORD  bps = BPS();     // and what's my BPS?
    DWORD  kBPS = bps / 1024;
    char text[16];
    DWORD bytesTotal = source->stAdd.tSz 
                      +source->stCopy.tSz
                      +dest->stAdd.tSz
                      +dest->stCopy.tSz;
    DWORD bytesComplete = source->stAdd.cSz
                         +source->stCopy.cSz
                         +dest->stAdd.cSz
                         +dest->stCopy.cSz-amt+complete;

    if (kBPS)
      bps = kBPS * 1024;

    sprintf(text, "%2d:%02d:%02d",
      (int) (x / 3600),
      (int) ((x / 60) % 60),
      (int) (x % 60));        
    SetWindowText(timeElapsed, text);

    SetWindowText(BPSWnd, fixNumber(text, bps));

    if (bps)
    {
      x = (bytesTotal - bytesComplete) / bps;
      sprintf(text, "%2d:%02d:%02d",
        (int) (x / 3600),
        (int) ((x / 60) % 60),
        (int) (x % 60));
    } else
      strcpy(text, "???");
    SetWindowText(timeRemaining, text);
  }
}

void statDlgDestroy(void)
{
  waitingWindow = TRUE;
  EnableWindow(GetDlgItem(statDlgWnd, IDOK), TRUE);
  SetWindowText(GetDlgItem(statDlgWnd, IDOK), "OK");
  WaitForMultipleObjects(1, &fnComplete, FALSE, INFINITE);
  CloseHandle(fnComplete);
}

void statDlgPlaceSubDlg(HWND hWnd)
{
  if (statDlgWnd)
  {
    RECT cr;
    WINDOWPLACEMENT wc;
    //
    // reset [hWnd]'s parent to [statDlgWnd]
    //
    long style = GetWindowLong(hWnd, GWL_STYLE);
    style = (style & ~WS_POPUP) | WS_CHILD;
    SetWindowLong(hWnd, GWL_STYLE, style);
    SetParent(hWnd, statDlgWnd);
    //
    // get my normal size
    //
    memset(&wc, 0, sizeof(wc));
    wc.length = sizeof(wc);
    GetWindowPlacement(statDlgWnd, &wc);
    //
    // get [hWnd] size
    //
    GetWindowRect(hWnd, &cr);
    SetWindowPos(
      hWnd,
      HWND_TOP,
      (wc.rcNormalPosition.right - cr.right + cr.left)/2,
      (wc.rcNormalPosition.bottom - cr.bottom + cr.top)/2,
      0,
      0,
      SWP_NOSIZE 
    );
  }
}
