/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
    USA
*/

/*
    refsmenu.c
    main routine of REFERENCES
*/

#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include <string.h>
#include <conio.h>
#if defined(__EMX__) && !defined(MIT_ANSI_SYS)
  #include <sys/video.h>
#endif
#if defined(__EMX__)
  #include <sys/types.h>
  #include <dirent.h>
#endif
#if defined(__EMX__)
  #include <fnmatch.h>
#endif
#if defined(__DJGPP__)
  #include <unistd.h>
  #include <dos.h>
#endif
/* Nur fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
  #include <pc.h>
#endif

#include "abbruch.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "l_menu.h"
#include "cfg_fun.h"
#include "refs.h"
#include "abstr.h"
#include "fd.h"
#include "rglobal.h"
#include "vtxt.h"
#include "keycodes.h"

#define HAUPTMENU "EditView$Enter data, edit, view complete d'base/subset, edit abstracts, view text files\
@ListR$Compile a list of references: standard/user defined formats, macros, abstracts\
@BatchT$Enter, edit, process batch tables {B|T}BT defining subsets of database records\
@SearchR$Search database records by keywords, editor's/author's names, year, title etc.\
@RefFormatD$Edit, create, delete or sort format definitions for lists of references/macros\
@Transfer$Export/import data into/from REFERENCES version 3.5 archives, files conversion\
@FileSystem$File functions: delete, transfer, edit files, database functions, DOS commands\
@Help$Help for REFERENCES: user interface, document types, file types, documentation\
@Quit$Finish REFERENCES (DOS) version 3.5, exit to the operation system command line"

 char meldung_kommandozeile[] = "\nVariables in configuration file REFS.CFG:\n\n"
"COLORS=COLOR_CODE [default: 0, range: 0..11]\n"
"EDITOR=EDITOR_FILE [default: `EDIT']\n"
#if defined(MIT_ANSI_SYS) || defined(__DJGPP__)
"LINES_OF_SCREEN=LINES [default: 25, range: 25, 43, 50]\n"
#endif
"INSERT_MODE=INS/OVR_CODE [default: 1, range: 0..1]\n"
"DELAY_LIST_WRITE=TIME_IN_MILLISECONDS [default: 0, range: 0..30000]\n"
"DELAY_STRUCT_WRITE=TIME_IN_MILLISECONDS [default: 0, range: 0..30000]\n"
"CALL_EDITOR_COMMAND_FILE=FILENAME.BAT [default: `TF.BAT']\n"
"HELP_FILES=PATH_TO_HELPFILES [default: `\\REFS35\\DOC']\n"
"COPY_COMMAND=CMD [default: `COPY /B']\n"
"\n"
"Option:\n"
"  -h  help screen\n"
"  -i  information about actual configuration parameters\n"
"  -r  override warning about incorrect file size(s): repair or delete index\n"
"      and database files\n"
#if defined(__EMX__)
"\nCompiled using GCC 2.7.2.1 (EMX 09c) "
#endif
#if defined(__DJGPP__)
"\nCompiled using GCC 2.8.1 (DJGPP 2.02) "
#endif
#if defined(MIT_ANSI_SYS)
"[ANSI.SYS] "
#endif
"on";

/* Fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
 unsigned * bildschirmpuffer;
 int bildschirmcursor_x, bildschirmcursor_y;
#endif

#define ABST_TXT "ABSTRACT._T_"

#define FERR "\n\nREFERENCES 3.5: Database file(s) or at least one BBT-file damaged!\n\n\
[Please press any key]>"



 int f1_fun_main(void);
 int re_edit_main(void);
 int re_brow_main(char * dpf, char * modus_cb);
 int search_main(char * datpath, char * exepfad);
 int btch_fun_main(char * datpath,char * exepfad);
 int list_rfd_main(char * mmodus, char * datpath);
 int list_fun_main(char * datpath);
 int expo_fun_main(char * datpath);
 int transf_main(char * datpath);
 int stru_fun_main(char * datpath);
 int f_ver_main(char * datpath);
 int rfd_fun_main(char * datenpfad);
 int abst_fun_main(char * amodus, char * datpath);
 int file_mg_main(char * datpath);
 int drec_fun_main(char * datpath);
 int fil_fun_main(char * datpath);
 int xtrrm_main(char * datenpfad);
 int srtf_main(char * datpath);
 int list_abs_main(char * datpath);
 int list_kj_main(char * datpath);
 int refs2tex_main(void);
 int txt2tex_main(void);
 int medl_arr_main(void);

 config_set one_config_set;

#if defined(MIT_ANSI_SYS)
 ansi_farben_set one_ansi_farben_set;
#elif defined(__DJGPP__)
 ansi_farben_set one_ansi_farben_set;
#elif defined(__EMX__)
 ansi_farben_set one_ansi_farben_set;
#endif


 void refs_hauptmenu(void);
 void cls(void);
 int edit_befehl_schreiben(char * dateiname);
 int splash_screen(void);
 int datenbank_untersuchen(void);
 int ok_datei_groesse(const char * d_name, int ds_groesse);

 char exepfad[PFAD_LEN];
 char datenpfad[PFAD_LEN];
 char TITELZEILE_MAIN_MENU[100];
 char editorpfad[PFAD_LEN];
 char dbase_name [PFAD_LEN];
 char kommandopfad[PFAD_LEN];
 char text_name[PFAD_LEN];


int main(int argc, char * argv[])
{
/* Fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
   if ((bildschirmpuffer = (unsigned *) malloc ((ScreenRows()*ScreenCols()*2+1) * sizeof(unsigned)))==NULL)
   {
      wrtxt("ERROR: unable to allocate screen buffer"); 
      return 1;
   }
   bildschirmcursor_x = wherex();
   bildschirmcursor_y = wherey();
   ScreenRetrieve(bildschirmpuffer);
#endif   

#if defined(__EMX__) && !defined(MIT_ANSI_SYS)
    int breite, hoehe;
    v_init();
#endif
   programmpfad(argv[0],exepfad);
   signal(SIGINT,SIG_IGN);

   one_config_set = config_auswerten(argv[0]);

   if (argc>1)
   {
      if (!strcmp(argv[1],"-?")||!strcmp(argv[1],"/?") ||
          !stricmp(argv[1],"-h")||!strcmp(argv[1],"/h"))
      {
          printf("\nUsage: %s [-Option]\n",argv[0]);
          printf("%s %s, %s\n",meldung_kommandozeile,__DATE__,__TIME__);
/* Fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
          free(bildschirmpuffer);
#endif
          return 0;
      }
      if (!strcmp(argv[1],"-i")||!strcmp(argv[1],"/i"))
      {
          printf("\nREFERENCES 3.5 -- Actual configuration parameters:\n\n");
          printf("COLORS=%i\n",one_config_set.colors);
          printf("EDITOR=%s\n",one_config_set.text_editor);
#if defined(MIT_ANSI_SYS) || defined(__DJGPP__)
          printf("LINES_OF_SCREEN=%i\n",one_config_set.sl);
#endif
          printf("INSERT_MODE=%i\n",one_config_set.insert_mode);
          printf("DELAY_LIST_WRITE=%i\n",one_config_set.delay_list_write);
          printf("DELAY_STRUCT_WRITE=%i\n",one_config_set.delay_struct_write);
          printf("CALL_EDITOR_COMMAND_FILE=%s\n",one_config_set.call_editor_command_file);
          printf("HELP_FILES=%s\n",one_config_set.help_path);
          printf("COPY_COMMAND=%s\n",one_config_set.copy_command);

/* Fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
          free(bildschirmpuffer);
#endif
          return 0;
      }
   }

#if defined(__EMX__) && !defined(MIT_ANSI_SYS)
   v_dimen(&breite,&hoehe);
   if (hoehe!=25 || breite !=80)
   {
      printf("\nProblem: screen size must be 25 lines, 80 columns for REFERENCES "
             "(EMX)\n");
      return 1;
   }
#endif
   if (!datenbank_untersuchen())
   {
      wrtxt(FERR);
      tastelesen();
      wrtxt("\n");
      if (argc > 1)
      {
        if (strcmp(argv[1],"-r")!=0)
        {
/* Fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
          free(bildschirmpuffer);
#endif
          return 1;
        }
        else
        {
           sc_clreol();
           wrtxt("\nPlease repair/rebuild database immediately!");
        }
      } else 
      { 
/* Fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
          free(bildschirmpuffer);
#endif
           return 1;
      }
   }
   else
   {
      wrtxt(" (Ok)");
   }

   farben_setzen(one_config_set.colors);
   strcpy(editorpfad,one_config_set.text_editor);

   splash_screen();
   refs_hauptmenu();
/* Fuer Speicherung des Bildschirms in `bildschirmpuffer' */
#if defined(__DJGPP__) && !defined(MIT_ANSI_SYS)
   ScreenUpdate(bildschirmpuffer);
   gotoxy(bildschirmcursor_x,bildschirmcursor_y);
   free(bildschirmpuffer);
#endif
   return 0;
}

void refs_hauptmenu(void)
{

    char cmd[400];
    int taste;

    getcwd(datenpfad,127);
#if defined(__EMX__)
    slash_to_backslash(datenpfad);
#endif
#if defined(__DJGPP__)
    slash_to_backslash(datenpfad);
#endif
    rtrim(datenpfad,'\\');
    strcat(datenpfad,"\\");
    do
    {
       int infopos_y;
       int infopos_x;
       static int menupos;
       int anz_pfadelemente;
       strcpy(cmd,"");
       strcat(cmd,datenpfad);
       rtrim(cmd,'\\');
       chdir(cmd);

       strcpy(cmd,"");


       sc_gotoxy(1,one_config_set.sl-1);
       anz_pfadelemente = countitem(datenpfad,"\\");
       extractitem(anz_pfadelemente,datenpfad,"\\",dbase_name);
       sprintf(TITELZEILE_MAIN_MENU,""
                 "  MAIN MENU");

       cls_line(TITELZEILE_MAIN_MENU);

       infopos_y=10;
       infopos_x=79;
       strcpy(wrtxtbu,"REFERENCES");
       sc_gotoxy(infopos_x-strlen(wrtxtbu),infopos_y);
       wrtxt(wrtxtbu);

       strcpy(wrtxtbu,"BIBLIOGRAPHIC SOFTWARE");
       sc_gotoxy(infopos_x-strlen(wrtxtbu),infopos_y+1);
       wrtxt(wrtxtbu);

       strcpy(wrtxtbu,"VERSION 3.5");
       sc_gotoxy(infopos_x-strlen(wrtxtbu),infopos_y+2);
       wrtxt(wrtxtbu);

       strcpy(wrtxtbu,"CURRENT DATABASE");
       sc_gotoxy(infopos_x-strlen(wrtxtbu),infopos_y+4);
       wrtxt(wrtxtbu);
       sprintf(wrtxtbu,"\"%s\"",dbase_name);
       upper(wrtxtbu);
       sc_gotoxy(infopos_x-strlen(wrtxtbu),infopos_y+5);
       wrtxt(wrtxtbu);

       sc_gotoxy(1,one_config_set.sl-1);

       taste = lotus_menu_default(&menupos, HAUPTMENU);


       if (taste==1)
       {
           static int menupos;
           int edtaste;
           int abstaste;

              cls_line("REFERENCES VERSION 3.5 * ENTER-EDIT-BROWSE");
              edtaste = lotus_menu_default(&menupos,
              "@EnterEdit$Enter or edit references, keywords"
              "@Abstracts$Enter or edit abstract of the current reference"
              "@CompleteBrowse$View references of the complete database"
              "@BatchTableBrowse$View the references referred to in a batch table"
              "@ViewText$View a text file"
              );

              if (edtaste==1)
              {
                 re_edit_main();
                 continue;
              }

              else if (edtaste==2)
              {
                 static int menupos;
                 cls_line("REFERENCES VERSION 3.5 * ABSTRACT-TEXT");
                 abstaste = lotus_menu_default(&menupos,
                                      "@DatabaseToText$Transfer abstract text from database into text file, make new abstract"
                                      "@EditText$Edit abstract text file, after editing, select 'TextToDatabase'"
                                      "@TextToDatabase$Transfer abstract text file into database"
                                      "@RemoveAbsText$Delete last abstract text file (recommended after transfer to database)"
                                      "@View$Show the contents of the abstract text file"
                                      "@Help$Short information about editing abstracts");
                 if (abstaste==1)
                 {
                    abst_fun_main("-1",datenpfad);
                    continue;
                 }
                 else if (abstaste == 2)
                 {

                    edit_befehl_schreiben(ABST_TXT);
                    continue;

                 }
                 else if (abstaste==3)
                 {
                    abst_fun_main("-2",datenpfad);
                    continue;
                 }
                 else if (abstaste==4)
                 {
                    if (isfile (ABST_TXT))
                    {
                         remove(ABST_TXT);
                         wrtxt("\n[Abstract text file deleted]>");
                        tastelesen();
                        continue;
                    }
                    else
                    {
                         wrtxt("\n[Abstract text file not found]>");
                         tastelesen();
                         continue;
                    }
                    continue;
                 }
                 else if (abstaste==5)
                 {
                    if (isfile (ABST_TXT))
                    {
                       vtxt_main(ABST_TXT);
                    }
                    else
                    {
                         wrtxt("\n[Abstract text file not found]>");
                         tastelesen();
                         continue;
                    }

                 }
                 else if (abstaste==6)
                 {
                  sc_gotoxy(1,one_config_set.sl-19);
                  wrtxt("   For creating or editing an abstract text please select the commands:\n");
                  wrtxt("   \n");
                  wrtxt("      (1) 'DatabaseToText'  Transfers a text from the database into text \n");
                  wrtxt("                            file `ABSTRACT._T_'.\n");
                  wrtxt("   \n");
                  wrtxt("      (2) 'EditText'        Writes the DOS batch file to call the text \n");
                  wrtxt("                            editor: please call this command from the DOS \n");
                  wrtxt("                            prompt to edit `ABSTRACT._T_'.\n");
                  wrtxt("   \n");
                  wrtxt("      (3) 'TextToDatabase'  Writes the text file edited in step (2) back\n");
                  wrtxt("                            to the database.\n");
                  wrtxt("   \n");
                  wrtxt("   Normally, you should not change the current reference number while\n");
                  wrtxt("   performing these three commands. Otherwise an abstract text file will\n");
                  wrtxt("   be assigned to another record. You may change the record number\n");
                  wrtxt("   explicitly to copy a text to another record. In this case be sure that\n");
                  wrtxt("   you understood this `edit abstract files' mechanism.");
                  sc_gotoxy(1,one_config_set.sl);
                  wrtxt("[Please press any key]>");
                  tastelesen();
                  continue;
                 }
                 else
                 {
                    continue;
                 }

                 continue;
              }
              else if (edtaste==3)
              {
                 re_brow_main(datenpfad,"-c");
                 continue;
              }
              else if (edtaste==4)
              {
                 re_brow_main(datenpfad,"-b");
                 continue;
              }
              else if (edtaste==5)
              {
               static int menupos;
               int tastelokal;
               tastelokal = lotus_menu_default(&menupos,
                      "@Text$View text file with extension TXT (ASCII-file)"
                      "@Batch$View text batch table with extension TBT (ASCII-file)"
                      "@ASCII$View text file with extension ASC (ASCII-file)"
                      "@LogFile$View log file (ASCII-file)"
                      "@Doc$View text file with extension DOC (ASCII-file)"
                      "@(La)TeX$View TeX or LaTeX file with extension TEX (ASCII-file)"
                      "@Script$View script file with extension SCF (ASCII-file)"
                      "@RArchive$View REFERENCES archive file with extension ARR "
                                 "(ASCII file)"
                                         );

                if (tastelokal==1)
                   {
                     static int dpos_txt;
                     if (!datei_suchen_default("*.TXT",text_name,&dpos_txt))
                     {
                         wrtxt("\n[Please press any key]>");
                         tastelesen();
                         continue;
                     }
                   }
                else if (tastelokal==2)
                   {
                      static int dpos_tbt;
                      if (!datei_suchen_default("*.TBT",text_name,&dpos_tbt))
                      {
                         wrtxt("\n[Please press any key]>");
                         tastelesen();
                         continue;
                      }
                   }
                else if (tastelokal==3)
                {
                   static int dpos_asc;
                   if (!datei_suchen_default("*.ASC",text_name,&dpos_asc))
                   {
                            wrtxt("\n[Please press any key]>");
                            tastelesen();
                            continue;
                   }
                }
                else if (tastelokal==4)
                {
                    static int dpos_log;
                    if (!datei_suchen_default("*.LOG",text_name,&dpos_log))
                    {
                             wrtxt("\n[Press any key]>");
                             tastelesen();
                             continue;
                    }
                }

                else if (tastelokal==5)
                {
                    static int dpos_doc;
                    if (!datei_suchen_default("*.DOC",text_name,&dpos_doc))
                    {
                             wrtxt("\n[Please press any key]>");
                             tastelesen();
                             continue;
                    }
                }
                else if (tastelokal==6)
                {
                    static int dpos_tex;
                    if (!datei_suchen_default("*.TEX",text_name,&dpos_tex))
                    {
                             wrtxt("\n[Please press any key]>");
                             tastelesen();
                             continue;
                    }
                }
                else if (tastelokal==7)
                {
                    static int dpos_tex;
                    if (!datei_suchen_default("*.SCF",text_name,&dpos_tex))
                    {
                             wrtxt("\n[Please press any key]>");
                             tastelesen();
                             continue;
                    }
                }
                else if (tastelokal==8)
                {
                    static int dpos_arr;
                    if (!datei_suchen_default("*.ARR",text_name,&dpos_arr))
                    {
                             wrtxt("\n[Please press any key]>");
                             tastelesen();
                             continue;
                    }
                }
                else continue;
                vtxt_main(text_name);
                continue;

              }
       }

       else if (taste==2)
       {
            int taste;
            static int menupos;

            cls_line("REFERENCES VERSION 3.5 * LIST OF REFERENCES");

            taste =lotus_menu_default(&menupos,
            "@StandardFormat$Compile a list of references in standard format with high speed"
            "@UserDefined$Compile a list of references in a FORMAT DEFINITION programmed by the user"
            "@JournalKeyword$Write complete lists of keywords and journal names into text files"
            "@Abstracts$Write abstract texts into text file"
            "@Macro$Generate macro for manipulation of manuscripts"
                              );
            if (taste==1)
            {
               list_fun_main(datenpfad);
            }
            else if (taste==2)
            {
               list_rfd_main("",datenpfad);
               continue;
            }
            else if (taste==3)
            {
               list_kj_main(datenpfad);
               continue;
            }
            else if (taste==4)
            {

               list_abs_main(datenpfad);
               continue;
            }
            else if (taste==5)
            {
               list_rfd_main("-m",datenpfad);
               continue;
            }

       }
       else if (taste==3)
       {

               btch_fun_main(datenpfad,exepfad);
               continue;
       }

       else if (taste==4)
       {
               search_main(datenpfad,exepfad);
               continue;
       }

       else if (taste==5)
       {
               rfd_fun_main(datenpfad);
               continue;
       }
       else if (taste==6)
       {
            static int menupos;
            cls_line("REFERENCES VERSION 3.5 * TRANSFER DATA - CONVERT TEXT FILES");
            taste = lotus_menu_default(&menupos,
              "Import$Import data from a REFERENCES V. 3.5 archive (NAME.ARR) into current database@"
              "Export$Write database records into a REFERENCES version 3.5 archive (NAME.ARR)@"
              "LaTeX$Convert REFERENCES TXT file (<refno>...) "
                       "into LaTeX 'thebibliography' file@"
              "TextLaTeX$Convert an ASCII text file into TeX/LaTeX format (extension TEX)@"
              "XtractRefNo$Extract reference numbers of a manuscript text file into a BBT-file@"
              "SrchR$Perform complex 'search' and 'replace' operations in a text file@"
              "Medline$Convert MEDLINE NLM record into a REFERENCES archive file, e. g. MEDL000.ARR"
                              );
              if (taste==1)
              {
                  transf_main(datenpfad);
                  continue;
              }
              if (taste==2)
              {
                  expo_fun_main(datenpfad);
                  continue;
              }
              if (taste==3)
              {

                  refs2tex_main();
                  continue;
              }
              if (taste==4)
              {
                  txt2tex_main();
                  continue;
              }
              if (taste==5)
              {

                  xtrrm_main(datenpfad);
                  continue;
              }
              if (taste==6)
              {

                 srtf_main(datenpfad);
                 continue;
              }
              if (taste==7)
              {

                 medl_arr_main();
                 continue;
              }

       }

       else if (taste==7)
       {
            static int menupos;
            cls_line("REFERENCES VERSION 3.5 * FILE AND DATABASE FUNCTIONS");
            taste = lotus_menu_default
            (&menupos,
              "@DeleteRen$Delete, rename single references in the current database"
              "@BatchDelete$Delete all references in the current database referred to in a BBT-file"
              "@RebuildDbase$Restructure Database, rebuild index files"
              "@EditText$Edit text-files with different extensions: txt, asc, tbt etc"
              "@FileManager$Copy, move, delete files"
              "@Verify$Program for checking database integrity"
              "@OS-Shell$Execute a DOS-command, press [Enter] for the DOS-prompt, return with exit"
            );
            if (taste==1)
            {
               fil_fun_main(datenpfad);
               continue;
            }
            else if (taste==2)
            {

               drec_fun_main(datenpfad);
               continue;
            }

            else if (taste==3)
            {
               stru_fun_main(datenpfad);
               continue;
            }
            else if (taste==4)
            {
               static int menupos;
               taste = lotus_menu_default(&menupos,
                      "@Text$Edit text file with extension TXT (ASCII-file)"
                      "@Batch$Edit text batch table with extension TBT (ASCII-file)"
                      "@ASCII$Edit text file with extension ASC (ASCII-file)"
                      "@LogFile$View/Edit log file (ASCII-file)"
                      "@Doc$Edit text file with extension DOC (ASCII-file)"
                      "@(La)TeX$Edit TeX or LaTeX file with extension TEX (ASCII-file)"
                      "@Script$Edit script file with extension SCF (ASCII-file)"
                                         );

                if (taste==1)
                   {
                     static int dpos_txt;
                     if (!datei_suchen_default("*.TXT",text_name,&dpos_txt))
                     {
                         wrtxt("\n[Please press any key]>");
                         tastelesen();
                         continue;
                     }
                   }
                else if (taste==2)
                   {
                     static int dpos_tbt;
                     if (!datei_suchen_default("*.TBT",text_name,&dpos_tbt))
                     {
                        wrtxt("\n[Please press any key]>");
                        tastelesen();
                        continue;
                     }
                   }
                else if (taste==3)
                {
                     static int dpos_asc;
                     if (!datei_suchen_default("*.ASC",text_name,&dpos_asc))
                     {
                              wrtxt("\n[Please press any key]>");
                              tastelesen();
                              continue;
                     }
                }
                else if (taste==4)
                {
                     static int dpos_log;
                     if (!datei_suchen_default("*.LOG",text_name,&dpos_log))
                     {
                              wrtxt("\n[Press any key]>");
                              tastelesen();
                              continue;
                     }
                }

                else if (taste==5)
                {
                     static int dpos_log;
                     if (!datei_suchen_default("*.DOC",text_name,&dpos_log))
                     {
                              wrtxt("\n[Please press any key]>");
                              tastelesen();
                              continue;
                     }
                }
                else if (taste==6)
                {
                     static int dpos_tex;
                     if (!datei_suchen_default("*.TEX",text_name,&dpos_tex))
                     {
                              wrtxt("\n[Please press any key]>");
                              tastelesen();
                              continue;
                     }
                }
                else if (taste==7)
                {
                     static int dpos_tex;
                     if (!datei_suchen_default("*.SCF",text_name,&dpos_tex))
                     {
                              wrtxt("\n[Please press any key]>");
                              tastelesen();
                              continue;
                     }
                }
                else continue;

                edit_befehl_schreiben(text_name);
                continue;
            }
            else if (taste==5)
            {

               file_mg_main(datenpfad);
               continue;
            }
            else if (taste==6)
            {
               f_ver_main(datenpfad);
               continue;
            }

            else if (taste==7)
            {
               static char os_cmd[PFAD_LEN+1];
               int osctaste;
               int kommandointerpreter;
               char * ev;
               kommandointerpreter=0;
               do
               {
                 info_zeile("Enter DOS-command(s), empty field for DOS shell, [Esc] Quit");
                 strcpy(wrtxtbu,"Command............");
                 wrtxt(wrtxtbu);
                 osctaste = e_zle(
                             1+strlen(wrtxtbu),
                             one_config_set.sl-1,
                             os_cmd,
                             80-strlen(wrtxtbu)-3,
                             PFAD_LEN - (strlen(exepfad)+strlen("# halten")),
                             0
                          );
                 sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
               } while (osctaste!=ENTER_KEY && osctaste!=ESC_KEY);
               if (osctaste==ESC_KEY) { cls_line(""); continue; }

               if (strlen(os_cmd)==0)
               {
                  ev=getenv("COMSPEC");
                  if (ev!=NULL)
                  {
                     strcpy(os_cmd,ev);
                     kommandointerpreter=1;
                  }
               }
               putenv("PROMPT=REFERENCES..$p$g");
               cls_line("");

               if (kommandointerpreter)
               {
                 printf("Please type EXIT [ENTER] to return to REFERENCES...\n");
                 fflush(stdout);
               }
               system(os_cmd);
               if (!kommandointerpreter)
               {
                  // sc_gotoxy(1,one_config_set.sl);
                  wrtxt("\nReturn to REFERENCES, please press any key>");
                  // sc_clreol();
                  tastelesen();
               }
               else
               {
                  strcpy(os_cmd,"");
               }
               continue;

            }
       }
       else if (taste==8)
       {
           f1_fun_main();
           continue;
       }
       else if (taste==9)
       {
#if defined(MIT_ANSI_SYS)
          wrtxt("\033[0;37;40m");
#elif defined(__EMX__)
          v_attrib(F_WHITE|B_BLACK);
#elif defined(__DJGPP__)
          textcolor(LIGHTGRAY);
          textbackground(BLACK);
#endif
          sc_clrscr();
          // sc_gotoxy(1,one_config_set.sl);
          break;
       }
    } while(1);
}

void cls(void)
{
   sc_clrscr();
   sc_gotoxy(1,one_config_set.sl-1);
}

int edit_befehl_schreiben(char * dateiname)
{
   FILE * fpcmd;
   /*
     name of text file in database directory
   */
   char tdname[PFAD_LEN];
   strcpy(tdname,datenpfad);
   strcat(tdname,dateiname);

   strcpy(kommandopfad,one_config_set.call_editor_command_file);
   upper(one_config_set.call_editor_command_file);
   if ((fpcmd=fopen(kommandopfad,"wt"))==NULL)
   {
      sprintf(wrtxtbu,"\n[ERROR: Unable to create %s batch file]>",kommandopfad);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }
   fprintf(fpcmd,"%s %s",editorpfad,tdname);
   fflush(fpcmd);
   fclose(fpcmd);
   sprintf(wrtxtbu,"\nPlease call '%s' to edit %s\n\n",
            one_config_set.call_editor_command_file,tdname);
   wrtxt(wrtxtbu);
   wrtxt("[Please press any key]>");
   tastelesen();
   return 1;
}

int splash_screen(void)
{
   int x,y;


   x=20;y=10;

   sc_gotoxy(x,y);

   wrtxt(" ͻ ");y++; sc_gotoxy(x,y);
   wrtxt("                                      ");y++; sc_gotoxy(x,y);
   wrtxt("        REFERENCES Version 3.5        ");y++; sc_gotoxy(x,y);
   wrtxt("        BIBLIOGRAPHIC SOFTWARE        ");y++; sc_gotoxy(x,y);
   wrtxt("                                      ");y++; sc_gotoxy(x,y);
   wrtxt(" ͼ ");
   sc_gotoxy(x+9,y-3);
   // sc_gotoxy(x+1,y);
   tastelesen();

   return 0;

}

int datenbank_untersuchen(void)
{
/* Namen fuer file check */
   char bbt_pfad[PFAD_LEN+1];


#if defined(__EMX__)
     DIR * dirp;
     struct dirent * direntp;
#endif
#if defined(__DJGPP__)
   struct find_t fi;
#endif


#define FC_JOURNAL_DAT   "JOURNAL.DAT"
#define FC_JOURNAL_IX    "JOURNAL.IX"
#define FC_DESC_DAT      "DESC.DAT"
#define FC_BOOK_DAT      "BOOK.DAT"
#define FC_AUTORJL_DAT   "AUTORJL.DAT"
#define FC_AUTORBO_DAT   "AUTORBO.DAT"
#define FC_SOURCE_DAT    "SOURCE.DAT"
#define FC_SOURCE_IX     "SOURCE.IX"
#define FC_KEYW_DAT      "KEYW.DAT"
#define FC_KEYW_IX       "KEYW.IX"
#define FC_ABST_DAT      "ABST.DAT"
#define FC_ABST_IX       "ABST.IX"
#define FC_FORMDEF_DAT   "FORMDEF.DAT"

   int rgwert;

   rgwert = 1;
   wrtxt("\nVerifying size of database files:");

   if (ok_datei_groesse(FC_JOURNAL_DAT,sizeof(journal_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_JOURNAL_IX,sizeof(refspix_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_DESC_DAT,sizeof(desc_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_BOOK_DAT,sizeof(buch_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_AUTORJL_DAT,sizeof(author_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_AUTORBO_DAT,sizeof(author_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_SOURCE_DAT,sizeof(quell_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_SOURCE_IX,sizeof(quellpix_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_KEYW_DAT,sizeof(keylist_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_KEYW_IX,sizeof(keylistpix_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_ABST_DAT,sizeof(abstr_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_ABST_IX,sizeof(abstrpix_rec))==0) rgwert=0;
   if (ok_datei_groesse(FC_FORMDEF_DAT,sizeof(formdef_rec))==0) rgwert=0;



#if defined(__EMX__)
  dirp = opendir(datenpfad);
  if (dirp!=NULL)
  {
     for(;;)
     {
          direntp = readdir(dirp);
          if (direntp==NULL) break;
          if ((direntp->d_attr & (A_HIDDEN|A_SYSTEM|A_LABEL|A_DIR))==0
                  && fnmatch("*.bbt",direntp->d_name,_FNM_IGNORECASE|_FNM_DOS)==0)
          {
               strcpy(bbt_pfad,direntp->d_name);
               if (ok_datei_groesse(bbt_pfad,sizeof(bbatchtable_rec))==0)
                          rgwert=0;
           }
       }
       closedir(dirp);
     }
#endif
#if defined(__DJGPP__)
    if ( !_dos_findfirst("*.bbt",_A_NORMAL,&fi) )
    {
       do
       {
          strcpy(bbt_pfad,fi.name);
          if (ok_datei_groesse(bbt_pfad,sizeof(bbatchtable_rec))==0)
                     rgwert=0;
       } while (!_dos_findnext(&fi));
    }
#endif

   return rgwert;
}

int ok_datei_groesse(const char * d_name, int ds_groesse)
{
   int ok;
   long f_groesse;

   ok = 1;
   f_groesse = filesize((char *) d_name);
   if (f_groesse > 0)
   {
         if (f_groesse % ds_groesse != 0)
      {
         ok = 0;
      }
      else
      {
         wrtxt(".");
      }
   }
   return ok;
}
