/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
    file_mg.c
    file manager
*/

#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <signal.h>
#include <float.h>
#include "str_fun.h"
#include "fl_ut.h"
#include "l_menu.h"
#include "cfg_fun.h"
#include "keycodes.h"

#define FN_LEN 150
 static char datpath[FN_LEN+1];
 static char d_path[FN_LEN+1];
 static char d_eins[FN_LEN+1];
 static char d_zwei[FN_LEN+1];
 static char d_drei[FN_LEN+1];

 extern char wrtxtbu[WRTXTBU_LEN];
 extern config_set one_config_set;

#define FMTITEL "REFERENCES VERSION 3.5 * FILE MANAGER"
#define MASKEN_LEN 10



 int file_mg_main(char * datpath);
 static void hauptmenu_fm(void);
 static void loeschen(void);
 static void importieren(void);
 static void verschieben(void);
 static void exportieren(void);
 static void erzeugen(void);
 static void umbenennen(void);
 static void duplizieren(void);
 static int extension_change_ok(char * quell, char * ziel);
 static int textd_konkatenieren(void);

int file_mg_main(char * datpath)
{
  hauptmenu_fm();

  return 0;
}

static void hauptmenu_fm(void)
{
   int taste;
   static int menupos;
   do
   {
      cls_line(FMTITEL);
      taste = lotus_menu_default(& menupos,
         "@ExportCopy$Copy files from the current directory into another directory"
         "@ImportCopy$Copy files from another directory into the current directory"
         "@Move$Move (copy and delete) files from another into the current directory"
         "@Delete$Delete files in the current database directory"
         "@Create$Create files in current database directory (do not overwrite existing files)"
         "@Rename$Rename files in current database directory (do not overwrite existing files)"
         "@2x$Duplicate files in current database directory (do not overwrite existing files)"
         "@Append$Concatenate two text files in current database directory"
                                 );
      if      (taste==1) exportieren();
      else if (taste==2) importieren();
      else if (taste==3) verschieben();
      else if (taste==4) loeschen();
      else if (taste==5) erzeugen();
      else if (taste==6) umbenennen();
      else if (taste==7) duplizieren();
      else if (taste==8) textd_konkatenieren();

   } while (taste!=0);
}


static void loeschen(void)
{

#define L_ABFRAGE \
  wrtxt("\n"); \
  btaste=lotus_menu( \
                    "@Cancel$Do *not* delete this file" \
                    "@Delete$Confirmation: delete this file"); \
  if (btaste!=2) continue
  /* Makro Abfrage vor dem Loeschen */

    static int menupos;
    int taste, btaste;
    char dname[FN_LEN];
    do
    {
       cls_line(FMTITEL);
       taste = lotus_menu_default(
                   &menupos,
                   "@1$Delete a *.TXT file"
                   "@2$Delete a *.TBT file"
                   "@3$Delete a text file: *.DOC"
                   "@4$Delete a REFERENCES archive file: *.ARR"
                   "@5$Delete an ARJ archive file: *.ARJ"
                   "@6$Delete a format definition file: *.FD3"
                   "@7$Delete a Binary Batch Table: *.BBT"
                   "@8$Delete a PKZIP archive file: *.ZIP"
                   "@9$Delete a REFERENCES LOG-file: *.LOG"
                   "@0$Delete an ASCII-file: *.ASC"
                   "@A$Delete a TeX or LaTeX text file: *.TEX"
                   "@B$Delete a Script file: *.SCF"
                   "@C$Delete any file: *.*"
                              );
        if (taste==1)
        {
                 if (!datei_suchen("*.TXT",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }

        else if (taste==2)
        {
                 if (!datei_suchen("*.TBT",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }



        else if (taste==3)
        {
                 if (!datei_suchen("*.DOC",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }

        else if (taste==4)
        {
                 if (!datei_suchen("*.ARR",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }

        else if (taste==5)
        {
                 if (!datei_suchen("*.ARJ",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }


        else if (taste==6)
        {
                 if (!datei_suchen("*.FD3",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }


        else if (taste==7)
        {
                 if (!datei_suchen("*.BBT",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }


        else if (taste==8)
        {
                 if (!datei_suchen("*.ZIP",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }

        else if (taste==9)
        {
                 if (!datei_suchen("*.LOG",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }
        else if (taste==10)
        {
                 if (!datei_suchen("*.ASC",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }
        else if (taste==11)
        {
                 if (!datei_suchen("*.TEX",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }
        else if (taste==12)
        {
                 if (!datei_suchen("*.SCF",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 L_ABFRAGE;
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }

        else if (taste==13)
        {

                 if (!datei_suchen("*.*",dname))
                 {
                     wrtxt("\n[Please press any key]>");
                     tastelesen();
                     continue;
                 }
                 upper(dname);
                 L_ABFRAGE;
                 if (
                       !strcmp(dname,"KEYW.DAT") ||
                       !strcmp(dname,"SOURCE.DAT") ||
                       !strcmp(dname,"ABST.DAT") ||
                       !strcmp(dname,"JOURNAL.DAT") ||
                       !strcmp(dname,"DESC.DAT") ||
                       !strcmp(dname,"BOOK.DAT") ||
                       !strcmp(dname,"AUTORJL.DAT") ||
                       !strcmp(dname,"AUTORBO.DAT") ||
                       !strcmp(dname,"FORMDEF.DAT") ||
                       !strcmp(dname,"ABST.IX") ||
                       !strcmp(dname,"KEYW.IX") ||
                       !strcmp(dname,"JOURNAL.IX") ||
                       !strcmp(dname,"SOURCE.IX") ||
                       !strcmp(dname,"DIR_KAT.$$1")
                    )
                 {
                    beeps();
                    sprintf(wrtxtbu,"\n[Warning: deletion of %s not permitted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                    continue;
                 }
                 if (remove(dname)==0)
                 {
                    sprintf(wrtxtbu,"\n[%s successfully deleted]>",dname);
                    wrtxt(wrtxtbu);
                    tastelesen();
                 }
        }

     } while (taste!=0) ;

#undef L_ABFRAGE
}

static void importieren(void)
{
   int taste;
   static int menupos;
   char befehl[FN_LEN+1];

   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
       info_zeile("Path of the file to be copied into the current directory: e. g. C:\\TEST\\ ");
       strcpy(wrtxtbu,"Path...............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   d_path,
                   80 - strlen(wrtxtbu) - 3,
                   FN_LEN-50,
                   0
                );
       sc_gotoxy(1,one_config_set.sl - 1);sc_clreol();
       if (strlen(d_path)==0) return;
       if (taste==ESC_KEY) return ;
       slash_to_backslash(d_path);
       /* vorige Zeile eingefuegt 5.12.1998 */
       rtrim(d_path,'\\');
       strlimcat(d_path,"\\",FN_LEN);
       cls_line("");
       if (isdirectory(d_path)==0)
       {
           sprintf(wrtxtbu,"\n[Cannot read directory %s]>",d_path);
           wrtxt(wrtxtbu);
           tastelesen();
           cls_line("");
           taste=200;
           continue;
       }
       upper(d_path);
   }
   while (taste!=ENTER_KEY);
   if (taste==ESC_KEY) return;
   cls_line("");
   strcpy(d_eins,d_path);

   taste = lotus_menu_default(&menupos,
      "@1$Text files: *.TXT"
      "@2$Text batch files: *.TBT"
      "@3$Text files: *.DOC"
      "@4$REFERENCES Archive files: *.ARR"
      "@5$ARJ archive files: *.ARJ"
      "@6$Format definition files: *.FD3"
      "@7$Batch tables: *.BBT"
      "@8$PKZIP archive files: *.ZIP"
      "@9$REFERENCES LOG-files: *.LOG"
      "@0$ASCII text files: *.ASC"
      "@A$TeX or LaTeX text file: *.TEX"
      "@B$Script file: *.SCF"

   );
   if (taste==1) strlimcat(d_eins,"*.TXT",FN_LEN);
   else if (taste==2) strlimcat(d_eins,"*.TBT",FN_LEN);
   else if (taste==3) strlimcat(d_eins,"*.DOC",FN_LEN);
   else if (taste==4) strlimcat(d_eins,"*.ARR",FN_LEN);
   else if (taste==5) strlimcat(d_eins,"*.ARJ",FN_LEN);
   else if (taste==6) strlimcat(d_eins,"*.FD3",FN_LEN);
   else if (taste==7) strlimcat(d_eins,"*.BBT",FN_LEN);
   else if (taste==8)  strlimcat(d_eins,"*.ZIP",FN_LEN);
   else if (taste==9)  strlimcat(d_eins,"*.LOG",FN_LEN);
   else if (taste==10)  strlimcat(d_eins,"*.ASC",FN_LEN);
   else if (taste==11)  strlimcat(d_eins,"*.TEX",FN_LEN);
   else if (taste==12)  strlimcat(d_eins,"*.SCF",FN_LEN);
   else return;
   if (!datei_suchen(d_eins,d_zwei))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }
   // strcpy(befehl,"COPY ");
   strlimcpy(befehl,one_config_set.copy_command,FN_LEN);
   strlimcat(befehl," ",FN_LEN);
   if (strlimcat(befehl,d_path,FN_LEN)==0) return;
   if (strlimcat(befehl,d_zwei,FN_LEN)==0) return;
   if (strlimcat(befehl," ",FN_LEN)==0) return;

   strcpy(d_drei,datpath);
   strlimcat(d_drei,d_zwei,FN_LEN);

   if (isfile(d_drei))
   {
       // cls_line("");
       wrtxt("\n");
       taste = lotus_menu(
            "@Cancel$Do not overwrite file in current directory"
            "@Overwrite$Overwrite the file in current directory"
                         );
       if (taste < 2) return;
   }
   else wrtxt("\n");

   if (strlimcat(befehl,d_drei,FN_LEN)==0) return;

   sprintf(wrtxtbu,"Executing DOS command: %s\n",befehl);
   wrtxt(wrtxtbu);
   system(befehl);
   _fpreset();
   wrtxt("\n[Please press any key]>");
   tastelesen();

}

static void verschieben(void)
{
   int taste;
   static int menupos;
   char befehl[FN_LEN+1];
   char quelldatei[FN_LEN+1];

   sc_gotoxy(1,one_config_set.sl-1);
   strcpy(quelldatei,"");

   do
   {
       info_zeile("Path of the file to be moved into the current directory: e. g. C:\\TEST\\ ");
       strcpy(wrtxtbu,"Path...............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   d_path,
                   80 - strlen(wrtxtbu) - 3,
                   FN_LEN-50,
                   0
                );
       sc_gotoxy(1,one_config_set.sl - 1);sc_clreol();
       if (strlen(d_path)==0) return;
       if (taste==ESC_KEY) return ;
       slash_to_backslash(d_path);
       /* vorige Zeile eingefuegt 5.12.1998 */
       rtrim(d_path,'\\');
       strlimcat(d_path,"\\",FN_LEN);
       cls_line("");
       if (isdirectory(d_path)==0)
       {
           sprintf(wrtxtbu,"\n[Cannot read directory %s]>",d_path);
           wrtxt(wrtxtbu);
           tastelesen();
           cls_line("");
           taste=200;
           continue;
       }
       upper(d_path);
   }
   while (taste!=ENTER_KEY);
   if (taste==ESC_KEY) return;
   cls_line("");
   strcpy(d_eins,d_path);

   taste = lotus_menu_default(&menupos,
      "@1$Text files: *.TXT"
      "@2$Text batch files: *.TBT"
      "@3$Text files: *.DOC"
      "@4$REFERENCES Archive files: *.ARR"
      "@5$ARJ archive files: *.ARJ"
      "@6$Format definition files: *.FD3"
      "@7$Batch tables: *.BBT"
      "@8$PKZIP archive files: *.ZIP"
      "@9$REFERENCES LOG-files: *.LOG"
      "@0$ASCII text files: *.ASC"
      "@A$TeX or LaTeX text file: *.TEX"
      "@B$Script file: *.SCF"

   );
   if (taste==1) strlimcat(d_eins,"*.TXT",FN_LEN);
   else if (taste==2) strlimcat(d_eins,"*.TBT",FN_LEN);
   else if (taste==3) strlimcat(d_eins,"*.DOC",FN_LEN);
   else if (taste==4) strlimcat(d_eins,"*.ARR",FN_LEN);
   else if (taste==5) strlimcat(d_eins,"*.ARJ",FN_LEN);
   else if (taste==6) strlimcat(d_eins,"*.FD3",FN_LEN);
   else if (taste==7) strlimcat(d_eins,"*.BBT",FN_LEN);
   else if (taste==8)  strlimcat(d_eins,"*.ZIP",FN_LEN);
   else if (taste==9)  strlimcat(d_eins,"*.LOG",FN_LEN);
   else if (taste==10)  strlimcat(d_eins,"*.ASC",FN_LEN);
   else if (taste==11)  strlimcat(d_eins,"*.TEX",FN_LEN);
   else if (taste==12)  strlimcat(d_eins,"*.SCF",FN_LEN);
   else return;
   if (!datei_suchen(d_eins,d_zwei))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }
   // strcpy(befehl,"COPY ");
   strlimcpy(befehl,one_config_set.copy_command,FN_LEN);
   strlimcat(befehl," ",FN_LEN);
   if (strlimcat(befehl,d_path,FN_LEN)==0) return;
   if (strlimcat(befehl,d_zwei,FN_LEN)==0) return;
   if (strlimcat(befehl," ",FN_LEN)==0) return;

   /* Pfad der zu loeschenden Datei */
   strlimcpy(quelldatei,d_path,FN_LEN);
   strlimcat(quelldatei,d_zwei,FN_LEN);
   upper(quelldatei);

   strcpy(d_drei,datpath);
   strlimcat(d_drei,d_zwei,FN_LEN);
   upper(d_drei);


   if (isfile(d_drei))
   {
       // cls_line("");
       wrtxt("\n");
       taste = lotus_menu(
            "@Cancel$Do not overwrite file in current directory"
            "@Overwrite$Overwrite the file in current directory"
                         );
       if (taste < 2) return;
   }
   else wrtxt("\n");

   if (strlimcat(befehl,d_drei,FN_LEN)==0) return;

   sprintf(wrtxtbu,"Executing DOS command: %s\n",befehl);
   wrtxt(wrtxtbu);
   system(befehl);
   _fpreset();
   if (remove(quelldatei)==0)
   {
      sprintf(wrtxtbu,"\nFile %s deleted\n",quelldatei);
      wrtxt(wrtxtbu);
   }
   wrtxt("\n[Please press any key]>");
   tastelesen();
}


static void exportieren(void)
{
   int taste;
   static int menupos;
   char befehl[FN_LEN+1];

   sc_gotoxy(1,one_config_set.sl-1);

   do
   {
       info_zeile("Destination directory: e. g. C:\\TEST\\ ");
       strcpy(wrtxtbu,"Path...............");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   d_path,
                   80 - strlen(wrtxtbu) - 3,
                   FN_LEN-50,
                   0
                );
       sc_gotoxy(1,one_config_set.sl - 1);sc_clreol();
       if (strlen(d_path)==0) return;
       if (taste==ESC_KEY) return ;
       slash_to_backslash(d_path);
       /* vorige Zeile eingefuegt 5.12.1998 */
       rtrim(d_path,'\\');
       strlimcat(d_path,"\\",FN_LEN);
       cls_line("");
       if (isdirectory(d_path)==0)
       {
           sprintf(wrtxtbu,"\n[Cannot read destination directory %s]>",d_path);
           wrtxt(wrtxtbu);
           tastelesen();
           cls_line("");
           taste=200;
           continue;
       }
       upper(d_path);
   }
   while (taste!=ENTER_KEY);
   if (taste==ESC_KEY) return;
   cls_line("");
   //strcpy(d_eins,d_path);
   strcpy(d_eins,datpath);
   taste = lotus_menu_default(&menupos,
      "@1$Text files: *.TXT"
      "@2$Text batch files: *.TBT"
      "@3$Text files: *.DOC"
      "@4$REFERENCES Archive files: *.ARR"
      "@5$ARJ archive files: *.ARJ"
      "@6$Format definition files: *.FD3"
      "@7$Batch tables: *.BBT"
      "@8$PKZIP archive files: *.ZIP"
      "@9$REFERENCES LOG-files: *.LOG"
      "@0$ASCII text files: *.ASC"
      "@A$TeX or LaTeX text file: *.TEX"
      "@B$Script file: *.SCF"
   );
   if (taste==1) strlimcat(d_eins,"*.TXT",FN_LEN);
   else if (taste==2) strlimcat(d_eins,"*.TBT",FN_LEN);
   else if (taste==3) strlimcat(d_eins,"*.DOC",FN_LEN);
   else if (taste==4) strlimcat(d_eins,"*.ARR",FN_LEN);
   else if (taste==5) strlimcat(d_eins,"*.ARJ",FN_LEN);
   else if (taste==6) strlimcat(d_eins,"*.FD3",FN_LEN);
   else if (taste==7) strlimcat(d_eins,"*.BBT",FN_LEN);
   else if (taste==8) strlimcat(d_eins,"*.ZIP",FN_LEN);
   else if (taste==9) strlimcat(d_eins,"*.LOG",FN_LEN);
   else if (taste==10) strlimcat(d_eins,"*.ASC",FN_LEN);
   else if (taste==11) strlimcat(d_eins,"*.TEX",FN_LEN);
   else if (taste==12) strlimcat(d_eins,"*.SCF",FN_LEN);
   else return;
   if (!datei_suchen(d_eins,d_zwei))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }
   // strcpy(befehl,"COPY ");
   strlimcpy(befehl,one_config_set.copy_command,FN_LEN);
   strlimcat(befehl," ",FN_LEN);
   if (strlimcat(befehl,datpath,FN_LEN)==0) return;
   if (strlimcat(befehl,d_zwei,FN_LEN)==0) return;
   if (strlimcat(befehl," ",FN_LEN)==0) return;

   strcpy(d_drei,d_path);
   strlimcat(d_drei,d_zwei,FN_LEN);

   if (isfile(d_drei))
   {
       // 12.01.97 cls_line("");
       wrtxt("\n");
       taste = lotus_menu(
            "@Cancel$Do not overwrite file in destination directory"
            "@Overwrite$Overwrite the file in destination directory"
                         );
       if (taste < 2) return;
   }
   else wrtxt("\n");

   if (strlimcat(befehl,d_drei,FN_LEN)==0) return;

   sprintf(wrtxtbu,"Executing DOS command: %s\n",befehl);
   wrtxt(wrtxtbu);
   system(befehl);
   _fpreset();
   wrtxt("\n[Please press any key]>");
   tastelesen();
}


static void erzeugen(void)
{
  FILE * fpc;
  static int menupos;
  int taste, eingabe_ok;
  char dname[FN_LEN];
  char crmode[4];
  do
  {
    cls_line(FMTITEL);
    if (menupos==6) menupos = 1;
    taste = lotus_menu_default(
        &menupos,
        "@1$Create a *.TXT file"
        "@2$Create a *.TBT (text batch) file"
        "@3$Create a *.DOC file"
        "@4$Create a *.BBT (binary batch) file"
        "@5$Create a *.ASC file"
        "@6$Create a TeX or LaTeX text file: *.TEX"
        "@7$Create script file: *.SCF"
                              );
        if (taste==0) break;
        sc_gotoxy(1,one_config_set.sl-1);
        do
        {
          int eingabetaste;
          eingabe_ok=0;
          strcpy(dname,"");
          info_zeile("Please enter file name to be created without extension");
          strcpy(wrtxtbu,"File name..........");
          wrtxt(wrtxtbu);
          eingabetaste = e_zle(
                       1+strlen(wrtxtbu),
                       one_config_set.sl-1,
                       dname,
                       8,
                       8,
                       0
                      );
          sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
          sc_gotoxy(1,one_config_set.sl);sc_clreol();
          sc_gotoxy(1,one_config_set.sl-1);

          if (strlen(dname)==0 || eingabetaste==ESC_KEY) return;
          if (!isdosfilename(dname)) return;
          upper(dname);
          if (taste==1) strcat (dname,".TXT");
          else if (taste==2) strcat (dname,".TBT");
          else if (taste==3) strcat (dname,".DOC");
          else if (taste==4) strcat (dname,".BBT");
          else if (taste==5) strcat (dname,".ASC");
          else if (taste==6) strcat (dname,".TEX");
          else strcat (dname,".SCF");
          if (isfile(dname))
          {
             int taste;

             taste = lotus_menu(
                 "@NewName$This file already exists, prompt for a new name"
                 "@Cancel$This file already exists, leave filename entry field"
                               );
             if (taste==1) continue;
             else break;
          }

        eingabe_ok = 1;
        if (taste==4) strcpy(crmode,"wb"); else strcpy(crmode,"wt");
        if ((fpc=fopen(dname,crmode))==NULL)
        {
           beeps();
           sprintf(wrtxtbu,"[Problem: Unable to create %s]>",dname);
           wrtxt(wrtxtbu);
           tastelesen();
        }
        else
        {
           sprintf(wrtxtbu,"\n[File %s created in mode '%s', please press any key]>",
              dname,crmode);
           wrtxt(wrtxtbu);
           fclose(fpc);
           tastelesen();

        }

      } while (!eingabe_ok);

  } while (1);

}

static void umbenennen(void)
{
   char quell_name[FN_LEN+1];
   char ziel_name[FN_LEN+1];
   char muster[FN_LEN+1];
   int taste,code;
   static int menupos;

   strcpy(quell_name,"");
   strcpy(ziel_name,"");

   taste = lotus_menu_default(&menupos,
      "@1$Text files: *.TXT"
      "@2$Text batch files: *.TBT"
      "@3$Text files: *.DOC"
      "@4$REFERENCES Archive files: *.ARR"
      "@5$ARJ archive files: *.ARJ"
      "@6$Format definition files: *.FD3"
      "@7$Batch tables: *.BBT"
      "@8$PKZIP archive files: *.ZIP"
      "@9$REFERENCES LOG-files: *.LOG"
      "@0$ASCII text files: *.ASC"
      "@A$TeX or LaTeX text file: *.TEX"
      "@B$Script file: *.SCF"
   );

   strcpy(muster,"");
   if (taste==1) strlimcat(muster,"*.TXT",FN_LEN);
   else if (taste==2) strlimcat(muster,"*.TBT",FN_LEN);
   else if (taste==3) strlimcat(muster,"*.DOC",FN_LEN);
   else if (taste==4) strlimcat(muster,"*.ARR",FN_LEN);
   else if (taste==5) strlimcat(muster,"*.ARJ",FN_LEN);
   else if (taste==6) strlimcat(muster,"*.FD3",FN_LEN);
   else if (taste==7) strlimcat(muster,"*.BBT",FN_LEN);
   else if (taste==8) strlimcat(muster,"*.ZIP",FN_LEN);
   else if (taste==9) strlimcat(muster,"*.LOG",FN_LEN);
   else if (taste==10) strlimcat(muster,"*.ASC",FN_LEN);
   else if (taste==11) strlimcat(muster,"*.TEX",FN_LEN);
   else if (taste==12) strlimcat(muster,"*.SCF",FN_LEN);
   else return;
   if (!datei_suchen(muster,quell_name))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }

   wrtxt("\n\n");
   upper(quell_name);

   do
   {
       sc_gotoxy(1,one_config_set.sl-1);
       info_zeile("Please enter new file name *with* extension "
                    "(no change for binary files!)");
       strcpy(wrtxtbu,"File name..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   ziel_name,
                   12,
                   12,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste < 0) continue;
       if (taste==ESC_KEY) return ;
       if (isfile(ziel_name))
       {
           sprintf(wrtxtbu,"\n['%s' already exists, overwriting not permitted]>",ziel_name);
           wrtxt(wrtxtbu);sc_clreol();
           tastelesen();
           //cls_line("");
           taste=200;
           continue;
       }
       if (!isdosfilename2(ziel_name))
       {
           sprintf(wrtxtbu,"\n['%s' is not a valid file-name]>",ziel_name);
           wrtxt(wrtxtbu);sc_clreol();
           tastelesen();
           //cls_line("");
           taste=200;
           continue;
       }
       upper(ziel_name);
       if (!extension_change_ok(quell_name,ziel_name))
       {
           sprintf(wrtxtbu,"\n[Sorry, not permitted to change (into) file name "
                      "extension of binary file]>");
           wrtxt(wrtxtbu);sc_clreol();
           tastelesen();
           //cls_line("");
           taste=200;
           continue;
       }
   }
   while (taste!=ENTER_KEY);
   if (taste==ESC_KEY) return;
   //cls_line("");
   code=rename(quell_name,ziel_name);
   if (code==0)
   {
      wrtxt("\n[Renaming file completed]>");sc_clreol();
      tastelesen();
   }

}

static void duplizieren(void)
{
   char quell_name[FN_LEN+1];
   char ziel_name[FN_LEN+1];
   char muster[FN_LEN+1];
   int taste;
   static int menupos;
   char kommando[FN_LEN+1];

   strcpy(quell_name,"");
   strcpy(ziel_name,"");
   strcpy(kommando,"");

   taste = lotus_menu_default(&menupos,
      "@1$Text files: *.TXT"
      "@2$Text batch files: *.TBT"
      "@3$Text files: *.DOC"
      "@4$REFERENCES Archive files: *.ARR"
      "@5$ARJ archive files: *.ARJ"
      "@6$Format definition files: *.FD3"
      "@7$Batch tables: *.BBT"
      "@8$PKZIP archive files: *.ZIP"
      "@9$REFERENCES LOG-files: *.LOG"
      "@0$ASCII text files: *.ASC"
      "@A$TeX or LaTeX text file: *.TEX"
      "@B$Script file: *.SCF"
   );
   strcpy(muster,"");

   if (taste==1) strlimcat(muster,"*.TXT",FN_LEN);
   else if (taste==2) strlimcat(muster,"*.TBT",FN_LEN);
   else if (taste==3) strlimcat(muster,"*.DOC",FN_LEN);
   else if (taste==4) strlimcat(muster,"*.ARR",FN_LEN);
   else if (taste==5) strlimcat(muster,"*.ARJ",FN_LEN);
   else if (taste==6) strlimcat(muster,"*.FD3",FN_LEN);
   else if (taste==7) strlimcat(muster,"*.BBT",FN_LEN);
   else if (taste==8) strlimcat(muster,"*.ZIP",FN_LEN);
   else if (taste==9) strlimcat(muster,"*.LOG",FN_LEN);
   else if (taste==10) strlimcat(muster,"*.ASC",FN_LEN);
   else if (taste==11) strlimcat(muster,"*.TEX",FN_LEN);
   else if (taste==12) strlimcat(muster,"*.SCF",FN_LEN);
   else return;
   if (!datei_suchen(muster,quell_name))
   {
      wrtxt("\n[Please press any key]>");
      tastelesen();
      return;
   }
   upper(quell_name);
   wrtxt("\n\n");

   do
   {
       sc_gotoxy(1,one_config_set.sl-1);
       info_zeile("Please enter new file name *with* extension "
                "(no change for binary files!)");
       strcpy(wrtxtbu,"File name..........");
       wrtxt(wrtxtbu);
       taste = e_zle(
                   1+strlen(wrtxtbu),
                   one_config_set.sl-1,
                   ziel_name,
                   12,
                   12,
                   0
                );
       sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
       if (taste < 0) continue;
       if (taste==ESC_KEY) return ;
       if (isfile(ziel_name))
       {
           sprintf(wrtxtbu,"\n['%s' already exists, overwriting not permitted]>",ziel_name);
           wrtxt(wrtxtbu);sc_clreol();
           tastelesen();
           //cls_line("");
           taste=200;
           continue;
       }
       if (!isdosfilename2(ziel_name))
       {
           sprintf(wrtxtbu,"\n['%s' is not a valid file-name]>",ziel_name);
           wrtxt(wrtxtbu);sc_clreol();
           tastelesen();
           //cls_line("");
           taste=200;
           continue;
       }
       upper(ziel_name);
       if (!extension_change_ok(quell_name,ziel_name))
       {
           sprintf(wrtxtbu,"\n[Sorry, not permitted to change (into) file name "
                      "extension of binary file]>");
           wrtxt(wrtxtbu);sc_clreol();
           tastelesen();
           //cls_line("");
           taste=200;
           continue;
       }
   }
   while (taste!=ENTER_KEY);
   if (taste==ESC_KEY) return;
   cls_line("");

   strlimcpy(kommando,one_config_set.copy_command,FN_LEN);
   strlimcat(kommando," ",FN_LEN);
   strlimcat(kommando,quell_name,FN_LEN);
   strlimcat(kommando," ",FN_LEN);
   strlimcat(kommando,ziel_name,FN_LEN);
   sc_clreol();

   system(kommando);
   sprintf(wrtxtbu,"\n\n[DOS command '%s' executed]>",kommando);
   wrtxt(wrtxtbu);sc_clreol();
   tastelesen();


}

static int extension_change_ok(char * quell, char * ziel)
{
   char quell_ext[FN_LEN+1];
   char ziel_ext[FN_LEN+1];
   strcpy(quell_ext,"");
   strcpy(ziel_ext,"");
   extractitem(2,quell,".",quell_ext);
   extractitem(2,ziel,".",ziel_ext);
   if (
        !stricmp(ziel_ext,"FD3") ||
        !stricmp(ziel_ext,"ARJ") ||
        !stricmp(ziel_ext,"BBT") ||
        !stricmp(ziel_ext,"ZIP") ||
        !stricmp(quell_ext,"FD3") ||
        !stricmp(quell_ext,"ARJ") ||
        !stricmp(quell_ext,"BBT") ||
        !stricmp(quell_ext,"ZIP")
        )
   {
      if (stricmp(ziel_ext,quell_ext))
      {
         return 0;
      }
   } return 1;
}

static int textd_konkatenieren(void)
{
   int zeichen;
   char quell_td_name[PFAD_LEN];
   char ziel_td_name[PFAD_LEN];

   FILE * fpzieltd;
   FILE * fpquelltd;

   int wahltaste;
   char maske[MASKEN_LEN];


   zeichen=0;
   wahltaste=0;
   strcpy(quell_td_name,"");
   strcpy(ziel_td_name,"");
   strcpy(maske,"*.txt");
   cls_line(FMTITEL);
   wrtxt("\n[Next menu: filename extension of target text file "
                "(file to be prolonged)]>");
   tastelesen();
   sc_gotoxy(1,one_config_set.sl);
   sc_clreol();
   sc_gotoxy(1,one_config_set.sl-1);
   wahltaste=lotus_menu("@Text$Target file with extension TXT"
                        "@Batch$Target file with extension TBT"
                        "@ASCII$$Target file with extension ASC"
                        "@LogFile$Target file with extension LOG"
                        "@DOC$Target file with extension DOC"
                        "@(La)TeX$Target file with extension TEX"
                        "@_T_$Target file with extension _T_"
                        );

   if (wahltaste==0)
   {
       wrtxt("\n[Function aborted: please press any key]>");
       tastelesen();
       sc_gotoxy(1,one_config_set.sl);
       sc_clreol();
       sc_gotoxy(1,one_config_set.sl-1);
       return 0;
   }
   if (wahltaste==1) { strcpy(maske,"*.txt"); }
   if (wahltaste==2) { strcpy(maske,"*.tbt"); }
   if (wahltaste==3) { strcpy(maske,"*.asc"); }
   if (wahltaste==4) { strcpy(maske,"*.log"); }
   if (wahltaste==5) { strcpy(maske,"*.doc"); }
   if (wahltaste==6) { strcpy(maske,"*.tex"); }
   if (wahltaste==7) { strcpy(maske,"*._T_"); }
   wrtxt("\n[Next file selection screen: target file name to processed]>");
   tastelesen();
   sc_gotoxy(1,one_config_set.sl);
   sc_clreol();
   if (!datei_suchen(maske,ziel_td_name))
   {
       wrtxt("\n[Function aborted: please press any key]>");
       tastelesen();
       return 0;
   }
   upper(ziel_td_name);

   cls_line(FMTITEL);
   wrtxt("\n[Next menu: filename extension of source text file "
                "(to be appended)]>");
   tastelesen();
   sc_gotoxy(1,one_config_set.sl);
   sc_clreol();
   sc_gotoxy(1,one_config_set.sl-1);
   wahltaste=lotus_menu("@Text$Source file with extension TXT"
                        "@Batch$Source file with extension TBT"
                        "@ASCII$$Source file with extension ASC"
                        "@LogFile$Source file with extension LOG"
                        "@DOC$Source file with extension DOC"
                        "@(La)TeX$Source file with extension TEX"
                        "@_T_$Source file with extension _T_"
                        );

   if (wahltaste==0)
   {
       wrtxt("\n[Function aborted: please press any key]>");
       tastelesen();
       sc_gotoxy(1,one_config_set.sl);
       sc_clreol();
       sc_gotoxy(1,one_config_set.sl-1);
       return 0;
   }
   if (wahltaste==1) { strcpy(maske,"*.txt"); }
   if (wahltaste==2) { strcpy(maske,"*.tbt"); }
   if (wahltaste==3) { strcpy(maske,"*.asc"); }
   if (wahltaste==4) { strcpy(maske,"*.log"); }
   if (wahltaste==5) { strcpy(maske,"*.doc"); }
   if (wahltaste==6) { strcpy(maske,"*.tex"); }
   if (wahltaste==7) { strcpy(maske,"*._T_"); }
   wrtxt("\n[Next file selection screen: source file name to processed]>");
   tastelesen();
   sc_gotoxy(1,one_config_set.sl);
   sc_clreol();
   if (!datei_suchen(maske,quell_td_name))
   {
       wrtxt("\n[Function aborted: please press any key]>");
       tastelesen();
       return 0;
   }
   upper(quell_td_name);
   if (!strcmp(ziel_td_name,quell_td_name))
   {
       wrtxt("\n[Problem: source and target file must not be identical]>");
       tastelesen();
       return 0;
   }
   if ((fpzieltd=fopen(ziel_td_name,"at"))==NULL)
   {
      wrtxt("\n[Problem: Cannot write into target file]>");
      tastelesen();
      return 0;
   }
   if ((fpquelltd=fopen(quell_td_name,"rt"))==NULL)
   {
      fclose(fpquelltd);
      wrtxt("\n[Problem: cannot read source file]>");
      tastelesen();
      return 0;
   }
   do
   {
      zeichen=fgetc(fpquelltd);
      if (zeichen!=EOF)
      {
        fputc(zeichen, fpzieltd);
      }
   } while (zeichen!=EOF);

   fclose(fpzieltd);
   fclose(fpquelltd);
   wrtxt("\n[Appending completed]>");
   tastelesen();
   return 1;
}

#undef FN_LEN
