/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*   fd.h    */

#ifndef FD_H
#define FD_H


#define FORMKENNUNG_LEN                         6
#define FORMATBESCHREIBUNG_LEN                 60
#define TYP_STRING_LEN                          3
#define FD_FELD_LEN                            14
#define J1_AUT_N                                8
#define J1_TIT_N                                8
#define J1_LOK_N                               20
#define B1_ED_N                                 8
#define B1_TIT_N                               10
#define B1_LOK_N                               20
#define B2_AUT_N                                8
#define B2_TIT_N                                8
#define B2_ED_N                                 8
#define B2_TITB_N                              10
#define B2_LOK_N                               40
#define AUTTYP_LEN                              1
#define ZIFFER_STRING_LEN                       3

typedef struct
{
   char formkennung[FORMKENNUNG_LEN + 1];
   char formatbeschreibung[FORMATBESCHREIBUNG_LEN +1];
   char fdj1_str1[TYP_STRING_LEN + 1];
   char fdj1_str2[TYP_STRING_LEN + 1];
   char fdj1_str3[TYP_STRING_LEN + 1];
   char fdb1_str1[TYP_STRING_LEN + 1];
   char fdb1_str2[TYP_STRING_LEN + 1];
   char fdb1_str3[TYP_STRING_LEN + 1];
   char fdb2_str1[TYP_STRING_LEN + 1];
   char fdb2_str2[TYP_STRING_LEN + 1];
   char fdb2_str3[TYP_STRING_LEN + 1];
   char fdb2_str4[TYP_STRING_LEN + 1];
   char fdb2_str5[TYP_STRING_LEN + 1];
   char j1_aut [J1_AUT_N] [FD_FELD_LEN + 1];
   char j1_tit [J1_TIT_N] [FD_FELD_LEN + 1];
   char j1_lok [J1_LOK_N] [FD_FELD_LEN + 1];
   char b1_ed  [B1_ED_N] [FD_FELD_LEN + 1];
   char b1_tit [B1_TIT_N] [FD_FELD_LEN + 1];
   char b1_lok [B1_LOK_N] [FD_FELD_LEN + 1];
   char b2_aut [B2_AUT_N] [FD_FELD_LEN + 1];
   char b2_tit [B2_TIT_N] [FD_FELD_LEN + 1];
   char b2_ed  [B2_ED_N] [FD_FELD_LEN + 1];
   char b2_titb [B2_TITB_N] [FD_FELD_LEN + 1];
   char b2_lok [B2_LOK_N] [FD_FELD_LEN + 1];

   char fdauttyp_j1 [AUTTYP_LEN+1];
   char fdauttyp_b1 [AUTTYP_LEN+1];
   char fdauttyp_b2au [AUTTYP_LEN+1];
   char fdauttyp_b2ed [AUTTYP_LEN+1];
   char fdbetwau_j1 [FD_FELD_LEN+1];
   char fdbetwau_b1 [FD_FELD_LEN+1];
   char fdbetwau_b2au [FD_FELD_LEN+1];
   char fdbetwau_b2ed [FD_FELD_LEN+1];
   char fdbetwaulast_j1 [FD_FELD_LEN+1];
   char fdbetwaulast_b1 [FD_FELD_LEN+1];
   char fdbetwaulast_b2au [FD_FELD_LEN+1];
   char fdbetwaulast_b2ed [FD_FELD_LEN+1];
   char fdv_j1 [FD_FELD_LEN+1];
   char fdv_b1 [FD_FELD_LEN+1];
   char fdv_b2au [FD_FELD_LEN+1];
   char fdv_b2ed [FD_FELD_LEN+1];
   char fdauvornach_j1 [FD_FELD_LEN+1];
   char fdauvornach_b1 [FD_FELD_LEN+1];
   char fdauvornach_b2au [FD_FELD_LEN+1];
   char fdauvornach_b2ed [FD_FELD_LEN+1];
   char fdaunachvor_j1 [FD_FELD_LEN+1];
   char fdaunachvor_b1 [FD_FELD_LEN+1];
   char fdaunachvor_b2au [FD_FELD_LEN+1];
   char fdaunachvor_b2ed [FD_FELD_LEN+1];
   char fdafterlastau_j1 [FD_FELD_LEN+1];
   char fdafterlastau_b1 [FD_FELD_LEN+1];
   char fdafterlastau_b2au [FD_FELD_LEN+1];
   char fdafterlastau_b2ed [FD_FELD_LEN+1];
   char fdweitereau_j1 [FD_FELD_LEN+1];
   char fdweitereau_b1 [FD_FELD_LEN+1];
   char fdweitereau_b2au [FD_FELD_LEN+1];
   char fdweitereau_b2ed [FD_FELD_LEN+1];
   char fdau_n_j1 [ZIFFER_STRING_LEN+1];
   char fdau_n_b1 [ZIFFER_STRING_LEN+1];
   char fdau_n_b2au [ZIFFER_STRING_LEN+1];
   char fdau_n_b2ed [ZIFFER_STRING_LEN+1];
   char fdau_m_j1 [ZIFFER_STRING_LEN+1];
   char fdau_m_b1 [ZIFFER_STRING_LEN+1];
   char fdau_m_b2au [ZIFFER_STRING_LEN+1];
   char fdau_m_b2ed [ZIFFER_STRING_LEN+1];

} formdef_rec;



#endif
