/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   drec_fun.c: deletes records in REFERENCES database, which are
   defined in a BBT-file.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include <dos.h>
#include <signal.h>
#include "ix01_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "l_menu.h"
#include "str_fun.h"
#include "sortix01.h"
#include "sortix04.h"
#include "abbruch.h"
#include "bbf_fun.h"
#include "sortbbf1.h"
#include "cfg_fun.h"



 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 extern FILE * ix01file;
 extern FILE * ix04file;

 extern config_set             one_config_set;

 extern journal_rec            one_journal_rec;
 extern desc_rec               one_desc_rec;
 extern buch_rec               one_buch_rec;
 extern refspix_rec            ix01rec;
 extern abstrpix_rec           ix04rec;
 extern abstr_rec              one_abstr_rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;

 static unsigned int           delaywrite;


 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern FILE * fpjournal;
 extern char desc_name[PFAD_LEN];
 extern FILE * fpdesc;
 extern char book_name[PFAD_LEN];
 extern FILE * fpbuch;
 extern char autorjl_name[PFAD_LEN];
 extern FILE * fpautorjl;
 extern char autorbu_name[PFAD_LEN];
 extern FILE * fpautorbu;
 static FILE * tmpix;
 static char tmpix_name[PFAD_LEN];
 static char newix_name[PFAD_LEN];

 extern char abstr_dat_name[PFAD_LEN];
 extern FILE * fpabs;
 extern char abstr_pix_name[PFAD_LEN];

 static FILE * tmpix_abs;

 static char tmpix_abs_name[PFAD_LEN];
 static char newix_abs_name[PFAD_LEN];
    /* Die Datei, aus der die zu loeschenden Datensaetze entnommen werden  */
 static FILE * fpbbt;
 static char bbt_name[PFAD_LEN];


 static char schluessel[KENNZIFFER_LEN + 2];
 static char schluessel_neu[KENNZIFFER_LEN + 2];

 /* Funktionen */
 int drec_fun_main(char * datpath);
 static int bbt_datei_vorbereiten(void);
 static int steuerung_ds_loeschen(void);
 static int db_dateien_oeffnen(void);
 static int db_dateien_schliessen(void);
 static int ds_loeschen(void);
 static int abstract_loeschen(void);


int drec_fun_main(char * datpath)
{
   strncpy(schluessel,"",KENNZIFFER_LEN);
   strncpy(schluessel_neu,"",KENNZIFFER_LEN);
   delaywrite=one_config_set.delay_struct_write;

   strcpy(journal_pix_name,datpath);strcat(journal_pix_name,"JOURNAL.IX");
   strcpy(journal_name,datpath);strcat(journal_name,"JOURNAL.DAT");
   strcpy(desc_name,datpath);strcat(desc_name,"DESC.DAT");
   strcpy(book_name,datpath);strcat(book_name,"BOOK.DAT");
   strcpy(autorjl_name,datpath);strcat(autorjl_name,"AUTORJL.DAT");
   strcpy(autorbu_name,datpath);strcat(autorbu_name,"AUTORBO.DAT");
   strcpy(tmpix_name,"TMP01.IX$");
   strcpy(newix_name,"NEW01.IX$");
   strcpy(abstr_dat_name,datpath);strcat(abstr_dat_name,"ABST.DAT");
   strcpy(abstr_pix_name,datpath);strcat(abstr_pix_name,"ABST.IX");
   strcpy(tmpix_abs_name,"TMP02.IX$");
   strcpy(newix_abs_name,"NEW02.IX$");

   cls_line( "REFERENCES VERSION 3.5 * DELETE DATABASE RECORDS DEFINED IN BBT-FILE");
   sc_gotoxy(1,one_config_set.sl - 13);
   wrtxt("        `BatchDelete'\n\n");
   wrtxt("        In the next screen, please select the BBT-file with the\n");
   wrtxt("        reference numbers to be deleted from the database.");
   sc_gotoxy(1,one_config_set.sl);
   wrtxt("[Please press any key]>");
   tastelesen();
   cls_line("");
   delaywrite = 0;
   if (bbt_datei_vorbereiten())
   {
      wrtxt("\n");
      steuerung_ds_loeschen();
      return 0;
   }
   else return 1;
}

static int bbt_datei_vorbereiten(void)
{
  int taste;

  taste = datei_suchen("*.BBT",bbt_name);

  if (taste)
  {
     int sortiert_ok;
     char kennz_alt[KENNZIFFER_LEN + 1];
     long i, anzahl_records;
     sortiert_ok = 1;

     strcpy(kennz_alt,"");

     if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
     {
          sprintf(fehlermeldung,"ERROR: cannot open %s for reading",
               bbt_name);
          beenden(fehlermeldung,2);
     }
     fseek(fpbbt,0L,SEEK_END);
     anzahl_records = ftell(fpbbt) / sizeof(one_bbt_rec) - 1;
     rewind(fpbbt);
     for (i=0;i<=anzahl_records;i++)
     {
         if (fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt)==0)
         {
             beeps();
             sprintf(wrtxtbu,"[ERROR: at least one record in %s not read]>",
                bbt_name);
             wrtxt(wrtxtbu);
             tastelesen();
         }
         if (strcmp(kennz_alt,one_bbt_rec.kennziffer)>=0)
         {
            sortiert_ok = 0;
            wrtxt("\n[It will be necessary to sort BBT-file, "
                     "please press any key]>");
            tastelesen();
            wrtxt("\n");
            break;
         }
         strcpy(kennz_alt,one_bbt_rec.kennziffer);
     }
     fclose (fpbbt);

     if (sortiert_ok)
     {
         sprintf(wrtxtbu,"\nReference numbers found sorted in %s\n",bbt_name);
         wrtxt(wrtxtbu);
         return 1;
     }
     else
     {
        if (isfile("_$.BBT")) remove("_$.BBT");
        if (isfile("_$$.BBT")) remove("_$$.BBT");
        sprintf(wrtxtbu,"\nSorting records from file %s in ascending order...\n",bbt_name);
        wrtxt(wrtxtbu);
        domergebbf1(bbt_name,"_$.BBT");
        wrtxt("\nRemoving duplicate reference numbers...\n");
        dupl_ex_bbf("_$.BBT","_$$.BBT");
        strcpy(bbt_name,"_$$.BBT");
        return 1;
     }
  }
  else
  {
     wrtxt("\n['Delete records defined in BBT file' aborted, please press any key]>");
     tastelesen();
     return 0;
  }

}


static int steuerung_ds_loeschen(void)
{
  int i_loesch;    /* Zaehler fuer zu loeschende Datensaetze */
  int abs_loesch;  /* Zaehler fuer zu loeschende Abstract-Datensaetze */
  long ix_zeiger_db, ix_zeiger_ab, anzahl_records;
  long i;
  int taste;

  taste = lotus_menu(
                   "@Cancel$Do not delete records of current database defined in BBT-file selected"
                   "@Delete$Delete records of current database defined in BBT-file selected"
                    );
  sc_gotoxy(1,one_config_set.sl-2);
  if (taste==0||taste==1)
  {
      if (isfile("_$$.bbt")) remove("_$$.bbt");
      if (isfile("_$.bbt")) remove("_$.bbt");
      return 0;
  }
  wrtxt("Deleting records, please wait...\n");
  i_loesch = 0;
  abs_loesch = 0;
  db_dateien_oeffnen();
  read_ix01(journal_pix_name);
  read_ix04(abstr_pix_name);

  if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
  {
      sprintf(fehlermeldung,"ERROR: cannot open %s", bbt_name);
      beenden(fehlermeldung,2);
  }
  fseek(fpbbt,0L,SEEK_END);

  anzahl_records = ftell(fpbbt)/sizeof(one_bbt_rec);
  anzahl_records--;
  rewind(fpbbt);

  /*
     ds_loeschen entfernen
  */

  if ((tmpix=fopen(tmpix_name,"w+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  if ((tmpix_abs=fopen(tmpix_abs_name,"w+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_abs_name);
     beenden(fehlermeldung,2);
  }


  for (i=0;i<=anzahl_records;i++)
  {
     if(fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt) < 1)
     {
        sprintf(fehlermeldung,"ERROR: cannot read %s",bbt_name);
        beenden(fehlermeldung,2);
     }
     ix_zeiger_db = locate_ix01(one_bbt_rec.kennziffer,&ix01rec);
     if (ix_zeiger_db > -1)
     {
           /* Datensaetze mit der Loeschkennung versehen */
         ds_loeschen();
           /* Index-Datensatz in temporaere Indexdatei schreiben  */
         fseek(tmpix,0L,SEEK_END);
         fwrite(&ix01rec,sizeof(ix01rec),1,tmpix);
         i_loesch++;
     }
  }
  rewind(fpbbt);
  for (i=0;i<=anzahl_records;i++)
  {
     if(fread(&one_bbt_rec,sizeof(one_bbt_rec),1,fpbbt) < 1)
     {
        sprintf(fehlermeldung,"ERROR: cannot read %s",bbt_name);
        beenden(fehlermeldung,2);
     }
     ix_zeiger_ab = locate_ix04(one_bbt_rec.kennziffer,&ix04rec);
     if (ix_zeiger_ab > -1)
     {
         /* Abstract-Datensaetze mit der Loeschkennung versehen */
         abstract_loeschen();
         /* Index-Datensatz (zu Abstract) in temporaere Indexdatei schreiben  */
         fseek(tmpix_abs,0L,SEEK_END);
         fwrite(&ix04rec,sizeof(ix04rec),1,tmpix_abs);
         abs_loesch++;
     }
  }

  fclose(fpbbt);
  fclose(tmpix);
  fclose(tmpix_abs);
  close_ix01();
  close_ix04();
  db_dateien_schliessen();
#if defined(__EMX__)
  if (delaywrite > 0) _sleep2(delaywrite);
#endif
#if defined(__DJGPP__)
  if (delaywrite > 0) delay(delaywrite);
#endif

  if (i_loesch > 0)
  {
          wrtxt("\n");
          if (i_loesch > 1)
          {
             domerge01(tmpix_name,newix_name);
             remove(tmpix_name);
             rename(newix_name,tmpix_name);
          }
          wrtxt("\nModifying main index file, please wait...\n");
#if defined(__EMX__)
          if (delaywrite > 0) _sleep2(delaywrite);
#endif
#if defined(__DJGPP__)
          if (delaywrite > 0) delay(delaywrite);
#endif
          deleteix01(journal_pix_name,tmpix_name,newix_name);
          remove(journal_pix_name); remove(tmpix_name);
          rename(newix_name,journal_pix_name);
          sprintf(wrtxtbu,"\n%i records successfully deleted\n",
             i_loesch);
          wrtxt(wrtxtbu);

  }
  else
  {
          if (isfile(tmpix_name)) remove(tmpix_name);
  }

  if (abs_loesch > 0)
  {
     if (abs_loesch > 1)
     {
        domerge04(tmpix_abs_name,newix_abs_name);
        remove(tmpix_abs_name);
        rename(newix_abs_name,tmpix_abs_name);
     }
     wrtxt("\nModifying abstract index file, please wait...\n");
     deleteix04(abstr_pix_name,tmpix_abs_name,newix_abs_name);
     remove(abstr_pix_name);
     remove(tmpix_abs_name); /* ergaenzt 25.12.1996 */
     rename(newix_abs_name,abstr_pix_name);
     sprintf(wrtxtbu,"\n%i abstracts successfully deleted\n",
          abs_loesch);
     wrtxt(wrtxtbu);
  }
  else
  {
     if (isfile(tmpix_abs_name)) remove(tmpix_abs_name);
  }
  if (isfile("_$$.bbt")) remove("_$$.bbt");
  if (isfile("_$.bbt")) remove("_$.bbt");
  if (i_loesch == 0 && abs_loesch==0)
    wrtxt("Nothing found to delete...\n");
  wrtxt("\n[Please press any key]>");
  tastelesen();
  return 1;
}


static int db_dateien_oeffnen(void)
{
  if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot read %s",journal_name);
     beenden(fehlermeldung,2);
  }
  if (setvbuf(fpjournal,NULL,_IOFBF,sizeof(one_journal_rec))!=0)
  {
     beenden("ERROR: cannot allocate buffer for fpjournal",2);
  }
  if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot read %s",desc_name);
     beenden(fehlermeldung,2);
  }
  if (setvbuf(fpdesc,NULL,_IOFBF,sizeof(one_desc_rec))!=0)
  {
     beenden("ERROR: cannot allocate buffer for fpdesc",2);
  }
  if ((fpbuch=fopen(book_name,"r+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot open %s",book_name);
     beenden(fehlermeldung,2);
  }
  if (setvbuf(fpbuch,NULL,_IOFBF,sizeof(one_buch_rec))!=0)
  {
      beenden("ERROR: cannot allocate buffer for fpbuch",2);
  }

  if ((fpautorjl=fopen(autorjl_name,"r+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot open %s",autorjl_name);
     beenden(fehlermeldung,2);
  }
  if (setvbuf(fpautorjl,NULL,_IOFBF,sizeof(one_aued_rec))!=0)
  {
      beenden("ERROR: cannot allocate buffer for fpautorjl",2);
  }

  if ((fpautorbu=fopen(autorbu_name,"r+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot open %s",autorbu_name);
     beenden(fehlermeldung,2);
  }
  if (setvbuf(fpautorbu,NULL,_IOFBF,sizeof(one_aued_rec))!=0)
  {
      beenden("ERROR: cannot allocate buffer for fpautorbu",2);
  }
  if ((fpabs=fopen(abstr_dat_name,"r+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot open %s",abstr_dat_name);
     beenden(fehlermeldung,2);
  }
  if (setvbuf(fpabs,NULL,_IOFBF,sizeof(abstr_rec))!=0)
  {
      beenden("ERROR: cannot allocate buffer for fpabs",2);
  }

  return 0;
}

static int db_dateien_schliessen(void)
{
  fclose(fpjournal);
  fclose(fpdesc);
  fclose(fpbuch);
  fclose(fpautorjl);
  fclose(fpautorbu);
  fclose(fpabs);
  return 0;
}

static int ds_loeschen(void)
{
  long byte_zeiger;
  int i, n_aut, n_desc;
  author_rec one_aued_rec;

  byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
  fseek(fpjournal,byte_zeiger,SEEK_SET);
  fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
  if (!strcmp(one_journal_rec.reftyp,"j1"))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }
      /* Ende j1 */

  if (!strcmp(one_journal_rec.reftyp,"b1"))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      one_buch_rec.in_use_bu = 0;
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }

       /* Ende b1 */


  if (!strcmp(one_journal_rec.reftyp,"b2"))
  {
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      one_buch_rec.in_use_bu = 0;
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }
  }
       /* Ende b2 */
  return 1;
}



static int abstract_loeschen(void)
{
  long byte_zeiger;
  int i, anzahl_bloecke;

  byte_zeiger = ix04rec.abstr_rptr * sizeof(one_abstr_rec);
  fseek(fpabs,byte_zeiger,SEEK_SET);
  fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
  fseek(fpabs,byte_zeiger,SEEK_SET);
  anzahl_bloecke = one_abstr_rec.abstr_n;
  for (i=1; i <= anzahl_bloecke;i++)
  {
      fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      one_abstr_rec.in_use = 0;
      fseek(fpabs, - (long) sizeof(one_abstr_rec),SEEK_CUR);
      fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      fseek(fpabs,0L,SEEK_CUR);
        /* zwischen Wechsel von fwrite nach fread immer 'fseek' */
  }
  return 1;
}
