#
#   REFERENCES -- bibliographic software
#   Copyright (C) 1995-2000  Volker Kiefel
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#   USA
#

#
# AWK--Script converting a text file generated with the "BibTeX" format
# definition into a BibTeX database file.
#
#
# Please call:
#     awk -f r2bib.awk bibfile.txt
#
# this script will then produce the database "bibfile.bib"
#
# This script has been tested with the AWK (Kernighan), GAWK and
# MAWK--implementations of the `AWK' script language
#
#




BEGIN {
    ok = 1;
    if (ARGC < 2)
    {
        print "\nUSAGE: " ARGV[0] " -f R2BIB.AWK TEXTF.TXT"
        exit(1);
    }

    # create the output file name

    nstring = ARGV[1];
    split(nstring,narr,".");
    neuname = narr[1] ".bib"
    print "R2BIB: " ARGV[1] " -> " neuname;

    # enter `head'

    print "%" > neuname;
    print "% BibTeX file generated by REFERENCES 3.5, "\
          "(c) Copyright V. Kiefel, 1995-1999" > neuname;
    print "%\n" > neuname;


}
{
    b = $0;
    pos = index(b,"@")
    if (pos > 1) {
      a = substr(b, pos)
    }
    else {
      a = b
    }

    gsub(/\|month=\{1\}/,"|month=jan",a)  # insert three-letter month codes
    gsub(/\|month=\{2\}/,"|month=feb",a)
    gsub(/\|month=\{3\}/,"|month=mar",a)
    gsub(/\|month=\{4\}/,"|month=apr",a)
    gsub(/\|month=\{5\}/,"|month=may",a)
    gsub(/\|month=\{6\}/,"|month=jun",a)
    gsub(/\|month=\{7\}/,"|month=jul",a)
    gsub(/\|month=\{8\}/,"|month=aug",a)
    gsub(/\|month=\{9\}/,"|month=sep",a)
    gsub(/\|month=\{10\}/,"|month=oct",a)
    gsub(/\|month=\{11\}/,"|month=nov",a)
    gsub(/\|month=\{12\}/,"|month=dec",a)

    gsub(/\|/,"\n",a)         # | -> "\n" (endline)
    gsub(/\$/,"{\\$}",a)      # $ -> {\$}
    gsub(/&/,"{\\\\&}",a)     # & -> {\&} cf. GAWK documentation
    gsub(/%/,"{\\%}",a)       # % -> {\%}
    gsub(/_/,"{\\_}",a)       # _ -> {\_}
    gsub(/"/,"''",a)          # " -> ''
    gsub(/\204/,"{\\\"a}",a)     #  -> {\"a}
    gsub(/\216/,"{\\\"A}",a)     #  -> {\"A}
    gsub(/\224/,"{\\\"o}",a)     #  -> {\"o}
    gsub(/\231/,"{\\\"O}",a)     #  -> {\"O}
    gsub(/\201/,"{\\\"u}",a)     #  -> {\"u}
    gsub(/\232/,"{\\\"U}",a)     #  -> {\"U}
    gsub(/\341/,"{\\ss}",a)      #  -> {\"ss}
    gsub(/\[/,"$[$",a)           # [ -> $[$
    gsub(/\]/,"$]$",a)           # ] -> $]$
    gsub(/</,"$<$",a)            # < -> $<$
    gsub(/>/,"$>$",a)            # > -> $>$
    gsub(/#/,"\\#",a)            # # -> \#

    gsub(/\207/,"{\\c{c}}",a)   #  -> {\c{c}}
    gsub(/\200/,"{\\c{c}}",a)   #  -> {\c{C}}
    gsub(/\202/,"{\\'{e}}",a)   #  -> {\'{e}}
    gsub(/\212/,"{\\`{e}}",a)   #  -> {\'{e}}
    gsub(/\210/,"{\\^{e}}",a)   #  -> {^{a}}
    gsub(/\211/,"{\\\"{e}}",a)  #  -> {\"{e}}
    gsub(/\220/,"{\\'{E}}",a)   #  -> {\'{E}}
    gsub(/\240/,"{\\'{a}}",a)   #  -> {\'{a}}
    gsub(/\205/,"{\\`{a}}",a)   #  -> {\'{a}}
    gsub(/\203/,"{\\^{a}}",a)   #  -> {^{a}}
    gsub(/\242/,"{\\'{o}}",a)   #  -> {\'{o}}
    gsub(/\225/,"{\\`{o}}",a)   #  -> {\'{o}}
    gsub(/\223/,"{\\^{o}}",a)   #  -> {^{o}}
    gsub(/\243/,"{\\'{u}}",a)   #  -> {\'{u}}
    gsub(/\227/,"{\\`{u}}",a)   #  -> {\'{u}}
    gsub(/\226/,"{\\^{u}}",a)   #  -> {^{u}}
    gsub(/\241/,"{\\'{i}}",a)   #  -> {\'{i}}
    gsub(/\215/,"{\\`{i}}",a)   #  -> {\'{i}}
    gsub(/\214/,"{\\^{i}}",a)   #  -> {^{i}}

    gsub(/\370/,"{\\ensuremath{^\\circ}}",a)    #  -> {\ensuremath{^\circ}}
    gsub(/\346/,"{\\ensuremath{\\mu}}",a)         #  -> {\ensuremath{^\mu}}
    gsub(/\340/,"{\\ensuremath{\\alpha}}",a)      #  -> {\ensuremath{^\alpha}}

    print a >> neuname
}
