/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   stru_fun.c: Restukturieren der REFERENCES-Datenbank (u. Index)
*/

#include <stdio.h>
#include <malloc.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <dos.h>
#include "refs.h"
#include "abstr.h"
#include "str_fun.h"
#include "fl_ut.h"
#include "ix01_fun.h"
#include "sortix01.h"
#include "ix02_fun.h"
#include "sortix02.h"
#include "ix03_fun.h"
#include "sortix03.h"
#include "ix04_fun.h"
#include "sortix04.h"
#include "l_menu.h"
#include "abbruch.h"
#include "keycodes.h"
#include "cfg_fun.h"


#define STRUCTTITEL "REFERENCES VERSION 3.5 * DATABASE FILE MAINTENANCE FUNCTIONS"
// #define CFG_FILE "REFS.CFG"

#define STRUCT_LOG "STRUCT.LOG"
 extern char journal_pix_name[PFAD_LEN];
 extern char desc_name[PFAD_LEN];
 static char desc_name_neu[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 static char journal_name_neu[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 static char book_name_neu[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 static char autorjl_name_neu[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 static char autorbu_name_neu[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 static char quell_name_neu[PFAD_LEN];
 extern char stichw_pix_name[PFAD_LEN];
 extern char stichw_name[PFAD_LEN];
 static char stichw_name_neu[PFAD_LEN];
 static char abstr_name[PFAD_LEN];
 static char abstr_name_neu[PFAD_LEN];
 extern char abstr_pix_name[PFAD_LEN];
 static char fd_name[PFAD_LEN];
 static char log_name[PFAD_LEN];

 static char tmpix_name[PFAD_LEN];
 static char newix_name[PFAD_LEN];

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * ix03file;
 extern FILE * ix04file;

 extern FILE * fpjournal;
 static FILE * fpjournalneu;
 extern FILE * fpdesc;
 static FILE * fpdescneu;
 extern FILE * fpbuch;
 static FILE * fpbuchneu;
 extern FILE * fpautorjl;
 static FILE * fpautorjlneu;
 extern FILE * fpautorbu;
 static FILE * fpautorbuneu;
 extern FILE * fparchiv;
 static FILE * tmpix;
 static FILE * newix;
 extern FILE * fpquell;
 static FILE * fpquellneu;
 extern FILE * fpstichw;
 static FILE * fpstichwneu;
 extern FILE * fpabs;
 static FILE * fpabsneu;
 static FILE * fplog;

 extern config_set             one_config_set;

 extern journal_rec            one_journal_rec;
 extern desc_rec               one_desc_rec;
 extern buch_rec               one_buch_rec;
 extern author_rec             one_aued_rec;
 extern quell_rec              one_quell_rec;
 static keylist_rec            one_key_rec;
 extern abstr_rec              one_abstr_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern keylistpix_rec         ix03rec;
 extern abstrpix_rec           ix04rec;


 static unsigned int           delaywrite;
 static int alles_ok;



 int stru_fun_main(char * datpath);
 static void hauptmenu_stru(void);
 static void make_ix01(void);
 static void make_ix02(void);
 static void make_ix03(void);
 static void copy_files(void);
 static void build_missing_files(void);
 static void make_ix04(void);
 static void copy_abstract_files(void);
 static void dateien_pruefen(void);
 static void zerstoeren(int code);


int stru_fun_main(char * datpath)
{
     delaywrite=one_config_set.delay_struct_write;


     strcpy(journal_pix_name,datpath);strcat(journal_pix_name,"JOURNAL.IX");
     strcpy(journal_name,datpath);strcat(journal_name,"JOURNAL.DAT");
     strcpy(journal_name_neu,datpath);strcat(journal_name_neu,"JOURNAL.DA$");
     strcpy(desc_name,datpath);strcat(desc_name,"DESC.DAT");
     strcpy(desc_name_neu,datpath);strcat(desc_name_neu,"DESC.DA$");
     strcpy(book_name,datpath);strcat(book_name,"BOOK.DAT");
     strcpy(book_name_neu,datpath);strcat(book_name_neu,"BOOK.DA$");
     strcpy(autorjl_name,datpath);strcat(autorjl_name,"AUTORJL.DAT");
     strcpy(autorjl_name_neu,datpath);strcat(autorjl_name_neu,"AUTORJL.DA$");
     strcpy(autorbu_name,datpath);strcat(autorbu_name,"AUTORBO.DAT");
     strcpy(autorbu_name_neu,datpath);strcat(autorbu_name_neu,"AUTORBO.DA$");
     strcpy(quell_pix_name,datpath);strcat(quell_pix_name,"SOURCE.IX");
     strcpy(quell_name,datpath);strcat(quell_name,"SOURCE.DAT");
     strcpy(quell_name_neu,datpath);strcat(quell_name_neu,"SOURCE.DA$");
     strcpy(stichw_pix_name,datpath);strcat(stichw_pix_name,"KEYW.IX");
     strcpy(stichw_name,datpath);strcat(stichw_name,"KEYW.DAT");
     strcpy(stichw_name_neu,datpath);strcat(stichw_name_neu,"KEYW.DA$");
     strcpy(tmpix_name,datpath);strcat(tmpix_name,"TMP01_R.IX");
     strcpy(newix_name,datpath);strcat(newix_name,"NEW01_R.IX");
     strcpy(fd_name,datpath);strcat(fd_name,"FORMDEF.DAT");
     strcpy(abstr_name,datpath);strcat(abstr_name,"ABST.DAT");
     strcpy(abstr_name_neu,datpath);strcat(abstr_name_neu,"ABST.DA$");
     strcpy(abstr_pix_name,datpath);strcat(abstr_pix_name,"ABST.IX");
     strcpy(log_name,datpath);strcat(log_name,STRUCT_LOG);



     if ((fplog=fopen(log_name,"w"))==NULL)
     {
       sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",log_name);
       beenden(fehlermeldung,2);
     }
     alles_ok=1;
     fprintf(fplog,"Functions 'RebuildDbase' (REFERENCES 3.5):\n");
     hauptmenu_stru();
     if (alles_ok)
     {
       fprintf(fplog,"\nNo problem encountered.");
     }
     fclose(fplog);
     return 0;
}


static void hauptmenu_stru(void)
{
   int taste;
   static int menupos;
   cls_line(STRUCTTITEL);
   taste = lotus_menu_default(&menupos,
     "@RestructureDb$Rebuild the database files (and index files)"
     "@IndexF$Rebuild the index files, database files will be left untouched"
     "@AbstractF$Rebuild the abstract database and index files"
     "@CreateF$Create missing index files and database files"
     "@1:DestroyDb$Erase the current database *but not* FORMDEF.DAT - CAUTION"
     "@2:DestroyDb$Erase the current database *including* FORMDEF.DAT - CAUTION");
     if (taste==1)
     {

       dateien_pruefen();

       cls_line("");
       fprintf(fplog,"\nRebuilding index files...");
       make_ix01();
       make_ix02();
       make_ix03();
       copy_files();
       sprintf(wrtxtbu,"\n[Reconstruction of database complete, please "
              "read %s]>",STRUCT_LOG);
       wrtxt(wrtxtbu);
       tastelesen();
     }
     else if (taste==2)
     {
       dateien_pruefen();
       fprintf(fplog,"\nRebuilding index files...");
       make_ix01();
       make_ix02();
       make_ix03();
       sprintf(wrtxtbu,"\n[Reconstruction of index files complete, please "
              "read %s]>",STRUCT_LOG);
       wrtxt(wrtxtbu);
       tastelesen();
     }
     else if (taste==3)
     {
        int abstract_taste;

        dateien_pruefen();
        abstract_taste = lotus_menu(
          "@Index$Rebuild abstract index file"
          "@Database$Rebuild index file and abstract database files"
        );
        if (abstract_taste==1)
        {
           fprintf(fplog,"\nRebuilding abstract index file...");
           make_ix04();
           sprintf(wrtxtbu,"\n[Reconstruction of abstract index file complete, "
                    "please read %s]>",STRUCT_LOG);
           wrtxt(wrtxtbu);
           tastelesen();
        }
        if (abstract_taste==2)
        {
           fprintf(fplog,"\nRebuilding abstract index file...");
           make_ix04();
           copy_abstract_files();
           sprintf(wrtxtbu,"\n[Reconstruction of abstract database complete, "
                  "please read %s]>",STRUCT_LOG);
           wrtxt(wrtxtbu);
           tastelesen();
        }
     }
     else if (taste==4)
     {
        build_missing_files();
     }
     else if (taste==5)
     {
        int taste_5;
              beeps();
              wrtxt("CAUTION - The current database will be destroyed if "
                         "you select 'Delete'.\n"
                   "A complete archive should be prepared before deleting!\n\n");
        taste_5 = lotus_menu
          (
              "@Cancel$Abort, the current REFERENCES database will not be deleted"
              "@Delete$Delete current database (but not FORMDEF.DAT file) *CAUTION*"
          );
        if (taste_5==2)
        {
           zerstoeren(1);
        }
     }
     else if (taste==6)
     {
        int taste_5;
              beeps();
              wrtxt("CAUTION - The current database will be destroyed if "
                         "you select 'Delete'.\n"
                   "A complete archive should be prepared before deleting!\n\n");
        taste_5 = lotus_menu
          (
              "@Cancel$Abort, the current REFERENCES database will not be deleted"
              "@Delete$Delete current database (including the FORMDEF.DAT file) *CAUTION*"
          );
        if (taste_5==2)
        {
           zerstoeren(2);
        }
     }
     return;
}


static void make_ix01(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records,ix_zeiger,i;
  char kennz_alt[KENNZIFFER_LEN + 1];
  cls_line("");
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",journal_name);
    beenden(fehlermeldung,2);
  }

  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",tmpix_name);
    beenden(fehlermeldung,2);
  }
  fseek(fpjournal,0L,SEEK_END);
  anzahl_records = ftell(fpjournal) / sizeof(one_journal_rec);
  rewind(fpjournal);
  anzahl_records--;
  sprintf(wrtxtbu,"Writing 1st Version of %s...\n",journal_pix_name);
  wrtxt(wrtxtbu);
  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix01rec,0,sizeof(ix01rec));
     fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
     byte_zeiger=ftell(fpjournal);
     rec_zeiger = (byte_zeiger / sizeof(one_journal_rec))-1;
     if (one_journal_rec.in_use==1)
     {
         strcpy(ix01rec.kennziffer,one_journal_rec.kennziffer);
         ix01rec.journal_rptr = rec_zeiger;
         ix01rec.buch_rptr = -1;
         ix01rec.autorjl_rptr = -1;
         ix01rec.autorbu_rptr = -1;
         ix01rec.desc_rptr = -1;
         fwrite(&ix01rec,sizeof(ix01rec),1,tmpix);
     }

  }
  fclose(fpjournal);
  fclose(tmpix);

  if (isfile(newix_name)) remove(newix_name);

  domerge01(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);


  /* Eine Kopie des Index herstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot read %s for eliminating "
            "duplicate entries in index",tmpix_name);
     beenden(fehlermeldung,2);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s for eliminating "
             "duplicate entries in index",newix_name);
     beenden(fehlermeldung,2);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix01rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kennz_alt,"",KENNZIFFER_LEN+1);
  sprintf(wrtxtbu,"Checking for duplicate key values in %s...\n",journal_name);
  wrtxt(wrtxtbu);
  fprintf(fplog,"\nChecking for duplicate key values in %s...",journal_name);
  for (i=0;i<=anzahl_records;i++)
  {
     fread(&ix01rec,sizeof(ix01rec),1,tmpix);
     if (strcmp(kennz_alt,ix01rec.kennziffer)!=0)
     {
       fwrite(&ix01rec,sizeof(ix01rec),1,newix);
     }
     else
     {
       fprintf(fplog,"\nProblem: duplicate key '%s' in '%s'",
               ix01rec.kennziffer,journal_name);
       alles_ok = 0;
     }
     strncpy(kennz_alt,ix01rec.kennziffer,KENNZIFFER_LEN+1);
  }

  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);

  /* Record-pointer aus BOOK.DAT eintragen */

  if (!read_write_ix01(newix_name))
  {
     sprintf(fehlermeldung,"Unexpected ERROR: cannot open %s",newix_name);
     beenden(fehlermeldung,2);
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot open %s", book_name);
     beenden(fehlermeldung,2);
  }
  fseek(fpbuch,0L,SEEK_END);
  byte_zeiger = ftell(fpbuch);
  anzahl_records = byte_zeiger / sizeof(one_buch_rec);
  anzahl_records--;
  rewind(fpbuch);
  sprintf(wrtxtbu,"Adding record pointers of %s...\n",book_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
     byte_zeiger = ftell(fpbuch);
     rec_zeiger = (byte_zeiger / sizeof(one_buch_rec)) -1;
     if (one_buch_rec.in_use_bu==1)
     {
        /* Wenn der Schluesselwert nicht gefunden wird? */
        ix_zeiger = locate_ix01(one_buch_rec.kennziffer,&ix01rec);
        if (ix_zeiger > -1)
        {
           ix01rec.buch_rptr = rec_zeiger;
           fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
           fwrite(&ix01rec,sizeof(ix01rec),1,ix01file);
        }
     }
  }
  fclose(fpbuch);
  close_ix01();
  /* Record-pointer aus AUTORJL.DAT eintragen*/

  if (!read_write_ix01(newix_name))
  {
     sprintf(fehlermeldung,"Unexpected ERROR: cannot open %s",newix_name);
     beenden(fehlermeldung,2);
  }

  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot open %s", autorjl_name);
     beenden(fehlermeldung,2);
  }
  fseek(fpautorjl,0L,SEEK_END);
  byte_zeiger = ftell(fpautorjl);
  anzahl_records = byte_zeiger / sizeof(one_aued_rec);
  anzahl_records--;
  rewind(fpautorjl);
  sprintf(wrtxtbu,"Adding record pointers of %s...\n",autorjl_name);
  wrtxt(wrtxtbu);


  for (i=0;i<=anzahl_records;i++)
  {
     fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
     byte_zeiger = ftell(fpautorjl);
     rec_zeiger = (byte_zeiger / sizeof(one_aued_rec)) -1;
     if ((one_aued_rec.in_use_au==1) && (one_aued_rec.au_i==1))
     {
        /* Wenn der Schluesselwert nicht gefunden wird? */
        ix_zeiger = locate_ix01(one_aued_rec.au_kennziffer,&ix01rec);
        if (ix_zeiger > -1)
        {
           ix01rec.autorjl_rptr = rec_zeiger;
           fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
           fwrite(&ix01rec,sizeof(ix01rec),1,ix01file);
        }
     }
  }

  fclose(fpautorjl);
  close_ix01();

  /* Record-pointer aus AUTORBO.DAT eintragen*/

  if (!read_write_ix01(newix_name))
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot open %s",newix_name);
     beenden(fehlermeldung,2);
  }

  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot open %s", autorbu_name);
     beenden(fehlermeldung,2);
  }
  fseek(fpautorbu,0L,SEEK_END);
  byte_zeiger = ftell(fpautorbu);
  anzahl_records = byte_zeiger / sizeof(one_aued_rec);
  anzahl_records--;
  rewind(fpautorbu);
  sprintf(wrtxtbu,"Adding record pointers of %s...\n",autorbu_name);
  wrtxt(wrtxtbu);


  for (i=0;i<=anzahl_records;i++)
  {
     fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
     byte_zeiger = ftell(fpautorbu);
     rec_zeiger = (byte_zeiger / sizeof(one_aued_rec)) -1;
     if ((one_aued_rec.in_use_au==1) && (one_aued_rec.au_i==1))
     {
        /* Wenn der Schluesselwert nicht gefunden wird? */
        ix_zeiger = locate_ix01(one_aued_rec.au_kennziffer,&ix01rec);
        if (ix_zeiger > -1)
        {
           ix01rec.autorbu_rptr = rec_zeiger;
           fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
           fwrite(&ix01rec,sizeof(ix01rec),1,ix01file);
        }
     }
  }

  fclose(fpautorbu);
  close_ix01();

  /* Record-pointer aus DESC.DAT eintragen*/

  if (!read_write_ix01(newix_name))
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot open %s",newix_name);
     beenden(fehlermeldung,2);
  }

  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot open %s", desc_name);
     beenden(fehlermeldung,2);
  }
  fseek(fpdesc,0L,SEEK_END);
  byte_zeiger = ftell(fpdesc);
  anzahl_records = byte_zeiger / sizeof(one_desc_rec);
  anzahl_records--;
  rewind(fpdesc);
  sprintf(wrtxtbu,"Adding record pointers of %s...\n",desc_name);
  wrtxt(wrtxtbu);

   for (i=0;i<=anzahl_records;i++)
   {
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      byte_zeiger = ftell(fpdesc);
      rec_zeiger = (byte_zeiger / sizeof(one_desc_rec)) -1;
      if ((one_desc_rec.in_use==1) && (one_desc_rec.desc_i==1))
      {
         /* Wenn der Schluesselwert nicht gefunden wird? */
         ix_zeiger = locate_ix01(one_desc_rec.kennziffer,&ix01rec);
         if (ix_zeiger > -1)
         {
            ix01rec.desc_rptr = rec_zeiger;
            fseek(ix01file,ix_zeiger * sizeof(ix01rec),SEEK_SET);
            fwrite(&ix01rec,sizeof(ix01rec),1,ix01file);
         }
      }
   }

   fclose(fpdesc);
   close_ix01();

  sc_gotoxy(1,one_config_set.sl);sc_clreol();
  remove(journal_pix_name);
  if (rename(newix_name,journal_pix_name)!=0)
  {
     sprintf(fehlermeldung,"ERROR: Reconstruction "
             "of %s failed",journal_pix_name);
     beenden(fehlermeldung,2);
  }
}


static void make_ix02(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records,i;
  char kuerzel_alt[QUELLKUERZEL_LEN + 1];
  if ((fpquell=fopen(quell_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",quell_name);
     beenden(fehlermeldung,2);
  }

  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  fseek(fpquell,0L,SEEK_END);
  anzahl_records = ftell(fpquell) / sizeof(one_quell_rec);
  rewind(fpquell);
  anzahl_records--;
  sprintf(wrtxtbu,"\nWriting 1st Version of %s...\n",quell_pix_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix02rec,0,sizeof(ix02rec));
     fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
     byte_zeiger=ftell(fpquell);
     rec_zeiger = (byte_zeiger / sizeof(one_quell_rec))-1;
     if (one_quell_rec.in_use_quell == 1)
     {
         strcpy(ix02rec.quell_kuerzel,one_quell_rec.quell_kuerzel);
         ix02rec.quell_rptr = rec_zeiger;
         fwrite(&ix02rec,sizeof(ix02rec),1,tmpix);
     }
  }
  fclose(tmpix);
  fclose(fpquell);
  if (isfile(newix_name)) remove(newix_name);
  domerge02(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);




  /* Eine Kopie des Index herstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot read %s for eliminating duplicate "
            "entries in index",tmpix_name);
     beenden(fehlermeldung,2);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s for "
             "eliminating duplicate entries in index",newix_name);
     beenden(fehlermeldung,2);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix02rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kuerzel_alt,"",QUELLKUERZEL_LEN+1);
  sprintf(wrtxtbu,"Checking for duplicate key values in %s...\n",quell_name);
  wrtxt(wrtxtbu);
  fprintf(fplog,"\nChecking for duplicate key values in %s...",quell_name);
  for (i=0;i<=anzahl_records;i++)
  {
     fread(&ix02rec,sizeof(ix02rec),1,tmpix);
     if (strcmp(kuerzel_alt,ix02rec.quell_kuerzel)!=0)
     {
       fwrite(&ix02rec,sizeof(ix02rec),1,newix);
     }
     else
     {
       fprintf(fplog,"\nProblem: duplicate key '%s' in '%s'",
               ix02rec.quell_kuerzel,quell_name);
       alles_ok = 0;
     }

     strncpy(kuerzel_alt,ix02rec.quell_kuerzel,QUELLKUERZEL_LEN+1);
  }

  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);

  sc_gotoxy(1,one_config_set.sl);sc_clreol();
  remove(quell_pix_name);
  if (rename(newix_name,quell_pix_name)!=0)
  {
     sprintf(fehlermeldung,"ERROR: Reconstruction of %s "
              "failed",quell_pix_name);
     beenden(fehlermeldung,2);
  }
}





static void make_ix03(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records,i;
  char kwfield_alt[KEYWORDS_LEN + 1];
  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",stichw_name);
     beenden(fehlermeldung,2);
  }

  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  fseek(fpstichw,0L,SEEK_END);
  anzahl_records = ftell(fpstichw) / sizeof(one_key_rec);
  rewind(fpstichw);
  anzahl_records--;
  sprintf(wrtxtbu,"\nWriting 1st Version of %s...\n",stichw_pix_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix03rec,0,sizeof(ix03rec));
     fread(&one_key_rec,sizeof(one_key_rec),1,fpstichw);
     byte_zeiger=ftell(fpstichw);
     rec_zeiger = (byte_zeiger / sizeof(one_key_rec))-1;
     if (one_key_rec.in_use == 1)
     {
         strcpy(ix03rec.keywordsfield,one_key_rec.keywordsfield);
         ix03rec.keywords_rptr = rec_zeiger;
         fwrite(&ix03rec,sizeof(ix03rec),1,tmpix);
     }
  }
  fclose(tmpix);
  fclose(fpstichw);
  if (isfile(newix_name)) remove(newix_name);
  domerge03(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);




  /* Eine Kopie des Index herstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot read %s "
               "for eliminating duplicate entries in index",tmpix_name);
     beenden(fehlermeldung,2);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s for "
           "eliminating duplicate entries in index",newix_name);
     beenden(fehlermeldung,2);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix03rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kwfield_alt,"",KEYWORDS_LEN+1);
  sprintf(wrtxtbu,"Checking for duplicate key values in %s...\n",stichw_name);
  wrtxt(wrtxtbu);
  fprintf(fplog,"\nChecking for duplicate key values in %s...",stichw_name);
  for (i=0;i<=anzahl_records;i++)
  {
     fread(&ix03rec,sizeof(ix03rec),1,tmpix);
     if (strcmp(kwfield_alt,ix03rec.keywordsfield)!=0)
     {
       fwrite(&ix03rec,sizeof(ix03rec),1,newix);
     }
     else
     {
       fprintf(fplog,"\nProblem: duplicate key '%s' in '%s'",
               ix03rec.keywordsfield,stichw_name);
       alles_ok = 0;
     }
     strncpy(kwfield_alt,ix03rec.keywordsfield,KEYWORDS_LEN+1);
  }

  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);

  sc_gotoxy(1,one_config_set.sl);sc_clreol();

  remove(stichw_pix_name);
  if (rename(newix_name,stichw_pix_name)!=0)
  {
     sprintf(fehlermeldung,"ERROR: Reconstruction "
                "of %s failed",stichw_pix_name);
     beenden(fehlermeldung,2);
  }

}


static void copy_files(void)
{
  long i, j, byte_zeiger, rec_zeiger, anzahl_records;
  int anzahl_desc;

  fprintf(fplog,"\nPerforming 'RestructureDatabase' (after rebuilding index files)...");
  fprintf(fplog,"\nThis function removes duplicate index files.");
  wrtxt("\nRebuilding main database, please wait...\n");

  if ((ix01file=fopen(journal_pix_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot "
              "read %s",journal_pix_name);
     beenden(fehlermeldung,2);
  }
  /* temporaere Indexdatei */
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",journal_name);
     beenden(fehlermeldung,2);
  }
  if ((fpjournalneu=fopen(journal_name_neu,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",
            journal_name_neu);
     beenden(fehlermeldung,2);
  }
  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",desc_name);
     beenden(fehlermeldung,2);
  }
  if ((fpdescneu=fopen(desc_name_neu,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",
            desc_name_neu);
     beenden(fehlermeldung,2);
  }
  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",book_name);
     beenden(fehlermeldung,2);
  }
  if ((fpbuchneu=fopen(book_name_neu,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",book_name_neu);
     beenden(fehlermeldung,2);
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",autorjl_name);
     beenden(fehlermeldung,2);
  }
  if ((fpautorjlneu=fopen(autorjl_name_neu,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot "
        "create %s",autorjl_name_neu);
     beenden(fehlermeldung,2);
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",autorbu_name);
     beenden(fehlermeldung,2);
  }
  if ((fpautorbuneu=fopen(autorbu_name_neu,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot "
        "create %s",autorbu_name_neu);
     beenden(fehlermeldung,2);
  }

  fseek(ix01file,0L,SEEK_END);
  anzahl_records = ftell(ix01file) / sizeof(ix01rec);
  anzahl_records--;
  rewind(ix01file);
  for (i=0;i<=anzahl_records;i++)
  {
      if (delaywrite > 0)
      {
#if defined(__EMX__)
         if (((i+1) % 200)==0) { _sleep2 (delaywrite); }
#endif
#if defined(__DJGPP__)
         if (((i+1) % 200)==0) { delay (delaywrite); }
#endif
      }

      fread(&ix01rec,sizeof(ix01rec),1,ix01file);
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournalneu);
      byte_zeiger = ftell(fpjournalneu);
      rec_zeiger = byte_zeiger / sizeof(one_journal_rec);
      ix01rec.journal_rptr = rec_zeiger - 1;

      if (ix01rec.buch_rptr!=-1)
      {
        byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
        fseek(fpbuch,byte_zeiger,SEEK_SET);
        fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
        fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuchneu);
        byte_zeiger = ftell(fpbuchneu);
        rec_zeiger = byte_zeiger / sizeof(one_buch_rec);
        ix01rec.buch_rptr = rec_zeiger - 1;
      }

      if (ix01rec.autorjl_rptr!=-1)
      {
        byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
        fseek(fpautorjl,byte_zeiger,SEEK_SET);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
        fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjlneu);
        byte_zeiger = ftell(fpautorjlneu);
        rec_zeiger = byte_zeiger / sizeof(one_aued_rec);
        ix01rec.autorjl_rptr = rec_zeiger - 1;
        if (one_aued_rec.au_n > 1)
        {
           for (j=2;j<=one_aued_rec.au_n;j++)
           {
               fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
               fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjlneu);
           }
        }
      }

      if (ix01rec.autorbu_rptr!=-1)
      {
        byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
        fseek(fpautorbu,byte_zeiger,SEEK_SET);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
        fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbuneu);
        byte_zeiger = ftell(fpautorbuneu);
        rec_zeiger = byte_zeiger / sizeof(one_aued_rec);
        ix01rec.autorbu_rptr = rec_zeiger - 1;
        if (one_aued_rec.au_n > 1)
        {
           for (j=2;j<=one_aued_rec.au_n;j++)
           {
               fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
               fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbuneu);
           }
        }
      }

      if (ix01rec.desc_rptr!=-1)
      {
        byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
        fseek(fpdesc,byte_zeiger,SEEK_SET);
        fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
        fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdescneu);
        byte_zeiger = ftell(fpdescneu);
        rec_zeiger = byte_zeiger / sizeof(one_desc_rec);
        ix01rec.desc_rptr = rec_zeiger - 1;
        anzahl_desc = one_desc_rec.desc_n;
        if (anzahl_desc > 1)
        {
           for (j=2;j<=anzahl_desc;j++)
           {
               fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
               fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdescneu);
           }
        }
      }


      fwrite(&ix01rec,sizeof(ix01rec),1,tmpix);
  }

  fclose(ix01file);
  fclose(tmpix);
  fclose(fpjournal);
  fclose(fpjournalneu);
  fclose(fpdesc);
  fclose(fpdescneu);
  fclose(fpbuch);
  fclose(fpbuchneu);
  fclose(fpautorjl);
  fclose(fpautorjlneu);
  fclose(fpautorbu);
  fclose(fpautorbuneu);

  if (isfile(journal_name)) remove(journal_name);
  rename(journal_name_neu,journal_name);
  if (isfile(desc_name)) remove(desc_name);
  rename(desc_name_neu,desc_name);
  if (isfile(book_name)) remove(book_name);
  rename(book_name_neu,book_name);
  if (isfile(autorjl_name)) remove(autorjl_name);
  rename(autorjl_name_neu,autorjl_name);
  if (isfile(autorbu_name)) remove(autorbu_name);
  rename(autorbu_name_neu,autorbu_name);

  if (isfile(journal_pix_name)) remove(journal_pix_name);
  rename(tmpix_name,journal_pix_name);

  /* SOURCE.DAT */
  wrtxt("Rebuilding database with JOURNAL-names...\n");
  if ((ix02file=fopen(quell_pix_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",quell_pix_name);
     beenden(fehlermeldung,2);
  }
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",tmpix_name);
    beenden(fehlermeldung,2);
  }

  if ((fpquell=fopen(quell_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",quell_name);
     beenden(fehlermeldung,2);
  }
  if ((fpquellneu=fopen(quell_name_neu,"wb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",quell_name_neu);
    beenden(fehlermeldung,2);
  }

  fseek(ix02file,0L,SEEK_END);
  anzahl_records = ftell(ix02file) / sizeof(ix02rec);
  anzahl_records--;
  rewind(ix02file);
  for (i=0;i<=anzahl_records;i++)
  {
      if (delaywrite > 0)
      {
#if defined(__EMX__)
         if (((i+1) % 200)==0) { _sleep2 (delaywrite); }
#endif
#if defined(__DJGPP__)
         if (((i+1) % 200)==0) { delay (delaywrite); }
#endif
      }

      fread(&ix02rec,sizeof(ix02rec),1,ix02file);
      byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
      fseek(fpquell,byte_zeiger,SEEK_SET);
      fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
      fwrite(&one_quell_rec,sizeof(one_quell_rec),1,fpquellneu);
      byte_zeiger = ftell(fpquellneu);
      rec_zeiger = byte_zeiger / sizeof(one_quell_rec);
      ix02rec.quell_rptr = rec_zeiger - 1;

      fwrite(&ix02rec,sizeof(ix02rec),1,tmpix);
  }

  fclose(ix02file);
  fclose(tmpix);
  fclose(fpquell);
  fclose(fpquellneu);

  if (isfile(quell_name)) remove(quell_name);
  rename(quell_name_neu,quell_name);
  if (isfile(quell_pix_name)) remove(quell_pix_name);
  rename(tmpix_name,quell_pix_name);



  /* KEYW.DAT */
  wrtxt("Rebuilding database with KEYWORDS...\n");
  if ((ix03file=fopen(stichw_pix_name,"rb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",stichw_pix_name);
    beenden(fehlermeldung,2);
  }
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",tmpix_name);
    beenden(fehlermeldung,2);
  }

  if ((fpstichw=fopen(stichw_name,"rb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",stichw_name);
    beenden(fehlermeldung,2);
  }
  if ((fpstichwneu=fopen(stichw_name_neu,"wb"))==NULL)
  {
    sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",stichw_name_neu);
    beenden(fehlermeldung,2);
  }

  fseek(ix03file,0L,SEEK_END);
  anzahl_records = ftell(ix03file) / sizeof(ix03rec);
  anzahl_records--;
  rewind(ix03file);
  for (i=0;i<=anzahl_records;i++)
  {
      if (delaywrite > 0)
      {
#if defined(__EMX__)
         if (((i+1) % 200)==0) { _sleep2 (delaywrite); }
#endif
#if defined(__DJGPP__)
         if (((i+1) % 200)==0) { delay (delaywrite); }
#endif
      }

      fread(&ix03rec,sizeof(ix03rec),1,ix03file);
      byte_zeiger = ix03rec.keywords_rptr * sizeof(one_key_rec);
      fseek(fpstichw,byte_zeiger,SEEK_SET);
      fread(&one_key_rec,sizeof(one_key_rec),1,fpstichw);
      fwrite(&one_key_rec,sizeof(one_key_rec),1,fpstichwneu);
      byte_zeiger = ftell(fpstichwneu);
      rec_zeiger = byte_zeiger / sizeof(one_key_rec);
      ix03rec.keywords_rptr = rec_zeiger - 1;

      fwrite(&ix03rec,sizeof(ix03rec),1,tmpix);
  }

  fclose(ix03file);
  fclose(tmpix);
  fclose(fpstichw);
  fclose(fpstichwneu);

  if (isfile(stichw_name)) remove(stichw_name);
  rename(stichw_name_neu,stichw_name);
  if (isfile(stichw_pix_name)) remove(stichw_pix_name);
  rename(tmpix_name,stichw_pix_name);
}



static void build_missing_files(void)
{
    FILE * fp;

    fprintf(fplog,"\nPerforming 'CreateFiles'...");
    if (!isfile(journal_pix_name))
    {
       if ((fp=fopen(journal_pix_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and "
                   "to create %s\n",journal_pix_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",journal_pix_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",journal_pix_name);
      wrtxt(wrtxtbu);
    }


    if (!isfile(journal_name))
    {
       if ((fp=fopen(journal_name,"wb"))==NULL)
       {
         sprintf("FATAL ERROR: Unable to find and to "
                    "create %s\n",journal_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",journal_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",journal_name);
      wrtxt(wrtxtbu);
    }

    if (!isfile(desc_name))
    {
       if ((fp=fopen(desc_name,"wb"))==NULL)
       {
         sprintf("FATAL ERROR: Unable to find and to "
                    "create %s\n",desc_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",desc_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",desc_name);
      wrtxt(wrtxtbu);
    }


    if (!isfile(book_name))
    {
       if ((fp=fopen(book_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to "
                "find and to create %s\n",book_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",book_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",book_name);
      wrtxt(wrtxtbu);
    }

    if (!isfile(autorjl_name))
    {
       if ((fp=fopen(autorjl_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and "
                "to create %s\n",autorjl_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",autorjl_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",autorjl_name);
      wrtxt(wrtxtbu);
    }


    if (!isfile(autorbu_name))
    {
       if ((fp=fopen(autorbu_name,"wb"))==NULL)
       {
         sprintf("FATAL ERROR: Unable to find and to "
              "create %s\n",autorbu_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",autorbu_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",autorbu_name);
      wrtxt(wrtxtbu);
    }


    if (!isfile(quell_pix_name))
    {
       if ((fp=fopen(quell_pix_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and to "
             "create %s\n",quell_pix_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",quell_pix_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",quell_pix_name);
      wrtxt(wrtxtbu);
    }


    if (!isfile(quell_name))
    {
       if ((fp=fopen(quell_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and "
                   "to create %s\n",quell_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",quell_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",quell_name);
      wrtxt(wrtxtbu);
    }

    if (!isfile(stichw_pix_name))
    {
       if ((fp=fopen(stichw_pix_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find "
               "and to create %s\n",stichw_pix_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",stichw_pix_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",stichw_pix_name);
      wrtxt(wrtxtbu);
    }

    if (!isfile(stichw_name))
    {
       if ((fp=fopen(stichw_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and to "
                  "create %s\n",stichw_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",stichw_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",stichw_name);
      wrtxt(wrtxtbu);
    }

    if (!isfile(abstr_name))
    {
       if ((fp=fopen(abstr_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and to "
                  "create %s\n",abstr_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",abstr_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",abstr_name);
      wrtxt(wrtxtbu);
    }


    if (!isfile(abstr_pix_name))
    {
       if ((fp=fopen(abstr_pix_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and to "
                  "create %s\n",abstr_pix_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",abstr_pix_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",abstr_pix_name);
      wrtxt(wrtxtbu);
    }



    if (!isfile(fd_name))
    {
       if ((fp=fopen(fd_name,"wb"))==NULL)
       {
         sprintf(fehlermeldung,"FATAL ERROR: Unable to find and to "
                  "create %s\n",fd_name);
         beenden(fehlermeldung,2);
       }
       fclose(fp);
       sprintf(wrtxtbu,"%s created...\n",fd_name);
       wrtxt(wrtxtbu);
    }
    else
    {
      sprintf(wrtxtbu,"%s found...\n",fd_name);
      wrtxt(wrtxtbu);
    }
    wrtxt("\n[Please press any key]>");
    tastelesen();
}

static void make_ix04(void)
{
  long rec_zeiger, byte_zeiger, anzahl_records, i;
  char kennz_alt[KENNZIFFER_LEN + 1];
  sc_gotoxy(1,one_config_set.sl-1);
  if ((fpabs=fopen(abstr_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected ERROR: cannot read %s",
                           abstr_name);
     beenden(fehlermeldung,2);
  }
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"Unexpected error: Cannot create %s",
                           tmpix_name);
     fclose(fpabs);
     beenden(fehlermeldung,2);

  }
  fseek(fpabs,0L,SEEK_END);
  anzahl_records=ftell(fpabs)/sizeof(one_abstr_rec);
  rewind(fpabs);
  anzahl_records--;
  sprintf(wrtxtbu,"\nWriting 1st Version of %s...\n",abstr_pix_name);
  wrtxt(wrtxtbu);

  for (i=0;i<=anzahl_records;i++)
  {
     memset(&ix04rec,0,sizeof(ix04rec));
     fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
     byte_zeiger = ftell(fpabs);
     rec_zeiger=(byte_zeiger/sizeof(one_abstr_rec)) -1;
     if ((one_abstr_rec.in_use==1) && (one_abstr_rec.abstr_i==1))
     {
        strcpy(ix04rec.kennziffer,one_abstr_rec.kennziffer);
        ix04rec.abstr_rptr = rec_zeiger;
        fwrite(&ix04rec,sizeof(ix04rec),1,tmpix);
     }
  }
  fclose(tmpix);
  fclose(fpabs);
  if (isfile(newix_name)) remove(newix_name);
  domerge04(tmpix_name,newix_name);
  remove(tmpix_name);
  rename(newix_name,tmpix_name);

  /* Eine Kopie des Index erstellen, Duplikate entfernen */
  if ((tmpix=fopen(tmpix_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: connot read temporary abstract "
                           "index file %s for eliminating duplicate entries",
             tmpix_name);
     beenden(fehlermeldung,2);
  }
  if ((newix=fopen(newix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create temporary abstract "
                           "index file %s for eliminating duplicate entries",
             newix_name);
     fclose(tmpix);
     beenden(fehlermeldung,2);
  }
  fseek(tmpix,0L,SEEK_END);
  byte_zeiger = ftell(tmpix);
  anzahl_records = byte_zeiger / sizeof(ix04rec);
  anzahl_records--;
  rewind(tmpix);
  strncpy(kennz_alt,"",KENNZIFFER_LEN + 1);
  sprintf(wrtxtbu,"Checking for duplicate key values in %s...\n",
          abstr_name);
  wrtxt(wrtxtbu);
  fprintf(fplog,"\nChecking for duplicate key values in %s...",abstr_name);
  for (i=0;i<=anzahl_records;i++)
  {
      fread(&ix04rec,sizeof(ix04rec),1,tmpix);
      if (strcmp(kennz_alt,ix04rec.kennziffer)!=0)
      {
         fwrite(&ix04rec,sizeof(ix04rec),1,newix);
      }
      else
      {
        fprintf(fplog,"\nProblem: duplicate key '%s' in '%s'",
                ix04rec.kennziffer,abstr_name);
        alles_ok = 0;
      }
      sprintf(kennz_alt,ix04rec.kennziffer,KENNZIFFER_LEN + 1);
  }
  fclose(newix);
  fclose(tmpix);
  if (isfile(tmpix_name)) remove(tmpix_name);
  sc_gotoxy(1,one_config_set.sl);sc_clreol();
  remove(abstr_pix_name);
  if (rename(newix_name,abstr_pix_name)!=0)
  {
      sprintf(fehlermeldung,"ERROR: Reconstruction of %s failed",
                            abstr_pix_name);
      beenden(fehlermeldung,2);
  }
  return;
}

static void copy_abstract_files(void)
{
   long i, byte_zeiger, rec_zeiger, anzahl_records;
   int j;
   fprintf(fplog,"\nPerforming 'AbstractFiles' 'Database' "
                 "(after rebuilding index files)...");
   fprintf(fplog,"\nThis function removes duplicate index files.");
   wrtxt("Rebuilding abstract database file, please wait...\n");

   if((ix04file=fopen(abstr_pix_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",
              abstr_pix_name);
      beenden(fehlermeldung,2);
   }
   if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
   {
      sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",
              tmpix_name);
      fclose(ix04file);
      beenden(fehlermeldung,2);
   }
   if ((fpabs=fopen(abstr_name,"rb"))==NULL)
   {
      sprintf(fehlermeldung,"Unexpected ERROR: Cannot read %s",
              abstr_name);
      fclose(tmpix);
      fclose(ix04file);
      beenden(fehlermeldung,2);
   }
   if ((fpabsneu=fopen(abstr_name_neu,"wb"))==NULL)
   {
      sprintf(fehlermeldung,"Unexpected ERROR: Cannot create %s",
             abstr_name_neu);
      fclose(tmpix);
      fclose(ix04file);
      fclose(fpabs);
      beenden(fehlermeldung,2);
   }

   fseek(ix04file,0L,SEEK_END);
   anzahl_records = ftell(ix04file) / sizeof(ix04rec);
   anzahl_records--;
   rewind(ix04file);
   for (i=0;i<=anzahl_records;i++)
   {
      if (delaywrite > 0)
      {
#if defined(__EMX__)
        if (((i+1) % 200)==0) { _sleep2 (delaywrite); }
#endif
#if defined(__DJGPP__)
        if (((i+1) % 200)==0) { delay (delaywrite); }
#endif
      }
      fread(&ix04rec,sizeof(ix04rec),1,ix04file);
      byte_zeiger = ix04rec.abstr_rptr * sizeof(one_abstr_rec);
      fseek(fpabs,byte_zeiger,SEEK_SET);
      fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsneu);
      byte_zeiger=ftell(fpabsneu);
      rec_zeiger=byte_zeiger / sizeof(one_abstr_rec);
      ix04rec.abstr_rptr = rec_zeiger - 1;
      if (one_abstr_rec.abstr_n > 1)
      {
        for (j=2;j<=one_abstr_rec.abstr_n;j++)
        {
           fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
           fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabsneu);
           /* hier koennte man noch eine Sicherung einbauen */
        }
      }
      fwrite(&ix04rec,sizeof(ix04rec),1,tmpix);
   }

   fclose(ix04file);
   fclose(tmpix);
   fclose(fpabs);
   fclose(fpabsneu);

   if (isfile(abstr_name)) remove(abstr_name);
   rename(abstr_name_neu,abstr_name);
   if (isfile(abstr_pix_name)) remove(abstr_pix_name);
   rename(tmpix_name,abstr_pix_name);
   return;
}

static void dateien_pruefen(void)
{
     if (
              (filesize(journal_name) < 3 * sizeof(one_journal_rec)) ||
              (filesize(quell_name) < 3 * sizeof(one_quell_rec)) ||
              (filesize(stichw_name) < 3 * sizeof(one_key_rec)) ||
              (filesize(abstr_name) < 3 * sizeof(one_abstr_rec))
       )
     {
       sprintf(fehlermeldung,"At least one database file < 3 records, restruct. "
               "not permitted");
       beenden(fehlermeldung,2);
     }
}

static void zerstoeren(int code)
{
   fprintf(fplog,"\nPerforming 'DestroyD'...");
   if (isfile(journal_name)) remove(journal_name);
   if (isfile(desc_name)) remove(desc_name);
   if (isfile(journal_pix_name)) remove(journal_pix_name);
   if (isfile(autorjl_name)) remove(autorjl_name);
   if (isfile(autorbu_name)) remove(autorbu_name);
   if (isfile(book_name)) remove(book_name);
   if (isfile(stichw_name)) remove(stichw_name);
   if (isfile(stichw_pix_name)) remove(stichw_pix_name);
   if (isfile(quell_name)) remove(quell_name);
   if (isfile(quell_pix_name)) remove(quell_pix_name);
   if (isfile(abstr_name)) remove(abstr_name);
   if (isfile(abstr_pix_name)) remove(abstr_pix_name);
   if (code==2)
   {
     if (isfile(fd_name)) remove(fd_name);
   }
   wrtxt("\n[No more data and index files in current directory, "
         "please press any key]>");
   tastelesen();

}
