/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   list_rfd.c: compile list of references, user defined
   Version 3.5
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include <signal.h>
#include <dos.h>
#include "refs.h"
#include "keycodes.h"
#include "ix01_fun.h"
#include "ix02_fun.h"
#include "fl_ut.h"
#include "str_fun.h"
#include "l_menu.h"
#include "str_refs.h"
#include "fd.h"
#include "list_rfd.h"
#include "abbruch.h"
#include "cfg_fun.h"

#define REFZAHL_LEN 7
#define TXTBUF_SIZE 15000
#define BBTBUF_SIZE 4000
#define ORDNUNGSZAHL_LEN 12

 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern char desc_name[PFAD_LEN];
 extern char book_name[PFAD_LEN];
 extern char autorjl_name[PFAD_LEN];
 extern char autorbu_name[PFAD_LEN];
 extern char quell_pix_name[PFAD_LEN];
 extern char quell_name[PFAD_LEN];
 static char txt_name[PFAD_LEN];
 static char log_name[PFAD_LEN];
 static char bbt_name[PFAD_LEN];
 static char haupt_schluessel[KENNZIFFER_LEN + 1];
 static char quell_schluessel[QUELLKUERZEL_LEN + 1];
 static char ordnungszahl[ORDNUNGSZAHL_LEN+1];
 extern char formdef_name[PFAD_LEN];
 static char txt_buf[TXTBUF_SIZE];
 static char bbt_buf[BBTBUF_SIZE];

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 static int fdau_n_j1;
 static int fdau_n_b1;
 static int fdau_n_b2au;
 static int fdau_n_b2ed;
 static int fdau_m_j1;
 static int fdau_m_b1;
 static int fdau_m_b2au;
 static int fdau_m_b2ed;
 static int fdedmax;
  /* Die hoechste Ziffernkennung in der Herausgeberliste */

 static long delaywrite;
 static int makromodus;
 static long formdef_datensatz;


 extern FILE * ix01file;
 extern FILE * ix02file;
 extern FILE * fpjournal;
 extern FILE * fpdesc;
 extern FILE * fpbuch;
 extern FILE * fpautorjl;
 extern FILE * fpautorbu;
 extern FILE * fpsource;
 static FILE * fpbbt;
 static FILE * fptxt;
 static FILE * fplog;
 extern FILE * fpformdef;


 static char * au_zeile;
 static char * ed_zeile;
 static char * ex_au_zeile;
 static char * ausgabe_zeile;
 static char * desc_zeile;

 extern config_set             one_config_set;

 extern journal_rec            one_journal_rec;
 extern desc_rec               one_desc_rec;
 extern buch_rec               one_buch_rec;
 extern quell_rec              one_quell_rec;
 extern refspix_rec            ix01rec;
 extern quellpix_rec           ix02rec;
 extern author_rec             one_aued_rec;
 static bbatchtable_rec        one_bbt_rec;
 static formdef_rec            fd;

 static int formdef_datensatz_lesen(void);
 static int getfilenames(void);
 static int dateien_oeffnen_list_rfd(void);
 static void dateien_schliessen_list_rfd(void);
 static void exarg01(char * zeile);
 static void machlist_list_rfd(void);
 static void compile_j1(void);
 static void compile_b1(void);
 static void compile_b2(void);
 static void j1_tit(void);
 static void j1_aut(void);
 static void j1_lok(void);
 static void b1_ed(void);
 static void b1_tit(void);
 static void b1_lok(void);
 static void b2_aut(void);
 static void b2_tit(void);
 static void b2_ed(void);
 static void b2_titb(void);
 static void b2_lok(void);


int list_rfd_main(char * mmodus, char * datpath)
{
     if (!strcmp(mmodus,"-m"))
     {
        makromodus = 1;
     }
     else
     {
        makromodus = 0;
     }
     delaywrite=one_config_set.delay_list_write;


     strcpy(journal_pix_name,datpath);strcat(journal_pix_name,"JOURNAL.IX");
     strcpy(journal_name,datpath);strcat(journal_name,"JOURNAL.DAT");
     strcpy(desc_name,datpath);strcat(desc_name,"DESC.DAT");
     strcpy(book_name,datpath);strcat(book_name,"BOOK.DAT");
     strcpy(autorjl_name,datpath);strcat(autorjl_name,"AUTORJL.DAT");
     strcpy(autorbu_name,datpath);strcat(autorbu_name,"AUTORBO.DAT");
     strcpy(quell_pix_name,datpath);strcat(quell_pix_name,"SOURCE.IX");
     strcpy(quell_name,datpath);strcat(quell_name,"SOURCE.DAT");
     strcpy(formdef_name,datpath);strcat(formdef_name,"FORMDEF.DAT");

     if (!getfilenames())
     {
          return 1;
     }
     if ((au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"LIST_RFD memory allocation error 001");
        beenden(fehlermeldung,2);
     }
     if ((ed_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"LIST_RFD memory allocation error 002");
        beenden(fehlermeldung,2);
     }
     if ((ex_au_zeile =  (char *) malloc((AUTORZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"LIST_RFD memory allocation error 003\n");
        beenden(fehlermeldung,2);
        return 1;
     }
     if ((ausgabe_zeile =  (char *) malloc((AUSGABEZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"LIST_RFD memory allocation error 004\n");
        beenden(fehlermeldung,2);
        return 1;
     }
     if ((desc_zeile =  (char *) malloc((DESC_ZEILE_LEN+1) * sizeof(char)))==NULL)
     {
        sprintf(fehlermeldung,"LIST_RFD memory allocation error 005\n");
        beenden(fehlermeldung,2);
        return 1;
     }
     if (dateien_oeffnen_list_rfd())
     {

       if (formdef_datensatz_lesen()) machlist_list_rfd();
       dateien_schliessen_list_rfd();
     }
     else
     {
        tastelesen();
     }


     free(au_zeile);
     free(ed_zeile);
     free(ex_au_zeile);
     free(ausgabe_zeile);
     free(desc_zeile);


     return 0;
}


static int formdef_datensatz_lesen(void)
{
   long i, j, anzahl_records, byte_zeiger, zahl, mn;
   int taste, ok;
   if (isfile(formdef_name) && filesize(formdef_name) >= sizeof(fd))
   {
      if ((fpformdef=fopen(formdef_name,"rb"))==0)
      {
        sprintf(fehlermeldung,"ERROR: cannot read %s",formdef_name);
        beenden(fehlermeldung,2);
      }
   }
   else
   {
      sprintf(wrtxtbu,"\n[%s does not exist/is empty]>",formdef_name);
      wrtxt(wrtxtbu);
      tastelesen();
      return 0;
   }

   if (!makromodus)
      wrtxt("\n[In the next screen, please select a *Reference List* format definition]>");
   else
      wrtxt("\n[In the next screen, please select a *Macro* format definition]>");
   tastelesen();

   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   cls_line("");

   fseek(fpformdef,0L,SEEK_END);
   byte_zeiger = ftell(fpformdef);
   anzahl_records = byte_zeiger/sizeof(fd);
   anzahl_records--;
   j = 1;
   rewind(fpformdef);
   for (i=0;i<=anzahl_records;i++)
   {
       if (fread(&fd,sizeof(fd),1,fpformdef)==0)
       {
         sprintf(fehlermeldung,"Cannot read record in %s",formdef_name);
         beenden(fehlermeldung,2);
       }
       // if ((j % 22)==0)
       if ((j % (one_config_set.sl-3))==0)
       {
          wrtxt("\n");
          taste=lotus_menu(
             "NextPage$Show the next page of format definitions"
             "@Cancel$Finish viewing the current text, enter the format definition code"
                          );
          if (taste==0 || taste==2)
          {
             sc_gotoxy(1,one_config_set.sl-2); break;
          }
          j++;
       }
       sprintf(wrtxtbu,"%6li %*s: %s\n",i,-FORMKENNUNG_LEN,fd.formkennung,fd.formatbeschreibung);
       wrtxt(wrtxtbu);
       j++;
   }
   wrtxt("\n\n");

   fclose(fpformdef);
   do
   {
       static char zahlstring[10];
       int ok;
       sc_gotoxy(1,one_config_set.sl-1);
       info_zeile("Please enter the number of the format definition to be selected");
       strcpy(wrtxtbu,"Format definition code.....");
       wrtxt(wrtxtbu);
       taste = e_zle(
                       1+strlen(wrtxtbu),
                       one_config_set.sl-1,
                       zahlstring,
                       4,
                       4,
                       0);
       if ((strlen(zahlstring)==0 && taste==ENTER_KEY) || (taste==ESC_KEY))
       {
          cls_line("");
          return 0;
       }
       string_in_long(zahlstring,&zahl,&ok);
       if (!ok || zahl<0 || zahl > anzahl_records) continue;
       if (taste==ENTER_KEY)
           break;

   } while (1);
   formdef_datensatz = zahl;
   byte_zeiger=formdef_datensatz*sizeof(fd);
   if ((fpformdef=fopen(formdef_name,"rb"))==0)
   {
     sprintf(fehlermeldung,"ERROR: cannot read %s",formdef_name);
     beenden(fehlermeldung,2);
   }

   fseek(fpformdef,byte_zeiger,SEEK_SET);
   fread(&fd,sizeof(fd),1,fpformdef);
   fclose(fpformdef);

   string_in_long(fd.fdau_n_j1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_j1=999; else fdau_n_j1 = mn;
   string_in_long(fd.fdau_n_b1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_b1=999; else fdau_n_b1 = mn;
   string_in_long(fd.fdau_n_b2au,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_b2au=999; else fdau_n_b2au = mn;
   string_in_long(fd.fdau_n_b2ed,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_n_b2ed=999; else fdau_n_b2ed = mn;

   string_in_long(fd.fdau_m_j1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_j1=999; else fdau_m_j1 = mn;
   string_in_long(fd.fdau_m_b1,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_b1=999; else fdau_m_b1 = mn;
   string_in_long(fd.fdau_m_b2au,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_b2au=999; else fdau_m_b2au = mn;
   string_in_long(fd.fdau_m_b2ed,&mn,&ok);
   if (!ok || mn < 1 || mn > 999) fdau_m_b2ed=999; else fdau_m_b2ed = mn;


   /* die folgenden 4 Zeilen eingefuegt am 12.07.1997 */
   if (fdau_n_j1 < fdau_m_j1) fdau_n_j1 = fdau_m_j1;
   if (fdau_n_b1 < fdau_m_b1) fdau_n_b1 = fdau_m_b1;
   if (fdau_n_b2au < fdau_m_b2au) fdau_n_b2au = fdau_m_b2au;
   if (fdau_n_b2ed < fdau_m_b2ed) fdau_n_b2ed = fdau_m_b2ed;

   exarg01(fd.fdbetwau_j1);
   exarg01(fd.fdbetwau_b1);
   exarg01(fd.fdbetwau_b2au);
   exarg01(fd.fdbetwau_b2ed);

   exarg01(fd.fdbetwaulast_j1);
   exarg01(fd.fdbetwaulast_b1);
   exarg01(fd.fdbetwaulast_b2au);
   exarg01(fd.fdbetwaulast_b2ed);

   exarg01(fd.fdv_j1);
   exarg01(fd.fdv_b1);
   exarg01(fd.fdv_b2au);
   exarg01(fd.fdv_b2ed);

   exarg01(fd.fdauvornach_j1);
   exarg01(fd.fdauvornach_b1);
   exarg01(fd.fdauvornach_b2au);
   exarg01(fd.fdauvornach_b2ed);

   exarg01(fd.fdaunachvor_j1);
   exarg01(fd.fdaunachvor_b1);
   exarg01(fd.fdaunachvor_b2au);
   exarg01(fd.fdaunachvor_b2ed);

   exarg01(fd.fdafterlastau_j1);
   exarg01(fd.fdafterlastau_b1);
   exarg01(fd.fdafterlastau_b2au);
   exarg01(fd.fdafterlastau_b2ed);

   exarg01(fd.fdweitereau_j1);
   exarg01(fd.fdweitereau_b1);
   exarg01(fd.fdweitereau_b2au);
   exarg01(fd.fdweitereau_b2ed);

   return 1;
}


static int getfilenames(void)
{
  int taste;
  static char eingabe[DOSDATEIVORNAME_LEN +1];
  static int dateipos;

  strcpy(eingabe,"");
  do
  {
    if (strlen(eingabe)==0)
    {
       if (!makromodus)
       {
          strcpy(eingabe,"REFLIST");
       } else
       {
          strcpy(eingabe,"MACRO");
       }
    }
    if (!makromodus)
        cls_line("REFERENCES VERSION 3.5 * LIST - USER-DEFINED FORMATS");
    else
        cls_line("REFERENCES VERSION 3.5 * LIST - MACROS");

    info_zeile("Edit filename for text/macro file, extension '.TXT' will be appended");
    strcpy(wrtxtbu,"File name......");
    wrtxt(wrtxtbu);
    taste = e_zle(
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  eingabe,
                  DOSDATEIVORNAME_LEN,
                  DOSDATEIVORNAME_LEN,
                  0
                     );

    sc_gotoxy(1,one_config_set.sl);sc_clreol();
    /* Zeile ergaenzt am 23.5.1998 */
    sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
    if (taste==ESC_KEY)
    {
        cls_line("");
        return 0;
    }
    if (!isdosfilename(eingabe)) continue;
    if (taste==ENTER_KEY && strlen(eingabe) > 0) break;
  } while (1);
  upper(eingabe);
  strcpy(txt_name,eingabe);
  if (makromodus==1)
  {
     strcat(txt_name,".TXT");
  }
  else
  {
     strcat(txt_name,".TXT");
  }
  strcpy(log_name,eingabe);
  strcat(log_name,".LOG");
  if (isfile(txt_name))
  {
     taste = lotus_menu("Cancel$File with the name already exists, do not overwrite"
                "@Overwrite$The contents of the existing file will be lost");
     if (taste<=1) return 0;
  }

  taste = datei_suchen_default("*.BBT",bbt_name,&dateipos);
  if (taste) return 1;
  else
  {
     wrtxt("\n[Please press any key]>");
     tastelesen();
     return 0;
  }
}


static int dateien_oeffnen_list_rfd(void)
{
  if (filesize(journal_pix_name)==0)
  {
    wrtxt("ERROR: main index file is empty\n");
    return 0;
  }
  if (!read_ix01(journal_pix_name)) return 0;
  if (!read_ix02(quell_pix_name)) return 0;
  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",journal_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    return 0;
  }
  if ((fpdesc=fopen(desc_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",desc_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    return 0;
  }

  if ((fpbuch=fopen(book_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",book_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    return 0;
  }
  if ((fpautorjl=fopen(autorjl_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",autorjl_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    return 0;
  }
  if ((fpautorbu=fopen(autorbu_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",autorbu_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    return 0;
  }

  if ((fpbbt=fopen(bbt_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",bbt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    return 0;
  }
  if (setvbuf(fpbbt,bbt_buf,_IOFBF,BBTBUF_SIZE)!=0)
  {
    wrtxt("ERROR: Cannot allocate memory for fpbbt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fpsource=fopen(quell_name,"rb"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: cannot read %s\n",quell_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    return 0;
  }

  if ((fptxt=fopen(txt_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: write read %s\n",txt_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    return 0;
  }
  if (setvbuf(fptxt,txt_buf,_IOFBF,TXTBUF_SIZE)!=0)
  {
    wrtxt("ERROR: Cannot allocate memory for fptxt\n");
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fptxt);
    return 0;
  }
  if ((fplog=fopen(log_name,"w"))==NULL)
  {
    sprintf(wrtxtbu,"ERROR: write read %s\n",log_name);
    wrtxt(wrtxtbu);
    close_ix01();
    close_ix02();
    fclose(fpjournal);
    fclose(fpdesc);
    fclose(fpbuch);
    fclose(fpautorjl);
    fclose(fpautorbu);
    fclose(fpbbt);
    fclose(fpsource);
    fclose(fptxt);
    return 0;
  }

  return 1;
}

static void dateien_schliessen_list_rfd(void)
{
   close_ix01();
   close_ix02();
   fclose(fpjournal);
   fclose(fpdesc);
   fclose(fpbuch);
   fclose(fpautorjl);
   fclose(fpautorbu);
   fclose(fpbbt);
   fclose(fpsource);
   fclose(fptxt);
   fclose(fplog);
}


static void exarg01(char * zeile)
{
   char hilfsvar[FD_FELD_LEN + 1];
   if (extractargument("%()", zeile, hilfsvar)==1)
       strcpy(zeile,hilfsvar);
}



static void machlist_list_rfd(void)
{
   long i, j, byte_zeiger, rec_zeiger, anzahl_records;
   static int menupos, taste, ok;
   char zahl[REFZAHL_LEN+1];
   int schleifeok;
   long verzoegerung;

   fseek(fpbbt,0L,SEEK_END);
   byte_zeiger = ftell(fpbbt);
   anzahl_records = byte_zeiger/sizeof(one_bbt_rec);
   anzahl_records--;
   strcpy(zahl,"1");
   if (anzahl_records==-1)
   {
      sc_gotoxy(1,one_config_set.sl-1);
      sc_clreol();
      wrtxt("\n[Current BBT-file is empty, please press any key]>");
      sc_clreol();
      tastelesen();
      return;
   }

   if (!makromodus)
   {
       taste=lotus_menu_default(
          &menupos,
         "@1:[]$Leading number: [1] REFERENCE..."
         "@2:[]<>$Leading number and reference number [1] <REFNO> REFERENCE..."
         "@3:<>$Leading reference number <REFNO> REFEREENCE..."
         "@4:VOID$No leading numbers"
                              );
   }
   else
   {
      taste = 4;
   }

   if (taste==0)
   {
      return;
   }
     /* folg. Zeile geaendert, wg. %n ist diese Abfrage stets erforderlich */
   if (taste==1 || taste==2 || taste==3 || taste==4)
   {
    schleifeok = 0;
    do
    {
      int wahl;
      sc_gotoxy(1,one_config_set.sl-1);
      sc_clreol();
      info_zeile("Enter number assigned to the first reference");
      strcpy(wrtxtbu,"[n].......");
      wrtxt(wrtxtbu);
      wahl = e_zle(
                      1+strlen(wrtxtbu),
                      one_config_set.sl-1,
                      zahl,
                      REFZAHL_LEN,
                      REFZAHL_LEN,
                      0);
      string_in_long(zahl,&j,&ok);
      if ((ok) && wahl==ENTER_KEY) schleifeok=1; else schleifeok=0;
      sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
      sc_gotoxy(1,one_config_set.sl);sc_clreol();
      sc_gotoxy(1,one_config_set.sl-1);

     }
     while (!schleifeok);
   }

  schleifeok = 0;
  strcpy(zahl,"0");
  do
  {
    int wahl;
    sc_gotoxy(1,one_config_set.sl-1);
    info_zeile("Enter delay time between processing of references in milliseconds");
    strcpy(wrtxtbu,"[msec]....");
    wrtxt(wrtxtbu);
    wahl = e_zle(
                  1+strlen(wrtxtbu),
                  one_config_set.sl-1,
                  zahl,
                  REFZAHL_LEN,
                  REFZAHL_LEN,
                  0);
    string_in_long(zahl,&verzoegerung,&ok);
    if ((ok) && wahl==ENTER_KEY && verzoegerung >=0 && verzoegerung <= 5000) schleifeok=1; else schleifeok=0;
    sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
    sc_gotoxy(1,one_config_set.sl);sc_clreol();
    sc_gotoxy(1,one_config_set.sl-1);

   }
   while (!schleifeok);

   /* eingefuegt 24.1.99 */
   sc_gotoxy(1,one_config_set.sl);
   sprintf(wrtxtbu,"Compiling %li references, please wait...\n",anzahl_records+1);
   wrtxt(wrtxtbu);
   rewind(fpbbt);
   for (i=0;i<=anzahl_records;i++)
   {
        sprintf(ordnungszahl,"%li",j);
#if defined(__EMX__)
        if (verzoegerung > 0) _sleep2((unsigned) verzoegerung);
#endif
#if defined(__DJGPP__)
        if (verzoegerung > 0) delay((unsigned) verzoegerung);
#endif
        if (abbrechen()) return;
        sc_gotoxy(1,one_config_set.sl);
        sprintf(wrtxtbu,"%.1f%% completed", (double) 100.0*(i+1)/(anzahl_records+1));
        wrtxt(wrtxtbu);
        sc_clreol();sc_gotoxy(1,one_config_set.sl);
        fread(&one_bbt_rec, sizeof(one_bbt_rec),1,fpbbt);

        strlimcpy(haupt_schluessel,one_bbt_rec.kennziffer,KENNZIFFER_LEN);
        if (locate_ix01(haupt_schluessel,&ix01rec) > -1)
        {
           rec_zeiger = ix01rec.journal_rptr;
           byte_zeiger = rec_zeiger * sizeof(one_journal_rec);
           fseek(fpjournal,byte_zeiger,SEEK_SET);
           fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

           if (ix01rec.desc_rptr > -1)
           {
              kwdsstr(desc_zeile,ix01rec.desc_rptr);
           }

           if (taste==1) sprintf(ausgabe_zeile,"[%li] ",j);
           else if (taste==2) sprintf(ausgabe_zeile,"[%li] <%s> ",j,haupt_schluessel);
           else if (taste==3) sprintf(ausgabe_zeile,"<%s> ",haupt_schluessel);
           else strcpy(ausgabe_zeile,"");

           if (!strcmp(one_journal_rec.reftyp,"j1")) compile_j1();
           else if (!strcmp(one_journal_rec.reftyp,"b1")) compile_b1();
           else compile_b2();

           if   (fprintf(fptxt,"%s\n",ausgabe_zeile)==EOF)
           {
              sprintf(fehlermeldung,"FATAL ERROR: cannot write "
                      "into output file");
              beenden(fehlermeldung,2);
           }
           if (!makromodus)
           {
               if   (fprintf(fptxt,"\n")==EOF)
               {
                  sprintf(fehlermeldung,"FATAL ERROR: cannot write "
                          "into output file");
                  beenden(fehlermeldung,2);
               }
           }
           if (delaywrite > 0)
           {
#if defined(__EMX__)
              if (((i+1) % 200)==0) { _sleep2 (delaywrite); }
#endif
#if defined(__DJGPP__)
              if (((i+1) % 200)==0) { delay(delaywrite); }
#endif
           }

        }
        else
          if (fprintf(fplog,"# %s: Reference not found\n",haupt_schluessel)==EOF)
          {
             sprintf(fehlermeldung,"FATAL ERROR: Cannot write into LOG-File");
             beenden(fehlermeldung,2);
          }
        j++;
   }
   sc_gotoxy(1,one_config_set.sl);sc_clreol();
   sprintf(wrtxtbu,"\n[Done: textfile %s closed, please press any key]>",txt_name);
   wrtxt(wrtxtbu);

   tastelesen();
}




static void compile_j1(void)
{
   if (!strcmp(fd.fdauttyp_j1,"3"))
   {
     fdautorenstr3(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                 );
   }
   else if (!strcmp(fd.fdauttyp_j1,"2"))
   {
     fdautorenstr2(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                 );
   }
   else if (!strcmp(fd.fdauttyp_j1,"1"))
   {
     fdautorenstr1(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                  );
   }
   else
   {
     fdautorenstr0(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_j1,
                  fd.fdbetwaulast_j1,
                  fd.fdv_j1,
                  fd.fdauvornach_j1,
                  fd.fdaunachvor_j1,
                  fd.fdafterlastau_j1,
                  fd.fdweitereau_j1,
                  fdau_n_j1,
                  fdau_m_j1
                  );
   }




   strncpy(quell_schluessel,one_journal_rec.kuerzel,KUERZEL_LEN);
   if (locate_ix02(quell_schluessel,&ix02rec) > -1)
   {
       long byte_zeiger;
       byte_zeiger = ix02rec.quell_rptr * sizeof(one_quell_rec);
       fseek(fpsource,byte_zeiger,SEEK_SET);
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpsource);
   }
   else
   {
      strcpy(one_quell_rec.quell_zeitschrift,"[");
      strcat(one_quell_rec.quell_zeitschrift,quell_schluessel);
      strcat(one_quell_rec.quell_zeitschrift,"]");
      strcpy(one_quell_rec.quell_kurzform,"");

      if (fprintf(fplog,"# %s: JOURNAL name corresponding to [%s] not found\n",haupt_schluessel,quell_schluessel)==EOF)
      {
             sprintf(fehlermeldung,"FATAL ERROR: Cannot write into LOG-File");
             beenden(fehlermeldung,2);
      }
   }



   if (!strcmp(fd.fdj1_str1,"%au"))
   {
     j1_aut();
   }
   if (!strcmp(fd.fdj1_str1,"%ti"))
   {
     j1_tit();
   }
   if (!strcmp(fd.fdj1_str1,"%lo"))
   {
     j1_lok();
   }

   if (!strcmp(fd.fdj1_str2,"%au"))
   {
     j1_aut();
   }
   if (!strcmp(fd.fdj1_str2,"%ti"))
   {
     j1_tit();
   }
   if (!strcmp(fd.fdj1_str2,"%lo"))
   {
     j1_lok();
   }

   if (!strcmp(fd.fdj1_str3,"%au"))
   {
     j1_aut();
   }
   if (!strcmp(fd.fdj1_str3,"%ti"))
   {
     j1_tit();
   }
   if (!strcmp(fd.fdj1_str3,"%lo"))
   {
     j1_lok();
   }
}


static void compile_b1(void)
{
   long byte_zeiger;

   if (!strcmp(fd.fdauttyp_b1,"3"))
   {
     fdedmax = fdautorenstr3(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                 );
   }
   else if (!strcmp(fd.fdauttyp_b1,"2"))
   {
     fdedmax = fdautorenstr2(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                 );
   }
   else if (!strcmp(fd.fdauttyp_b1,"1"))
   {
     fdedmax = fdautorenstr1(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                  );
   }
   else
   {
     fdedmax = fdautorenstr0(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b1,
                  fd.fdbetwaulast_b1,
                  fd.fdv_b1,
                  fd.fdauvornach_b1,
                  fd.fdaunachvor_b1,
                  fd.fdafterlastau_b1,
                  fd.fdweitereau_b1,
                  fdau_n_b1,
                  fdau_m_b1
                  );
   }

   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);

   if (!strcmp(fd.fdb1_str1,"%ed"))
   {
     b1_ed();
   }
   if (!strcmp(fd.fdb1_str1,"%bo"))
   {
     b1_tit();
   }
   if (!strcmp(fd.fdb1_str1,"%lo"))
   {
     b1_lok();
   }

   if (!strcmp(fd.fdb1_str2,"%ed"))
   {
     b1_ed();
   }
   if (!strcmp(fd.fdb1_str2,"%bo"))
   {
     b1_tit();
   }
   if (!strcmp(fd.fdb1_str2,"%lo"))
   {
     b1_lok();
   }

   if (!strcmp(fd.fdb1_str3,"%ed"))
   {
     b1_ed();
   }
   if (!strcmp(fd.fdb1_str3,"%bo"))
   {
     b1_tit();
   }
   if (!strcmp(fd.fdb1_str3,"%lo"))
   {
     b1_lok();
   }

   return;
}



static void compile_b2(void)
{
   long byte_zeiger;

   if (!strcmp(fd.fdauttyp_b2au,"3"))
   {
     fdautorenstr3(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2au,"2"))
   {
     fdautorenstr2(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2au,"1"))
   {
     fdautorenstr1(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                  );
   }
   else
   {
     fdautorenstr0(fpautorjl,
                  au_zeile,
                  ix01rec.autorjl_rptr,
                  fd.fdbetwau_b2au,
                  fd.fdbetwaulast_b2au,
                  fd.fdv_b2au,
                  fd.fdauvornach_b2au,
                  fd.fdaunachvor_b2au,
                  fd.fdafterlastau_b2au,
                  fd.fdweitereau_b2au,
                  fdau_n_b2au,
                  fdau_m_b2au
                  );
   }



   if (!strcmp(fd.fdauttyp_b2ed,"3"))
   {
     fdedmax = fdautorenstr3(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2ed,"2"))
   {
     fdedmax = fdautorenstr2(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                 );
   }
   else if (!strcmp(fd.fdauttyp_b2ed,"1"))
   {
     fdedmax = fdautorenstr1(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                  );
   }
   else
   {
     fdedmax = fdautorenstr0(fpautorbu,
                  ed_zeile,
                  ix01rec.autorbu_rptr,
                  fd.fdbetwau_b2ed,
                  fd.fdbetwaulast_b2ed,
                  fd.fdv_b2ed,
                  fd.fdauvornach_b2ed,
                  fd.fdaunachvor_b2ed,
                  fd.fdafterlastau_b2ed,
                  fd.fdweitereau_b2ed,
                  fdau_n_b2ed,
                  fdau_m_b2ed
                  );
   }


   byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
   fseek(fpbuch,byte_zeiger,SEEK_SET);
   fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);


   if (!strcmp(fd.fdb2_str1,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str1,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str1,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str1,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str1,"%lo"))
   {
     b2_lok();
   }


   if (!strcmp(fd.fdb2_str2,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str2,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str2,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str2,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str2,"%lo"))
   {
     b2_lok();
   }



   if (!strcmp(fd.fdb2_str3,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str3,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str3,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str3,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str3,"%lo"))
   {
     b2_lok();
   }

   if (!strcmp(fd.fdb2_str4,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str4,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str4,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str4,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str4,"%lo"))
   {
     b2_lok();
   }


   if (!strcmp(fd.fdb2_str5,"%ed"))
   {
     b2_ed();
   }
   if (!strcmp(fd.fdb2_str5,"%au"))
   {
     b2_aut();
   }
   if (!strcmp(fd.fdb2_str5,"%ti"))
   {
     b2_tit();
   }
   if (!strcmp(fd.fdb2_str5,"%bo"))
   {
     b2_titb();
   }
   if (!strcmp(fd.fdb2_str5,"%lo"))
   {
     b2_lok();
   }
   return;
}



static int fdautorenstr0(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {
        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}




static int fdautorenstr1(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   char vn[2];

   int n_vornamen, k;
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
   strlimcat(auedstring,fdaunachvor,AUTORZEILE_LEN);
   n_vornamen=strlen(one_aued_rec.au_vornamen);
   for (k=0;k<=n_vornamen-1;k++)
   {
      vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
      strlimcat(auedstring,vn,AUTORZEILE_LEN);
      strlimcat(auedstring,fdv,AUTORZEILE_LEN);
   }
   rtrim(auedstring,' ');

   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {
        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);
        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        strlimcat(auedstring,fdaunachvor,AUTORZEILE_LEN);

        n_vornamen=strlen(one_aued_rec.au_vornamen);
        for (k=0;k<=n_vornamen-1;k++)
        {
           vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
           strlimcat(auedstring,vn,AUTORZEILE_LEN);
           strlimcat(auedstring,fdv,AUTORZEILE_LEN);
        }
        rtrim(auedstring,' ');
        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}


static int fdautorenstr2(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   char vn[2];

   int n_vornamen, k;
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);


   n_vornamen=strlen(one_aued_rec.au_vornamen);
   for (k=0;k<=n_vornamen-1;k++)
   {
      vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
      strlimcat(auedstring,vn,AUTORZEILE_LEN);
      strlimcat(auedstring,fdv,AUTORZEILE_LEN);
   }
   rtrim(auedstring,' ');
   strlimcat(auedstring,fdauvornach,AUTORZEILE_LEN);
   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);


   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {

        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        n_vornamen=strlen(one_aued_rec.au_vornamen);
        for (k=0;k<=n_vornamen-1;k++)
        {
           vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
           strlimcat(auedstring,vn,AUTORZEILE_LEN);
           strlimcat(auedstring,fdv,AUTORZEILE_LEN);
        }

        rtrim(auedstring,' ');
        strlimcat(auedstring,fdauvornach,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}


static int fdautorenstr3(FILE * fpaued,
                  char * auedstring,
                  long zeiger,
                  char * fdbetwau,
                  char * fdbetwaulast,
                  char * fdv,
                  char * fdauvornach,
                  char * fdaunachvor,
                  char * fdafterlastau,
                  char * fdweitereau,
                  int fdau_n,
                  int fdau_m
                  )
{
   int anzahl_n, i, etalzufuegen;
   long byte_zeiger;
   char fdzwiau[FD_FELD_LEN+1];
   char vn[2];

   int n_vornamen, k;
   strcpy(auedstring,"");
   etalzufuegen = 0;
   byte_zeiger = zeiger * sizeof(one_aued_rec);
   fseek(fpaued,byte_zeiger,SEEK_SET);
   fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

   strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);
   strlimcat(auedstring,fdaunachvor,AUTORZEILE_LEN);
   n_vornamen=strlen(one_aued_rec.au_vornamen);
   for (k=0;k<=n_vornamen-1;k++)
   {
      vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
      strlimcat(auedstring,vn,AUTORZEILE_LEN);
      strlimcat(auedstring,fdv,AUTORZEILE_LEN);
   }

   rtrim(auedstring,' ');

   anzahl_n = one_aued_rec.au_n;
   for (i=2;i<=anzahl_n;i++)
   {

        /* die if-Bedingung eingefuegt am 12.7.1997 */
        if (fdau_m==1 && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }

        if (i < anzahl_n) strcpy(fdzwiau,fdbetwau); else strcpy(fdzwiau,fdbetwaulast);
        fread(&one_aued_rec,sizeof(one_aued_rec),1,fpaued);

        strlimcat(auedstring,fdzwiau,AUTORZEILE_LEN);
        n_vornamen=strlen(one_aued_rec.au_vornamen);
        for (k=0;k<=n_vornamen-1;k++)
        {
           vn[0] = one_aued_rec.au_vornamen[k]; vn[1] = '\0';
           strlimcat(auedstring,vn,AUTORZEILE_LEN);
           strlimcat(auedstring,fdv,AUTORZEILE_LEN);
        }

        rtrim(auedstring,' ');
        strlimcat(auedstring,fdauvornach,AUTORZEILE_LEN);
        strlimcat(auedstring,one_aued_rec.au_nachname,AUTORZEILE_LEN);

        if (i==fdau_m && anzahl_n > fdau_n)
        {
           etalzufuegen = 1;
           break;
        }
   }
   if (etalzufuegen) strlimcat(auedstring,fdweitereau,AUTORZEILE_LEN);
         else strlimcat(auedstring,fdafterlastau,AUTORZEILE_LEN);
   return anzahl_n;
}


static int kwdsstr(char * desc_zeile, long zeiger)
{
   int n_desc, i;
   long byte_zeiger;

   strcpy(desc_zeile,"");
   byte_zeiger = zeiger * sizeof(one_desc_rec);
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
   n_desc = one_desc_rec.desc_n;
   fseek(fpdesc,byte_zeiger,SEEK_SET);
   for (i=1;i<=n_desc;i++)
   {
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      strlimcat(desc_zeile,one_desc_rec.keywordsfield,DESC_ZEILE_LEN);
      if (i < n_desc)
      {
         strlimcat(desc_zeile,", ",DESC_ZEILE_LEN);
      }
   }
   return 1;
}


static void j1_aut(void)
{
   int i;
   for (i=0;i<J1_AUT_N;i++)
   {
     if (!strcmp(fd.j1_aut[i],"%auth"))
     {
        strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_aut[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j1_aut[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.j1_aut[i],AUSGABEZEILE_LEN);
   }
}


static void j1_tit(void)
{
   int i;
   for (i=0;i<J1_TIT_N;i++)
   {
     if (!strcmp(fd.j1_tit[i],"%title"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }

     else if  (!strcmp(fd.j1_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j1_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.j1_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.j1_tit[i],AUSGABEZEILE_LEN);
   }
}



static void j1_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char quell_kurz_del[2*KURZFORM_LEN + 1];
   for (i=0;i<J1_LOK_N;i++)
   {
     if (!strcmp(fd.j1_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%month"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.monat,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%m()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.monat) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%day"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.tag,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%d()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.tag) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%journ"))
     {
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%journsh"))
     {
        if (strlen(one_quell_rec.quell_kurzform) > 0)
          strlimcat(ausgabe_zeile,one_quell_rec.quell_kurzform,AUSGABEZEILE_LEN);
        else
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%issn"))
     {
        strlimcat(ausgabe_zeile,one_quell_rec.quell_issn,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%isn()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_quell_rec.quell_issn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%journ4l"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.kuerzel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%status"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.status,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%js()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_quell_rec.quell_kurzform) > 0)
        {
          fdjsdelimiter(one_quell_rec.quell_kurzform, quell_kurz_del, argument1, 2*KURZFORM_LEN);
          strlimcat(ausgabe_zeile,quell_kurz_del,AUSGABEZEILE_LEN);
        }
        else
        strlimcat(ausgabe_zeile,one_quell_rec.quell_zeitschrift,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%volume"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%v()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%issuenum"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.issue_nummer,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%inu()",fd.j1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.issue_nummer) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.j1_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.j1_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.j1_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.j1_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }

     else strlimcat(ausgabe_zeile,fd.j1_lok[i],AUSGABEZEILE_LEN);
   }
}

static void b1_ed(void)
{
   int i;
   for (i=0;i<B1_ED_N;i++)
   {
      if (!strcmp(fd.b1_ed[i],"%edits"))
      {
         strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%refnr"))
      {
         strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%n"))
      {
         strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%year"))
      {
         strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%space"))
      {
         strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%endline"))
      {
         strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%fullstop"))
      {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%EdEds"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"Editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"Editors",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b1_ed[i],"%ededs"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"editors",AUSGABEZEILE_LEN);
      }
      else strlimcat(ausgabe_zeile,fd.b1_ed[i],AUSGABEZEILE_LEN);
   }
}

static void b1_tit(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];

   for (i=0;i<B1_TIT_N;i++)
   {
     if (!strcmp(fd.b1_tit[i],"%titlebo"))
     {
        strlimcat(ausgabe_zeile,one_buch_rec.titel_bu, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.b1_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_tit[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b1_tit[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b1_tit[i], AUSGABEZEILE_LEN);
   }
}

static void b1_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char ort_ex[PUBLORT_LEN+1];
   for (i=0;i<B1_LOK_N;i++)
   {
     if (!strcmp(fd.b1_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%place"))
     {
         extractitem(1,one_buch_rec.publ_ort,",",ort_ex);
         trim(ort_ex,' ');
         strlimcat(ausgabe_zeile,ort_ex,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%places"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.publ_ort, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%publisher"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.verlag, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%isbn"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.isbn, AUSGABEZEILE_LEN);
     }
     else if (extractargument("%ibn()",fd.b1_lok[i],argument1))
     {
        if (strlen(one_buch_rec.isbn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%status"))
     {
         strlimcat(ausgabe_zeile, one_journal_rec.status, AUSGABEZEILE_LEN);
     }

     else if (!strcmp(fd.b1_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b1_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.b1_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.b1_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else if (extractargument("%p()",fd.b1_lok[i],argument1))
     {
        if (strlen(one_journal_rec.seite_von) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile, fd.b1_lok[i],AUSGABEZEILE_LEN);
   }

}


static void b2_aut(void)
{
   int i;
   for (i=0;i<B2_AUT_N;i++)
   {
     if (!strcmp(fd.b2_aut[i],"%auth"))
     {
        strlimcat(ausgabe_zeile,au_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_aut[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.b2_aut[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b2_aut[i],AUSGABEZEILE_LEN);
   }
}

static void b2_tit(void)
{
   int i;
   for (i=0;i<B2_TIT_N;i++)
   {
     if (!strcmp(fd.b2_tit[i],"%title"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.titel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }

     else if (!strcmp(fd.b2_tit[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_tit[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b2_tit[i],AUSGABEZEILE_LEN);
   }
}

static void b2_ed(void)
{
   int i;
   for (i=0;i<B2_ED_N;i++)
   {
      if (!strcmp(fd.b2_ed[i],"%edits"))
      {
         strlimcat(ausgabe_zeile,ed_zeile,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%refnr"))
      {
         strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%n"))
      {
         strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%year"))
      {
         strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%space"))
      {
         strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%endline"))
      {
         strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%fullstop"))
      {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%EdEds"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"Editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"Editors",AUSGABEZEILE_LEN);
      }
      else if (!strcmp(fd.b2_ed[i],"%ededs"))
      {
         if (fdedmax <= 1)
            strlimcat(ausgabe_zeile,"editor",AUSGABEZEILE_LEN);
         else
            strlimcat(ausgabe_zeile,"editors",AUSGABEZEILE_LEN);
      }
      else strlimcat(ausgabe_zeile,fd.b2_ed[i],AUSGABEZEILE_LEN);
   }
}

static void b2_titb(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];

   for (i=0;i<B2_TITB_N;i++)
   {
     if (!strcmp(fd.b2_titb[i],"%titlebo"))
     {
        strlimcat(ausgabe_zeile,one_buch_rec.titel_bu, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%refnr"))
     {
        strlimcat(ausgabe_zeile,haupt_schluessel,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%n"))
     {
        strlimcat(ausgabe_zeile,ordnungszahl,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if  (!strcmp(fd.b2_titb[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_titb[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b2_titb[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else strlimcat(ausgabe_zeile,fd.b2_titb[i], AUSGABEZEILE_LEN);
   }
}

static void b2_lok(void)
{
   int i;
   char argument1[FD_FELD_LEN + 1];
   char ort_ex[PUBLORT_LEN+1];
   for (i=0;i<B2_LOK_N;i++)
   {
     if (!strcmp(fd.b2_lok[i],"%year"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.jahrgang,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%space"))
     {
        strlimcat(ausgabe_zeile," ",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%endline"))
     {
        strlimcat(ausgabe_zeile,"\n",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%kwds"))
     {
        strlimcat(ausgabe_zeile,desc_zeile,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%fullstop"))
     {
        if (!satzzeichen(ausgabe_zeile))
        strlimcat(ausgabe_zeile,".",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%edno"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,one_journal_rec.band,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%Edition"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Edition",AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%Auflage"))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,". Auflage",AUSGABEZEILE_LEN);
     }
     else if (extractargument("%e()",fd.b2_lok[i],argument1))
     {
        if (strlen(one_journal_rec.band) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%place"))
     {
         extractitem(1,one_buch_rec.publ_ort,",",ort_ex);
         trim(ort_ex,' ');
         strlimcat(ausgabe_zeile,ort_ex,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%places"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.publ_ort, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%publisher"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.verlag, AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%isbn"))
     {
         strlimcat(ausgabe_zeile, one_buch_rec.isbn, AUSGABEZEILE_LEN);
     }
     else if (extractargument("%ibn()",fd.b2_lok[i],argument1))
     {
        if (strlen(one_buch_rec.isbn) > 0)
           strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%status"))
     {
         strlimcat(ausgabe_zeile, one_journal_rec.status, AUSGABEZEILE_LEN);
     }

     else if (!strcmp(fd.b2_lok[i],"%pagefrom"))
     {
        strlimcat(ausgabe_zeile,one_journal_rec.seite_von,AUSGABEZEILE_LEN);
     }
     else if (!strcmp(fd.b2_lok[i],"%pageto"))
     {
        if (strlen(one_journal_rec.seite_bis)==0 || strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0)
        {
          strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile, one_journal_rec.seite_bis, AUSGABEZEILE_LEN);
        }
     }
     else if (!strcmp(fd.b2_lok[i],"%pagetosh"))
     {
        seitenziffern(one_journal_rec.seite_von, one_journal_rec.seite_bis);
        strlimcat(ausgabe_zeile,one_journal_rec.seite_bis,AUSGABEZEILE_LEN);
     }
     else if (extractargument("%pgs()",fd.b2_lok[i],argument1))
     {
        if (strcmp(one_journal_rec.seite_von, one_journal_rec.seite_bis)==0
           || strlen(one_journal_rec.seite_bis)==0)
        {
           strcat(ausgabe_zeile,"");
        }
        else
        {
          strlimcat(ausgabe_zeile,argument1,AUSGABEZEILE_LEN);
        }
     }
     else strlimcat(ausgabe_zeile,fd.b2_lok[i],AUSGABEZEILE_LEN);
   }
}

#undef REFZAHL_LEN
