/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000 Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/

/*
   fil_fun.c: Loeschen und Umbenennen von Datensaetzen, manuelle
              Eingabe der Kennziffer

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include <signal.h>
#include <dos.h>
#include "ix01_fun.h"
#include "ix04_fun.h"
#include "fl_ut.h"
#include "l_menu.h"
#include "str_fun.h"
#include "fil_fun.h"
#include "sortix01.h"
#include "sortix04.h"
#include "abbruch.h"
#include "cfg_fun.h"
#include "keycodes.h"

 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];

 extern FILE * ix01file;
 extern FILE * ix04file;

 extern config_set one_config_set;

 extern journal_rec one_journal_rec;
 extern desc_rec one_desc_rec;
 extern buch_rec one_buch_rec;
 extern refspix_rec ix01rec;
 extern abstrpix_rec ix04rec;
 extern abstr_rec one_abstr_rec;
 extern author_rec one_aued_rec;

 extern char journal_pix_name[PFAD_LEN];
 extern char journal_name[PFAD_LEN];
 extern FILE * fpjournal;
 extern char desc_name[PFAD_LEN];
 extern FILE * fpdesc;
 extern char book_name[PFAD_LEN];
 extern FILE * fpbuch;
 extern char autorjl_name[PFAD_LEN];
 extern FILE * fpautorjl;
 extern char autorbu_name[PFAD_LEN];
 extern FILE * fpautorbu;
 static FILE * tmpix;
 static char tmpix_name[PFAD_LEN];
 static char newix_name[PFAD_LEN];

 extern char abstr_dat_name[PFAD_LEN];
 extern FILE * fpabs;
 extern char abstr_pix_name[PFAD_LEN];

 static FILE * tmpix_abs;
 static char tmpix_abs_name[PFAD_LEN];
 static char newix_abs_name[PFAD_LEN];


 static char schluessel[KENNZIFFER_LEN + 2];
 static char schluessel_neu[KENNZIFFER_LEN + 2];

int fil_fun_main(char * datpath)
{

 int taste;
 strncpy(schluessel,"",KENNZIFFER_LEN);
 strncpy(schluessel_neu,"",KENNZIFFER_LEN);

 strcpy(journal_pix_name,datpath);strcat(journal_pix_name,"JOURNAL.IX");
 strcpy(journal_name,datpath);strcat(journal_name,"JOURNAL.DAT");
 strcpy(desc_name,datpath);strcat(desc_name,"DESC.DAT");
 strcpy(book_name,datpath);strcat(book_name,"BOOK.DAT");
 strcpy(autorjl_name,datpath);strcat(autorjl_name,"AUTORJL.DAT");
 strcpy(autorbu_name,datpath);strcat(autorbu_name,"AUTORBO.DAT");
 strcpy(tmpix_name,"TMP01.IX$");
 strcpy(newix_name,"NEW01.IX$");
 strcpy(abstr_dat_name,datpath);strcat(abstr_dat_name,"ABST.DAT");
 strcpy(abstr_pix_name,datpath);strcat(abstr_pix_name,"ABST.IX");
 strcpy(tmpix_abs_name,"TMP02.IX$");
 strcpy(newix_abs_name,"NEW02.IX$");
 do
 {
     static int menupos;
     cls_line( "REFERENCES VERSION 3.5 * FILE MAINTENANCE FUNCTIONS: DELETE/RENAME RECORDS");
     taste = lotus_menu_default(&menupos,FIL_FUN_MENU01);
     if (taste==1)
     {
         steuerung_ds_loeschen();
     }
     if (taste==2)
     {
        if (key_entry("Enter number of an existing reference to be renamed, [Esc] Quit",
                      schluessel))
        {
           if (key_entry("Enter new reference number",
                          schluessel_neu))
             ds_umbenennen(schluessel, schluessel_neu);
        }

     }
 } while (taste > 0);
 cls_line("");
 return 0;
}


static int key_entry(char * infotext, char * zeile)
{
       int taste;
       do
       {
          cls_line("REFERENCES VERSION 3.5 * DELETE/RENAME RECORDS");

          info_zeile(infotext);
          wrtxt("Ref.-number........");
          taste = e_zle(
                      1+strlen("Ref.-number........"),
                      one_config_set.sl-1,
                      zeile,
                      KENNZIFFER_LEN,
                      KENNZIFFER_LEN,
                      0
                   );
          sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
          if (taste==ESC_KEY) break;
       }
       while ((taste!=ENTER_KEY) || (strlen(zeile)==0));
       if (taste==ESC_KEY)
       {
          cls_line("");
          return 0;
       }
       return 1;
}

static int ds_loeschen(const char * key)
{
  long byte_zeiger,ix_zeiger;
  refspix_rec ix01rec_lokal;
  int i, n_aut, taste, n_desc;
  author_rec one_aued_rec;


  if (filesize(journal_pix_name) < 3 * sizeof(ix01rec))
  {
     beeps();
     wrtxt("[Less than 3 entries in database, deleting not allowed, press any key]>");
     tastelesen();
     return 0;
  }
  read_ix01(journal_pix_name);
  ix_zeiger = locate_ix01(key, &ix01rec_lokal);
  close_ix01();
  if (ix_zeiger==-1)
  {
     cls_line("");
     sprintf(wrtxtbu,"\n[Reference corresponding to %s not found]>",key);
     wrtxt(wrtxtbu);
     tastelesen();
     sc_gotoxy(1,one_config_set.sl-1);
     return 0;
  }
  taste = lotus_menu("Cancel$Do not delete current record@"
                     "Ok$Delete current record");
  if (taste < 2) return 0;
  sc_gotoxy(1,one_config_set.sl-1);
  ix01rec = ix01rec_lokal;

  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot read %s",journal_name);
     beenden(fehlermeldung,2);
  }
  byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
  fseek(fpjournal,byte_zeiger,SEEK_SET);
  fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
  fclose(fpjournal);

  if (!strcmp(one_journal_rec.reftyp,"j1"))
  {
      if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",journal_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorjl=fopen(autorjl_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorjl_name);
         beenden(fehlermeldung,2);
      }
      if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",desc_name);
         beenden(fehlermeldung,2);
      }
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }



      fclose(fpjournal);
      fclose(fpautorjl);
      fclose(fpdesc);
  }

      /* ende j1 */

  if (!strcmp(one_journal_rec.reftyp,"b1"))
  {
      if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",journal_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorbu=fopen(autorbu_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorbu_name);
         beenden(fehlermeldung,2);
      }
      if ((fpbuch=fopen(book_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",book_name);
         beenden(fehlermeldung,2);
      }
      if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",desc_name);
         beenden(fehlermeldung,2);
      }

      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      one_buch_rec.in_use_bu = 0;
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }


      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }

      fclose(fpjournal);
      fclose(fpautorbu);
      fclose(fpbuch);
      fclose(fpdesc);
  }

       /* ende b1 */


  if (!strcmp(one_journal_rec.reftyp,"b2"))
  {
      if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",journal_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorjl=fopen(autorjl_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorjl_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorbu=fopen(autorbu_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorbu_name);
         beenden(fehlermeldung,2);
      }
      if ((fpbuch=fopen(book_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",book_name);
        beenden(fehlermeldung,2);
      }
      if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",desc_name);
         beenden(fehlermeldung,2);
      }

      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      one_journal_rec.in_use = 0;
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      one_buch_rec.in_use_bu = 0;
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);



      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            one_aued_rec.in_use_au = 0;
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            one_desc_rec.in_use = 0;
            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }



      fclose(fpjournal);
      fclose(fpautorbu);
      fclose(fpautorjl);
      fclose(fpbuch);
      fclose(fpdesc);
  }
       /* ende b2 */
  if ((tmpix=fopen(tmpix_name,"r+b"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot modify %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  fseek(tmpix,0L,SEEK_END);
  fwrite(&ix01rec_lokal,sizeof(ix01rec_lokal),1,tmpix);
  fclose(tmpix);

  return 1;
}


static int abstract_loeschen(const char * key)
{
  long byte_zeiger, ix_zeiger;
  abstrpix_rec ix04rec_lokal;
  int i, anzahl_bloecke;
  if (filesize(abstr_pix_name) < 3 * sizeof(ix04rec))
  {
      wrtxt("[Unexpected ERROR: Less than 3 entries in "
              "abstract database]>");
      tastelesen();
      return 0;
  }
  read_ix04(abstr_pix_name);
  ix_zeiger = locate_ix04(key,&ix04rec_lokal);
  close_ix04();
  if (ix_zeiger==-1)
  {
     cls_line("");
     return 0;
  }
  ix04rec = ix04rec_lokal;
  if ((fpabs=fopen(abstr_dat_name,"r+b"))==NULL)
  {
     sprintf(wrtxtbu,"Unexpected ERROR: unable to read/write %s",abstr_dat_name);
     wrtxt(wrtxtbu);
     tastelesen();
     return 0;
  }

  if ((tmpix_abs=fopen(tmpix_abs_name,"r+b"))==NULL)
  {
     fclose(fpabs);
     sprintf(wrtxtbu,"Unexpected ERROR: unable to write into %s, therefore "
            "one abstract record cannot be deleted\n\n"
            "[Please press any key]>",
     tmpix_abs_name);
     wrtxt(wrtxtbu);
     tastelesen();
     return 0;
  }

  fseek(tmpix_abs,0L,SEEK_END);
  fwrite(&ix04rec_lokal,sizeof(ix04rec_lokal),1,tmpix_abs);
  fclose(tmpix_abs);

  byte_zeiger = ix04rec.abstr_rptr * sizeof(one_abstr_rec);
  fseek(fpabs,byte_zeiger,SEEK_SET);
  fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
  fseek(fpabs,byte_zeiger,SEEK_SET);
  anzahl_bloecke = one_abstr_rec.abstr_n;
  for (i=1; i <= anzahl_bloecke;i++)
  {
      fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      one_abstr_rec.in_use = 0;
      fseek(fpabs, - (long) sizeof(one_abstr_rec),SEEK_CUR);
      fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
      fseek(fpabs,0L,SEEK_CUR);
        /* zwischen Wechsel von fwrite nach fread immer 'fseek' */
  }
  fclose(fpabs);


  return 1;
}



static int ds_umbenennen(const char * key, const char * key_new)
{
  long byte_zeiger,ix_zeiger;
  refspix_rec ix01rec_lokal;
  abstrpix_rec ix04rec_lokal;
  int i, n_aut, n_desc, taste, anzahl_bloecke;
  author_rec one_aued_rec;


  if (filesize(journal_pix_name) < 3 * sizeof(ix01rec))
  {
     cls_line("");
     wrtxt("\n[Less than 3 entries in d'base, renaming not allowed, "
                "please press any key]>");
     tastelesen();
     return 0;
  }
  if (filesize(abstr_pix_name) < 3 * sizeof(ix04rec))
  {
     cls_line("");
     wrtxt("\n[Less than 3 abstracts in d'base, renaming not allowed, "
               "please press any key]>");
     tastelesen();
     return 0;
  }
  read_ix01(journal_pix_name);
  ix_zeiger = locate_ix01(key, &ix01rec_lokal);

  if (ix_zeiger==-1)
  {
     cls_line("");
     sprintf(wrtxtbu,"\n[Reference corresponding to %s not found]>",key);
     wrtxt(wrtxtbu);
     tastelesen();
     sc_gotoxy(1,one_config_set.sl-1);
     close_ix01();
     return 0;
  }
  ix_zeiger = locate_ix01(key_new, &ix01rec_lokal);
  if (ix_zeiger > -1)
  {
     cls_line("");
     sprintf(wrtxtbu,"\n[Reference corresponding to %s already in file]>",key_new);
     wrtxt(wrtxtbu);
     tastelesen();
     sc_gotoxy(1,one_config_set.sl-1);
     close_ix01();
     return 0;
  }

  ix_zeiger = locate_ix01(key, &ix01rec_lokal);
    /* ix01rec_lokal enthaelt nun die Angaben des alten Indexeintrags */

  close_ix01();



  taste = lotus_menu("Cancel$Do not rename current record@"
                     "Ok$Rename current record");
  if (taste < 2) return 0;
  sc_gotoxy(1,one_config_set.sl-1);
  ix01rec = ix01rec_lokal;

  if ((fpjournal=fopen(journal_name,"rb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: cannot read %s",journal_name);
     beenden(fehlermeldung,2);
  }
  byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
  fseek(fpjournal,byte_zeiger,SEEK_SET);
  fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
  fclose(fpjournal);

  if (!strcmp(one_journal_rec.reftyp,"j1"))
  {
      if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",journal_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorjl=fopen(autorjl_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorjl_name);
         beenden(fehlermeldung,2);
      }
      if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",desc_name);
         beenden(fehlermeldung,2);
      }
      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      strncpy(one_journal_rec.kennziffer,key_new,KENNZIFFER_LEN);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            strncpy(one_aued_rec.au_kennziffer,key_new,AUKENNZIFFER_LEN);

            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            strncpy(one_desc_rec.kennziffer,key_new,KENNZIFFER_LEN);

            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }


      fclose(fpjournal);
      fclose(fpautorjl);
      fclose(fpdesc);
  }
      /* ende j1 */

  if (!strcmp(one_journal_rec.reftyp,"b1"))
  {
      if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",journal_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorbu=fopen(autorbu_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorbu_name);
         beenden(fehlermeldung,2);
      }
      if ((fpbuch=fopen(book_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",book_name);
         beenden(fehlermeldung,2);
      }
      if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",desc_name);
         beenden(fehlermeldung,2);
      }

      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      strncpy(one_journal_rec.kennziffer,key_new,KENNZIFFER_LEN);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      strncpy(one_buch_rec.kennziffer,key_new,KENNZIFFER_LEN);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            strncpy(one_aued_rec.au_kennziffer,key_new,AUKENNZIFFER_LEN);
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            strncpy(one_desc_rec.kennziffer,key_new,KENNZIFFER_LEN);

            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }


      fclose(fpjournal);
      fclose(fpautorbu);
      fclose(fpbuch);
      fclose(fpdesc);
  }

       /* ende b1 */


  if (!strcmp(one_journal_rec.reftyp,"b2"))
  {
      if ((fpjournal=fopen(journal_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",journal_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorjl=fopen(autorjl_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorjl_name);
         beenden(fehlermeldung,2);
      }
      if ((fpautorbu=fopen(autorbu_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",autorbu_name);
         beenden(fehlermeldung,2);
      }
      if ((fpbuch=fopen(book_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",book_name);
         beenden(fehlermeldung,2);
      }
      if ((fpdesc=fopen(desc_name,"r+b"))==NULL)
      {
         sprintf(fehlermeldung,"ERROR: cannot open %s",desc_name);
         beenden(fehlermeldung,2);
      }

      byte_zeiger = ix01rec.journal_rptr * sizeof(one_journal_rec);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fread(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);
      strncpy(one_journal_rec.kennziffer,key_new,KENNZIFFER_LEN);
      fseek(fpjournal,byte_zeiger,SEEK_SET);
      fwrite(&one_journal_rec,sizeof(one_journal_rec),1,fpjournal);

      byte_zeiger = ix01rec.buch_rptr * sizeof(one_buch_rec);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fread(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);
      strncpy(one_buch_rec.kennziffer,key_new,KENNZIFFER_LEN);
      fseek(fpbuch,byte_zeiger,SEEK_SET);
      fwrite(&one_buch_rec,sizeof(one_buch_rec),1,fpbuch);



      byte_zeiger = ix01rec.autorjl_rptr * sizeof(one_aued_rec);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
      fseek(fpautorjl,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            strncpy(one_aued_rec.au_kennziffer,key_new,AUKENNZIFFER_LEN);
            fseek(fpautorjl, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorjl);
            fseek(fpautorjl,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }


      byte_zeiger = ix01rec.autorbu_rptr * sizeof(one_aued_rec);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
      fseek(fpautorbu,byte_zeiger,SEEK_SET);
      n_aut = one_aued_rec.au_n;
      for (i=1;i<=n_aut;i++)
      {
            fread(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            strncpy(one_aued_rec.au_kennziffer,key_new,AUKENNZIFFER_LEN);
            fseek(fpautorbu, - (long) sizeof(one_aued_rec),SEEK_CUR);
            fwrite(&one_aued_rec,sizeof(one_aued_rec),1,fpautorbu);
            fseek(fpautorbu,0L,SEEK_CUR);   /* Wechsel von fwrite nach fread */
      }

      byte_zeiger = ix01rec.desc_rptr * sizeof(one_desc_rec);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
      fseek(fpdesc,byte_zeiger,SEEK_SET);
      n_desc = one_desc_rec.desc_n;
      for (i=1;i<=n_desc;i++)
      {
            fread(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            strncpy(one_desc_rec.kennziffer,key_new,KENNZIFFER_LEN);

            fseek(fpdesc, - (long) sizeof(one_desc_rec),SEEK_CUR);
            fwrite(&one_desc_rec,sizeof(one_desc_rec),1,fpdesc);
            fseek(fpdesc,0L,SEEK_CUR); /* Wechsel von fwrite nach fread */
      }


      fclose(fpjournal);
      fclose(fpautorbu);
      fclose(fpautorjl);
      fclose(fpbuch);
      fclose(fpdesc);
  }


       /* ende b2 */




  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  fwrite(&ix01rec_lokal,sizeof(ix01rec_lokal),1,tmpix);
  fclose(tmpix);

  deleteix01(journal_pix_name,tmpix_name,newix_name);
  remove(journal_pix_name); remove(tmpix_name);
  rename(newix_name,journal_pix_name);
  wrtxt("\n");
  strncpy(ix01rec_lokal.kennziffer,key_new,KENNZIFFER_LEN);
  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  fwrite(&ix01rec_lokal,sizeof(ix01rec_lokal),1,tmpix);
  fclose(tmpix);

  mrgeix01(journal_pix_name,tmpix_name,newix_name);
  remove(journal_pix_name); remove(tmpix_name);
  rename(newix_name,journal_pix_name);

  wrtxt("\n\n");

  read_ix04(abstr_pix_name);
  ix_zeiger=locate_ix04(key,&ix04rec_lokal);
  if (ix_zeiger!=-1)
  {
       /* Abstract mit 'KEY' gefunden */
       ix_zeiger=locate_ix04(key_new,&ix04rec_lokal);
       if (ix_zeiger!=-1)
       {
           sprintf(wrtxtbu,"\n[Unexpected ERROR: Abstract with key %s already "
                  "in d'base]>",key_new);
           wrtxt(wrtxtbu);
           tastelesen();
           close_ix04();
       } else
       {
            /* bis hierhin alles ok */
          ix_zeiger = locate_ix04(key,&ix04rec_lokal);
            /* ix04rec_lokal enthaelt nun die Angaben des alten
               Indexeintrags */
          close_ix04();
          ix04rec = ix04rec_lokal;
          if ((fpabs=fopen(abstr_dat_name,"r+b"))==NULL)
          {
              sprintf(wrtxtbu,"\n[Unexpected ERROR: cannot read/write %s "
                     "abstract d'base will remain inconsistent]>",
                  abstr_dat_name);
              wrtxt(wrtxtbu);
              tastelesen();
              return 0;
          }
          byte_zeiger = ix04rec.abstr_rptr * sizeof(one_abstr_rec);
          fseek(fpabs,byte_zeiger,SEEK_SET);
          fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
          anzahl_bloecke = one_abstr_rec.abstr_n;
          fseek(fpabs,byte_zeiger,SEEK_SET);
          for (i=1;i<=anzahl_bloecke;i++)
          {
              fread(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
              strncpy(one_abstr_rec.kennziffer,key_new,KENNZIFFER_LEN);

              fseek(fpabs, - (long) sizeof(one_abstr_rec),SEEK_CUR);
              fwrite(&one_abstr_rec,sizeof(one_abstr_rec),1,fpabs);
              fseek(fpabs,0L,SEEK_CUR);
          }
          fclose(fpabs);
       }
  }
  else
  {
      /* ix_zeiger == -1 */
     close_ix04();
     sprintf(wrtxtbu,"[Record %s successfully renamed in %s]>",key,key_new);
     wrtxt(wrtxtbu);
     tastelesen();
     return 1;
  }
  if ((tmpix_abs=fopen(tmpix_abs_name,"wb"))==NULL)
  {
     sprintf(wrtxtbu,"Unexpected ERROR: Cannot create %s: abstract database will "
            "remain inconsistent\n\n[please press any key]>",
              tmpix_abs_name);
     wrtxt(wrtxtbu);
     tastelesen();
     return 0;
  }
  fwrite(&ix04rec_lokal,sizeof(ix04rec_lokal),1,tmpix_abs);
  fclose(tmpix_abs);
  deleteix04(abstr_pix_name,tmpix_abs_name,newix_abs_name);
  remove(abstr_pix_name);
  remove(tmpix_abs_name);
  rename(newix_abs_name,abstr_pix_name);
  wrtxt("\n");
  strncpy(ix04rec_lokal.kennziffer,key_new,KENNZIFFER_LEN);
  if ((tmpix_abs=fopen(tmpix_abs_name,"wb"))==NULL)
  {
     sprintf(wrtxtbu,"Unexpected ERROR: Cannot create %s: abstract database will "
            "remain inconsistent\n\n[please press any key]>",
              tmpix_abs_name);
     wrtxt(wrtxtbu);
     tastelesen();
     return 0;
  }
  fwrite(&ix04rec_lokal,sizeof(ix04rec_lokal),1,tmpix_abs);
  fclose(tmpix_abs);
  mrgeix04(abstr_pix_name,tmpix_abs_name,newix_abs_name);
  remove(abstr_pix_name);
  remove(tmpix_abs_name);
  rename(newix_abs_name,abstr_pix_name);

  sprintf(wrtxtbu,"\n\n[Record and abstract %s successfully renamed in %s]>",
      key,key_new);
  wrtxt(wrtxtbu);
  tastelesen();
  return 1;
}

static void steuerung_ds_loeschen(void)
{
  int i_loesch;    /* Zaehler fuer zu loeschende Datensaetze */
  int abs_loesch;  /* Zaehler fuer zu loeschende Abstract-Datensaetze */
  long n_records;  /* Anzahl der Datensaetze in JOURNAL.DAT */
  long n_abstracts;/* Anzahl der Datensaetze in ABS.DAT */

  int ok_weiter;

  refspix_rec ix01rec_lokal;

  i_loesch = 0;
  abs_loesch = 0;

  n_records = filesize(journal_pix_name) / sizeof(ix01rec);
  n_abstracts = filesize(abstr_pix_name) / sizeof(ix04rec);

  if ((tmpix=fopen(tmpix_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_name);
     beenden(fehlermeldung,2);
  }
  fclose(tmpix);
  if ((tmpix_abs=fopen(tmpix_abs_name,"wb"))==NULL)
  {
     sprintf(fehlermeldung,"ERROR: Cannot create %s",tmpix_abs_name);
     beenden(fehlermeldung,2);
  }
  fclose(tmpix_abs);

  ok_weiter = 1;
    /* benoetigt zum Abfragen von Fehlerbedingungen in der Schleife */
  do
  {
     if (!isfile(abstr_pix_name))
     {
         cls_line("");
         wrtxt("Deleting of records not permitted: No abstract index file "
                "found\n\n");
         wrtxt("[Please press any key]>");
         tastelesen();
         ok_weiter=0;
     }
     if (n_records - (i_loesch+1) <= 3)
     {
         cls_line("");
         wrtxt("Deleting of (more) records not permitted: \n"
                "database should contain > 4 records\n\n"
                "[Please press any key]>");
         tastelesen();
         ok_weiter=0;
     }
     if (n_abstracts-(abs_loesch+1) <= 3)
     {
         cls_line("");
         wrtxt("Deleting of (more) records not permitted: \n"
                "database with abstracts should contain > 4 records\n"
                /* "[Please press any key]>"*/);
         /* tastelesen(); */
         ok_weiter=0;
     }

     if (ok_weiter && key_entry("Enter number of reference or [Esc] to quit "
                    "and complete function",
                    schluessel))
     {
         if (scanseq_ix01(schluessel,&ix01rec_lokal,tmpix_name)==-1)
         {
            if (ds_loeschen(schluessel))
            {
               i_loesch++;
               if (abstract_loeschen(schluessel))
               {
                   abs_loesch++;
               }
               cls_line("");
               sprintf(wrtxtbu,"\n[Reference '%s' accepted for deleting, please press any key]>",schluessel);
               wrtxt(wrtxtbu);
               tastelesen();
            }
         }
         else
         {
            cls_line("");
            sprintf(wrtxtbu,"\n[Reference '%s' has just been deleted]>",schluessel);
            wrtxt(wrtxtbu);
            tastelesen();
            continue;
         }
     }
     else
     {
        if (i_loesch > 0)
        {
          wrtxt("\n");
          if (i_loesch > 1)
          {
             domerge01(tmpix_name,newix_name);
             remove(tmpix_name);
             rename(newix_name,tmpix_name);
          }
          deleteix01(journal_pix_name,tmpix_name,newix_name);
          remove(journal_pix_name); remove(tmpix_name);
          rename(newix_name,journal_pix_name);
          sprintf(wrtxtbu,"\n%i records successfully deleted\n",
             i_loesch);
          wrtxt(wrtxtbu);
        }
        else
        {
          remove(tmpix_name);
        }
        if (abs_loesch > 0)
        {
           if (abs_loesch > 1)
           {
              domerge04(tmpix_abs_name,newix_abs_name);
              remove(tmpix_abs_name);
              rename(newix_abs_name,tmpix_abs_name);
           }
           deleteix04(abstr_pix_name,tmpix_abs_name,newix_abs_name);
           remove(abstr_pix_name);
           remove(tmpix_abs_name); /* ergaenzt 25.12.1996 */
           rename(newix_abs_name,abstr_pix_name);
           sprintf(wrtxtbu,"\n%i abstracts successfully deleted\n",
                abs_loesch);
           wrtxt(wrtxtbu);
        }
        else
        {
           remove(tmpix_abs_name);
        }
        wrtxt("\n[Please press any key]>");
        tastelesen();
        break;
     }
  } while (1);
}
