/*
    REFERENCES -- bibliographic software
    Copyright (C) 1995-2000  Volker Kiefel

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
    USA
*/
/*
   medl_arr.c
   MEDLINE format to REFERENCES archive file format

*/
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <string.h>
#include <signal.h>
#include <stdlib.h>
#include <conio.h>
#include "str_fun.h"
#include "keycodes.h"
#include "fl_ut.h"
#include "refs.h"
#include "l_menu.h"
#include "cfg_fun.h"
#include "abbruch.h"
#include "str_refs.h"
#include "rfnr_fun.h"
#include "medl_arr.h"


#define JOURN_DEL " .-,/;:()[]\t"
   /* Delimiter zum Analysieren der Zeichtschriftennamen */

#define SOURCE_DAT "SOURCE.DAT"

#define LEERTAG "      "
  /* kennzeichnet leeren Zeilenanfang (6 spaces) */

#define AUTAG "AU  - "
  /* kennzeichnet 'author' */

#define TITATAG "TI  - "
  /* kennzeichnet 'title of article' */

#define DPTAG "DP  - "
  /* kennzeichnet das 'date of publication' */

#define VITAG "VI  - "
  /* kennzeichnet das 'volume' */

#define TATAG "TA  - "
  /* kennzeichnet Zeitschrift */

#define PGTAG "PG  - "
  /* kennzeichnet 'pages' */

#define MHTAG "MH  - "
  /* kennzeichnet 'MeSH' */

#define ABTAG "AB  - "
  /* kennzeichnet 'Abstract' */

#define IPTAG "IP  - "
  /* kennzeichnet 'Issue number'*/

#define ARR_LEN  (size_t) 32000L
#define ABSTRACT_ZEILE_LEN 30600

#define TMP_REC_KEY "R_KEY.T"

 extern char kennziff_temp_name[PFAD_LEN];
 extern config_set one_config_set;
 extern char fehlermeldung[250];
 extern char wrtxtbu[WRTXTBU_LEN];


 static char * txtzeile;
 static char * arrzeile;
 static char * ex_zeile;
 static char * exex_zeile;
 static char * exexex_zeile;
 static char * autor_zeile;
 static char * desc_zeile;
 static char * abstract_zeile;

 static int mit_mesh;

 char actual_tag[255];
 char titel_zeile[TITEL_LEN +1];
 char jahrgang_zeile[JAHRGANG_LEN +1];
 char monat_zeile[MONAT_LEN +1];
 char tag_zeile[TAG_LEN +1];
 char volume_zeile[BAND_LEN +1];
 char issue_nummer_zeile[ISSUE_NUMMER_LEN +1];
 char s_von_zeile[SEITE_VON_LEN + 1];
 char s_bis_zeile[SEITE_BIS_LEN + 1];
 char quellkuerzel_zeile[QUELLKUERZEL_LEN + 1];
 char zeitschrift_zeile_gl[ZEITSCHRIFT_LEN + 1]; /* global */

 static char kennziff[KENNZIFFER_LEN+1];
 extern config_set one_config_set;

 FILE * fptxt;
 static char txt_name[PFAD_LEN];

 FILE * fparr;
 static char arr_name[PFAD_LEN];

 FILE * fpquell;
 static char quell_name[PFAD_LEN];
 extern quell_rec one_quell_rec;

 static char maske[PFAD_LEN];
 static int alles_ok;

 static int dateinamen_bestimmen(void);
 static int kennziffer_bestimmen(void);
 static int dateien_oeff(void);
 static int medl_konvertieren(void);
 static int zeitschriften_kennung(
                                  char * kennung, /* 4-Buchstabenkennung */
                                  char * medline_name /* Name in medline */
                                  );


int medl_arr_main(void)
{
   strcpy(quell_name,SOURCE_DAT);
   strcpy(kennziff_temp_name,TMP_REC_KEY);

   if ((txtzeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for txtzeile");
       beenden(fehlermeldung,2);
   }
   if ((arrzeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for arrzeile");
       beenden(fehlermeldung,2);
   }
   if ((ex_zeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for ex_zeile");
       beenden(fehlermeldung,2);
   }
   if ((exex_zeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for exex_zeile");
       beenden(fehlermeldung,2);
   }
   if ((exexex_zeile =  (char *) malloc((ARR_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for exex_zeile");
       beenden(fehlermeldung,2);
   }
   if ((autor_zeile =  (char *) malloc((AUTORZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for autor_zeile");
       beenden(fehlermeldung,2);
   }
   if ((desc_zeile =  (char *) malloc((DESC_ZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for desc_zeile");
       beenden(fehlermeldung,2);
   }
   if ((abstract_zeile =  (char *) malloc((ABSTRACT_ZEILE_LEN + 1) * sizeof(char)))==NULL)
   {
       sprintf(fehlermeldung,"ERROR: Cannot allocate memory for abstract_zeile");
       beenden(fehlermeldung,2);
   }
   strcpy(actual_tag,"");
   strcpy(txtzeile,"");
   strcpy(arrzeile,"");
   strcpy(ex_zeile,"");
   strcpy(exex_zeile,"");
   strcpy(exexex_zeile,"");
   strcpy(autor_zeile,"");
   strcpy(titel_zeile,"");
   strcpy(quellkuerzel_zeile,"");
   strcpy(zeitschrift_zeile_gl,"");
   strcpy(jahrgang_zeile,"");
   strcpy(monat_zeile,"");
   strcpy(tag_zeile,"");
   strcpy(volume_zeile,"");
   strcpy(issue_nummer_zeile,"");
   strcpy(s_von_zeile,"");
   strcpy(s_bis_zeile,"");
   strcpy(desc_zeile,"");
   strcpy(abstract_zeile,"");

   alles_ok = 1;

   if (dateinamen_bestimmen())
   {
     if (kennziffer_bestimmen())
     {
       if (dateien_oeff())
       {
         static int menu_pos;
         int ta;
         ta=lotus_menu_default(&menu_pos,
           "@MeSH$Import MH-field"
           "@NoMeSH$Ignore MH-field, do not import");
         if (ta==1)
         {
           mit_mesh=1;
         }
         else
         {
           mit_mesh=0;
         }
         medl_konvertieren();
         fclose(fptxt);
         fclose(fparr);
       }
     }
   }
   free(abstract_zeile);
   free(desc_zeile);
   free(autor_zeile);
   free(exexex_zeile);
   free(exex_zeile);
   free(ex_zeile);
   free(arrzeile);
   free(txtzeile);
   return 1;
}

static int dateinamen_bestimmen(void)
{
   static char eingabe[PFAD_LEN];
   static int dateipos;

   int taste;
   strcpy(maske,"*.TXT");
   if (!datei_suchen_default(maske,txt_name,&dateipos))
   {
       wrtxt("\n[Function aborted: please press any key]>");
       tastelesen();
       return 0;
   }
   cls_line(MEDLTITEL);

   do
   {
     if (strlen(eingabe)==0)
     {
        strcpy(eingabe,"MEDL000");
     }
     cls_line(MEDLTITEL);
     info_zeile("Edit filename for archive file, extension '.ARR' will be appended");
     strcpy(wrtxtbu,"File name......");
     wrtxt(wrtxtbu);
     taste = e_zle(
                   1 + strlen(wrtxtbu),
                   one_config_set.sl-1,
                   eingabe,
                   DOSDATEIVORNAME_LEN,DOSDATEIVORNAME_LEN,0
                      );

     sc_gotoxy(1,one_config_set.sl);
     sc_clreol();
     sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
     if (taste==ESC_KEY)
     {
       wrtxt("\n[Function aborted: please press any key]>");
       tastelesen();
       return 0;
     }
     if (!isdosfilename(eingabe)) continue;
     if (taste==ENTER_KEY && strlen(eingabe) > 0)
     {
       strcpy(arr_name,eingabe);
       upper(arr_name);
       strcat(arr_name,".ARR");
       return 1;
     }
   } while (1);

   return 1;
}

static int kennziffer_bestimmen(void)
{
   int taste;
   do
   {
     kennziffer_lesen_allein(kennziff);
     cls_line(MEDLTITEL);
     info_zeile("Edit reference number for the record to be translated");
     strcpy(wrtxtbu,"Reference no...");
     wrtxt(wrtxtbu);
     taste = e_zle(
                   1 + strlen(wrtxtbu),
                   one_config_set.sl-1,
                   kennziff,
                   KENNZIFFER_LEN,KENNZIFFER_LEN,0
                   );

     sc_gotoxy(1,one_config_set.sl);
     sc_clreol();
     sc_gotoxy(1,one_config_set.sl-1);sc_clreol();
     if (taste==ESC_KEY)
     {
       wrtxt("\n[Function aborted: please press any key]>");
       tastelesen();
       return 0;
     }
     if (taste==ENTER_KEY && strlen(kennziff) > 0)
     {
       kennziffer_schreiben(kennziff);
       return 1;
     }
   } while (1);

   return 1;
}

static int dateien_oeff(void)
{
   if ((fptxt = fopen(txt_name,"rt"))==NULL)
   {
        sprintf(wrtxtbu,"ERROR: Cannot read %s",txt_name);
        wrtxt(wrtxtbu);
        tastelesen();
        return 0;
   }

   if ((fparr = fopen(arr_name,"wt"))==NULL)
   {
        sprintf(wrtxtbu,"ERROR: Cannot create %s",arr_name);
        wrtxt(wrtxtbu);
        fclose(fptxt);
        tastelesen();
        return 0;
   }

   return 1;
}

static int medl_konvertieren(void)
{
   int anzahl_namenselem;    /* Elemente Namen */
   int anzahl_namen;          /* Anzahl Autorennamen */
   int anzahl_abstract_zeilen;
   int anzahl_tita_zeilen;
   int anzahl_mesh;


   anzahl_namenselem = 0;
   anzahl_namen = 1;
   anzahl_abstract_zeilen = 1;
   anzahl_tita_zeilen = 1;
   anzahl_mesh = 1;

   fprintf(fparr,"****:BEGIN ARCHIVE\n\n");
   fprintf(fparr,"****:BEGIN REFERENCES\n");

   while (fgets(txtzeile,ARR_LEN,fptxt)!=NULL)
   {
     strcpy(ex_zeile,"");
     strcpy(exex_zeile,"");
     strcpy(exexex_zeile,"");

     if (strlen(txtzeile) >= ARR_LEN - 1)
     {
         wrtxt("\n[Problem: Line too long]>");
         tastelesen();
         alles_ok = 0;
         return 0;
     }
     rtrim(txtzeile,'\n');
     if (strlen(txtzeile)==0)
     {
        if (
             strlen(autor_zeile) > 0 ||
             strlen(titel_zeile) > 0 ||
             strlen(quellkuerzel_zeile) > 0 ||
             strlen(zeitschrift_zeile_gl) > 0 ||
             strlen(jahrgang_zeile) > 0 ||
             strlen(monat_zeile) > 0 ||
             strlen(tag_zeile) > 0 ||
             strlen(volume_zeile) > 0 ||
             strlen(issue_nummer_zeile) > 0 ||
             strlen(s_von_zeile) > 0 ||
             strlen(s_bis_zeile) > 0 ||
             strlen(desc_zeile) > 0 ||
             strlen(abstract_zeile) > 0
           )
        {
           /* ... first empty line following the data */
           break;
        }
        else
        {
           /* ... leading empty lines are ignored */
           continue;
        }
        /* changed on 13.01.2000 */
        /* break; */
     }

     /* Bei diesen Feldern sind Folgezeilen moeglich */
     if (!strcmp(actual_tag,TITATAG) ||
         !strcmp(actual_tag,ABTAG))
     {
        if (locate_substring(LEERTAG,txtzeile) < 0)
        {
           strcpy(actual_tag,"");
        }
     }

     if (locate_substring(AUTAG,txtzeile)==0)
     {
        int i;
        strcpy(actual_tag,AUTAG);
        if (anzahl_namen >= MAX_N_AUTHORS)
        {
          continue;
        }
        extract_subs(ex_zeile,txtzeile,strlen(AUTAG),AUTORZEILE_LEN);
        anzahl_namenselem = countitem(ex_zeile," ");
        if (anzahl_namenselem < 2)
        {
            strlimcat(autor_zeile,"?,?;",AUTORZEILE_LEN);
        }

        else
        {
           for (i=1;i<anzahl_namenselem;i++)
           {
             extractitem(i,ex_zeile," ",exex_zeile);
             strlimcat(exexex_zeile,exex_zeile,AUTORZEILE_LEN);
             strlimcat(exexex_zeile," ",AUTORZEILE_LEN);
           }
           rtrim(exexex_zeile,' ');
           exexex_zeile[AUNAME_LEN]='\0';
           if (strlen(exex_zeile) > 0)
           strlimcat(autor_zeile,exexex_zeile,AUTORZEILE_LEN);
           strlimcat(autor_zeile,",",AUTORZEILE_LEN);
              /* Nachname eingetragen */

           strcpy(exex_zeile,"");
           strcpy(exexex_zeile,"");

           extractitem(anzahl_namenselem,ex_zeile," ",exex_zeile);
           exex_zeile[AUVORNAMEN_LEN]='\0';
           strlimcat(autor_zeile,exex_zeile,AUTORZEILE_LEN);
           strlimcat(autor_zeile,";",AUTORZEILE_LEN);
        }
        anzahl_namen++;
     }
     if (
         (locate_substring(TITATAG,txtzeile)==0)||   /* erste Zeile? */
         (locate_substring(LEERTAG,txtzeile)==0 &&   /* Folgezeile im TITA */
          !strcmp(actual_tag,TITATAG))
        )
     {
        strcpy(actual_tag,TITATAG);
        extract_subs(ex_zeile,txtzeile,strlen(TITATAG),TITEL_LEN);
        trim(ex_zeile,' ');
        strlimcat(titel_zeile,ex_zeile,TITEL_LEN);
        strlimcat(titel_zeile," ",TITEL_LEN);
        anzahl_tita_zeilen++;
     }
     if (locate_substring(DPTAG,txtzeile)==0)
     {
        strcpy(actual_tag,DPTAG);
        extract_subs(ex_zeile,txtzeile,strlen(DPTAG),ARR_LEN);
        extractitem(1,ex_zeile," -/.:",exex_zeile);
        exex_zeile[JAHRGANG_LEN]='\0';
        strlimcpy(jahrgang_zeile,exex_zeile,JAHRGANG_LEN);
        sprintf(wrtxtbu,"\nYEAR of publication converted");
        wrtxt(wrtxtbu);
        if (countitem(ex_zeile," -/.:")>=2)
        {
           extractitem(2,ex_zeile," -/.:",exex_zeile);
           upper(exex_zeile);
           if (!strcmp(exex_zeile,"JAN")) strcpy(monat_zeile,"1");
           else if (!strcmp(exex_zeile,"FEB")) strcpy(monat_zeile,"2");
           else if (!strcmp(exex_zeile,"MAR")) strcpy(monat_zeile,"3");
           else if (!strcmp(exex_zeile,"APR")) strcpy(monat_zeile,"4");
           else if (!strcmp(exex_zeile,"MAY")) strcpy(monat_zeile,"5");
           else if (!strcmp(exex_zeile,"JUN")) strcpy(monat_zeile,"6");
           else if (!strcmp(exex_zeile,"JUL")) strcpy(monat_zeile,"7");
           else if (!strcmp(exex_zeile,"AUG")) strcpy(monat_zeile,"8");
           else if (!strcmp(exex_zeile,"SEP")) strcpy(monat_zeile,"9");
           else if (!strcmp(exex_zeile,"OCT")) strcpy(monat_zeile,"10");
           else if (!strcmp(exex_zeile,"NOV")) strcpy(monat_zeile,"11");
           else if (!strcmp(exex_zeile,"DEC")) strcpy(monat_zeile,"12");
           else strcpy(monat_zeile,"");
        }
        if (strlen(monat_zeile)>0)
        {
          sprintf(wrtxtbu,"\nDate of publication: MONTH converted");
          wrtxt(wrtxtbu);
        }
        if (countitem(ex_zeile," -/.:")>=3)
        {
           extractitem(3,ex_zeile," -/.:",exex_zeile);
           exex_zeile[TAG_LEN]='\0';
           if ( /*
                 *  I must admit, not extremely elegant ...
                 *
                 *  This construct avoids that in dates fields as
                 *  `DP  - 1999 Nov-Dec' `11' is (correctly) entered into
                 *  the MONP--field and `De' into the `DAYP' field.
                 */
                strcmp(exex_zeile,"1")==0 ||
                strcmp(exex_zeile,"01")==0 ||
                strcmp(exex_zeile,"2")==0 ||
                strcmp(exex_zeile,"02")==0 ||
                strcmp(exex_zeile,"3")==0 ||
                strcmp(exex_zeile,"03")==0 ||
                strcmp(exex_zeile,"4")==0 ||
                strcmp(exex_zeile,"04")==0 ||
                strcmp(exex_zeile,"5")==0 ||
                strcmp(exex_zeile,"05")==0 ||
                strcmp(exex_zeile,"6")==0 ||
                strcmp(exex_zeile,"06")==0 ||
                strcmp(exex_zeile,"7")==0 ||
                strcmp(exex_zeile,"07")==0 ||
                strcmp(exex_zeile,"8")==0 ||
                strcmp(exex_zeile,"08")==0 ||
                strcmp(exex_zeile,"9")==0 ||
                strcmp(exex_zeile,"09")==0 ||
                strcmp(exex_zeile,"10")==0 ||
                strcmp(exex_zeile,"11")==0 ||
                strcmp(exex_zeile,"12")==0 ||
                strcmp(exex_zeile,"13")==0 ||
                strcmp(exex_zeile,"14")==0 ||
                strcmp(exex_zeile,"15")==0 ||
                strcmp(exex_zeile,"16")==0 ||
                strcmp(exex_zeile,"17")==0 ||
                strcmp(exex_zeile,"18")==0 ||
                strcmp(exex_zeile,"19")==0 ||
                strcmp(exex_zeile,"20")==0 ||
                strcmp(exex_zeile,"21")==0 ||
                strcmp(exex_zeile,"22")==0 ||
                strcmp(exex_zeile,"23")==0 ||
                strcmp(exex_zeile,"24")==0 ||
                strcmp(exex_zeile,"25")==0 ||
                strcmp(exex_zeile,"26")==0 ||
                strcmp(exex_zeile,"27")==0 ||
                strcmp(exex_zeile,"28")==0 ||
                strcmp(exex_zeile,"29")==0 ||
                strcmp(exex_zeile,"30")==0 ||
                strcmp(exex_zeile,"31")==0
              )
           {
              strlimcpy(tag_zeile,exex_zeile,TAG_LEN);
           }
        }
        if (strlen(tag_zeile)>0)
        {
          sprintf(wrtxtbu,"\nDate of publication: DAY converted");
          wrtxt(wrtxtbu);
        }
     }
     if (locate_substring(VITAG,txtzeile)==0)
     {
        strcpy(actual_tag,VITAG);
        extract_subs(ex_zeile,txtzeile,strlen(VITAG),ARR_LEN);
        ex_zeile[BAND_LEN]='\0';
        strlimcpy(volume_zeile,ex_zeile,BAND_LEN);
        sprintf(wrtxtbu,"\nVOLUME IDENTIFIER converted");
        wrtxt(wrtxtbu);
     }
     if (locate_substring(IPTAG,txtzeile)==0)
     {
        strcpy(actual_tag,IPTAG);
        extract_subs(ex_zeile,txtzeile,strlen(IPTAG),ARR_LEN);
        ex_zeile[ISSUE_NUMMER_LEN]='\0';
        strlimcpy(issue_nummer_zeile,ex_zeile,ISSUE_NUMMER_LEN);
        sprintf(wrtxtbu,"\nISSUE NUMBER converted");
        wrtxt(wrtxtbu);
     }
     if (locate_substring(TATAG,txtzeile)==0)
     {
        strcpy(actual_tag,TATAG);
        extract_subs(ex_zeile,txtzeile,strlen(TATAG),ARR_LEN);
        zeitschriften_kennung(quellkuerzel_zeile,ex_zeile);
        strlimcpy(zeitschrift_zeile_gl,ex_zeile,ZEITSCHRIFT_LEN);
     }

     if (locate_substring(PGTAG,txtzeile)==0)
     {
        strcpy(actual_tag,PGTAG);
        extract_subs(ex_zeile,txtzeile,strlen(PGTAG),ARR_LEN);
        extractitem(1,ex_zeile," -",exex_zeile);
        exex_zeile[SEITE_VON_LEN]='\0';
        strlimcpy(s_von_zeile,exex_zeile,SEITE_VON_LEN);
        strcpy(exex_zeile,"");
        extractitem(2,ex_zeile," -",exex_zeile);

        seitenziffern_komplettieren(s_von_zeile,exex_zeile,exexex_zeile);
        exexex_zeile[SEITE_BIS_LEN]='\0';
        strlimcpy(s_bis_zeile,exexex_zeile,SEITE_BIS_LEN);
        sprintf(wrtxtbu,"\nPAGE NUMBER(S) converted");
        wrtxt(wrtxtbu);
     }
     if (locate_substring(MHTAG,txtzeile)==0)
     {
        strcpy(actual_tag,MHTAG);
        extract_subs(ex_zeile,txtzeile,strlen(MHTAG),ARR_LEN);
        trim(ex_zeile,' ');
        trim(ex_zeile,',');
        strlimcat(desc_zeile,ex_zeile,DESC_ZEILE_LEN);
        strlimcat(desc_zeile,", ",DESC_ZEILE_LEN);
        anzahl_mesh++;
     }
     if (
         (locate_substring(ABTAG,txtzeile)==0)||     /* erste Zeile? */
         (locate_substring(LEERTAG,txtzeile)==0 &&   /* Folgezeile im ABST */
          !strcmp(actual_tag,ABTAG))
        )
     {
        strcpy(actual_tag,ABTAG);
        strlimcpy(ex_zeile,txtzeile,ARR_LEN);
        rtrim(ex_zeile,' ');
        strlimcat(abstract_zeile,ex_zeile,ABSTRACT_ZEILE_LEN);
        strlimcat(abstract_zeile,"\xFE",ABSTRACT_ZEILE_LEN);
        anzahl_abstract_zeilen++;
     }
   } /* while (fgets(.. */

   if (mit_mesh==0)
   {
      strcpy(desc_zeile,"");
      anzahl_mesh=1;
   }
   sprintf(wrtxtbu,"\n%i AUTHOR NAMES converted",anzahl_namen-1);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\n%i lines for TITLE OF ARTICLE converted",
      anzahl_tita_zeilen-1);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\nShort form for JOURNAL NAME "
             "[%s]: `%s'",zeitschrift_zeile_gl,quellkuerzel_zeile);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\nMeSH: %i items written into KEYWORDS field",
      anzahl_mesh-1);
   wrtxt(wrtxtbu);
   sprintf(wrtxtbu,"\n%i lines of ABSTRACT converted",
      anzahl_abstract_zeilen-1);
   wrtxt(wrtxtbu);

   sprintf(wrtxtbu,"\n");
   wrtxt(wrtxtbu);
   fprintf(fparr,"\nRECN:%s\n",kennziff);
   fprintf(fparr,"DTYP:j1\n");
   rtrim(autor_zeile,';');
   if (strlen(autor_zeile)==0)
   {
      strcpy(autor_zeile,"?,?");
   }
   fprintf(fparr,"AUTH:%s\n",autor_zeile);
   rtrim(titel_zeile,' ');
   rtrim(titel_zeile,'.');
   fprintf(fparr,"TITA:%s\n",titel_zeile);
   fprintf(fparr,"JRNL:%s\n",quellkuerzel_zeile);
   fprintf(fparr,"YEAR:%s\n",jahrgang_zeile);
   fprintf(fparr,"MONP:%s\n",monat_zeile);
   fprintf(fparr,"DAYP:%s\n",tag_zeile);
   fprintf(fparr,"VOLM:%s\n",volume_zeile);
   fprintf(fparr,"ISNU:%s\n",issue_nummer_zeile);
   fprintf(fparr,"PGFR:%s\n",s_von_zeile);
   fprintf(fparr,"PGTO:%s\n",s_bis_zeile);
   fprintf(fparr,"STAT:\n");
   trim(desc_zeile,' ');
   trim(desc_zeile,',');
   if (strlen(desc_zeile)==0)
   {
      strcpy(desc_zeile,"no MeSH in MEDLINE format");
   }
   fprintf(fparr,"KEYW:%s\n",desc_zeile);

   if (strlen(abstract_zeile)>0)
   {
     fprintf(fparr,"ABST:%s\xFE\xFE%s\n",kennziff,abstract_zeile);
   }
   else
   {
     fprintf(fparr,"ABST:\n");
   }

   fprintf(fparr,"\n****:END REFERENCES\n\n");
   fprintf(fparr,"****:BEGIN JOURNALS\n\n");
   fprintf(fparr,"****:END JOURNALS\n\n");
   fprintf(fparr,"****:BEGIN KEYWORDS THESAURUS\n\n");
   fprintf(fparr,"****:END KEYWORDS THESAURUS\n\n");
   fprintf(fparr,"****:END ARCHIVE\n");

   wrtxt("\n[Conversion completed, please press any key]>");
   tastelesen();
   return 1;
}

static int zeitschriften_kennung(
                                 char * kennung, /* 4-Buchstabenkennung */
                                 char * medline_name /* Name in medline */
                                 )
{
   char zeitschrift[ZEITSCHRIFT_LEN + 2];
   char medline_zeitschrift[ZEITSCHRIFT_LEN + 2];
   char kurz_zeitschrift[KURZFORM_LEN + 2];
   long anzahl_records, i;
   int j, anzahl_woerter;


   strcpy(kennung,"j1");
   strcpy(zeitschrift,"");
   strcpy(medline_zeitschrift,"");
   strcpy(kurz_zeitschrift,"");
   if (filesize(quell_name) < sizeof(one_quell_rec))
   {
       strcpy(kennung,"j1");
       return 0;
   }
   if ((fpquell = fopen(quell_name,"rb"))==NULL)
   {
       strcpy(kennung,"j1");
       return 0;
   }

   anzahl_woerter=countitem(medline_name,JOURN_DEL);
   for (j=1;j<=anzahl_woerter;j++)
   {
       extractitem(j,medline_name,JOURN_DEL,exex_zeile);
       strlimcat(medline_zeitschrift,exex_zeile,ZEITSCHRIFT_LEN);
       strlimcat(medline_zeitschrift," ",ZEITSCHRIFT_LEN);
   }
   rtrim(medline_zeitschrift,' ');
   upper(medline_zeitschrift);

   fseek(fpquell,0L,SEEK_END);
   anzahl_records = ftell(fpquell) / sizeof(one_quell_rec) - 1;
   rewind(fpquell);
   for (i=0;i<=anzahl_records;i++)
   {
       fread(&one_quell_rec,sizeof(one_quell_rec),1,fpquell);
       if (one_quell_rec.in_use_quell==0)
       {
         continue;
       }
       trim(one_quell_rec.quell_zeitschrift,' ');
       if (strlen(one_quell_rec.quell_zeitschrift) > 0)
       {
         strcpy(zeitschrift,"");
         anzahl_woerter=countitem(one_quell_rec.quell_zeitschrift,JOURN_DEL);
         for (j=1;j<=anzahl_woerter;j++)
         {
             extractitem(j,one_quell_rec.quell_zeitschrift,JOURN_DEL,exex_zeile);
             strlimcat(zeitschrift,exex_zeile,ZEITSCHRIFT_LEN);
             strlimcat(zeitschrift," ",ZEITSCHRIFT_LEN);
         }
         rtrim(zeitschrift,' ');
         upper(zeitschrift);
         if (!strcmp(zeitschrift,medline_zeitschrift))
         {
            strlimcpy(kennung,one_quell_rec.quell_kuerzel,QUELLKUERZEL_LEN);
            break;
         }
       }
       if (strlen(one_quell_rec.quell_kurzform) > 0)
       {
         strcpy(kurz_zeitschrift,"");
         anzahl_woerter=countitem(one_quell_rec.quell_kurzform,JOURN_DEL);
         for (j=1;j<=anzahl_woerter;j++)
         {
             extractitem(j,one_quell_rec.quell_kurzform,JOURN_DEL,exex_zeile);
             strlimcat(kurz_zeitschrift,exex_zeile,KURZFORM_LEN);
             strlimcat(kurz_zeitschrift," ",KURZFORM_LEN);
         }
         rtrim(kurz_zeitschrift,' ');
         upper(kurz_zeitschrift);
         if (!strcmp(kurz_zeitschrift,medline_zeitschrift))
         {
            strlimcpy(kennung,one_quell_rec.quell_kuerzel,QUELLKUERZEL_LEN);
            break;
         }
       }
   }
   fclose(fpquell);
   return 1;
}
