// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbcond.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/07/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Condition variable class used by a thread to block its own
execution until an expression involving shared data attains a
particular state. 
*/
// ----------------------------------------------------------- //   
#ifndef __VBCONDITION_HPP__
#define __VBCONDITION_HPP__

#include "thrtypes.h"
#include "thelpers.h"
#include "vbmutex.h"

class vbCondition
{
public:
  vbCondition(vbProcessType type = vbPROCESS_PRIVATE);
  ~vbCondition();

private: // Disallow copying and assignment
  vbCondition(const vbCondition &ob) { } 
  void operator=(const vbCondition &ob) { }

public:
  int ConditionInit(vbProcessType type = vbPROCESS_PRIVATE);
  int ConditionDestroy();
  int ConditionWait(vbMutex *m);
  int ConditionTimedWait(vbMutex *m, unsigned long sec, unsigned long nsec=0);
  int ConditionSignal();
  int ConditionBroadcast();
  int ThreadsWaiting() { return num_waiters > 0; }
  int NumWaiting() { return num_waiters; }
  vbCondition_t *GetCondition() { return &condition; }
  vbConditionError GetConditionError() { return condition.condition_error; }
  vbProcessType GetConditionProcessType() { return condition.process_type; }

public: // Condition variable status/debug message functions
  const char *ConditionExceptionMessage();
  
private:
  int num_waiters;
  vbCondition_t condition;
};

#endif // __VBCONDITION_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


