// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Simple test program demonstrating the basic operation of the
vbThread class using mutex and condition variable synchronization 
primitives.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"
#include "vbmutex.h"
#include "vbcond.h"

// Constants
const int max_reps = 10;

// Global variables
char buffer;
int buffer_has_item = 0;
int num_reps;

// Global synchronization objects
vbMutex mutex;
vbCondition condition;

// Standalone funciton that works with the reader class 
inline char make_new_item() { return 'A' + num_reps; }
inline void consume_item(char &c) { c = 0; }
void WriterFunction();

// Class derived from the abstract vbThread base class 
class ReaderClass : public vbThread
{
public:
  ReaderClass() { }
  ~ReaderClass() { }
  
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
};

// Program's main thread of execution
int main()
{
  // Set the rep count to zero
  num_reps = 0;
  
  ReaderClass t;
  t.CreateThread();
  
  WriterFunction();
  
  // Wait for the thread to consume the last item before exiting
  t.sSleep(3);
  
  return 1;
}

void *ReaderClass::ThreadEntryRoutine(vbThread_t *thread)
{
   while(num_reps < max_reps) {
    mutex.MutexLock();
    condition.ConditionTimedWait(&mutex, 1);
    if(buffer_has_item == 1) {
      cout << "Comsuing item: " << buffer << endl;
      consume_item(buffer);
      buffer_has_item = 0;
    } 
    mutex.MutexUnlock();
  } 
  return 0;
}
  
void WriterFunction()
{
  while(num_reps < max_reps) {
    mutex.MutexLock();
    condition.ConditionTimedWait(&mutex, 1);
      if(buffer_has_item == 0) {
	buffer = make_new_item();
	cout << "Making item: " << buffer << endl;
	buffer_has_item = 1;
	num_reps++;
      }
      mutex.MutexUnlock();
  }
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

