// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: thrtypes.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/07/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This include file contains cross-platform type definitions and
enumerations used throughout the VB thread library.

The following is a list of conditional directives used for cross-
compiler/cross platform compilation. NOTE: These directives must be
defined in project makefile with the "-D" compiler option.

__WIN32__ - WIN32 directive for Windows 95/98/NT applications.
__HAS__BEGINTHREADEX__ - Create thread using the _beginthreadex() C RTL call

__UNIX__    - Generic UNIX directive. Must be defined for all UNIX systems.
__POSIX__   - Define for applications using POSIX threads.
__HPUX10__  - Define for all HPUX 10.20 applications.
__SOLARIS__ - Solaris directive. Must be defined for Solaris or POSIX threads.

The following is a list of conditional directives reserved for future use
in the VB thread library:

__MSVC__    - Microsoft Visual C++ 4.2 and higher compiler specifics.
__BCC32__   - Borland BCC 4.0 and higher compiler specifics.
__MFC__     - MFC directive for Windows 95/98/NT MFC applications.
__HPUX__    - HPUX directive defined for all versions of HPUX.
__HPUX11__          - Define for all HPUX 11.0 and higher applications.
__LINUX__           - Linux directive. Defined for Linux or POSIX threads.
__LINUX_THREADS__   - Define for applications using Linux threads.
__SOLARIS_THREADS__ - Define for applications using Solaris threads.
*/
// ----------------------------------------------------------- //   
#ifndef __VBTHREAD_TYPES_HPP_
#define __VBTHREAD_TYPES_HPP_

// --------------------------------------------------------------
// Platform specific include files
// --------------------------------------------------------------
// Generic UNIX include files
#if defined (__UNIX__)
#include <unistd.h>
#endif

// Thread specific native API include files
#if defined (__WIN32__)
#include <windows.h> 
#include <process.h>

#elif defined (__SOLARIS__) && defined (__POSIX__)
#ifndef __EXTENSIONS__
#define __EXTENSIONS__
#endif
#include <pthread.h>
#include <sched.h>

#elif defined (__HPUX__) && defined (__POSIX__)
#ifndef _INCLUDE_POSIX1C_SOURCE
#define _INCLUDE_POSIX1C_SOURCE
#endif
#include <pthread.h>
#include <sched.h>

#elif defined (__POSIX__) // Generic UNIX OS with POSIX complient extensions
#include <pthread.h>
#include <sched.h>

#else
#error You must define an API: __WIN32__ or __POSIX__ and a UNIX variant
#endif
// --------------------------------------------------------------

// --------------------------------------------------------------
// Native thread API specific type definitions
// --------------------------------------------------------------
#if defined (__WIN32__)
typedef HANDLE vbThreadID;        // WIN32 thread handle
typedef DWORD vbStackSizeType;    // Type used to specify a stack size
typedef DWORD vbThreadExitCode;   // Type used to hold a thread's exit code
typedef DWORD vbThreadKey;        // Key type for thread-specific values
typedef LPSECURITY_ATTRIBUTES vbThreadAttribute; // Security attributes

#elif defined (__HPUX10__) && defined (__POSIX__)
// HPUX 10.20 Common Multithread Architecture (CMA) services
// POSIX 1003.4 interface
typedef cma_t_attr vbThreadAttribute; // CMA thread attribute type
typedef cma_t_thread vbThreadID; // Type used to identify a thread
typedef long vbStackSizeType;    // Type used to specify a stack size
typedef int vbThreadExitCode;    // Type used to hold a thread's exit code
typedef cma_t_key vbThreadKey;   // Key type for thread-specific values

#elif defined (__POSIX__)
// POSIX 1003.1c 1995 thread standard
typedef pthread_attr_t vbThreadAttribute; // POSIX thread attribute type
typedef pthread_t vbThreadID;      // Type used to identify a thread
typedef unsigned vbStackSizeType;  // Type used to specify a stack size
typedef int vbThreadExitCode;      // Type used to hold a thread's exit code
typedef pthread_key_t vbThreadKey; // Key type for thread-specific values
 
#else
#error You must define an API: __WIN32__ or __POSIX__
#endif
// --------------------------------------------------------------

// --------------------------------------------------------------
// Type definitions common to all platforms
// --------------------------------------------------------------
typedef long vbThreadObjectID; // Type used for object IDs
typedef long vbThreadClassID;  // Type used for class IDs
// --------------------------------------------------------------

// --------------------------------------------------------------
// Function pointers used for type casting thread start routines
// --------------------------------------------------------------
#if defined (__WIN32__)
typedef unsigned (__stdcall *vbThreadStartRoutine)(void *arg);

#elif defined (__HPUX10__) && defined (__POSIX__)
// HPUX 10.20 Common Multithread Architecture (CMA) services
typedef cma_t_start_routine vbThreadStartRoutine;

#elif defined (__POSIX__)
typedef void *(*vbThreadStartRoutine)(void *arg); 

#else
#error You must define an API: __WIN32__ or __POSIX__
#endif
// --------------------------------------------------------------

// --------------------------------------------------------------
// Enumerations
// --------------------------------------------------------------
enum vbThreadState { // Current thread state
  vbTHREAD_STATE_INVALID = 0,  // The current state of this thread is unknown
  vbTHREAD_STATE_CANCELED,     // Thread has been canceled
  vbTHREAD_STATE_EXITED,       // Thread has exited
  vbTHREAD_STATE_NEW,          // Newly created thread
  vbTHREAD_STATE_RUNNING,      // Thread is currently running
  vbTHREAD_STATE_SUSPENDED,    // Thread has been suspended
  vbTHREAD_STATE_WAITING       // Execution is blocked waiting for a signal 
};

enum vbThreadPriority { // Thread priority settings
  vbTHREAD_PRIORITY_INVALID = 0, // The priority of this thread is invalid
  vbTHREAD_PRIORITY_LOW,         // Move to the bottom of the priority chain
  vbTHREAD_PRIORITY_NORMAL,      // Add to the priority chain (default)
  vbTHREAD_PRIORITY_HIGH         // Move to the top of the priority chain
};

enum vbThreadPriorityClass { // Thread scheduling policies
  vbTHREAD_PRIORITY_CLASS_INVALID = 0, // The priority class is invalid

  // POSIX scheduling policies. NOTE: The WIN32 scheduling policy is
  // determined by the priority class of its process. None of these
  // policies have any effect under WIN32. 
  vbTHREAD_PRIORITY_CLASS_OTHER, // Another scheduling policy (default policy)
  vbTHREAD_PRIORITY_CLASS_FIFO,  // First in-first out (FIFO) scheduling policy
  vbTHREAD_PRIORITY_CLASS_RR     // Round robin scheduling policy
};

enum vbThreadError { // Thread error codes
  vbTHREAD_NO_ERROR = 0, // No errors reported
  vbTHREAD_INVALID_CODE, // Invalid thread error code
  
  vbTHREAD_CANCEL_ERROR,   // Error canceling thread
  vbTHREAD_CLOSE_ERROR,    // Error closing thread
  vbTHREAD_CREATE_ERROR,   // Error creating thread
  vbTHREAD_RUNNING_ERROR,  // Thread is already running
  vbTHREAD_EXECUTE_ERROR,  // Thread cannot be executed 
  vbTHREAD_POLICY_ERROR,   // Cannot retrieve thread scheduling policy
  vbTHREAD_PRIORITY_ERROR, // Error setting the thread priority
  vbTHREAD_RESUME_ERROR,   // Error resuming thread
  vbTHREAD_SCHED_ERROR,    // Scheduling error
  vbTHREAD_SCOPE_ERROR,    // Contention scope error
  vbTHREAD_STACK_ERROR,    // Error setting the stack size
  vbTHREAD_STATE_ERROR,    // Could not set the thread state
  vbTHREAD_SUSPEND_ERROR   // Error suspending thread 
};

enum vbThreadType { // Thread types
  vbTHREAD_TYPE_DETACHED, // System reclaims resources when thread terminates
  vbTHREAD_TYPE_JOINABLE
};

enum vbProcessType { // Process types
  vbPROCESS_PRIVATE = 0, // Resources are available only to a single process
  vbPROCESS_SHARED  = 1  // Resources are available to multiple processes
};
// --------------------------------------------------------------

#endif // __VBTHREAD_TYPES_HPP_
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
