// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbderror.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer    
// File Creation Date: 02/14/1996  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbdError functions and classes are used to catch and/or
record database exceptions that occur during run-time. This
implementation can be used with or without C++ built-in exception
handling. If C++ exception handling is not enabled with the
__CPP_EXCEPTIONS__ macro, then the vbDatabaseError enumerated
constants can be used to record database errors.
*/
// ----------------------------------------------------------- //   
#ifndef __VBD_ERROR_HPP__
#define __VBD_ERROR_HPP__

enum vbDatabaseError { // Database error codes
  vbDBASE_NO_ERROR = 0,        // No errors reported
  vbDBASE_INVALID_CODE,        // Invalid error code
  vbDBASE_ACCESS_VIOLATION,    // Access Violation
  vbDBASE_ASSERT_ERROR,        // Assertion failed
  vbDBASE_BAD_CLASS_ID,        // Wrong object type
  vbDBASE_BAD_OBJECT_ADDRESS,  // Bad object address
  vbDBASE_BAD_REFERENCE,       // Bad Reference
  vbDBASE_CACHE_FULL,          // Cache full
  vbDBASE_CHECKSUM_ERROR,      // Checksum Error
  vbDBASE_DIVIDEBY_ZERO,       // Divide By Zero Error
  vbDBASE_EOF_ERROR,           // Unexpected end of file
  vbDBASE_FILE_CLOSE_ERROR,    // Error closing file
  vbDBASE_FILE_CORRUPT,        // File corrupted
  vbDBASE_FILE_CREATION_ERROR, // Error creating file
  vbDBASE_FILE_EXISTS,         // File already exists
  vbDBASE_FILE_NOT_OPEN_ERROR, // Trying to use a closed file
  vbDBASE_FILE_NOT_READY,      // File not ready (failed or closed file)
  vbDBASE_FILE_NOT_WRITEABLE,  // Could not write to file 
  vbDBASE_FILE_OPEN_ERROR,     // Error opening file
  vbDBASE_FILE_POSITION_ERROR, // Cannot obtain the current file position
  vbDBASE_FILE_READ_ERROR,     // Error reading file  
  vbDBASE_FILE_SEEK_ERROR,     // Error seeking in file
  vbDBASE_FILE_WRITE_ERROR,    // Error writing to file
  vbDBASE_NO_DATABASE_OPEN,    // No database open
  vbDBASE_NO_FILE_EXISTS,      // No such file exists
  vbDBASE_NO_OBJECTS_EXIST,    // No objects exist
  vbDBASE_NULL_PTR,            // Accessing a null pointer 
  vbDBASE_OBJECT_EXISTS,       // Object already exists
  vbDBASE_OPEN_FILE_REFERENCE, // Another object is referencing this file
  vbDBASE_OVERFLOW,            // Math overflow
  vbDBASE_PARSE_ERROR,         // Parse error
  vbDBASE_PATH_ERROR,          // Invalid path
  vbDBASE_READ_ONLY_FILE,      // Trying to write to read-only file
  vbDBASE_STACK_EMPTY,         // Stack empty
  vbDBASE_STACK_FULL,          // Stack full
  vbDBASE_SYNC_ERROR,          // Synchronization Error
  vbDBASE_UNDERFLOW,           // Math under-flow
  vbDBASE_WRONG_FILE_TYPE,     // Wrong file type

  // Persistent lock error codes
  vbDBASE_INVALID_LOCK_TYPE,        // Invalid lock type specified
  vbDBASE_FILELOCK_ACCESS_ERROR,    // The file lock cannot be accessed
  vbDBASE_FILELOCK_ERROR,           // Error locking the file
  vbDBASE_RECORDLOCK_ACCESS_ERROR,  // The record lock cannot be accessed
  vbDBASE_RECORDLOCK_ERROR          // Error locking a record
};

// Standalone functions use to report database errors
const char *vbDatabaseExceptionMessage(vbDatabaseError err);

#ifdef __CPP_EXCEPTIONS__
// Class declarations for exceptions representing program errors. 
// This implementation is provided for use C++'s built-in exception
// handling routines.

// A fatal file error condition has been reached. All database engine
// calls must catch this exception and evaluate it by testing the
// vbDatabase or vbDatabase64 internal error variable.
class vbCDatabaseException { };  

#endif // __CPP_EXCEPTIONS__

#endif // __VBD_ERROR_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
