// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA

Test program demonstrating how to create thread-specific data. 
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"

// Constants
const int NUM_THREADS = 2;
 
// Thread specific data used in this process
struct threadSpecific_data_t
{
  threadSpecific_data_t(int i, int j) {
    threadSpecific1 = i; threadSpecific2 = j; 
  }
  
  int threadSpecific1;
  int threadSpecific2;
};

// Thread key
vbThreadKey threadSpecificKey;

class SimpleThread : public vbThread
{
public:
  SimpleThread () { oid = 1; }
  
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
  void ThreadExitRoutine(vbThread_t *thread);
  
private: // Functions that use the threadSpecific data
  void foo(vbThread_t *thread);  
  void bar(vbThread_t *thread);

private:
  vbThreadObjectID oid;
};

void *SimpleThread::ThreadEntryRoutine(vbThread_t *thread)
// Thread's entry function
{
  thread->SetObjectID(oid++);
  cout << "Entering thread: " << thread->GetObjectID() << endl;
  
  threadSpecific_data_t *gData = \
    (threadSpecific_data_t *)thread->GetThreadParm();

  if(ThreadSetSpecific(threadSpecificKey, gData) != 0) {
    cout << "Thread local storage error" << endl;
    return ExitThread(thread, 1);
  }
  
  foo(thread);
  return 0;
}
 
void SimpleThread::foo(vbThread_t *thread)
{
  threadSpecific_data_t *gData = \
    (threadSpecific_data_t *)ThreadGetSpecific(threadSpecificKey);

  cout << "Thread: " << thread->GetObjectID() << " entering foo(), ";
  cout << "threadSpecific data = " << gData->threadSpecific1 << ' '
       << gData->threadSpecific2
       << endl;

  bar(thread);
}
 
void SimpleThread::bar(vbThread_t *thread)
{
  threadSpecific_data_t *gData = \
    (threadSpecific_data_t *)ThreadGetSpecific(threadSpecificKey);
  
  cout << "Thread: " << thread->GetObjectID() << " entering bar(), ";
  cout << "threadSpecific data = " << gData->threadSpecific1 << ' '
       << gData->threadSpecific2
       << endl;
}
 
void SimpleThread::ThreadExitRoutine(vbThread_t *thread)
{
  cout << "Thread: " << thread->GetObjectID() << " exiting" << endl;

  void *parm = thread->GetThreadParm();

  // Free the local storage resources
  delete parm;
}
 
int main()
{
  SimpleThread t;
  vbThread_t *thread[NUM_THREADS];

  if(t.ThreadKeyCreate(threadSpecificKey) != 0) {
    cout << "Thread local storage error!" << endl;
    cout << "Could not obtain and index." << endl;
    return 1;
  }

  cout << "Creating " << NUM_THREADS << " threads" << endl;
  int i;
  for(i = 0; i < NUM_THREADS; i++) {
    // Create per-thread threadSpecific data and pass it to the thread
    threadSpecific_data_t *gData = new threadSpecific_data_t(i, ((i+1)*2));
    thread[i] = t.CreateThread((void *)gData);
    t.sSleep(1); // Allow the thread to print their messages in order
  }
 
  cout << "Wait for the threads to complete, and release their resources"
       << endl;
  for(i = 0; i < NUM_THREADS; i++) t.JoinThread(thread[i]);

  // Release the index
  t.ThreadKeyDelete(threadSpecificKey);

  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
