// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Simple test program demonstrating the basic operation of the
vbThread class using an entry and exit function.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"

class SimpleThread : public vbThread
{
public:
  SimpleThread() { }
  ~SimpleThread() { }
  
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
  void ThreadExitRoutine(vbThread_t *thread);
};


void *SimpleThread::ThreadEntryRoutine(vbThread_t *thread)
{
  cout << endl;
  cout << "Executing thread..." << endl;
  return 0;
}

void SimpleThread::ThreadExitRoutine(vbThread_t *thread)
{
  cout << "Exiting thread..." << endl;
  cout << endl;
}

int main()
{
  SimpleThread t;

  t.CreateThread();

  t.sSleep(1); // Wait for the thread to exit
  
  return 0; // Exit the process, terminating all threads
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

