// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 04/28/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program used demonstrate the use of the vbThread
library in multi-threaded server.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include <stdlib.h>
#include "httpserv.h"

int main(int argc, char **argv)
{
  // Check arguments. Should be only one: the port number to bind to.
  if(argc != 2) {
    cerr << "Usage: " << argv[0] << " port" << endl;
    return 1;
  }

  unsigned short port = (unsigned short) atoi(argv[1]);
  vbHTTPServer server;
  
  cout << "Initializing the HTTP server..." << endl;
  int rv = server.InitHTTPServer(port);
  if(rv != 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }

  // Get the host name assigned to this machine
  char hostname[vbsMAX_NAME_LEN];
  rv = server.HostName(hostname);
  if(rv != 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }

  cout << "Opening HTTP server on host " << hostname << endl;
  cout << "Press Ctrl C to exit" << endl;
  cout << endl;
  
  cout << "Listening on port " << port << endl;

  while(1) { // Loop forever accepting connections

    // Block the server until a client requests service
    if(server.Accept() < 0) {
      cout << server.SocketExceptionMessage() << endl;
      continue;
    }

    // Get the client info
    char client_name[vbsMAX_NAME_LEN]; int r_port = -1;
    server.GetClientInfo(client_name, r_port);
    
    cout << "Recieved request from " << client_name 
	 << " remote port " << r_port << endl << flush;

    // Start a client thread
    vbThread_t *client_thread = server.CreateThread();
    if(client_thread->GetThreadError() != vbTHREAD_NO_ERROR) {
      cout << client_thread->ThreadExceptionMessage() << endl;
    }
  }

  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

