// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
vbMutex example program demonstrating how to protect access to
shared data.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"
#include "vbmutex.h"

// Constants
const int NUMTHREADS = 3;

// Mutex that will be shared by threads within this process
vbMutex mutex;

// Shared data
int sharedData1 = 0;
int sharedData2 = 0;

class SimpleThread : public vbThread
{
public:
  SimpleThread() { }
  ~SimpleThread() { }
  
public:
  void Begin();
  void End();
  
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);

public:
  vbThread_t *thread[NUMTHREADS];
};

void *SimpleThread::ThreadEntryRoutine(vbThread_t *thread)
{
  cout << "Entering thread" << endl;
  mutex.MutexLock();
  
  //********** Critical Section *******************//
  cout << "Start critical section, holding lock" << endl;

  // Access to shared data goes here 
  ++sharedData1; --sharedData2;
  cout << "sharedData1 = " << sharedData1 << ", sharedData2 = " << sharedData2
       << endl;
  
  cout << "End critical section, release lock" << endl;
  //********** Critical Section *******************//

  mutex.MutexUnlock();
  return 0;
}

void SimpleThread::Begin()
{
  for(int i = 0; i < NUMTHREADS; ++i) thread[i] = CreateThread();
}

void SimpleThread::End()
{
  for(int i = 0; i < NUMTHREADS; ++i) JoinThread(thread[i]);
}

int main()
{
  SimpleThread t;
  
  cout << "Hold Mutex to prevent access to shared data" << endl;
  cout << "sharedData1 = " << sharedData1 << ", sharedData2 = " << sharedData2
       << endl;
  
  mutex.MutexLock();
 
  cout << "Create/start threads" << endl;
  t.Begin();
  
  cout << "Wait a until we are done with the shared data" << endl;
  t.sSleep(3);

  cout << "Unlock shared data" << endl;
  mutex.MutexUnlock();

  cout << "Wait for the threads to complete, and release their resources"
       << endl;
  t.End();
  
  return 0; // Exit the process
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

 
