// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Simple test program demonstrating the vbThread status and error
message functions for vbThread_t types.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include <stdlib.h>
#include "vbthread.h"

// Constants
const int THREAD_EXIT_CODE = 15; // Arbitrary exit code value

void PrintThreadStatus(vbThread_t *thread)
{
  cout << "Thread OID: " << (int)thread->GetObjectID() << endl;
  cout << "Thread CID: " << (int)thread->GetClassID() << endl;
  cout << thread->ThreadExceptionMessage() << endl;
  cout << thread->ThreadPriorityMessage() << endl;
  cout << thread->ThreadStateMessage() << endl;
  cout << thread->ThreadTypeMessage() << endl;
  if(thread->GetStackSize() > (vbStackSizeType)0)
    cout << "Stack size: " << (int)thread->GetStackSize() << endl;
  if(thread->GetThreadExitCode() == (vbThreadExitCode)THREAD_EXIT_CODE)
    cout << "Exit code: " << (int)thread->GetThreadExitCode() << endl;
}

class SimpleThread : public vbThread
{
public:
  SimpleThread() { cid = 1500; oid = 0; }
  ~SimpleThread() { }
  
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
  void ThreadExitRoutine(vbThread_t *thread);

private:
  vbThreadObjectID oid;
  vbThreadClassID cid;
};

void *SimpleThread::ThreadEntryRoutine(vbThread_t *thread)
{
  thread->SetClassID(cid);
  thread->SetObjectID(oid++);
  PrintThreadStatus(thread);  
  sSleep(1);
  return (void *)THREAD_EXIT_CODE;
}

void SimpleThread::ThreadExitRoutine(vbThread_t *thread)
{
  cout << endl;
  PrintThreadStatus(thread);  
  cout << endl;
}

// Main thread of execution
int main()
{
  SimpleThread t;

  const int NUM_THREADS = 10;
  vbThread_t *thread[NUM_THREADS];

  int i;
  for(i = 0; i < NUM_THREADS; i++) {
    thread[i] = t.CreateThread();

    // Check for any errors created during thread creataion
    if(thread[i]->GetThreadError() != 0) {
      cout << thread[i]->ThreadExceptionMessage() << endl;
    }

    t.sSleep(3);
  }

  // Wait for all the threads to finish before exiting
  for(i = 0; i < NUM_THREADS; i++) t.JoinThread(thread[i]);
  

  // Cleanup all the vbThread_t pointers
  for(i = 0; i < NUM_THREADS; i++) {
    int rv = t.DestroyThread(thread[i]);
    if(rv != 0) {
      cout << "Error destroying thread!" << endl;
    }
  }

  return 0; // Exit the process
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

