// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vsheader.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This include file contains cross-platform type definitions and
enumerations used throughout the VB socket library.
*/
// ----------------------------------------------------------- //   
#ifndef __VBSOCKET_TYPES_HPP__
#define __VBSOCKET_TYPES_HPP__

// --------------------------------------------------------------
// Platform specific include files
// --------------------------------------------------------------
#if defined (__WIN32__)
#include <winsock.h>

#elif defined (__UNIX__)
#include <unistd.h>     // UNIX standard function definitions 
#include <sys/types.h>  // Type definitions
#include <netdb.h>      // Net DB structures
#include <arpa/inet.h>  // Inet functions
#include <netinet/in.h> // Structures defined by the internet system
#include <sys/socket.h> // Definitions related to sockets

#else
#error You must define a target platform:\n __WIN32__ or __UNIX__
#endif
// --------------------------------------------------------------

// --------------------------------------------------------------
// Type definitions
// --------------------------------------------------------------
typedef int vbsAddressFamily;  // Address family to which a socket belongs
typedef int vbsProtocolFamily; // Protocol family to which a socket belongs
typedef int vbsSocket_t;       // Type used to ID sockets
typedef int vbsPort_t;         // Data type used for port numbers
typedef sockaddr_in vbsSocketAddress; // Sock Internet address
typedef servent vbsServent;           // Service name and protocol information
typedef hostent vbsHostNameInfo;      // Host name information
// --------------------------------------------------------------

// --------------------------------------------------------------
// Constants 
// --------------------------------------------------------------
const unsigned vbsBUF_SIZE     =  1024; // Fixed string buffer length
const unsigned vbsMAX_NAME_LEN =  255;  // Maximum string name length
// --------------------------------------------------------------

// --------------------------------------------------------------
// Enumerations
// --------------------------------------------------------------
enum vbsSocketError {    // vbSocket exception codes
  vbSOCKET_NO_ERROR = 0,       // No socket errors reported
  vbSOCKET_INVALID_ERROR_CODE, // Invalid socket error code

  // Socket error codes
  vbSOCKET_ACCEPT_ERROR,         // Error accepting remote socket
  vbSOCKET_BIND_ERROR,           // Could not bind socket
  vbSOCKET_CONNECT_ERROR,        // Could not connect socket
  vbSOCKET_HOSTNAME_ERROR,       // Could not resolve hostname
  vbSOCKET_INIT_ERROR,           // Initialization error
  vbSOCKET_LISTEN_ERROR,         // Listen error
  vbSOCKET_PROTOCOL_ERROR,       // Unknown protocol requested
  vbSOCKET_RECEIVE_ERROR,        // Receive error
  vbSOCKET_SERVICE_ERROR,        // Unknown service requested
  vbSOCKET_SOCKETTYPE_ERROR,     // Unknown socket type requested
  vbSOCKET_TRANSMIT_ERROR,       // Transmit error

  // WIN32 WinSock Error Codes (Transparent to UNIX applications)
  vbSOCKET_WINSOCKCLEANUP_ERROR, // WSACleanup operation failed
  vbSOCKET_WINSOCKEINVAL_ERROR,  // Version specified not supported by DLL
  vbSOCKET_WINSOCKINIT_ERROR,    // Could not initialize Winsock
  vbSOCKET_WINSOCKNETWORK_ERROR, // Network subsystem is not ready
  vbSOCKET_WINSOCKVERSION_ERROR, // Requested version not supported
  
  // Exception codes added to handle variable block errors
  vbSOCKET_BLOCKACK_ERROR,    // Variable block acknowledgment error
  vbSOCKET_BLOCKHEADER_ERROR, // Bad variable block header
  vbSOCKET_BLOCKSIZE_ERROR,   // Bad variable block size
  vbSOCKET_BLOCKSYNC_ERROR    // Variable block synchronization error
};

enum vbsSocketLibraryVersion {
  // Platform specific library version constants

  // WIN32 supported WSA versions. NOTE: The WSA constants have no
  // meaning in UNIX implementations but will work transparently in
  // all UNIX applications.
  vbSOCKET_WSAVER_ONEZERO, // Testing purposes only
  vbSOCKET_WSAVER_ONEONE,  // Windows 95A/B/C, 98, 98SE, NT4.0 compatible
  vbSOCKET_WSAVER_TWOZERO, // Windows 98, 98SE, 2000 compatible
  vbSOCKET_WSAVER_TWOTWO   // Windows 98SE, 2000 compatible
};

enum vbsServices {
  // Common port assignments
  vbSOCKET_FTP_PORT        = 21,  // tcp ftp port
  vbSOCKET_TELNET_PORT     = 23,  // tcp telnet port
  vbSOCKET_SMTP_PORT       = 25,  // tcp simple mail transfer protocol port
  vbSOCKET_TIME_PORT       = 37,  // tcp time server
  vbSOCKET_NAME_PORT       = 42,  // tcp name server
  vbSOCKET_NAMESERVER_PORT = 53,  // tcp domain name server
  vbSOCKET_FINGER_PORT     = 79,  // tcp finger port
  vbSOCKET_HTTP_PORT       = 80,  // tcp http port
  vbSOCKET_POP_PORT        = 109, // tcp postoffice protocol
  vbSOCKET_POP2_PORT       = 109, // tcp postoffice protocol
  vbSOCKET_POP3_PORT       = 110, // tcp postoffice protocol
  vbSOCKET_NNTP_PORT       = 119, // tcp network news transfer protocol

  // vbsSocket default port assignment
  vbsDEFAULT_PORT = 3000 // Value used if no port is assigned
};

enum vbsServerTypes {
  vbSOCKET_STREAM_SERVER,
  vbSOCKET_DATAGRAM_SERVER,
  vbSOCKET_SERIAL_PORT_SERVER,
  vbSOCKET_HTTP_SERVER,
  vbSOCKET_LOCAL_FILE_SYSTEM
};

enum vbClientTypes {
  vbSOCKET_STREAM_CLIENT,
  vbSOCKET_DATAGRAM_CLIENT,
  vbSOCKET_HTTP_CLIENT,
  vbSOCKET_SERIAL_PORT_CLIENT
};
// --------------------------------------------------------------

#endif // __VBSOCKET_TYPES_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
