// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Simple test program demonstrating the basic operation of the
vbThread class using condition variables.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"
#include "vbcond.h"
#include "vbmutex.h"

// For safe condition variable usage, must use a boolean predicate and 
// a mutex with the condition.
int conditionMet = 0;
vbCondition cond;
vbMutex mutex;

class SimpleThread : public vbThread
{
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
};

void *SimpleThread::ThreadEntryRoutine(vbThread_t *thread)
// Thread's entry function
{
  mutex.MutexLock();
  
  while (!conditionMet) {
    cout << "Thread blocked" << endl;
    cond.ConditionWait(&mutex);
  }

  mutex.MutexUnlock();

  return 0;
}

int main(int argc, char **argv)
{
  const int NUM_THREADS = 5;
  SimpleThread t;
  vbThread_t *thread[NUM_THREADS];

  cout << "Create " << NUM_THREADS << " threads" << endl;
  int i;
  for(i = 0; i < NUM_THREADS; i++) thread[i] = t.CreateThread(); 

  t.sSleep(1); // Serialize the threads 
  mutex.MutexLock();
  
  // The condition has occured. Set the flag and wake up any waiters
  conditionMet = 1;
  cout << "Wake up all waiters..." << endl;
  cond.ConditionBroadcast();
  
  mutex.MutexUnlock();

  
  cout << "Wait for threads before exiting" << endl;
  for(i = 0; i < NUM_THREADS; ++i) t.JoinThread(thread[i]);

  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

