// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbdfptr.cpp 
// Compiler Used: MSVC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer  
// File Creation Date: 02/04/1997 
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The VBD file pointer routines are a collection of classes and
standalone functions used to define the underlying file system
used by the VBD file manager. NOTE: None of the data structures
and functions defined here are intended to be used directly. They
are used by the vbDatabase class to call the correct native file
API function for each supported platform.
*/
// ----------------------------------------------------------- // 
#include "vbdfptr.h"

vbdFPTR *vbdFPTRCreate(const char *fname)
// Create a new file and truncate existing files.
// Returns a null value if the file cannot be
// created.
{
  vbdFPTR *stream = new vbdFPTR;
  if(!stream) return 0;
  stream->fptr = fopen(fname, "w+b");
  if(stream->fptr == 0) return 0;
  return stream;
}

vbdFPTR *vbdFPTROpen(const char *fname, vbDatabaseAccessMode mode)
// Open an exsiting file. The "mode" variable determines if the file
// is opened for read only or read/write access. Returns a null value
// if the specified file cannot be opened. NOTE: This version of the
// open functions will only accept: vbDBASE_READONLY and vbDBASE_READWRITE
// access modes.
{
  vbdFPTR *stream = new vbdFPTR;
  if(!stream) return 0;

  if(mode == vbDBASE_READONLY) { // Open for read only access
    stream->fptr = fopen(fname, "rb");
    if(stream->fptr == 0) return 0;
  }
  else { // Open for read/write access
    stream->fptr = fopen(fname, "r+b");
    if(stream->fptr == 0) return 0;
  }
  return stream;
}

int vbdFPTRClose(vbdFPTR *stream)
// Close an open file. Returns a non-zero value to
// indicate an error condition or zero if successful.
{
  if(!stream) return 0; // The file stream is not open
  if(fclose(stream->fptr) != 0) return 1;
  stream->fptr = 0;
  delete stream;
  return 0;
}

int vbdFPTRFlush(vbdFPTR *stream)
// Flush the any open disk buffers. Returns
// a non-zero value to indicate an error
// condition or zero if successful. 
{
  if(fflush(stream->fptr) != 0)
    return 1;
  else
    return 0;
}

int vbdFPTRRead(vbdFPTR *stream, void *buf, __UWORD__ bytes)
// Read a specified number of bytes from the current file position
// into a memory buffer. Returns a non-zero value to indicate an error
// condition or zero if successful.
{
  if(!stream) return 1; // The file stream is not open

  if(fread((unsigned char *)buf, 1, bytes, stream->fptr) != bytes) return 1;

  return 0;
}

int vbdFPTRWrite(vbdFPTR *stream, const void *buf, __UWORD__ bytes) 
// Write a specific number of bytes from a memory buffer to the
// current file position. Returns a non-zero value to indicate an
// error condition or zero if successful.
{
  if(!stream) return 1; // The file stream is not open

  if(fwrite((const unsigned char *)buf, 1, bytes, stream->fptr) != bytes)
    return 1;

  return 0;
}

__LWORD__ vbdFPTRSeek(vbdFPTR *stream, __LWORD__ offset,
		      vbDatabaseSeekMode mode)
// Seek to the specified offset starting at the beginning (SEEK_SET),
// end (SEEK_END) or current offset (SEEK_CUR). Returns a negative 1
// to indicate an error condition or the current stream position if
// successful.
{
  if(!stream) return 1; // The file stream is not open

  if(mode == vbDBASE_SEEK_BEG) {
    return fseek(stream->fptr, offset, SEEK_SET);
  }
  else if(mode == vbDBASE_SEEK_CUR) {
    return fseek(stream->fptr, offset, SEEK_CUR);
  }
  else if(mode == vbDBASE_SEEK_END) {
    return fseek(stream->fptr, offset, SEEK_CUR);
  }
  else { // An invalid seek mode was specified
    return (__LWORD__)-1;
  }
}

__LWORD__ vbdFPTRTell(vbdFPTR *stream)
{
  if(!stream) return (__LWORD__)-1; // The file stream is not open
  
  return ftell(stream->fptr);
}

int vbdFPTRExists(const char *fname)
// Returns true if the specified file exists.
{
  struct stat buf;
  return stat(fname, &buf) == (__LWORD__)0;
}

__LWORD__ vbdFPTRFileSize(const char *fname)
// Returns the length of the specified file or negative 1
// to indicate an error condition.
{
  struct stat buf;
  int result = stat(fname, &buf);
  if(result != 0) return -1;
  return buf.st_size;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
