// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Simple test program demonstrating the basic operation of the
vbThread class using templates.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"

template <class TYPE>
class SimpleThread : public vbThread
{
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
};

template <class TYPE>
void *SimpleThread<TYPE>::ThreadEntryRoutine(vbThread_t *thread)
// Thread's entry function
{
  cout << endl;
  TYPE info = *((TYPE *)thread->GetThreadParm());
  cout << "Executing thread: " << info  << endl;
  return 0;
}

// Program's main thread of execution
int main()
{
  SimpleThread<int> t1;
  SimpleThread<char> t2;
  SimpleThread<char *> t3;

  int i = 5;
  t1.CreateThread((void *)&i); // Create and execute a thread
  t1.sSleep(1); // Wait for the thread to exit
  
  char c = 'A';
  t2.CreateThread((void *)&c); 
  t2.sSleep(1); 
  
  char *s = "TEST";
  t3.CreateThread((void *)&s); 
  t3.sSleep(1); 

  return 0; // Exit the process, terminating all threads
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

