// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA
 
Simple test program demonstrating barrier synchronization
using the VbSemaphore class.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include <stdlib.h>
#include "vbthread.h"
#include "vbsema.h"

// Global semaphore objects
vbSemaphore semaA, semaB;

// Classes derived from the vbThread base class 
class Simple1 : public vbThread
{
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
};

class Simple2 : public vbThread
{
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
};

void *Simple1::ThreadEntryRoutine(vbThread_t *thread)
{
  cout << "Thread 1 here, before the barrier." << endl;
  semaB.SemaphorePost();
  semaA.SemaphoreWait();
  cout << "Thread 1 after the barrier." << endl;
  return 0;
}

void *Simple2::ThreadEntryRoutine(vbThread_t *thread)
{
  cout << "Thread 2 here, before the barrier." << endl;
  semaA.SemaphorePost();
  semaB.SemaphoreWait();
  cout << "Thread 2 after the barrier." << endl;
  return 0;
}

int main()
{
  Simple1 t1;
  Simple2 t2;

  vbThread_t *t1_thread = t1.CreateThread();
  vbThread_t *t2_thread = t2.CreateThread();

  t1.JoinThread(t1_thread);
  t2.JoinThread(t2_thread);

  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

