// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA

Test program demonstrating how to change the detachstate attribute
of a newly created thread. You cannot use the thread ID (the value
of type vbThread_t::thread_is) for a detached thread. This means
that you cannot cancel the thread or use the vbThread::JoinThread()
function to to wait for the thread to complete or to retrieve the
thread's exit status. The system will reclaim a detached thread's
resources when the detach thread exits. 
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "vbthread.h"

class SimpleThread : public vbThread
{
private: // Base class interface
  void *ThreadEntryRoutine(vbThread_t *thread);
};

void *SimpleThread::ThreadEntryRoutine(vbThread_t *thread)
// Thread's entry function
{
  cout << "Executing thread: " << (int)thread->GetThreadParm() << ", "
       << thread->ThreadTypeMessage() << '\n' << flush;
    
  return 0;
}

int main()
{
  const unsigned NUM_THREADS = 10;

  vbThreadType type = vbTHREAD_TYPE_DETACHED;
  
  SimpleThread *t = new SimpleThread;
  vbThread_t *thread[NUM_THREADS];
  
  unsigned i;
  cout << "Creating " << NUM_THREADS << " threads" << endl;
  for(i = 0; i < NUM_THREADS; i++) {
    thread[i] = t->CreateThread((void *)i, type);

    // Check for any errors
    if(thread[i]->GetThreadError() != vbTHREAD_NO_ERROR)
      cout << thread[i]->ThreadExceptionMessage() << endl;
    
    // Allow the threads to print there messages in order
    t->sSleep(1);
  }

  cout << "Waiting for the all treads to finish..." << endl;
  t->sSleep(3);

  cout << endl;
  cout << "Destroying all the threads..." << endl;
  for(i = 0; i < NUM_THREADS; i++) t->DestroyThread(thread[i]);

  cout << "Exiting..." << endl;

  delete t;
  return 0; // Exit the process, terminating all threads
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

