// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbdatagm.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/12/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbDatagram class is derived from the vbSocket class and is 
used to send and receive variable blocks over a UDP connection.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include "vbdatagm.h"

// Datagram functions
// --------------------------------------------------------------
int vbDatagram::DatagramServer(int port)
// Initialize a datagram server. Please note all ports below 1024 are
// reserved. Returns a non-zero value if any errors occur during
// initialization. 
{
  if(InitSocketLibrary() == 0) {
    if(InitSocket(SOCK_DGRAM, port) < 0) return socket_error;
  }
  else {
    return socket_error;
  }

  // Bind the name to the socket
  if(Bind() < 0) {
    Close();
    return socket_error;
  }

  return socket_error = vbSOCKET_NO_ERROR;
}

int vbDatagram::DatagramClient(int port, char *host)
// Connect a Datagram client. Please note all ports below 1024 are
// reserved. Returns zero if no errors occur during initialization.
{
  if(InitSocketLibrary() == 0) {
    if(InitSocket(SOCK_DGRAM, port, host) < 0) return socket_error;
  }
  else {
    return socket_error;
  }

  return socket_error = vbSOCKET_NO_ERROR;  
}

void vbDatagram::SetBlockStatus(vbBlockHeader &vb, __SBYTE__ net_status,
			      __SBYTE__ file_status)
// Set the variable block header status member control byte.
// NOTE: The block's next deleted variable must be set, if
// needed, after a call to this function. The block length
// will not be set here.
{
  __ULWORD__ block_status = net_status;
  block_status = (block_status<<8) & 0xff00;
  block_status += file_status;
  vb.block_status = block_status;
  vb.block_check_word = vbCheckWord;
  vb.block_nd_fptr = (FAU)0;
}

int vbDatagram::WriteBlock(vbsSocket_t s, vbsSocketAddress *sa, 
			   const void *buf, int bytes)
// Write a block of raw data to the socket. NOTE: All block read and write
// operations must operate in blocking mode to maintain synchronization
// between the transmitter and receiver. Returns zero if no errors
// occur.
{
  vbBlockHeader vb;
  SetBlockStatus(vb, vbSendBlock);
  vb.block_length = bytes;

  // Write the block header
  if(WriteBlock(s, sa, buf, vb) != vbSOCKET_NO_ERROR) 
    return socket_error;
  
  return socket_error = vbSOCKET_NO_ERROR;  
}

int vbDatagram::WriteBlock(vbsSocket_t s, vbsSocketAddress *sa, 
			   const void *buf, vbBlockHeader &vb)
// Write a variable block to the specified socket. Returns zero if no
// errors occur. NOTE: This function assumes that the block header has
// already been initialized.
{
  // Write the block header
  if(WriteHeader(s, sa, vb) != vbSOCKET_NO_ERROR) return socket_error;

  // Write the block
  if(SendTo(s, sa, (char *)buf, vb.block_length) < 0)
    return socket_error;
  
  if(bytes_moved != vb.block_length) 
      return socket_error = vbSOCKET_BLOCKSIZE_ERROR;

  return socket_error = vbSOCKET_NO_ERROR;  
}

int vbDatagram::WriteHeader(vbsSocket_t s, vbsSocketAddress *sa, 
			    vbBlockHeader &vb)
// Write a variable block header to the specified socket.
// returns zero if no errors occur.
{
  // Write the block header
  if(SendTo(s, sa, (char *)&vb, sizeof(vbBlockHeader)) < 0)
    return socket_error;

  // If the bytes sent do not equal the bytes moved then
  // the transmitter and receiver are no longer synchronized.
  if(bytes_moved != sizeof(vbBlockHeader)) 
    return socket_error = vbSOCKET_BLOCKHEADER_ERROR;

  return socket_error = vbSOCKET_NO_ERROR;
}

int vbDatagram::ReadBlock(vbsSocket_t s, vbsSocketAddress *sa, void *buf, 
			  vbBlockHeader &vb)
// Read variable block from the specified socket. Returns zero
// if no errors occur.
{
  if(RecvFrom(s, sa, buf, vb.block_length) < 0)
    return socket_error;

  // If the bytes read do not equal the bytes received then
  // the transmitter and receiver are no longer synchronized.
  if(bytes_read != vb.block_length) 
    return socket_error = vbSOCKET_BLOCKSIZE_ERROR;

  return socket_error = vbSOCKET_NO_ERROR;
}

int vbDatagram::ReadHeader(vbsSocket_t s, vbsSocketAddress *sa, 
			   vbBlockHeader &vb)
// Read a variable block header from the specified socket.
// Returns zero if no errors occur or an error number
// corresponding to a value defined in the vbsSocketError
// enumeration.
{
  if(RecvFrom(s, sa, (char *)&vb, sizeof(vbBlockHeader)) < 0)
    return socket_error;

  // If the bytes read do not equal the bytes received then
  // the transmitter and receiver are no longer synchronized.
  if(bytes_read != sizeof(vbBlockHeader)) 
    return socket_error = vbSOCKET_BLOCKHEADER_ERROR;
      
  if(vb.block_check_word != vbCheckWord) 
    return socket_error = vbSOCKET_BLOCKSYNC_ERROR;
  	
  return socket_error = vbSOCKET_NO_ERROR;    
}

void *vbDatagram::RequestBlock(vbsSocket_t s, vbsSocketAddress *sa, 
			       const void *request,
			       vbBlockHeader &request_header, 
			       vbBlockHeader &requested_block_header)
// Request a block from the specified socket. Returns the requested block
// or a null value if an error occurs.
{
  SetBlockStatus(request_header, vbRequestBlock);

  // Write the request header and the request itself
  if(WriteBlock(s, sa, request, request_header) != vbSOCKET_NO_ERROR)
    return 0;
  
  // Read the returned request header 
  if(ReadHeader(s, sa, requested_block_header) != vbSOCKET_NO_ERROR) 0;

  // Read the returned requested block
  char *buf = new char[(__ULWORD__)requested_block_header.block_length];
  if(!buf) return 0;
  
  if(RecvFrom(s, sa, buf, requested_block_header.block_length) < 0)
    return 0;

  // Check the byte count to ensure that all blocks were received.
  if(bytes_read != requested_block_header.block_length) return 0; 

  return (void *)(buf); // Return the requested block
}

int vbDatagram::DeleteBlock(vbsSocket_t s, vbsSocketAddress *sa, 
			    const void *request,
			    vbBlockHeader &request_header)
// Request the a block be deleted on the remote end. Returns
// zero if no error occur.
{
  SetBlockStatus(request_header, vbDeleteRemoteBlock);

  // Write the delete request and the request itself
  if(WriteBlock(s, sa, request, request_header) != vbSOCKET_NO_ERROR)
    return socket_error;

  return socket_error = vbSOCKET_NO_ERROR;    
}

int vbDatagram::AddBlock(vbsSocket_t s, vbsSocketAddress *sa, 
			 const void *block, vbBlockHeader &block_header)
// Request that this block be added. Returns zero if no error 
// occur.
{
  SetBlockStatus(block_header, vbAddRemoteBlock);

  // Write the add request and then the block to add
  if(WriteBlock(s, sa, block, block_header) != vbSOCKET_NO_ERROR)
    return socket_error;

  return socket_error = vbSOCKET_NO_ERROR;    
}

int vbDatagram::ChangeBlock(vbsSocket_t s, vbsSocketAddress *sa, 
			    const void *request, const void *block, 
			    vbBlockHeader &request_header,  
			    vbBlockHeader &block_header)
// Request that this block be changed. Returns zero if no error 
// occur.
{
  // Write the change request and the request itself
  SetBlockStatus(request_header, vbChangeRemoteBlock);
  if(WriteBlock(s, sa, request, request_header) != vbSOCKET_NO_ERROR)
    return socket_error;

  // Write the changes
  SetBlockStatus(block_header, vbSendBlock);
  if(WriteBlock(s, sa, block, block_header) != vbSOCKET_NO_ERROR)
    return socket_error;

  return socket_error = vbSOCKET_NO_ERROR;    
}

int vbDatagram::WriteAckBlock(vbsSocket_t s, vbsSocketAddress *sa)
// Send an acknowledgment header to the specified socket.
// Returns zero if no errors occur.
{
  vbBlockHeader ack;
  SetBlockStatus(ack, vbAcknowledgeBlock);
  
  if(WriteHeader(s, sa, ack) != vbSOCKET_NO_ERROR)
    return socket_error = vbSOCKET_BLOCKACK_ERROR;
  
  return socket_error = vbSOCKET_NO_ERROR;    
}

int vbDatagram::ReadAckBlock(vbsSocket_t s, vbsSocketAddress *sa)
// Read an acknowledgment block from the specified socket.
// Returns zero if no errors occur.
{
  // Wait for an acknowledgment
  vbBlockHeader ack;
  if(ReadHeader(s, sa, ack) != vbSOCKET_NO_ERROR)
    return socket_error = vbSOCKET_BLOCKACK_ERROR;

  // Read the status byte to determine what to do with this block
  __ULWORD__ block_status = ack.block_status;
  __SBYTE__ status = (__SBYTE__)((block_status & 0xFF00)>>8);
      
  if(status != vbAcknowledgeBlock)
    return socket_error = vbSOCKET_BLOCKACK_ERROR;

  return socket_error = vbSOCKET_NO_ERROR; 
}

int vbDatagram::TerminateConnection(vbsSocket_t s, vbsSocketAddress *sa)
// Block command used to shutdown a server or client.
// Returns zero if no errors occur.
{
  vbBlockHeader vb;
  SetBlockStatus(vb, vbKillServer);

  if(WriteHeader(s, sa, vb) != vbSOCKET_NO_ERROR) return socket_error;

  return socket_error = vbSOCKET_NO_ERROR;  
}

int vbDatagram::CloseConnection(vbsSocket_t s, vbsSocketAddress *sa)
// Block command used to close a persistent client or
// server connection. Returns zero if no errors occur.
{
  vbBlockHeader vb;
  SetBlockStatus(vb, vbCloseConnection);

  if(WriteHeader(s, sa, vb) != vbSOCKET_NO_ERROR) return socket_error;

  return socket_error = vbSOCKET_NO_ERROR;  
}

int vbDatagram::PortNumber(int &port)
// Pass back the port number actually set by the system
// in the "port" variable.
{
  if(GetSockName() < 0) {
    return socket_error;
  }
  port = GetPortNumber();
  return socket_error = vbSOCKET_NO_ERROR;
}

int vbDatagram::RemotePortNumber(int &port)
// Pass back the port number actually set by the system
// in the "port" variable.
{
  port = GetRemotePortNumber();
  return socket_error = vbSOCKET_NO_ERROR;
}

int vbDatagram::HostName(char *hs)
{
  if(GetHostName(hs) < 0) {
    return socket_error;
  }
  return socket_error = vbSOCKET_NO_ERROR;
}

int vbDatagram::RemoteHostName(char *hs)
{
  if(GetRemoteHostName(hs) < 0) {
    return socket_error;
  }
  return socket_error = vbSOCKET_NO_ERROR;
}

int vbDatagram::WriteBlock(const void *buf, int bytes)
{
  return WriteBlock(vbsocket, &sin, buf, bytes);
}

int vbDatagram::TerminateConnection()
{
  return TerminateConnection(vbsocket, &sin);
}

int vbDatagram::CloseConnection()
{
  return CloseConnection(vbsocket, &sin);
}

int vbDatagram::ReadRemoteBlock(void *buf, vbBlockHeader &vb)
{
  return ReadBlock(vbsocket, &remote_sin, buf, vb);
}

int vbDatagram::ReadClientHeader(vbBlockHeader &vb)
{
  return ReadHeader(vbsocket, &remote_sin, vb);
}

int vbDatagram::WriteRemoteBlock(void *buf, int bytes)
{
  return WriteBlock(vbsocket, &remote_sin, buf, bytes);
}

void *vbDatagram::RequestBlock(const void *request,
			     vbBlockHeader &request_header, 
			     vbBlockHeader &requested_block_header)
{
  return RequestBlock(vbsocket, &sin, request, request_header,
		      requested_block_header);
}

int vbDatagram::DeleteBlock(const void *request, vbBlockHeader &request_header)
{
  return DeleteBlock(vbsocket, &sin, request, request_header);
}

int vbDatagram::WriteAckBlock()
{
  return WriteAckBlock(vbsocket, &sin);
}

int vbDatagram::WriteRemoteAckBlock()
{
  return WriteAckBlock(vbsocket, &remote_sin);
}

int vbDatagram::ReadAckBlock()
{
  return ReadAckBlock(vbsocket, &sin);
}

int vbDatagram::ReadRemoteAckBlock()
{
  return ReadAckBlock(vbsocket, &remote_sin);
}

int vbDatagram::AddBlock(const void *block, vbBlockHeader &block_header)
{
  return AddBlock(vbsocket, &sin, block, block_header);
}

int vbDatagram::ChangeBlock(const void *request, const void *block, 
			    vbBlockHeader &request_header, 
			    vbBlockHeader &block_header)
{
  return ChangeBlock(vbsocket, &sin, request, block, 
		     request_header, block_header);
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
