// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbsocket.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 04/28/2000
// Date Last Modified: 08/10/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

A very simple multi-threaded HTTP server built using the
vbThread library.
*/
// ----------------------------------------------------------- // 
#include "httpserv.h"
#include "string.h"

int vbHTTPServer::InitHTTPServer(int port, int max_connections)
// Initialize the HTTP server. Returns a non-zero value if any
// errors ocurr.
{
  if(InitSocketLibrary() == 0) {
    if(InitSocket(SOCK_STREAM, port) < 0) return 1;
  }
  else {
    return 1;
  }

  // Bind the name to the socket
  if(Bind() < 0) {
    Close();
    return 1;
  }
    
  // Listen for connections with a specifed backlog
  if(Listen(max_connections) < 0) {
    Close();
    return 1;
  }

  return 0;
}

int vbHTTPServer::RemotePortNumber(int &port)
// Pass back the port number actually set by the system
// in the "port" variable.
{
  port = GetRemotePortNumber();
  return 0;
}

int vbHTTPServer::HostName(char *hs)
{
  if(GetHostName(hs) < 0) {
    return 1;
  }
  return 0;
}

int vbHTTPServer::RemoteHostName(char *hs)
{
  if(GetRemoteHostName(hs) < 0) {
    return 1;
  }
  return 0;
}

void *vbHTTPServer::ThreadEntryRoutine(vbThread_t *thread)
// Client thread.
{
  const int rxbuf = 1024;
  char request[rxbuf];
  int rv = RawRemoteRead(request, rxbuf);
  request[rv] = 0; // Null terminate the buffer

  // At this point we need to parse the client request and process it.
  // For simplicity sake these operations have been omitted.
  // ... (parsing operation)
  // ... (processing operation)

  // Simply send a test page (with a header) back to the client.
  const char *test_page = "HTTP/1.0 200 OK\r\nServer: vbThread\r\nConnection: \
close\r\n\r\n<HTML>\n<HEAD>\n<TITLE> vbThread Test Page </TITLE>\n</HEAD>\
<BODY><CENTER><H1>vbThread Test Page</H1></CENTER><HR><PRE>Response from the \
multi-threaded HTTP server</PRE><HR><CENTER>End of document</CENTER>\n</BODY>\
\n</HTML>";

  RemoteSend(test_page, strlen(test_page));
  return 0;
}

void vbHTTPServer::ThreadExitRoutine(vbThread_t *thread)
// Thread exit function used to close the client thread.
{
  CloseRemoteSocket();
}

void vbHTTPServer::ThreadCleanupHandler(vbThread_t *thread)
// Thread cleanup handler used in the event that the thread is
// canceled.
{
  CloseRemoteSocket();
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
