// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: scomserv.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/12/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbSerialCommServer class is a used to establish a client
or server connection that can transmit or receive variable
blocks over a serial port.
*/
// ----------------------------------------------------------- //   
#ifndef __VBSCOMMSERVER_HPP__
#define __VBSCOMMSERVER_HPP__

#include "vbscomm.h"
#include "vbheader.h"

// Serial communications server/client
class vbSerialCommServer : public vbSerialComm
{
public:
  vbSerialCommServer() { }
  ~vbSerialCommServer() { }
  
public: // Client/Server configuration
  int InitCommServer(char *dev, int sp = 9600, char pr = 'N', int cs = 8,
		     int sb = 1,
		     int flow = vbSerialComm::scommNO_FLOW_CONTROL);

public: // Variable block functions
  void SetBlockStatus(vbBlockHeader &vb, __SBYTE__ dev_status,
		      __SBYTE__ file_status = vbRemoteDeviceBlock);
  int WriteBlock(const void *buf, int bytes);
  int WriteBlock(const void *buf, vbBlockHeader &vb);
  int WriteHeader(vbBlockHeader &vb);
  int ReadBlock(void *buf, vbBlockHeader &vb);
  int ReadHeader(vbBlockHeader &vb);
  void *RequestBlock(const void *request, vbBlockHeader &request_header, 
		     vbBlockHeader &requested_block_header);
  int AddBlock(const void *block, vbBlockHeader &block_header);
  int DeleteBlock(const void *request, vbBlockHeader &request_header);
  int ChangeBlock(const void *request, const void *block,
		  vbBlockHeader &request_header, vbBlockHeader &block_header);
  int WriteAckBlock();
  int ReadAckBlock();
  int TerminateConnection();
  int CloseConnection();
};

#endif // __VBSCOMMSERVER_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
