// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: client.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/14/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The program is used to test vbSerialComm class transmit 
functions by writing a file or character string to a serial 
port.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <fstream.h>
#include <string.h>
#include <stdlib.h>
#include "vbscomm.h"

int main(int argc, char **argv)
{
  if(argc < 2) {
    cout << "Serial port comsend program" << endl;
    cout << "Usage 1: " << argv[0] << " device name [baud rate]" << endl;
    cout << "Usage 2: " << argv[0] << " device name [baud rate] [file name]"
	 << endl;
    return 1;
  }

  vbSerialComm dev;
  int status = dev.OpenSerialPort(argv[1]);
  if(status < 0) {
    cout << "Cannot open the specifed device!" << endl;
    cout << "Exiting..." << endl;
    return 1;
  }
  else {
    if(status == vbSerialComm::scommREAD_WRITE)
      cout << argv[1] << " open for read/write access." << endl;
    else if(status == vbSerialComm::scommREAD_ONLY)
      cout << argv[1] << " open for read only access." << endl;
    else if(status == vbSerialComm::scommWRITE_ONLY)
      cout << argv[1] << " open for write only access." << endl;
    else {
      cout << "Invalid status opening " << argv[1] << endl;
      cout << "Exiting..." << endl;
      return 1;
    }
  }
  
  if(argc > 2 && atoi(argv[2])) dev.SetBaudRate(atoi(argv[2]));
  else dev.SetBaudRate(9600);

  dev.SetFlowControl(vbSerialComm::scommNO_FLOW_CONTROL);
  // dev.SetFlowControl(vbSerialComm::scommHARD_FLOW);
  // dev.SetFlowControl(vbSerialComm::scommSOFT_FLOW);
  // dev.SetFlowControl(vbSerialComm::scommXON_XOFF);

  dev.SetCharacterSize(8);
  // dev.SetCharacterSize(7);

  dev.SetParity('N');
  // dev.SetParity('E');
  // dev.SetParity('0');
  // dev.SetParity('M');
  // dev.SetParity('S'); 

  dev.SetStopBits(1);
  
  if(dev.InitSerialPort() < 0) {
    cout << "Cannot initalize the specifed device!" << endl;
    return 1;
  }
    
  if(status == vbSerialComm::scommREAD_ONLY) {
    cout << endl;
    cout << argv[1] << " is open for read only access." << endl;
    cout << "You do not have permission to write to this device!" << endl;
    cout << "Exiting..." << endl;
    cout << endl;
    return 1;
  }
  
  if(argc > 3) {
    char *fname = argv[3];
#if defined(__DOS__) || defined(__WIN32__)
    // In MS-DOS there are two file types, text and binary
#ifdef __BCC_BUILDER_40__
    // The BCC 32 ios class does not have an enumeration for "nocreate"
    fstream infile(fname, ios::in|ios::binary);
#else
    fstream infile(fname, ios::in|ios::nocreate|ios::binary);
#endif // __BCC_BUILDER_40__
    
#elif defined(__UNIX__) 
    // In UNIX there is only one file type
    fstream infile(fname, ios::in|ios::nocreate);
#else
#error You must define a file system: __DOS__, __WIN32__, or __UNIX__
#endif
    if(!infile) {
      cout << endl;
      cout << "Cannot open file: " << fname << endl;
      cout << "Exiting..." << endl;
      cout << endl;
	  return 0;
    }

    char c;
    const unsigned buff_sz = 1024;
    unsigned i, bytes_read;
    char sbuf[buff_sz];

    cout << "Coping the " << fname << " file to " << argv[1] << "..." << endl;
    bytes_read = 0;
    for(i = 0; i < buff_sz; i++) sbuf[i] = 0;
    while(!infile.eof()) {
      infile.get(c);
      sbuf[bytes_read] = c;
      bytes_read++;
      if((bytes_read == buff_sz) || (infile.eof())) {
	if(dev.Send((char *)sbuf, bytes_read) < 0) {
	  cout << "Error writing to the specifed device" << endl;
	  break;
	}
	bytes_read = 0;
	for(i = 0; i < buff_sz; i++) sbuf[i] = 0;
      }
    }
    cout << "File copied with no errors reported." << endl;
  }
  else {
    char *test_pattern = "The quick brown fox jumps over the lazy dog \
0123456789\n";
    cout << "Sending a test pattern to " << argv[1] << endl;
    if(dev.Send((char *)test_pattern, strlen(test_pattern)) < 0) {
      cout << "Error writing to the specifed device" << endl;
      return 1;
    }
    else {
      cout << strlen(test_pattern) << " bytes sent." << endl;
      cout << "Message was sent with no errors reported." << endl;
    }
  }
  
  dev.Close();
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
