// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: server.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/11/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This program is used to demonstrate how to stream variable blocks
across a network connection.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include "vbstream.h"
#include "dbobject.h"

int FindObject(vbStream *server, vbBlockHeader &vb,
	       DatabaseObject *dbobjectdb)
{
  cout << "Client has queried the database" << endl << flush;
 
  if(server->ReadRemoteBlock((char *)dbobjectdb->p, vb) != 0) return 1;
  cout << "Searching for: " << dbobjectdb->p->name << endl << flush;
  
  FAU addr = dbobjectdb->FindObject();
  if(!addr) {
    cout << "Did not find the object" << endl << flush;
    dbobjectdb->p->name[0] = 0;
    dbobjectdb->p->oid = (OID)0;
    dbobjectdb->p->cid = (CID)0;
  }
  else
    cout << "Found the requested object" << endl << flush;

  cout << "Sending search results to the client" << endl << flush;
  if(server->WriteRemoteBlock((char *)dbobjectdb->p,
			      sizeof(DatabaseObjectData))
     != 0) return 1;

  return 0;
}

int ChangeObject(vbStream *server, vbBlockHeader &vb,
		 DatabaseObject *dbobjectdb)
{
  cout << "Received a change object request" << endl << flush;
 
  // Read the name of the object to be changed
  if(server->ReadRemoteBlock((char *)dbobjectdb->p, vb) != 0) return 1;

  cout << "Client requested a change to object: " <<
    dbobjectdb->p->name << endl << flush;

  DatabaseObjectData new_dbobject_info;
  vbBlockHeader block_header;

  // Get the object's new info from the client 
  if(server->ReadClientHeader(block_header) != 0) return 1;
  if(server->ReadRemoteBlock((char *)&new_dbobject_info, block_header) != 0)
    return 1;

  FAU addr = dbobjectdb->ChangeObject(new_dbobject_info);
  if(!addr) {
    cout << "Change request denied: Did not find object in the database" 
	 << endl << flush;
    dbobjectdb->p->name[0] = 0;
    dbobjectdb->p->oid = (OID)0;
    dbobjectdb->p->cid = (CID)0;
  }
  else {
    cout << "Object changed to: " << dbobjectdb->p->name << ", "
	 << dbobjectdb->p->oid 
	 << ", " << dbobjectdb->p->cid << endl << flush;
  }
  return 0;
}

int AddObject(vbStream *server, vbBlockHeader &vb,
	      DatabaseObject *dbobjectdb)
{
  cout << "Adding an object" << endl << flush;
  if(server->ReadRemoteBlock(dbobjectdb->p, vb) != 0) return 1;
  dbobjectdb->WriteObject();
  cout << dbobjectdb->p->name << " added to the database" << endl << flush;
  return 0;
}

int DeleteObject(vbStream *server, vbBlockHeader &vb,
		 DatabaseObject *dbobjectdb)
{
  cout << "Deleting an object" << endl << flush;
  if(server->ReadRemoteBlock(dbobjectdb->p, vb) != 0) return 1;
  FAU addr = dbobjectdb->DeleteObject();
  if(!addr) 
    cout << "Could not find \"" << dbobjectdb->p->name << "\" in the database" 
	 << endl << flush;
  else
    cout << "Deleted: " << dbobjectdb->p->name << endl << flush;
  return 0;
}

int main(int argc, char **argv)
{
  // Check arguments. Should be only one: the port number to bind to.
  if(argc != 2) {
    cerr << "Usage: " << argv[0] << " port" << endl << flush;
    return 1;
  }
  
  DatabaseObject *dbobjectdb = new DatabaseObject; 
  cout << "Initializing the database..." << endl << flush;
  const char *fname = "dbobject.vbd";

  if(!vbDatabase::Exists(fname)) {
    cout << "Creating new file..." << endl << flush;
    dbobjectdb->Create(fname);
  }
  else {
    cout << "Opening existing file..." << endl << flush;
    dbobjectdb->Open(fname);
  }

  vbStream server;
  vbsSocket_t remote_socket;
  unsigned short port = (unsigned short) atoi(argv[1]);

  cout << "Initializing the VB stream server..." << endl << flush;
  if(server.StreamServer(port) != 0) {
    cout << server.SocketExceptionMessage() << endl << flush;
    return 1;
  }
  
  // Get the host name assigned to this machine
  char hostname[vbsMAX_NAME_LEN];
  if(server.HostName(hostname) != 0) {
    cout << server.SocketExceptionMessage() << endl << flush;
    return 1;
  }
  cout << "Opening VBD stream server on host " << hostname << endl << flush;

  int server_up = 1;
  while(server_up) { // Loop until signaled to exit 
    cout << "Listening on port " << port << endl << flush;
    remote_socket = server.Accept(); // Block until the next read.
    if(remote_socket < 0) {
      cout << server.SocketExceptionMessage() << endl << flush;
      return 1;
    }

    // Read the block following a client connection
    vbBlockHeader vb;
    if(server.ReadClientHeader(vb) != 0) {
      cout << server.SocketExceptionMessage() << endl << flush;
      return 1;
    }

    cout << flush;
    
    // Get the client info
    char client_name[vbsMAX_NAME_LEN]; int r_port = -1;
    server.GetClientInfo(client_name, r_port);
    cout << client_name << " connecting on port " << r_port << endl << flush;

    // Read the status byte to determine what to do with this block
    __ULWORD__ block_status = vb.block_status;
    __SBYTE__ status = (__SBYTE__)((block_status & 0xFF00)>>8);

    switch(status) { 
      // Process each block of data
      case vbAcknowledgeBlock:
	cout << "Received an acknowledge block command" << endl << flush;
	cout << "Sending acknowledgment" << endl << flush;
	if(server.WriteRemoteAckBlock() != 0)
	  cout << server.SocketExceptionMessage() << endl << flush;	  
	server.CloseRemoteSocket();
	break;

      case vbAddRemoteBlock:
	if(AddObject(&server, vb, dbobjectdb) != 0) 
	  cout << server.SocketExceptionMessage() << endl << flush;
	server.CloseRemoteSocket();
	break;

      case vbChangeRemoteBlock:
	if(ChangeObject(&server, vb, dbobjectdb) != 0) 
	  cout << server.SocketExceptionMessage() << endl << flush;
	server.CloseRemoteSocket();
	break;

      case vbRequestBlock:
	if(FindObject(&server, vb, dbobjectdb) != 0) 
	  cout << server.SocketExceptionMessage() << endl << flush;
	server.CloseRemoteSocket();
	break;

      case vbDeleteRemoteBlock:
	if(DeleteObject(&server, vb, dbobjectdb) != 0) 
	  cout << server.SocketExceptionMessage() << endl << flush;
	server.CloseRemoteSocket();
	break;

      case vbSendBlock :  
	cout << "Not excepting raw data blocks" << endl << flush;
	server.CloseRemoteSocket();
	break;

      case vbCloseConnection : 
	cout << "Client sent a close connection command" << endl << flush;
	server.CloseRemoteSocket();
	break;

      case vbKillServer:
	cout << "Client shutdown the server" << endl << flush;
	server_up = 0;
	break;
	
      default:
	cout << "Received bad block command from client" << endl << flush;
	server.CloseRemoteSocket();
	break;
    }
  }

  dbobjectdb->Close();
  server.Close();
  cout << "Exiting..." << endl << flush;
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
