// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: server.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/14/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Simple datagram server demo using the vbSocket class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include "vbsocket.h"

int main(int argc, char **argv)
{
  // Check arguments. Should be only one: the port number to bind to.
  if(argc != 2) {
    cerr << "Usage: " << argv[0] << " port" << endl;
    return 1;
  }

  unsigned short port = (unsigned short) atoi(argv[1]);

  cout << "Construcing datagram server..." << endl;
  vbSocket server(SOCK_DGRAM, port);
  if(!server) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }
  
  // Get the host name assigned to this machine (statistical info only)
  char hostname[vbsMAX_NAME_LEN];
  int rv = server.GetHostName(hostname);
  if(rv < 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }

  cout << "Opening stream server on host " << hostname << endl;
  cout << "Listening on port " << port << endl;

  // Bind the name to the socket
  rv = server.Bind();
  if(rv < 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }
 
  const int buf_len = 255; // Receive buffer size
  char sbuf[buf_len];
  rv = server.RawReadFrom(sbuf, buf_len); // Non-blocking read
  if(rv < 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }
  
  // Get the client info (statistical info only)
  char client_name[vbsMAX_NAME_LEN]; int r_port = -1;
  server.GetClientInfo(client_name, r_port);
  cout << "Receiving data from " << client_name 
       << " remote port " << r_port << endl << flush;

  cout << "Received " << rv << " bytes" << endl;

  // Print the buffer contents to the stdout for visual conformation
  sbuf[rv] = 0; // Null termainate the buffer
  cout << sbuf;

  cout << "Exiting..." << endl;
  server.Close(); // Close the socket connection
  server.ReleaseSocketLibrary();
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
