// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: client.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/14/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The program is used to test vbSerialCommServer class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "scomserv.h"

const char *test_block = "The quick brown fox jumps over the lazy dog \
0123456789\n";

void ClearInputStream(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

void PrgMenu()
{
  cout << endl;
  cout << "(a, A)    Add a variable block" << endl;
  cout << "(c, C)    Change a variable block" << endl;
  cout << "(d, D)    Delete a variable block" << endl;
  cout << "(l, L)    Send a client close command" << endl;
  cout << "(h, H, ?) Help (prints this menu)" << endl;
  cout << "(k, K)    Shutdown the server" << endl;
  cout << "(q, Q)    Quit this program" << endl;
  cout << "(r, R)    Request a variable block" << endl;
  cout << "(s, S)    Send a raw block of data" << endl;
  cout << "(w, W)    Send an acknowledgment block" << endl;
  cout << endl;
}

void Acknowledge(vbSerialCommServer *client)
{
  cout << "Requesting acknowledgment block from the server" << endl;

  if(client->WriteAckBlock() != 0) {
    cout << client->SerialCommExceptionMessage() << endl;
    return;
  }

  if(client->ReadAckBlock() != 0) {
    cout << client->SerialCommExceptionMessage() << endl;
    return;
  }

  cout << "Received an acknowledgment from the server " << endl;
}

void CloseCommand(vbSerialCommServer *client)
{
  cout << "Closing the connection..." << endl;
  if(client->CloseConnection() != 0)
    cout << client->SerialCommExceptionMessage() << endl;
  
}

void DeleteBlock(vbSerialCommServer *client)
{
  cout << "Sending a request to delete a remote block" << endl;
  char *request = "DOG"; // Arbitary block ID
  vbBlockHeader vb;
  vb.block_length = strlen(request);

  if(client->DeleteBlock((char *)request, vb) != 0) 
    cout << client->SerialCommExceptionMessage() << endl;
}

void AddBlock(vbSerialCommServer *client)
{
  cout << "Sending a request to add a remote block" << endl;

  vbBlockHeader vb;
  vb.block_length = strlen(test_block);

  if(client->AddBlock((char *)test_block, vb) != 0) 
    cout << client->SerialCommExceptionMessage() << endl;
}

void ChangeBlock(vbSerialCommServer *client)
{
  cout << "Sending a request to change a remote block" << endl;

  char *request = "CAT"; // Arbitary block ID
  vbBlockHeader request_header;
  request_header.block_length = strlen(request);

  vbBlockHeader block_header;
  block_header.block_length = strlen(test_block);

  if(client->ChangeBlock((char *)request, (char *)test_block, request_header,
			block_header) != 0) 
    cout << client->SerialCommExceptionMessage() << endl;
}

void ShutDownServer(vbSerialCommServer *client)
{
  cout << "Shutting down the server..." << endl;
  if(client->TerminateConnection() != 0) 
    cout << client->SerialCommExceptionMessage() << endl;
}

void RequestBlock(vbSerialCommServer *client)
{
  cout << "Requesting a block from the server" << endl;
  char *request = "FOX"; // Arbitary block ID
  vbBlockHeader request_header;
  request_header.block_length = strlen(request);
  vbBlockHeader requested_block_header;
  request_header.block_length = strlen(request);

  void *block = client->RequestBlock((char *)request, request_header,
				    requested_block_header);
  if(!block) {
    cout << client->SerialCommExceptionMessage() << endl;
    return;
  }
  cout << "Received requested block" << endl;
  cout.write((char *)block, requested_block_header.block_length);
}

void SendBlock(vbSerialCommServer *client)
// Send a block of data
{
  cout << "Sending a block " << strlen(test_block) << " bytes long..." << endl;
  if(client->WriteBlock((char *)test_block, strlen(test_block)) != 0) {
    cout << client->SerialCommExceptionMessage() << endl;
    return;
  }
}

int main(int argc, char **argv)
{
  if(argc < 2) {
    cout << "VB Serial port client" << endl;
    cout << "Usage: " << argv[0] << " device name [baud rate]" << endl;
    return 1;
  }

  vbSerialCommServer client;

  int baud_rate = 9600;
  if(argc > 2 && atoi(argv[2])) baud_rate = atoi(argv[2]);

  int rv = client.InitCommServer(argv[1], baud_rate);
  
  if(rv != vbSerialComm::scomm_NO_ERROR) {
    cout << client.SerialCommExceptionMessage() << endl;
    return 1;
  }

  char key;
  PrgMenu();
  rv = 1;
  while(rv) {
    if (!cin) { // Input is in fail state
      ClearInputStream(cin); // Go to end of line
      if (!cin) {  // Can't fix
	cout << "Input stream is broken" << endl;
	return 0;
      }
    }
    cout << '>';
    cin >> key;
    if (!cin) continue; // Fix at top of loop
    switch(key) {
      case '?' : PrgMenu(); break;
      case 'h' : case 'H' : PrgMenu(); break;
      case 'q' : case 'Q' : rv = 0; break;

      case 'a' : case 'A' : 
	AddBlock(&client);
	break;
      case 'c' : case 'C' : 
	ChangeBlock(&client);
	break;
      case 'd' : case 'D' :  
	DeleteBlock(&client);
	break;
      case 'k' : case 'K' : 
	ShutDownServer(&client);
	break;
      case 'r' : case 'R' : 
	RequestBlock(&client);
	break;
      case 's' : case 'S' : 
	SendBlock(&client);
	break;
      case 'l' : case 'L' : 
	CloseCommand(&client);
	break;
      case 'w' : case 'W' : 
	Acknowledge(&client);
	break;
      default:
        cout << "Unrecognized command" << endl;
    }
  }

  client.Close(); 
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
