// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbthread.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/07/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbThread class is an abstract base class used to create
platform independent multi-threaded applications. The derived
class interface consists of three functions:

virtual void *vbThread::ThreadEntryRoutine(vbThread_t *thread) = 0;
virtual void vbThread::ThreadExitRoutine(vbThread_t *thread);
virtual void vbThread::ThreadCleanupHandler(vbThread_t *thread);

A derived class must override the vbThread::ThreadEntryRoutine()
function, which is the thread's entry point of execution.

The vbThread::ThreadExitRoutine() function can be used by a
derived class to perform any additional operations required
before the thread exits.

The vbThread::ThreadCleanupHandler should be used by a derived
class if any cleanup operations need to be performed prior to
thread cancellation.
*/
// ----------------------------------------------------------- //   
#ifndef __VBTHREAD_HPP_
#define __VBTHREAD_HPP_

#include "thrtypes.h"
#include "vthreadt.h"
#include "thrpool.h"

// Foward class calling conventions
class vbThreadAPIWrapper; // Class used to handle native API calls

class vbThread
{
public:
  vbThread();
  virtual ~vbThread();

private: // Disallow coping and assignment
  vbThread(const vbThread &ob) { }
  void operator=(const vbThread &ob) { } 

public: // Thread functions
  vbThread_t *ConstructThread(vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
			      vbStackSizeType ssize = 0);

  vbThread_t *ConstructThread(void *parm,
			      vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
			      vbStackSizeType ssize = 0);

  vbThread_t *CreateThread(vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
			   vbStackSizeType ssize = 0);

  // Overload that allows a parameter to be passed to the thread
  vbThread_t *CreateThread(void *parm,
			   vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
			   vbStackSizeType ssize = 0);

  int CreateThread(vbThread_t *thread);
  int DestroyThread(vbThread_t *thread, int check_state = 1);
  int ResumeThread(vbThread_t *thread);
  int SuspendThread(vbThread_t *thread);
  int JoinThread(vbThread_t *thread);
  int CloseThread(vbThread_t *thread);
  int CancelThread(vbThread_t *thread);
  void *ExitThread(vbThread_t *thread, int exit_code);
  int ThreadKeyCreate(vbThreadKey &key);
  int ThreadKeyDelete(vbThreadKey &key);
  int ThreadSetSpecific(vbThreadKey &key, const void *value);
  void *ThreadGetSpecific(vbThreadKey &key);
  int SetThreadPriority(vbThread_t *thread);
  int SetThreadPriority(vbThread_t *thread, vbThreadPriority prio);
  int SetThreadPriority(vbThread_t *thread, vbThreadPriority prio,
			vbThreadPriorityClass prio_class);

public: // Thread pool functions
  vbThread_t *ConstructThread(thrPool *thread_pool,
			   vbThreadPriority prio = vbTHREAD_PRIORITY_NORMAL, 
			   vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
			   vbStackSizeType ssize = 0);

  vbThread_t *CreateThread(thrPool *thread_pool,
  			   vbThreadPriority prio = vbTHREAD_PRIORITY_NORMAL, 
  			   vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
  			   vbStackSizeType ssize = 0);

  vbThread_t *ConstructThread(thrPool *thread_pool, void *parm,
			   vbThreadPriority prio = vbTHREAD_PRIORITY_NORMAL, 
			   vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
			   vbStackSizeType ssize = 0);

  vbThread_t *CreateThread(thrPool *thread_pool, void *parm,
  			   vbThreadPriority prio = vbTHREAD_PRIORITY_NORMAL, 
  			   vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
  			   vbStackSizeType ssize = 0);

  thrPool *ConstructThreadPool(unsigned pool_size);

  thrPool *CreateThreadPool(unsigned pool_size, void *parm = 0,
			    vbThreadPriority prio = vbTHREAD_PRIORITY_NORMAL, 
			    vbThreadType t = vbTHREAD_TYPE_JOINABLE, 
			    vbStackSizeType ssize = 0);
  
  int JoinThread(thrPool *thread_pool);
  void RebuildThreadPool(thrPool *thread_pool);
  int DestoryThreadPool(thrPool *thread_pool, int check_state = 1);

public: // Timer functions
  void mSleep(int milliseconds);
  void sSleep(int seconds);
  
protected: // Derived class interface
  virtual void *ThreadEntryRoutine(vbThread_t *thread) = 0;
  virtual void ThreadExitRoutine(vbThread_t *thread);
  virtual void ThreadCleanupHandler(vbThread_t *thread);
  
protected: // vbThread_t class interface
  friend class vbThread_t;

protected: // Interface to API wrapper class
  friend class vbThreadAPIWrapper;
  vbThreadAPIWrapper *thread_api_wrapper;
};

#endif // __VBTHREAD_HPP_
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
