// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: thrapiw.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/07/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbThreadAPIWrapper class is used to call native thread API 
functions for each specified platform. NOTE: This class is not 
intended to be used directly by an application or a derived 
class. It is used by the vbThread base class to call the correct 
native thread API function for each of the supported platforms.
*/
// ----------------------------------------------------------- //   
#ifndef __VBTHREAD_API_WRAPPER_HPP__
#define __VBTHREAD_API_WRAPPER_HPP__

#include "thrtypes.h"

// Foward class calling conventions
class vbThread_t; // Thread class used to store thread variables
class vbThread;   // Base class used to create threaded objects 

class vbThreadAPIWrapper
{
public:
  vbThreadAPIWrapper() { }   
  ~vbThreadAPIWrapper() { }

private: // Disallow copying and assignment
  vbThreadAPIWrapper(const vbThreadAPIWrapper &ob) { }
  void operator=(const vbThreadAPIWrapper &ob) { }

public: // Native thread API functions
  int apiInitThreadAttribute(vbThreadAttribute *attr);
  int apiDestroyThreadAttribute(vbThreadAttribute *attr);
  int apiCreateThread(vbThread_t *thread);
  int apiJoinThread(vbThread_t *thread);
  int apiSuspendThread(vbThread_t *thread);
  int apiResumeThread(vbThread_t *thread);
  int apiCancelThread(vbThread_t *thread);
  int apiCloseThread(vbThread_t *thread);
  int apiDestroyThread(vbThread_t *thread, int check_state = 1);
  void *apiExitThread(vbThread_t *thread, int exit_code);
  int apiSetThreadPriority(vbThread_t *thread);
  int apiThreadKeyCreate(vbThreadKey &key);
  int apiThreadKeyDelete(vbThreadKey &key);
  int apiThreadSetSpecific(vbThreadKey &key, const void *value);
  void *apiThreadGetSpecific(vbThreadKey &key);

public: // Timer functions
  void api_mSleep(int milliseconds);
  void api_sSleep(int seconds);

public: // Cross-platform thread entry points
#if defined (__WIN32__)
  // NOTE: The *arg pointer will be cast to vbThread_t type
  static DWORD apiThreadStartRoutine(void *arg);
#elif defined (__POSIX__)
  // NOTE: The *arg pointer will be cast to vbThread_t type
  static void *apiThreadStartRoutine(void *arg);
#else
#error You must define an API: __WIN32__ or __POSIX__
#endif

public: // Thread cleanup handler
  // NOTE: The *arg pointer will be cast to vbThread_t type
  static void apiThreadCleanupHandler(void *arg);
};

#endif // __VBTHREAD_API_WRAPPER_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
