// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbdatagm.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/12/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbDatagram class is derived from the vbSocket class and is 
used to send and receive variable blocks over a UDP connection.
*/
// ----------------------------------------------------------- //   
#ifndef __VBDATAGRAM_HPP__
#define __VBDATAGRAM_HPP__

#include "vbsocket.h"
#include "vbheader.h"

class vbDatagram : public vbSocket
{
public:
  vbDatagram() { }
  ~vbDatagram() { }

public: // Client/Server configuration
  int DatagramServer(int port);
  int DatagramClient(int port, char *host);
  int PortNumber(int &port);
  int RemotePortNumber(int &port);
  int HostName(char *hs);
  int RemoteHostName(char *hs);
  
public: // High-level variable block functions
  int WriteBlock(const void *buf, int bytes);
  int TerminateConnection();
  int CloseConnection();
  int ReadClientHeader(vbBlockHeader &vbs);
  int ReadRemoteBlock(void *buf, vbBlockHeader &vb);
  int WriteRemoteBlock(void *buf, int bytes);
  void *RequestBlock(const void *request, vbBlockHeader &request_header, 
		      vbBlockHeader &requested_block_header);
  int AddBlock(const void *block, vbBlockHeader &block_header);
  int ChangeBlock(const void *request, const void *block, 
		  vbBlockHeader &request_header, vbBlockHeader &block_header);
  int DeleteBlock(const void *request, vbBlockHeader &request_header);
  int WriteAckBlock();
  int WriteRemoteAckBlock();
  int ReadAckBlock();
  int ReadRemoteAckBlock();
  
public: // Low-level variable block functions
  void SetBlockStatus(vbBlockHeader &vb, __SBYTE__ net_status,
		      __SBYTE__ file_status = vbRemoteDeviceBlock);
  int WriteBlock(vbsSocket_t s, vbsSocketAddress *sa,
		 const void *buf, int bytes);
  int WriteBlock(vbsSocket_t s, vbsSocketAddress *sa,
		 const void *buf, vbBlockHeader &vb);
  int WriteHeader(vbsSocket_t s, vbsSocketAddress *sa, vbBlockHeader &vb);
  int ReadBlock(vbsSocket_t s, vbsSocketAddress *sa,
		void *buf, vbBlockHeader &vb);
  int ReadHeader(vbsSocket_t s, vbsSocketAddress *sa, vbBlockHeader &vb);
  void *RequestBlock(vbsSocket_t s, vbsSocketAddress *sa, const void *request,
		     vbBlockHeader &request_header, 
		     vbBlockHeader &requested_block_header);
  int AddBlock(vbsSocket_t s, vbsSocketAddress *sa, const void *block,
	       vbBlockHeader &block_header);
  int ChangeBlock(vbsSocket_t s, vbsSocketAddress *sa, 
		  const void *request, const void *block, 
		  vbBlockHeader &request_header,  
		  vbBlockHeader &block_header);
  int DeleteBlock(vbsSocket_t s, vbsSocketAddress *sa, const void *request,
		  vbBlockHeader &request_header);
  int WriteAckBlock(vbsSocket_t s, vbsSocketAddress *sa);
  int ReadAckBlock(vbsSocket_t s, vbsSocketAddress *sa);
  int TerminateConnection(vbsSocket_t s, vbsSocketAddress *sa);
  int CloseConnection(vbsSocket_t s, vbsSocketAddress *sa);
};

#endif // __VBDATAGRAM_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
