// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: server.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/20/1999
// Date Last Modified: 08/14/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The program is used to test vbSerialCommServer class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include "scomserv.h"

int ReadBlock(vbSerialCommServer *server, vbBlockHeader &vb)
{
  cout << "Reading a raw block of data" << endl;
  
  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << buf;
  cout << server->BytesRead() << " bytes received." << endl;
  
  delete buf;
  return 0;
}

int AnswerRequest(vbSerialCommServer *server, vbBlockHeader &vb)
{
  cout << "Client has requested a block" << endl;
 
  char *test_block = "The quick brown fox jumps over the lazy dog \
0123456789\n";

  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << "Client has requested block: " << buf << endl;
  delete buf;

  cout << "Answering request" << endl;
  
  if(server->WriteBlock((char *)test_block, strlen(test_block)) != 0)
    return 1;

  return 0;
}

int ChangeBlock(vbSerialCommServer *server, vbBlockHeader &vb)
{
  cout << "Received a change block request" << endl;
 
  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << "Client requested that block \"" << buf << "\" be changed to:" 
       << endl << flush;
  delete buf;

  vbBlockHeader block_header;
  if(server->ReadHeader(block_header) != 0) return 1;

  char *block = new char[(__ULWORD__)block_header.block_length];
  if(server->ReadBlock((char *)block, block_header) != 0) return 1;

  cout << "Bytes = " << block_header.block_length << endl;
  block[(__ULWORD__)block_header.block_length] = 0;
  cout << block << flush;

  delete block;
  return 0;
}

int AddBlock(vbSerialCommServer *server, vbBlockHeader &vb)
{
  cout << "Received an add block request" << endl;
  
  char *block = new char[(__ULWORD__)vb.block_length];
  if(server->ReadBlock(block, vb) != 0) return 1;

  block[(__ULWORD__)vb.block_length] = 0;
  cout << "Client has requested the following block be added:" << endl;
  cout << block << flush;
  delete block;
  
  return 0;
}

int DeleteBlock(vbSerialCommServer *server, vbBlockHeader &vb)
{
  cout << "Received a delete block request" << endl;
  
  char *buf = new char[(__ULWORD__)vb.block_length];
  if(server->ReadBlock(buf, vb) != 0) return 1;

  buf[(__ULWORD__)vb.block_length] = 0;
  cout << "Client has requested block \"" << buf << "\" be deleted" << endl;
  delete buf;
  
  return 0;
}

int main(int argc, char **argv)
{
  if(argc < 2) {
    cout << "VB Serial port server" << endl;
    cout << "Usage: " << argv[0] << " device name [baud rate]" << endl;
    return 1;
  }

  vbSerialCommServer server;

  int baud_rate = 9600;
  if(argc > 2 && atoi(argv[2])) baud_rate = atoi(argv[2]);

  cout << "Initializing the VB serial port server..." << endl;
  int rv = server.InitCommServer(argv[1], baud_rate);

  if(rv != vbSerialComm::scomm_NO_ERROR) {
    cout << server.SerialCommExceptionMessage() << endl;
    return 1;
  }

  cout << "Opening VB serial port server on " << argv[1] << endl;
    
  while(1) { // Block until the next read. 
    // Wait for a block header
    vbBlockHeader vb;
    if(server.ReadHeader(vb) != 0) {
      cout << server.SerialCommExceptionMessage() << endl;
      return 1;
    }

    cout << "Client connecting on " << argv[1] << endl;

    // Read the status byte to determine what to do with this block
    __ULWORD__ block_status = vb.block_status;
    __SBYTE__ status = (__SBYTE__)((block_status & 0xFF00)>>8);

    switch(status) { 
      // Process each block of data
      case vbAcknowledgeBlock:
	cout << "Received an acknowledge block command" << endl;
	cout << "Sending acknowledgment" << endl;
	if(server.WriteAckBlock() != 0)
	  cout << server.SerialCommExceptionMessage() << endl;	  
	break;

      case vbAddRemoteBlock:
	if(AddBlock(&server, vb) != 0) 
	  cout << server.SerialCommExceptionMessage() << endl;
	break;

      case vbChangeRemoteBlock:
	if(ChangeBlock(&server, vb) != 0) 
	  cout << server.SerialCommExceptionMessage() << endl;
	break;

      case vbRequestBlock:
	if(AnswerRequest(&server, vb) != 0) 
	  cout << server.SerialCommExceptionMessage() << endl;
	break;

      case vbDeleteRemoteBlock:
	if(DeleteBlock(&server, vb) != 0) 
	  cout << server.SerialCommExceptionMessage() << endl;
	break;

      case vbSendBlock :  
	if(ReadBlock(&server, vb) != 0) 
	  cout << server.SerialCommExceptionMessage() << endl;
	break;

      case vbCloseConnection : 
	cout << "Client sent a close connection command" << endl;
	break;

      case vbKillServer:
	cout << "Client shutdown the server" << endl;
	server.Close();
	return 0;
	
      default:
	cout << "Received bad block command from client" << endl;
	break;
    }
  }

  server.Close();
  cout << "Exiting..." << endl;
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
