// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbmutex.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/07/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Mutual exclusion class used to provide simple lock primitives
that can be used to control access to a shared resource. A mutex
is used to cause other threads to wait while the thread holding
the mutex executes code in a critical section.
*/
// ----------------------------------------------------------- //   
#ifndef __VBMUTEX_HPP__
#define __VBMUTEX_HPP__

#include "thrtypes.h"
#include "thelpers.h"

class vbMutex
{
public:
  vbMutex(vbProcessType type = vbPROCESS_PRIVATE); 
  ~vbMutex();

private: // Disallow copying and assignment
  vbMutex(const vbMutex &ob) { } 
  void operator=(const vbMutex &ob) { }

public:
  int MutexInit(vbProcessType type = vbPROCESS_PRIVATE);
  int MutexDestroy();
  int MutexLock();
  int MutexUnlock();
  int MutexTryLock();
  int IsLocked() { return mutex_lock > 0; }
  int NumLocks() { return mutex_lock; }
  vbMutex_t *GetMutex() { return &mutex; }
  vbMutexError GetMutexError() { return mutex.mutex_error; }
  vbProcessType GetMutexProcessType() { return mutex.process_type; }
  
public: // Mutex status/debug message functions
  const char *MutexExceptionMessage();

private:
  int mutex_lock;
  vbMutex_t mutex;
};

#endif // __VBMUTEX_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
  

