# Include file used for all project makefiles

# Build dependency rules
# ===============================================================
THELPERS_DEP = thrtypes.h thelpers.h

THRAPIW_DEP = thrtypes.h thrapiw.h \
	vthreadt.h vbthread.h \
	thrpool.h vbmutex.h \
	vbcond.h thelpers.h

THRPOOL_DEP = thrtypes.h thrpool.h \
	vthreadt.h

VBCOND_DEP = thrtypes.h vbcond.h \
	thelpers.h vbmutex.h

VBMUTEX_DEP = thrtypes.h vbmutex.h \
	thelpers.h

VBSEMA_DEP = thrtypes.h vbsema.h \
	thelpers.h

VBTHREAD_DEP = thrtypes.h  vbthread.h \
	vthreadt.h thrapiw.h \
	thrpool.h

VTHREADT_DEP = thrtypes.h vthreadt.h \
	vbthread.h thrpool.h \
	vbcond.h vbmutex.h \
	thelpers.h

VBSOCKET_DEP = ../../include/vbsocket.h \
	../../include/vbstypes.h

HTTPSERV_DEP = ../../include/vbsocket.h \
	../../include/vbstypes.h \
	httpserv.h \
	thrtypes.h thelpers.h \
	vbthread.h vthreadt.h \
	thrpool.h vbmutex.h \
	vbcond.h vbsema.h

SERVER_DEP = ../../include/vbsocket.h \
	../../include/vbstypes.h \
	httpserv.h \
	thrtypes.h thelpers.h \
	vbthread.h vthreadt.h \
	thrpool.h vbmutex.h \
	vbcond.h vbsema.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

thrapiw$(OBJ_EXT):	thrapiw.cpp $(THRAPIW_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) thrapiw.cpp

thelpers$(OBJ_EXT):	thelpers.cpp $(THELPERS_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) thelpers.cpp

thrpool$(OBJ_EXT):	thrpool.cpp $(THRPOOL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) thrpool.cpp

vbthread$(OBJ_EXT):	vbthread.cpp $(VBTHREAD_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) vbthread.cpp

vthreadt$(OBJ_EXT):	vthreadt.cpp $(VTHREADT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) vthreadt.cpp

vbmutex$(OBJ_EXT):	vbmutex.cpp $(VBMUTEX_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) vbmutex.cpp

vbcond$(OBJ_EXT):	vbcond.cpp $(VBCOND_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) vbcond.cpp

vbsema$(OBJ_EXT):	vbsema.cpp $(VBSEMA_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) vbsema.cpp

server$(OBJ_EXT):	server.cpp $(SERVER_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) server.cpp

vbsocket$(OBJ_EXT):	../../src/vbsocket.cpp $(VBSOCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	../../src/vbsocket.cpp

httpserv$(OBJ_EXT):	httpserv.cpp $(HTTPSERV_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) httpserv.cpp

# Make the executable
OBJECTS = vbsocket$(OBJ_EXT) httpserv$(OBJ_EXT) server$(OBJ_EXT) \
	vbthread$(OBJ_EXT) vbmutex$(OBJ_EXT) thrpool$(OBJ_EXT) \
	vthreadt$(OBJ_EXT) vbcond$(OBJ_EXT) vbsema$(OBJ_EXT) \
	thrapiw$(OBJ_EXT) thelpers$(OBJ_EXT)
# ===============================================================
