// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbderror.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer  
// File Creation Date: 02/14/1996  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbdError functions and classes are used to catch and/or
record database exceptions that occur during run-time. This
implementation can be used with or without C++ built-in exception
handling. If C++ exception handling is not enabled with the
__CPP_EXCEPTIONS__ macro, then the vbDatabaseError enumerated
constants can be used to record database errors.
*/
// ----------------------------------------------------------- // 
#include "vbderror.h"

// NOTE: This array must contain the same number of exceptions as the
// vbDatabaseError enumeration. 
const int vbdMaxExceptionMessages = 43;
const char *vbdExceptionMessages[vbdMaxExceptionMessages] = {
  "Database exception: No exception reported",               // None
  "Database exception: Invalid error code reported",         // Invalid
  "Database exception: Access Violation",                    // AccessViolation
  "Database exception: Assertion failed",                    // AssertError
  "Database exception: Wrong object type",                   // BadClassID
  "Database exception: Bad object address",                  // BadObjectAddress
  "Database exception: Bad reference",                       // BadReference
  "Database exception: Cache full",                          // CacheFull
  "Database exception: Checksum error",                      // ChecksumError
  "Database exception: Divide by zero error",                // DivideByZero
  "Database exception: Unexpected end of file was reached",  // EOFError
  "Database exception: Error closing file",                  // FileCloseError
  "Database exception: File is corrupt",                     // FileCorrupt
  "Database exception: Error creating file",                 // CreationError
  "Database exception: File already exists",                 // FileExists
  "Database exception: Trying to use a closed file",         // FileNotOpenError
  "Database exception: File not ready for reading/writing",  // FileNotReady
  "Database exception: Could not write to file",             // NotWriteable
  "Database exception: Error opening file",                  // FileOpenError
  "Database exception: Cannot obtain a file position",       // FilePostionError
  "Database exception: Error reading from file",             // FileReadError
  "Database exception: Error seeking in file",               // FileSeekError
  "Database exception: Error writing to file",               // FileWriteError
  "Database exception: No database open",                    // NoDatabaseOpen
  "Database exception: No such file exists",                 // NoFileExists
  "Database exception: No objects exist",                    // NoObjectsExist
  "Database exception: Accessing a null pointer",            // NullPtr
  "Database exception: Object already exists",               // ObjectExists
  "Database exception: Another object is referencing this file", // Referenced
  "Database exception: Math overflow error",                 // OverFlow
  "Database exception: Parse error",                         // ParseError
  "Database exception: Invalid path",                        // PathError
  "Database exception: Trying to write to a read-only file", // ReadOnlyFile
  "Database exception: Stack empty",                         // StackEmpty
  "Database exception: Stack full",                          // StackFull
  "Database exception: Synchronization Error",               // SyncError    
  "Database exception: Math under-flow error",               // UnderFlow
  "Database exception: Wrong file type",                     // WrongFileType

  // Persistent lock error messages
  "Database exception: Invalid lock type specified",          // LOCK_TYPE
  "Database exception: Cannot access the file lock header",   // FLK_ACCESS
  "Database exception: Cannot lock the file",                 // FLK_ERROR
  "Database exception: Cannot access the record lock header", // RLK_ACCESS
  "Database exception: Cannot lock the specified record"      // RLK_ERROR
};

const char *vbDatabaseExceptionMessage(vbDatabaseError err)
// Standalone function that returns a null terminated string that can
// be use to log or print a database exception message.
{
  int error = (int)err;
  if(error > vbdMaxExceptionMessages) error = vbDBASE_INVALID_CODE;

  // Find the corresponding message in the exception array
  return vbdExceptionMessages[error];
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

