// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbuint64.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbUINT64 class is used to represent 64 bit unsigned integers
independently of the operating system or hardware platform used.
It works by separating a 64-bit value into eight separate byte
values and reordering the bytes lowest-order to highest-order.
A vbUINT64 type has a base 10 limit of 18446744073709551615.
*/
// ----------------------------------------------------------- //   
#ifndef __vbUINT64_HPP__
#define __vbUINT64_HPP__

#include <iostream.h>
#include "vbdtypes.h"
#include "vbdtyp64.h"

#if defined (__USE_NATIVE_INT_TYPES__)
typedef __ULLWORD__ vbUINT64;
#else

// Data structure for platform independent signed 32 bit integer values.
class vbUINT64
{
public:
  vbUINT64(__ULLWORD__ val = 0);
  vbUINT64(const vbUINT64& ob);
  vbUINT64& operator=(const vbUINT64& ob);
  vbUINT64& operator=(const __ULLWORD__ ob);

public:
  void UnPackBits(__ULLWORD__ val);
  __ULLWORD__ PackBits() const;

public: // Conversion fucntions
  operator __ULLWORD__() const;

public: // String fucntions added to print 64-bit types
  char *c_str(int radix = 10);
  const char *c_str(int radix = 10) const;
  vbUINT64 &StringToUINT64(const char *str);
  vbUINT64 &StringToUINT64(char *str);

public: // Class type to ostream type conversions
  friend ostream &operator<<(ostream &os, const vbUINT64 &val);
  friend istream &operator>>(istream &os, vbUINT64 &val);

public: // Arithmetic operators that modify their operand
  vbUINT64 operator++(int);  // Postfix
  vbUINT64 operator--(int);  // Postfix
  vbUINT64 &operator++() { operator=(*this + 1); return *this; } // Prefix
  vbUINT64 &operator--() { operator=(*this - 1); return *this; } // Prefix
  void operator+=(const vbUINT64 &i) { operator=(*this + i); }
  void operator-=(const vbUINT64 &i) { operator=(*this - i); }
  void operator*=(const vbUINT64 &i) { operator=(*this * i); }
  void operator/=(const vbUINT64 &i);

  void operator+=(const __LLWORD__ &i) { operator=(*this + i); }
  void operator-=(const __LLWORD__ &i) { operator=(*this - i); }
  void operator*=(const __LLWORD__ &i) { operator=(*this * i); }
  void operator/=(const __LLWORD__ &i);

  void operator+=(const __ULLWORD__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __ULLWORD__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __ULLWORD__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __ULLWORD__ &i);

  void operator+=(const __LWORD__ &i) { operator=(*this + i); }
  void operator-=(const __LWORD__ &i) { operator=(*this - i); }
  void operator*=(const __LWORD__ &i) { operator=(*this * i); }
  void operator/=(const __LWORD__ &i);

  void operator+=(const __ULWORD__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __ULWORD__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __ULWORD__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __ULWORD__ &i);

  void operator+=(const __WORD__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __WORD__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __WORD__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __WORD__ &i);

  void operator+=(const __SWORD__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __SWORD__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __SWORD__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __SWORD__ &i);

  void operator+=(const __UWORD__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __UWORD__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __UWORD__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __UWORD__ &i);

  void operator+=(const __USWORD__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __USWORD__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __USWORD__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __USWORD__ &i);

  void operator+=(const __SBYTE__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __SBYTE__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __SBYTE__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __SBYTE__ &i);

  void operator+=(const __UBYTE__ &i) { operator=(*this + (__LLWORD__)i); }
  void operator-=(const __UBYTE__ &i) { operator=(*this - (__LLWORD__)i); }
  void operator*=(const __UBYTE__ &i) { operator=(*this * (__LLWORD__)i); }
  void operator/=(const __UBYTE__ &i);

public: // Comparison operators
  friend int operator==(const vbUINT64 &a, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __LLWORD__ &bl);
  friend int operator==(const __LLWORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __ULLWORD__ &bl);
  friend int operator==(const __ULLWORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __LWORD__ &bl);
  friend int operator==(const __LWORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __ULWORD__ &bl);
  friend int operator==(const __ULWORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __WORD__ &bl);
  friend int operator==(const __WORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __SWORD__ &bl);
  friend int operator==(const __SWORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __UWORD__ &bl);
  friend int operator==(const __UWORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __USWORD__ &bl);
  friend int operator==(const __USWORD__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __SBYTE__ &bl);
  friend int operator==(const __SBYTE__ &al, const vbUINT64 &b);
  friend int operator==(const vbUINT64 &a, const __UBYTE__ &bl);
  friend int operator==(const __UBYTE__ &al, const vbUINT64 &b);

  friend int operator!=(const vbUINT64 &a, const __LLWORD__ &bl);
  friend int operator!=(const __LLWORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __ULLWORD__ &bl);
  friend int operator!=(const __ULLWORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __LWORD__ &bl);
  friend int operator!=(const __LWORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __ULWORD__ &bl);
  friend int operator!=(const __ULWORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __WORD__ &bl);
  friend int operator!=(const __WORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __SWORD__ &bl);
  friend int operator!=(const __SWORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __UWORD__ &bl);
  friend int operator!=(const __UWORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __USWORD__ &bl);
  friend int operator!=(const __USWORD__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __SBYTE__ &bl);
  friend int operator!=(const __SBYTE__ &al, const vbUINT64 &b);
  friend int operator!=(const vbUINT64 &a, const __UBYTE__ &bl);
  friend int operator!=(const __UBYTE__ &al, const vbUINT64 &b);

  friend int operator<(const vbUINT64 &a, const __LLWORD__ &bl);
  friend int operator<(const __LLWORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __ULLWORD__ &bl);
  friend int operator<(const __ULLWORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __LWORD__ &bl);
  friend int operator<(const __LWORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __ULWORD__ &bl);
  friend int operator<(const __ULWORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __WORD__ &bl);
  friend int operator<(const __WORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __SWORD__ &bl);
  friend int operator<(const __SWORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __UWORD__ &bl);
  friend int operator<(const __UWORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __USWORD__ &bl);
  friend int operator<(const __USWORD__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __SBYTE__ &bl);
  friend int operator<(const __SBYTE__ &al, const vbUINT64 &b);
  friend int operator<(const vbUINT64 &a, const __UBYTE__ &bl);
  friend int operator<(const __UBYTE__ &al, const vbUINT64 &b);

  friend int operator>(const vbUINT64 &a, const __LLWORD__ &bl);
  friend int operator>(const __LLWORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __ULLWORD__ &bl);
  friend int operator>(const __ULLWORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __LWORD__ &bl);
  friend int operator>(const __LWORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __ULWORD__ &bl);
  friend int operator>(const __ULWORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __WORD__ &bl);
  friend int operator>(const __WORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __SWORD__ &bl);
  friend int operator>(const __SWORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __UWORD__ &bl);
  friend int operator>(const __UWORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __USWORD__ &bl);
  friend int operator>(const __USWORD__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __SBYTE__ &bl);
  friend int operator>(const __SBYTE__ &al, const vbUINT64 &b);
  friend int operator>(const vbUINT64 &a, const __UBYTE__ &bl);
  friend int operator>(const __UBYTE__ &al, const vbUINT64 &b);

  friend int operator<=(const vbUINT64 &a, const __LLWORD__ &bl);
  friend int operator<=(const __LLWORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __ULLWORD__ &bl);
  friend int operator<=(const __ULLWORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __LWORD__ &bl);
  friend int operator<=(const __LWORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __ULWORD__ &bl);
  friend int operator<=(const __ULWORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __WORD__ &bl);
  friend int operator<=(const __WORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __SWORD__ &bl);
  friend int operator<=(const __SWORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __UWORD__ &bl);
  friend int operator<=(const __UWORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __USWORD__ &bl);
  friend int operator<=(const __USWORD__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __SBYTE__ &bl);
  friend int operator<=(const __SBYTE__ &al, const vbUINT64 &b);
  friend int operator<=(const vbUINT64 &a, const __UBYTE__ &bl);
  friend int operator<=(const __UBYTE__ &al, const vbUINT64 &b);

  friend int operator>=(const vbUINT64 &a, const __LLWORD__ &bl);
  friend int operator>=(const __LLWORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __ULLWORD__ &bl);
  friend int operator>=(const __ULLWORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __LWORD__ &bl);
  friend int operator>=(const __LWORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __ULWORD__ &bl);
  friend int operator>=(const __ULWORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __WORD__ &bl);
  friend int operator>=(const __WORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __SWORD__ &bl);
  friend int operator>=(const __SWORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __UWORD__ &bl);
  friend int operator>=(const __UWORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __USWORD__ &bl);
  friend int operator>=(const __USWORD__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __SBYTE__ &bl);
  friend int operator>=(const __SBYTE__ &al, const vbUINT64 &b);
  friend int operator>=(const vbUINT64 &a, const __UBYTE__ &bl);
  friend int operator>=(const __UBYTE__ &al, const vbUINT64 &b);
  
private:
  __UBYTE__ byte[8];
};
#endif // __USE_NATIVE_INT_TYPES__

#endif // __vbUINT64_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
