// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbhdr64.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 02/04/1997
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This include file contains type definitions, constants, and data 
structures needed to create 64-bit variable block headers. 
*/
// ----------------------------------------------------------- //   
#ifndef __VARIABLE_BLOCK_64_BIT_HEADER_HPP__
#define __VARIABLE_BLOCK_64_BIT_HEADER_HPP__

// --------------------------------------------------------------
// Include files
// --------------------------------------------------------------
#include "vbdtypes.h"
#include "vbdtyp64.h"
#include "vbint64.h"
#include "vbuint64.h"
#include "vbheader.h"
// --------------------------------------------------------------

// --------------------------------------------------------------
// Type definitions 
// --------------------------------------------------------------
// typedefs for file operations and stream position
typedef vbINT64 FAU64; // File Address Unit, physical file address type
typedef vbINT64 vbStreamPos64; // Stream position
// --------------------------------------------------------------

// --------------------------------------------------------------
// Constants
// --------------------------------------------------------------
const FAU64 vbStartOfFile64   = (FAU64)0;  // First byte in the file
const FAU64 vbCurrAddress64   = (FAU64)-1; // Indicates current location
const FAU64 vbFSListCorrupt64 = (FAU64)-1; // Free space list is corrupt
// --------------------------------------------------------------

// --------------------------------------------------------------
// Data Sturctures
// --------------------------------------------------------------
// Variable Block Database File Header
struct vbFileHeader64 // VBD file header 64 information (48 bytes)
{ 
  vbFileHeader64() { 
    vbd_fs_fptr = vbd_eof = vbd_hs_fptr = vbd_hb_fptr = (FAU64)0;
    vbd_ver = (FAU64)0; vbd_sig[0] = 0;
  }
  ~vbFileHeader64() { }

  FAU64 vbd_fs_fptr;     // Address to first block of free heap space
  FAU64 vbd_eof;         // Address of byte after end of file
  FAU64 vbd_hs_fptr;     // Address of the start of the heap space
  FAU64 vbd_hb_fptr;     // Highest allocated variable block
  __SBYTE__ vbd_sig[10]; // Signature used to ID a VBD file 
  FAU64 vbd_ver;         // VBD version number
  
private: // Disallow copying and assignment
  vbFileHeader64(const vbFileHeader64 &ob) { }
  void operator=(const vbFileHeader64 &ob) { }
};

// Variable Block Header 
struct vbBlockHeader64 // Marks each variable data block (20 bytes)
{
  vbBlockHeader64() {
    block_check_word = vbCheckWord;
    block_status = vbNormalBlock;
    block_length = (vbUINT32)0;
    block_nd_fptr = (FAU64)0;
  }
  ~vbBlockHeader64() { }
  vbBlockHeader64(const vbBlockHeader64 &ob) {
    block_check_word = ob.block_check_word; 
    block_length = ob.block_length; 
    block_status = ob.block_status;
    block_nd_fptr = ob.block_nd_fptr;
  }
  vbBlockHeader64& operator=(const vbBlockHeader64 &ob) {
    block_check_word = ob.block_check_word; 
    block_length = ob.block_length; 
    block_status = ob.block_status;
    block_nd_fptr = ob.block_nd_fptr;
    return *this;
  }

  vbUINT32 block_check_word; // Check-word used to mark each block
  vbUINT32 block_length;     // Block block_length
  vbUINT32 block_status;     // First byte  = status of the block's data 
                             // Second byte = block control commands
                             // Third byte  = reserved for future use
                             // Fourth byte = reserved for future use
  FAU64 block_nd_fptr;       // Pointer to next deleted block
};
// --------------------------------------------------------------

#endif // __VARIABLE_BLOCK_64_BIT_HEADER_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
