// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbd_ver.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 09/05/1997  
// Date Last Modified: 08/11/2000
// Copyright (c) 1997, 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This include file is used to define the current version number
and revision letter of the VB thread library. 
*/
// ----------------------------------------------------------- //   
#ifndef __VBDATABASE_VERSION_HPP__
#define __VBDATABASE_VERSION_HPP__

// Current VB Database version number.
const long vbDatabaseVersionNumber = 2000; // VBD release 2

// Version specific changes
const double vbDatabaseRevisionNumber = .101;

// VBD library distribution version number
const double vbDatabaseVersion = vbDatabaseVersionNumber + \
vbDatabaseRevisionNumber;

// ----------------------------------------- //
// Set the VB Database revision letter here.
// ----------------------------------------- //
const char vbDatabaseRevisionLetter = 'C';

// The version letter will determine the amount of overhead per
// variable block. Any of these revision letters can be used to
// create files with the vbDatabase file manager, version 2000.101
// and higher. When an existing file is opened the version/revision
// stored in the file header will be used.

// VBD revision letter zero (denoted by any of the following: 0, '\0', 
// or ' ') excludes the persistent checksum value, the persistent file
// lock header, and the persistent record lock header. The total revision
// zero overhead per block equals 16 bytes.

// VBD revision 'A' reserves space at the end of each block for
// an optional persistent checksum value and excludes the persistent
// file lock header, and the persistent record. The total revision 'A'
// overhead per block equals 20 bytes.

// VBD revision 'B' includes the persistent checksum value with addition
// of a persistent file lock header. The total revision 'B' overhead per
// block equals 20 bytes.

// VBD revision 'C' includes all the features of revision 'A' and 'B' with
// the addition of persistent lock headers. The total revision 'C' overhead
// per block equals 32 bytes. 
// ----------------------------------------- //

#endif // __VBDATABASE_VERSION_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
