// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: dbobject.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer    
// File Creation Date: 09/18/1997  
// Date Last Modified: 08/12/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
The VBD C++ classes are copyright (c) 1997, by Douglas M. Gaer.
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Database object class used with the client/server example.
*/
// ----------------------------------------------------------- //   
#ifndef __VBS_DATABASEOBJECT_HPP__
#define __VBS_DATABASEOBJECT_HPP__

#include <string.h>
#include "vbdbase.h"
#include "vbfloat.h"

typedef vbINT32 OID;
typedef vbFLOAT64 CID;

struct DatabaseObjectData {
  DatabaseObjectData();

  char name[vbMaxNameLength];  
  OID oid; 
  CID cid;
};

class DatabaseObject : public vbDatabase
{ 
public:
  DatabaseObject() { p = new DatabaseObjectData; }
  ~DatabaseObject() { delete p; }

public: 
  FAU WriteObject();
  void ReadObject(FAU Address);
  FAU FindObject();
  FAU DeleteObject();
  FAU RemoveObject();
  FAU ChangeObject(const DatabaseObjectData &new_dbobject_info);

public:
  DatabaseObjectData *p;
};

#endif // __VBS_DATABASEOBJECT_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
