// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vthreadt.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/11/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The vbThread_t class is a data structure used to initialize and
store thread variables prior to and after thread creation.
*/
// ----------------------------------------------------------- //   
#ifndef __VBTHREAD_THREAD_CONTAINER__
#define __VBTHREAD_THREAD_CONTAINER__

#include "thrtypes.h"

// Foward class calling conventions
class vbThread;           // Base class used to create threaded objects
class vbThreadAPIWrapper; // Class used to handle native API calls
class vbMutex;            // Mutual exclusion class 
class vbCondition;        // Class used to handle condition variables

class vbThread_t
{
public:
  vbThread_t(vbThreadType t = vbTHREAD_TYPE_JOINABLE);
  ~vbThread_t();

private: // Disallow coping and assignment
  vbThread_t(const vbThread_t &ob) { } 
  void operator=(const vbThread_t &ob) { }
  
public: // Thread status functions
  vbThreadState GetThreadState() { return thread_state; }
  vbThreadState GetThreadState() const { return thread_state; }
  vbThreadID GetThreadID() { return thread_id; }
  vbThreadID GetThreadID() const { return thread_id; }
  vbThreadType GetThreadType() { return thread_type; }
  vbThreadType GetThreadType() const { return thread_type; }
  vbStackSizeType GetStackSize() { return stack_size; }
  vbStackSizeType GetStackSize() const { return stack_size; }
  vbThreadAttribute *GetThreadAttribute() { return &thread_attribute; }
  
public: // Thread status/debug message functions
  const char *ThreadExceptionMessage();
  const char *ThreadPriorityMessage();
  const char *ThreadPriorityClassMessage();
  const char *ThreadStateMessage();
  const char *ThreadTypeMessage();
  
public: // Thread initialization functions
        // NOTE: These values must be set before the thread is created
  void SetThreadStackSize(unsigned ssize) { stack_size = ssize; }
  void SetThreadType(vbThreadType t) { thread_type = t; }

public: // Thread priority functions
  void SetThreadPriority(vbThreadPriority p) { thread_priority = p; }
  vbThreadPriority GetThreadPriority() { return thread_priority; }
  vbThreadPriority GetThreadPriority() const { return thread_priority; }
  vbThreadPriorityClass GetThreadPriorityClass() {
    return thread_priority_class;
  }
  vbThreadPriorityClass GetThreadPriorityClass() const {
    return thread_priority_class;
  }
  void SetThreadPriorityClass(vbThreadPriorityClass prio_class) {
    thread_priority_class = prio_class;
  }

public: // Thread error functions
  vbThreadError GetThreadError() { return thread_error; }
  vbThreadError GetThreadError() const { return thread_error; }
  void ResetThreadError() { thread_error = vbTHREAD_NO_ERROR; }
  void ResetThreadExitCode() { thread_exit_code = (vbThreadExitCode)0; }
  vbThreadExitCode GetThreadExitCode() { return thread_exit_code; }
  vbThreadExitCode GetThreadExitCode() const { return thread_exit_code; }

public: // Thread parameter functions
  void *GetThreadParm() { return thread_parm; }
  void SetThreadParm(void *v) { thread_parm = v; }

public: // Class ID/Object ID functions
  vbThreadClassID GetClassID() { return thread_cid; }
  vbThreadClassID GetClassID() const { return thread_cid; }
  vbThreadObjectID GetObjectID() { return thread_oid; }
  vbThreadObjectID GetObjectID() const { return thread_oid; }
  void SetClassID(vbThreadClassID cid) { thread_cid = cid; }
  void SetObjectID(vbThreadObjectID oid) { thread_oid = oid; }

public: // Overloaded operators
  friend int operator==(const vbThread_t &a, const vbThread_t &b);
  friend int operator!=(const vbThread_t &a, const vbThread_t &b); 
  
private: // vbThread base class interface
  friend class vbThread;
  vbThread *entry; // Pointer to this thread's entry function

private: // Interface to API wrapper class
  friend class vbThreadAPIWrapper;

private: // Thread variables
  vbStackSizeType stack_size;                  // Thread stack size
  vbThreadPriority thread_priority;            // Thread priority
  vbThreadPriorityClass thread_priority_class; // Thread scheduling policy 
  vbThreadState thread_state;                  // Thread state
  vbThreadID thread_id;                        // Thread ID or handle 
  vbThreadAttribute thread_attribute;          // Thread attribute

  vbThreadType thread_type;           // Type of thread (Detached or Joinable)
  vbThreadError thread_error;         // Last reported thread error
  vbThreadExitCode thread_exit_code;  // Thread exit code

  // Thread parameter pointer
  void *thread_parm; // Optional thread parameter pointer
  
  // Object and class identification members
  vbThreadObjectID thread_oid; // Object ID for this thread     
  vbThreadClassID thread_cid;  // Class ID for this thread
  
  // Members used to suspend and resume threads 
  vbMutex *suspend_lock_t; // Lock used to serialize access to suspend_t
  vbCondition *suspend_t;  // Thread suspend condition
};

#endif // __VBTHREAD_THREAD_CONTAINER__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
