// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: vbsema.h
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/11/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Semaphore synchronization class implemented using condition variables
and a mutually exclusive integer variable. Typically, an application
uses a semaphore to limit the number of threads using a resource by
causing a thread to stop and wait until another thread signals that it
has arrived at a certain place in the entry function.
*/
// ----------------------------------------------------------- //   
#ifndef __VBTHREAD_SEMAPHORE_HPP__
#define __VBTHREAD_SEMAPHORE_HPP__

#include "thrtypes.h"
#include "thelpers.h"

class vbSemaphore
{
public:
  vbSemaphore(vbProcessType type = vbPROCESS_PRIVATE);
  ~vbSemaphore();

private: // Disallow copying and assignment
  vbSemaphore(const vbSemaphore &ob) { }
  void operator=(const vbSemaphore &ob) { }

public:
  int SemaphoreInit(vbProcessType type = vbPROCESS_PRIVATE);
  int SemaphoreDestroy();
  int SemaphoreValue();
  int SemaphoreWait();
  int SemaphorePost();
  int SemaphoreDecrement();
  int SemaphoreIncrement();
  vbSemaphore_t *GetSemaphore() { return &semaphore; }
  vbSemaphoreError GetSemaphoreError() { return semaphore.semaphore_error; }
  vbProcessType GetSemaphoreProcessType() { return semaphore.process_type; }
  
public: // Semaphore status/debug message functions
  const char *SemaphoreExceptionMessage();
  
public: // Overloaded operators
  void operator++(int) { SemaphoreIncrement(); }
  void operator--(int) { SemaphoreDecrement(); }

public: // Conversion functions
  operator int() { return SemaphoreValue(); }

private:
  vbSemaphore_t semaphore;
};

#endif // __VBTHREAD_SEMAPHORE_HPP__
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
