// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: vbcond.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: Doug Gaer   
// File Creation Date: 03/25/2000
// Date Last Modified: 08/11/2000
// Copyright (c) 2000 Douglas M. Gaer
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Condition variable class used used by a thread to block its own
execution until an expression involving shared data attains a
particular state. 
*/
// ----------------------------------------------------------- //   
#include "vbcond.h"

vbCondition::vbCondition(vbProcessType type)
{
  ConditionInit(type);
}

vbCondition::~vbCondition()
{
  ConditionDestroy();
}

int vbCondition::ConditionInit(vbProcessType type)
// Initialize the condition variable. Returns a non-zero
// value if any errors occur.
{
  int rv = vbThreadConditionInit(&condition, type);
  if(rv != 0) return rv;
  num_waiters = 0;
  return 0;
}

int vbCondition::ConditionDestroy()
// Destroy the condition variable. Returns a non-zero
// value if any errors occur.
{
  int rv = vbThreadConditionDestroy(&condition);
  if(rv != 0) return rv;
  num_waiters = 0;
  return 0;
}

int vbCondition::ConditionWait(vbMutex *m)
// Function used to block a thread from its own execution
// until this condition is signaled. Returns a non-zero value
// if any errors occur.
{
  num_waiters++;
  int rv = vbThreadConditionWait(&condition, m->GetMutex());
  if(rv != 0) {
    num_waiters--;
    return rv;
  }
  return 0;
}

int vbCondition::ConditionSignal()
// Function used to wake up a thread waiting on the this
// condition. Returns a non-zero value if any errors occur.
{
  int rv = vbThreadConditionSignal(&condition);
  if(rv != 0) return rv;
  if(num_waiters > 0) num_waiters--;
  return 0;
}

int vbCondition::ConditionBroadcast()
// Function used to wake up all threads waiting on this
// condition Returns a non-zero value if any errors occur.
{
  int rv = vbThreadConditionBroadcast(&condition);
  if(rv != 0) return rv;
  num_waiters = 0;
  return 0;
}

int vbCondition::ConditionTimedWait(vbMutex *m, unsigned long sec,
				    unsigned long nsec)
// Function used to block a thread from its own execution until this 
// condition is signaled or the timeout value elapses. Returns a
// non-zero value if any errors occur.
{
  num_waiters++;
  int rv = vbThreadConditionTimedWait(&condition, m->GetMutex(), sec, nsec);
  if(rv != 0) {
    num_waiters--;
    return rv;
  }
  return 0;
}

const char *vbCondition::ConditionExceptionMessage()
// Returns a null terminated string that can be
// use to log or print a condition exception.
{
  return vbThreadConditionExceptionMessage(&condition);
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
